/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;

class ColorMapLabelMatcher {
    static final String DEFAULT_ATTRIBUTE_NAME = "Label";
    String attributeName;
    ColorMap colorMap;
    String labelInclusion;
    Integer channel;

    ColorMapLabelMatcher(String attributeName, ColorMap colorMap, String labelInclusion, Integer channel) {
        String labelInclusionUpper = labelInclusion.toUpperCase();
        if (!LabelInFeatureInfoMode.getAsStringList().contains(labelInclusionUpper)) {
            throw new RuntimeException("Unsupported labelInFeatureInfo VendorOption value " + labelInclusion + ". It should be one of add, replace, none");
        }
        this.attributeName = attributeName;
        this.colorMap = colorMap;
        this.labelInclusion = labelInclusionUpper;
        this.channel = channel;
    }

    String getAttributeName() {
        return this.attributeName;
    }

    Integer getChannel() {
        return this.channel;
    }

    String getLabelForPixel(double pixel) {
        int type = this.colorMap.getType();
        ColorMapEntry[] entries = this.colorMap.getColorMapEntries();
        String label = null;
        switch (type) {
            case 1: {
                label = this.getLabelForPixelRamp(pixel, entries);
                break;
            }
            case 2: {
                label = this.getLabelForPixelIntervals(pixel, entries);
                break;
            }
            case 3: {
                label = this.getLabelForPixelValue(pixel, entries);
            }
        }
        return label;
    }

    private String getLabelForPixelRamp(double pixel, ColorMapEntry[] entries) {
        String label = null;
        for (int i = 0; i < entries.length; ++i) {
            ColorMapEntry current = entries[i];
            double currentVal = (Double)current.getQuantity().evaluate(null, Double.class);
            if (i == 0 && pixel <= currentVal) {
                label = current.getLabel();
                break;
            }
            if (pixel <= currentVal) {
                double diffWithPrev;
                ColorMapEntry prev = entries[i - 1];
                double prevValue = (Double)prev.getQuantity().evaluate(null, Double.class);
                double diffWithCurr = Math.abs(pixel - currentVal);
                if (diffWithCurr < (diffWithPrev = Math.abs(pixel - prevValue))) {
                    label = current.getLabel();
                    break;
                }
                label = prev.getLabel();
                break;
            }
            if (i != entries.length - 1 || !(pixel > currentVal)) continue;
            label = current.getLabel();
        }
        return label;
    }

    private String getLabelForPixelValue(double pixel, ColorMapEntry[] entries) {
        String label = null;
        for (ColorMapEntry entry : entries) {
            double quantity = (Double)entry.getQuantity().evaluate(null, Double.class);
            if (pixel != quantity) continue;
            label = entry.getLabel();
            break;
        }
        return label;
    }

    private String getLabelForPixelIntervals(double pixel, ColorMapEntry[] entries) {
        String label = null;
        for (int i = 1; i < entries.length; ++i) {
            ColorMapEntry current = entries[i];
            ColorMapEntry prev = entries[i - 1];
            double currentQuantity = (Double)current.getQuantity().evaluate(null, Double.class);
            double prevQuantity = (Double)entries[i - 1].getQuantity().evaluate(null, Double.class);
            if (i == 1 && pixel < prevQuantity) {
                label = prev.getLabel();
                break;
            }
            if (!(pixel >= prevQuantity) || !(pixel < currentQuantity)) continue;
            label = current.getLabel();
            break;
        }
        return label;
    }

    String getLabelInclusion() {
        return this.labelInclusion;
    }

    static int getLabelAttributeNameCount(List<ColorMapLabelMatcher> colorMapLabelMatchers) {
        return (int)colorMapLabelMatchers.stream().filter(l -> l.getAttributeName() == DEFAULT_ATTRIBUTE_NAME).count();
    }

    static boolean isLabelReplacingValue(List<ColorMapLabelMatcher> colorMapLabelMatchers) {
        return !colorMapLabelMatchers.isEmpty() && colorMapLabelMatchers.stream().allMatch(l -> l.getLabelInclusion().equals(LabelInFeatureInfoMode.REPLACE.name()));
    }

    static enum LabelInFeatureInfoMode {
        ADD,
        REPLACE,
        NONE;


        static List<String> getAsStringList() {
            return Stream.of(LabelInFeatureInfoMode.values()).map(v -> v.name()).collect(Collectors.toList());
        }
    }
}

