/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public final class LayerIdentifierUtils {
    private static final Logger LOGGER = Logging.getLogger(LayerIdentifierUtils.class);

    private LayerIdentifierUtils() {
    }

    public static List<FeatureCollection> reproject(List<FeatureCollection> featureCollections, CoordinateReferenceSystem targetCrs) {
        if (targetCrs == null) {
            return featureCollections;
        }
        return featureCollections.stream().map(featureCollection -> LayerIdentifierUtils.reproject(featureCollection, targetCrs)).collect(Collectors.toList());
    }

    public static FeatureCollection reproject(FeatureCollection featureCollection, CoordinateReferenceSystem targetCrs) {
        if (targetCrs == null) {
            return featureCollection;
        }
        if (!(featureCollection instanceof SimpleFeatureCollection)) {
            LOGGER.warning("Complex feature collection will not be reprojected.");
            return featureCollection;
        }
        CoordinateReferenceSystem sourceCrs = featureCollection.getSchema().getCoordinateReferenceSystem();
        if (sourceCrs == null) {
            return featureCollection;
        }
        if (!CRS.equalsIgnoreMetadata((Object)sourceCrs, (Object)targetCrs)) {
            try {
                return new ReprojectFeatureResults(featureCollection, targetCrs);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Error reproject feature collection from SRS '%s' to SRS '%s'.", CRS.toSRS((CoordinateReferenceSystem)sourceCrs), CRS.toSRS((CoordinateReferenceSystem)targetCrs)), exception);
            }
        }
        return featureCollection;
    }

    public static CoordinateReferenceSystem getCrs(FeatureCollection featureCollection) {
        CoordinateReferenceSystem crs = featureCollection.getSchema().getCoordinateReferenceSystem();
        if (crs != null || featureCollection.isEmpty()) {
            return crs;
        }
        GeometryDescriptor geometryDescriptor = featureCollection.getSchema().getGeometryDescriptor();
        CoordinateReferenceSystem coordinateReferenceSystem = crs = geometryDescriptor == null ? null : geometryDescriptor.getCoordinateReferenceSystem();
        if (crs != null) {
            return crs;
        }
        try (FeatureIterator iterator = featureCollection.features();){
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                if (!(feature instanceof SimpleFeature)) {
                    CoordinateReferenceSystem coordinateReferenceSystem2 = null;
                    return coordinateReferenceSystem2;
                }
                SimpleFeature simpleFeature = (SimpleFeature)feature;
                Object object = simpleFeature.getDefaultGeometry();
                if (!(object instanceof Geometry)) continue;
                Geometry geometry = (Geometry)object;
                Object userData = geometry.getUserData();
                if (!(userData instanceof CoordinateReferenceSystem)) {
                    CoordinateReferenceSystem coordinateReferenceSystem3 = null;
                    return coordinateReferenceSystem3;
                }
                CoordinateReferenceSystem geometryCrs = (CoordinateReferenceSystem)userData;
                if (crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)geometryCrs)) {
                    CoordinateReferenceSystem coordinateReferenceSystem4 = null;
                    return coordinateReferenceSystem4;
                }
                crs = geometryCrs;
            }
        }
        return crs;
    }
}

