/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.AbstractOpenLayersMapOutputFormat;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;

public class OpenLayers2MapOutputFormat
extends AbstractOpenLayersMapOutputFormat {
    static final String OL2_TEMPLATE_FTL = "OpenLayers2MapTemplate.ftl";
    public static final String OL2_FORMAT = "application/openlayers2";
    public static final String MIME_TYPE = "text/html; subtype=openlayers2";
    private static final Set<String> OUTPUT_FORMATS = new HashSet<String>(Arrays.asList("application/openlayers2", "text/html; subtype=openlayers2"));

    public OpenLayers2MapOutputFormat(WMS wms) {
        super(wms);
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return OUTPUT_FORMATS;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    protected String getTemplateName(WMSMapContent mapContent) {
        return OL2_TEMPLATE_FTL;
    }

    @Override
    protected String getUnits(WMSMapContent mapContent) {
        CoordinateReferenceSystem crs = mapContent.getRequest().getCrs();
        String result = crs instanceof ProjectedCRS ? "m" : "degrees";
        try {
            String unit = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
            String degreeSign = "\u00b0";
            if ("\u00b0".equals(unit) || "degrees".equals(unit) || "dd".equals(unit)) {
                result = "degrees";
            } else if ("m".equals(unit) || "meters".equals(unit)) {
                result = "m";
            } else if ("km".equals(unit) || "kilometers".equals(unit)) {
                result = "mi";
            } else if ("in".equals(unit) || "inches".equals(unit)) {
                result = "inches";
            } else if ("ft".equals(unit) || "feets".equals(unit)) {
                result = "ft";
            } else if ("mi".equals(unit) || "miles".equals(unit)) {
                result = "mi";
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error trying to determine unit of measure", e);
        }
        return result;
    }
}

