/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.OverlapBehavior;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.filter.FilterAttributeExtractor;

public class PaletteExtractor
extends FilterAttributeExtractor
implements StyleVisitor {
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final int TRANSPARENT_CODE = 0xFFFFFF;
    Set<Color> colors = new HashSet<Color>();
    boolean translucentSymbolizers;
    boolean externalGraphicsSymbolizers;
    boolean unknownColors;
    boolean rasterUsed;

    public PaletteExtractor(Color background) {
        super(null);
        if (background == null) {
            background = TRANSPARENT;
        }
        this.colors.add(background);
    }

    public boolean canComputePalette() {
        if (this.translucentSymbolizers || this.externalGraphicsSymbolizers || this.unknownColors || this.rasterUsed) {
            return false;
        }
        return !this.colors.isEmpty() && this.colors.size() <= 256;
    }

    public IndexColorModel getPalette() {
        int length;
        if (!this.canComputePalette()) {
            return null;
        }
        int[] cmap = new int[this.colors.size()];
        int i = 0;
        for (Color color : this.colors) {
            cmap[i++] = color.getAlpha() << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        }
        Arrays.sort(cmap);
        int transparentIndex = cmap[cmap.length - 1] == 0xFFFFFF ? cmap.length - 1 : -1;
        int bits = 8;
        if (cmap.length <= 2) {
            bits = 1;
        } else if (cmap.length <= 4) {
            bits = 2;
        } else if (cmap.length <= 16) {
            bits = 4;
        }
        int n = length = bits == 1 ? 2 : 256;
        if (cmap.length < length) {
            int[] temp = new int[length];
            System.arraycopy(cmap, 0, temp, 0, cmap.length);
            cmap = temp;
        }
        return new IndexColorModel(bits, cmap.length, cmap, 0, true, transparentIndex, 0);
    }

    void handleOpacity(Expression opacity) {
        if (opacity == null) {
            return;
        }
        if (opacity instanceof Literal) {
            Literal lo = (Literal)opacity;
            double value = (Double)lo.evaluate(null, Double.class);
            this.translucentSymbolizers = this.translucentSymbolizers || value != 1.0;
        } else {
            this.translucentSymbolizers = true;
        }
    }

    void handleColor(Expression color) {
        if (color == null) {
            return;
        }
        if (color instanceof Literal) {
            Literal lc = (Literal)color;
            String rgbColor = (String)lc.evaluate(null, String.class);
            this.colors.add(Color.decode(rgbColor));
        } else {
            this.unknownColors = true;
        }
    }

    public void visit(Style style) {
        style.featureTypeStyles().forEach(ft -> ft.accept((StyleVisitor)this));
    }

    public void visit(Rule rule) {
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        rule.symbolizers().forEach(s -> s.accept((StyleVisitor)this));
    }

    public void visit(FeatureTypeStyle fts) {
        fts.rules().forEach(r -> r.accept((StyleVisitor)this));
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers;
        for (StyledLayer layer : layers = sld.getStyledLayers()) {
            if (layer instanceof NamedLayer) {
                ((NamedLayer)layer).accept((StyleVisitor)this);
                continue;
            }
            if (!(layer instanceof UserLayer)) continue;
            ((UserLayer)layer).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        Style[] styles;
        for (Style style : styles = layer.getStyles()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        Style[] styles;
        for (Style style : styles = layer.getUserStyles()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(Fill fill) {
        this.handleColor(fill.getColor());
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept((StyleVisitor)this);
        }
        this.handleOpacity(fill.getOpacity());
    }

    public void visit(Stroke stroke) {
        this.handleColor(stroke.getColor());
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept((StyleVisitor)this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept((StyleVisitor)this);
        }
        this.handleOpacity(stroke.getOpacity());
    }

    public void visit(RasterSymbolizer rs) {
        this.rasterUsed = true;
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (text instanceof TextSymbolizer && text.getGraphic() != null) {
            text.getGraphic().accept((StyleVisitor)this);
        }
        if (text.getFill() != null) {
            text.getFill().accept((StyleVisitor)this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
    }

    public void visit(Graphic gr) {
        for (GraphicalSymbol symbol : gr.graphicalSymbols()) {
            if (symbol instanceof Symbol) {
                symbol.accept((StyleVisitor)this);
                continue;
            }
            throw new RuntimeException("Don't know how to copy " + symbol);
        }
        this.handleOpacity(gr.getOpacity());
    }

    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept((StyleVisitor)this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(ExternalGraphic exgr) {
        this.externalGraphicsSymbolizers = true;
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept((StyleVisitor)this);
        }
    }

    public void visit(ColorMap map) {
        this.unknownColors = true;
    }

    public void visit(ColorMapEntry entry) {
        this.unknownColors = true;
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
        this.unknownColors = true;
    }

    public void visit(ImageOutline outline) {
        this.unknownColors = true;
    }

    public void visit(ChannelSelection cs) {
        this.unknownColors = true;
    }

    public void visit(OverlapBehavior ob) {
        this.unknownColors = true;
    }

    public void visit(SelectedChannelType sct) {
        this.unknownColors = true;
    }

    public void visit(ShadedRelief sr) {
        this.unknownColors = true;
    }
}

