/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.utfgrid;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.util.JSONBuilder;
import net.sf.json.util.JSONStringer;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RawMap;
import org.geoserver.wms.utfgrid.UTFGridEntries;
import org.geoserver.wms.utfgrid.UTFGridMapContent;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.util.Converters;
import org.geotools.xml.gml.GMLComplexTypes;

public class UTFGridMap
extends RawMap {
    private RenderedImage image;

    public UTFGridMap(UTFGridMapContent mapContent, RenderedImage image) {
        super((WMSMapContent)mapContent, (byte[])null, "application/json;type=utfgrid");
        this.image = image;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        UTFGridEntries.UTFGridEntry entry;
        Iterator<UTFGridEntries.UTFGridEntry> it;
        UTFGridEntries entries = this.getEntries();
        PrintWriter pw = new PrintWriter(out);
        pw.println("{");
        pw.println("\"grid\": [");
        List<UTFGridEntries.UTFGridEntry> encodedEntries = this.writeGrid(pw, this.image, entries);
        pw.println("],");
        pw.println("\"keys\": [");
        if (encodedEntries.isEmpty()) {
            pw.println("  \"\"");
        } else {
            pw.println("  \"\",");
            it = encodedEntries.iterator();
            while (it.hasNext()) {
                entry = it.next();
                pw.print("  \"");
                pw.print(entry.getKey());
                if (it.hasNext()) {
                    pw.println("\",");
                    continue;
                }
                pw.println("\"");
            }
        }
        pw.println("],");
        pw.println("\"data\": {");
        it = encodedEntries.iterator();
        while (it.hasNext()) {
            entry = it.next();
            pw.print("  \"");
            pw.print(entry.getKey());
            pw.print("\" : ");
            pw.print(this.getAttributesJson(entry.getFeature()));
            if (!it.hasNext()) continue;
            pw.println(",");
        }
        pw.println("}");
        pw.println("}");
        pw.flush();
    }

    private String getAttributesJson(Feature feature) {
        JSONBuilder builder = new JSONStringer().object();
        builder.key("id").value((Object)feature.getIdentifier().toString());
        if (feature instanceof SimpleFeature) {
            SimpleFeature sf = (SimpleFeature)feature;
            for (AttributeDescriptor ad : sf.getFeatureType().getAttributeDescriptors()) {
                if (ad instanceof GeometryDescriptor) continue;
                String name = ad.getLocalName();
                Object value = sf.getAttribute(name);
                this.addAttribute(builder, name, value);
            }
        } else {
            for (Property p : feature.getProperties()) {
                if (p.getType() instanceof GMLComplexTypes.GeometryPropertyType) continue;
                String name = p.getName().getLocalPart();
                Object value = p.getValue();
                this.addAttribute(builder, name, value);
            }
        }
        builder.endObject();
        return builder.toString();
    }

    private void addAttribute(JSONBuilder builder, String name, Object value) {
        if (value instanceof Date || value instanceof Calendar) {
            value = Converters.convert((Object)value, String.class);
        }
        builder.key(name).value(value);
    }

    private List<UTFGridEntries.UTFGridEntry> writeGrid(PrintWriter pw, RenderedImage image, UTFGridEntries entries) {
        Map<Integer, UTFGridEntries.UTFGridEntry> keyToFeature = entries.getEntryMap();
        ArrayList<UTFGridEntries.UTFGridEntry> result = new ArrayList<UTFGridEntries.UTFGridEntry>();
        int key = 1;
        Raster data = this.getData(image);
        int width = data.getWidth();
        int[] pixels = new int[width];
        int height = data.getHeight();
        for (int r = 0; r < height; ++r) {
            data.getDataElements(0, r, width, 1, pixels);
            pw.print("\"");
            for (int j : pixels) {
                int pixel = j & 0xFFFFFF;
                if (pixel == 0) {
                    pw.print(" ");
                    continue;
                }
                UTFGridEntries.UTFGridEntry entry = keyToFeature.get(pixel);
                if (entry == null) {
                    throw new RuntimeException("Could not find entry for pixel value " + pixel + ". This normally means there is some color altering option at work that the UTFGrid code failed to remove, like opacity, blending and the like");
                }
                int entryKey = entry.getKey();
                if (entryKey == -1) {
                    entryKey = key++;
                    entry.setKey(entryKey);
                    result.add(entry);
                }
                pw.print(this.getGridChar(entryKey));
            }
            if (r < height - 1) {
                pw.println("\",");
                continue;
            }
            pw.println("\"");
        }
        return result;
    }

    private Raster getData(RenderedImage image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getRaster();
        }
        return image.getData();
    }

    private char getGridChar(int val) {
        int result = val + 32;
        if (result >= 34) {
            ++result;
        }
        if (result >= 92) {
            ++result;
        }
        return (char)result;
    }

    UTFGridEntries getEntries() {
        UTFGridMapContent mc = (UTFGridMapContent)this.mapContent;
        return mc.getEntries();
    }
}

