/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.util.IOUtils;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.DateUtil;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.util.DefaultFileFilter;
import org.geotools.util.Range;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RasterTimeDimensionDefaultValueTest
extends WMSDimensionsTestSupport {
    static final QName WATTEMP_FUTURE = new QName(MockData.SF_URI, "watertemp_future_generated", MockData.SF_PREFIX);
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        RasterTimeDimensionDefaultValueTest.prepareFutureCoverageData(WATTEMP_FUTURE, this.getDataDirectory(), this.getCatalog());
    }

    @Before
    public void setup() throws Exception {
        this.wms = this.getWMS();
    }

    @Test
    public void testDefaultTimeCoverageSelector() throws Exception {
        this.setupResourceDimensionDefaultValue(WATTEMP_FUTURE, "time", null, new String[0]);
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        long todayMidnight = cal.getTimeInMillis();
        CoverageInfo coverage = this.getCatalog().getCoverageByName(WATTEMP_FUTURE.getLocalPart());
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)coverage);
        Assert.assertNotNull((String)"Returns a valid Default time", (Object)d);
        Assert.assertEquals((String)"Default time should be the closest one", (long)d.getTime(), (long)todayMidnight);
    }

    @Test
    public void testExplicitCurrentTimeCoverageSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(DimensionDefaultValueSetting.TIME_CURRENT);
        this.setupResourceDimensionDefaultValue(WATTEMP_FUTURE, "time", defaultValueSetting, new String[0]);
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        long todayMidnight = cal.getTimeInMillis();
        CoverageInfo coverage = this.getCatalog().getCoverageByName(WATTEMP_FUTURE.getLocalPart());
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)coverage);
        Assert.assertNotNull((String)"Returns a valid Default time", (Object)d);
        Assert.assertEquals((String)"Default time should be the closest one", (long)d.getTime(), (long)todayMidnight);
    }

    @Test
    public void testFixedTimeRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("P1M/PRESENT");
        this.setupResourceDimensionDefaultValue(WATTEMP_FUTURE, "time", defaultValueSetting, new String[0]);
        CoverageInfo coverage = this.getCatalog().getCoverageByName(WATTEMP_FUTURE.getLocalPart());
        java.util.Date curr = new java.util.Date();
        Range d = (Range)this.wms.getDefaultTime((ResourceInfo)coverage);
        Assert.assertNotNull((String)"Returns a valid Default range", (Object)d);
        RasterTimeDimensionDefaultValueTest.assertDateEquals(curr, (java.util.Date)d.getMaxValue(), 60000L);
        RasterTimeDimensionDefaultValueTest.assertDateEquals(new Date(curr.getTime() - 2592000000L), (java.util.Date)d.getMinValue(), 60000L);
    }

    @Test
    public void testExplicitMinTimeCoverageSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.setupResourceDimensionDefaultValue(WATTEMP_FUTURE, "time", defaultValueSetting, new String[0]);
        Date expected = Date.valueOf("2008-10-31");
        CoverageInfo coverage = this.getCatalog().getCoverageByName(WATTEMP_FUTURE.getLocalPart());
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)coverage);
        Assert.assertNotNull((String)"Returns a valid Default time", (Object)d);
        Assert.assertEquals((String)"Default time should be the smallest one", (long)d.getTime(), (long)expected.getTime());
    }

    @Test
    public void testExplicitMaxTimeCoverageSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.setupResourceDimensionDefaultValue(WATTEMP_FUTURE, "time", defaultValueSetting, new String[0]);
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        cal.set(2, cal.get(2) + 1);
        cal.set(2, cal.get(2) - 1);
        cal.set(1, cal.get(1) + 1);
        long oneYearInFuture = cal.getTimeInMillis();
        CoverageInfo coverage = this.getCatalog().getCoverageByName(WATTEMP_FUTURE.getLocalPart());
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)coverage);
        Assert.assertNotNull((String)"Returns a valid Default time", (Object)d);
        Assert.assertEquals((String)"Default time should be the biggest one", (long)d.getTime(), (long)oneYearInFuture);
    }

    @Test
    public void testExplicitFixedTimeCoverageSelector() throws Exception {
        String fixedTimeStr = "2012-06-01T03:00:00.000Z";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue(fixedTimeStr);
        this.setupResourceDimensionDefaultValue(WATTEMP_FUTURE, "time", defaultValueSetting, new String[0]);
        long fixedTime = DateUtil.parseDateTime((String)fixedTimeStr);
        CoverageInfo coverage = this.getCatalog().getCoverageByName(WATTEMP_FUTURE.getLocalPart());
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)coverage);
        Assert.assertNotNull((String)"Returns a valid Default time", (Object)d);
        Assert.assertEquals((String)"Default time should be the fixed one", (long)d.getTime(), (long)fixedTime);
    }

    @Test
    public void testExplicitNearestToGivenTimeCoverageSelector() throws Exception {
        String preferredTimeStr = "2009-01-01T00:00:00.000Z";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(preferredTimeStr);
        this.setupResourceDimensionDefaultValue(WATTEMP_FUTURE, "time", defaultValueSetting, new String[0]);
        Date expected = Date.valueOf("2008-11-01");
        CoverageInfo coverage = this.getCatalog().getCoverageByName(WATTEMP_FUTURE.getLocalPart());
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)coverage);
        Assert.assertNotNull((String)"Returns a valid Default time", (Object)d);
        Assert.assertEquals((String)"Default time should be the closest one", (long)d.getTime(), (long)expected.getTime());
    }

    public static void prepareFutureCoverageData(QName coverageName, GeoServerDataDirectory dataDirectory, Catalog catalog) throws IOException {
        SimpleDateFormat tsFormatter = new SimpleDateFormat("yyyyMMdd");
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        long justPast = cal.getTimeInMillis();
        cal.set(2, cal.get(2) + 1);
        long oneMonthInFuture = cal.getTimeInMillis();
        cal.set(2, cal.get(2) - 1);
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        cal.set(1, cal.get(1) + 1);
        long oneYearInFuture = cal.getTimeInMillis();
        GeoServerResourceLoader loader = catalog.getResourceLoader();
        File targetDir = loader.createDirectory(dataDirectory.root(), coverageName.getPrefix() + File.separator + coverageName.getLocalPart());
        File target = new File(targetDir, coverageName.getLocalPart() + ".zip");
        loader.copyFromClassPath("org/geoserver/wms/dimension/watertemp.zip", target);
        IOUtils.decompress((File)target, (File)targetDir);
        target.delete();
        File input = null;
        File output = null;
        DefaultFileFilter tiffFilter = new DefaultFileFilter("*.tiff");
        String[] tiffnames = targetDir.list((FilenameFilter)tiffFilter);
        if (tiffnames != null && tiffnames.length > 0) {
            input = new File(targetDir, tiffnames[0]);
            output = new File(targetDir, "DUMMY_watertemp_000_" + tsFormatter.format(new Date(justPast)) + "T0000000_12.tiff");
            FileUtils.copyFile((File)input, (File)output);
            output = new File(targetDir, "DUMMY_watertemp_000_" + tsFormatter.format(new Date(oneMonthInFuture)) + "T0000000_12.tiff");
            FileUtils.copyFile((File)input, (File)output);
            output = new File(targetDir, "DUMMY_watertemp_000_" + tsFormatter.format(new Date(oneYearInFuture)) + "T0000000_12.tiff");
            FileUtils.copyFile((File)input, (File)output);
        }
        RasterTimeDimensionDefaultValueTest.addRasterLayerFromDataDir(WATTEMP_FUTURE, dataDirectory, catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRasterLayerFromDataDir(QName qName, GeoServerDataDirectory dataDirectory, Catalog catalog) throws IOException {
        String prefix = qName.getPrefix();
        String name = qName.getLocalPart();
        File file = new File(dataDirectory.root() + File.separator + prefix, name);
        if (!file.exists()) {
            throw new IllegalArgumentException("There is no file with name '" + prefix + File.separator + name + "' in the data directory");
        }
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
        if (format == null) {
            throw new RuntimeException("No format for " + file.getCanonicalPath());
        }
        AbstractGridCoverage2DReader reader = null;
        try {
            CoverageStoreInfo store;
            reader = format.getReader((Object)file);
            if (reader == null) {
                throw new RuntimeException("No reader for " + file.getCanonicalPath() + " with format " + format.getName());
            }
            if (catalog.getWorkspaceByName(prefix) == null) {
                ((SystemTestData)testData).addWorkspace(prefix, qName.getNamespaceURI(), catalog);
            }
            if ((store = catalog.getCoverageStoreByName(prefix, name)) == null) {
                store = catalog.getFactory().createCoverageStore();
            }
            store.setName(name);
            store.setWorkspace(catalog.getWorkspaceByName(prefix));
            store.setEnabled(true);
            store.setURL(URLs.fileToUrl((File)file).toString());
            store.setType(format.getName());
            if (store.getId() == null) {
                catalog.add((StoreInfo)store);
            } else {
                catalog.save((StoreInfo)store);
            }
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore((StoreInfo)store);
            CoverageInfo coverage = null;
            try {
                coverage = builder.buildCoverage((GridCoverage2DReader)reader, null);
                if (format instanceof ImageMosaicFormat) {
                    coverage.getParameters().put(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().getCode(), Boolean.FALSE);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            coverage.setName(name);
            coverage.setTitle(name);
            coverage.setDescription(name);
            coverage.setEnabled(true);
            CoverageInfo cov = catalog.getCoverageByCoverageStore(store, name);
            if (cov == null) {
                catalog.add((ResourceInfo)coverage);
            } else {
                builder.updateCoverage(cov, coverage);
                catalog.save((ResourceInfo)cov);
                coverage = cov;
            }
            LayerInfo layer = catalog.getLayerByName((Name)new NameImpl(qName));
            if (layer == null) {
                layer = catalog.getFactory().createLayer();
            }
            layer.setResource((ResourceInfo)coverage);
            layer.setDefaultStyle(catalog.getStyleByName(SystemTestData.DEFAULT_RASTER_STYLE));
            layer.setType(PublishedType.RASTER);
            layer.setEnabled(true);
            if (layer.getId() == null) {
                catalog.add(layer);
            } else {
                catalog.save(layer);
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }
}

