/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.Range;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VectorElevationDimensionDefaultValueTest
extends WMSTestSupport {
    static final QName ELEVATION_WITH_START_END = new QName(MockData.SF_URI, "ElevationWithStartEnd", MockData.SF_PREFIX);
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setup() throws Exception {
        this.wms = this.getWMS();
        ((SystemTestData)testData).addVectorLayer(ELEVATION_WITH_START_END, Collections.emptyMap(), "TimeElevationWithStartEnd.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testExplicitMinElevationVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.setupFeatureElevationDimension(defaultValueSetting);
        FeatureTypeInfo elevationWithStartEnd = this.getCatalog().getFeatureTypeByName(ELEVATION_WITH_START_END.getLocalPart());
        Double originallySmallest = 1.0;
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the smallest one", (Math.abs(e - originallySmallest) < 1.0E-5 ? 1 : 0) != 0);
        this.addFeatureWithElevation(fid++, 10.0);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the smallest one", (Math.abs(e - originallySmallest) < 1.0E-5 ? 1 : 0) != 0);
        Double smaller = originallySmallest - 1.0;
        this.addFeatureWithElevation(fid++, smaller);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the smallest one", (Math.abs(e - smaller) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitMaxElevationVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.setupFeatureElevationDimension(defaultValueSetting);
        FeatureTypeInfo elevationWithStartEnd = this.getCatalog().getFeatureTypeByName(ELEVATION_WITH_START_END.getLocalPart());
        Double originallyBiggest = 2.0;
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the biggest one", (Math.abs(e - originallyBiggest) < 1.0E-5 ? 1 : 0) != 0);
        Double smaller = originallyBiggest - 1.0;
        this.addFeatureWithElevation(fid++, smaller);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the biggest one", (Math.abs(e - originallyBiggest) < 1.0E-5 ? 1 : 0) != 0);
        Double bigger = originallyBiggest + 1.0;
        this.addFeatureWithElevation(fid++, bigger);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the biggest one", (Math.abs(e - bigger) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitFixedElevationVectorSelector() throws Exception {
        int fid = 1000;
        String fixedElevationStr = "550";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue(fixedElevationStr);
        Double fixedElevation = Double.parseDouble(fixedElevationStr);
        this.setupFeatureElevationDimension(defaultValueSetting);
        FeatureTypeInfo elevationWithStartEnd = this.getCatalog().getFeatureTypeByName(ELEVATION_WITH_START_END.getLocalPart());
        Double originallyBiggest = 3.0;
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the fixed one", (Math.abs(e - fixedElevation) < 1.0E-5 ? 1 : 0) != 0);
        Double smaller = originallyBiggest - 1.0;
        this.addFeatureWithElevation(fid++, smaller);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the fixed one", (Math.abs(e - fixedElevation) < 1.0E-5 ? 1 : 0) != 0);
        Double bigger = originallyBiggest + 1.0;
        this.addFeatureWithElevation(fid++, bigger);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the fixed one", (Math.abs(e - fixedElevation) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitNearestToGivenElevationVectorSelector() throws Exception {
        int fid = 1000;
        String referenceElevationStr = "1.6";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(referenceElevationStr);
        Double referenceElevation = Double.parseDouble(referenceElevationStr);
        this.setupFeatureElevationDimension(defaultValueSetting);
        FeatureTypeInfo elevationWithStartEnd = this.getCatalog().getFeatureTypeByName(ELEVATION_WITH_START_END.getLocalPart());
        Double expected = 2.0;
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)("Default elevation should be the nearest one to " + referenceElevation), (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
        expected = 1.8;
        this.addFeatureWithElevation(fid++, expected);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)("Default elevation should be the nearest one to " + referenceElevation), (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
        this.addFeatureWithElevation(fid++, 1.3);
        e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)("Default elevation should be the nearest one to " + referenceElevation), (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testFixedRangeElevation() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("-100/0");
        this.setupFeatureElevationDimension(defaultValueSetting);
        FeatureTypeInfo elevationWithStartEnd = this.getCatalog().getFeatureTypeByName(ELEVATION_WITH_START_END.getLocalPart());
        Range defaultRange = (Range)this.wms.getDefaultElevation((ResourceInfo)elevationWithStartEnd);
        Assert.assertNotNull((String)"Default elevation is null", (Object)defaultRange);
        Assert.assertEquals((double)-100.0, (double)((Double)defaultRange.getMinValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((Double)defaultRange.getMaxValue()), (double)0.0);
    }

    protected void setupFeatureElevationDimension(DimensionDefaultValueSetting defaultValue) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(ELEVATION_WITH_START_END.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute("startElevation");
        di.setDefaultValue(defaultValue);
        di.setPresentation(DimensionPresentation.LIST);
        info.getMetadata().put("elevation", (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void addFeature(int id, Date time, Double elevation) throws IOException {
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(ELEVATION_WITH_START_END.getLocalPart());
        SimpleFeatureStore fs = (SimpleFeatureStore)timeWithStartEnd.getFeatureSource(null, null);
        SimpleFeatureType type = (SimpleFeatureType)timeWithStartEnd.getFeatureType();
        MemoryFeatureCollection coll = new MemoryFeatureCollection(type);
        StringBuffer content = new StringBuffer();
        content.append(id);
        content.append('|');
        content.append(time.toString());
        content.append("||");
        content.append(elevation);
        content.append('|');
        SimpleFeature f = DataUtilities.createFeature((SimpleFeatureType)type, (String)content.toString());
        coll.add(f);
        try (Transaction tx = fs.getTransaction();){
            fs.addFeatures((FeatureCollection)coll);
            tx.commit();
        }
    }

    private void addFeatureWithElevation(int fid, double value) throws IOException {
        this.addFeature(fid, Date.valueOf("2013-01-13"), value);
    }
}

