/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import it.geosolutions.imageio.pam.PAMDataset;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.io.FileUtils;
import org.geoserver.wms.featureinfo.AttributeTableEnricher;
import org.geoserver.wms.featureinfo.RasterAttributeTableVisitor;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbolizer;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.PAMResourceInfo;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.xml.styling.SLDParser;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RasterAttributeTableVisitorTest {
    public static final String NATIVE_NAME = "rat";
    static File ROOT = new File("./src/test/resources/org/geoserver/wms/featureinfo");
    static GeoTiffReader READER;

    @BeforeClass
    public static void prepare() throws DataSourceException {
        READER = new GeoTiffReader((Object)new File(ROOT, "rat.tiff"));
    }

    @AfterClass
    public static void cleanup() {
        READER.dispose();
    }

    @Test
    public void testBelowMinScale() throws Exception {
        RasterAttributeTableVisitor visitor = new RasterAttributeTableVisitor(0.1, NATIVE_NAME, (GridCoverage2DReader)READER);
        this.getRatStyle().accept((StyleVisitor)visitor);
        Assert.assertNull((Object)visitor.getAttributeTableEnricher());
    }

    @Test
    public void testAboveMaxScale() throws Exception {
        RasterAttributeTableVisitor visitor = new RasterAttributeTableVisitor(2000000.0, NATIVE_NAME, (GridCoverage2DReader)READER);
        this.getRatStyle().accept((StyleVisitor)visitor);
        Assert.assertNull((Object)visitor.getAttributeTableEnricher());
    }

    @Test
    public void testNoVendorOption() throws Exception {
        Style style = this.getRatStyle();
        Symbolizer symbolizer = (Symbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        symbolizer.getOptions().clear();
        RasterAttributeTableVisitor visitor = new RasterAttributeTableVisitor(1000.0, NATIVE_NAME, (GridCoverage2DReader)READER);
        style.accept((StyleVisitor)visitor);
        Assert.assertNull((Object)visitor.getAttributeTableEnricher());
    }

    @Test
    public void testGetEnricher() throws Exception {
        RasterAttributeTableVisitor visitor = new RasterAttributeTableVisitor(1000.0, NATIVE_NAME, (GridCoverage2DReader)READER);
        this.getRatStyle().accept((StyleVisitor)visitor);
        AttributeTableEnricher enricher = visitor.getAttributeTableEnricher();
        Assert.assertNotNull((Object)enricher);
        PAMDataset.PAMRasterBand band = enricher.getPamRasterBand();
        PAMDataset pam = ((PAMResourceInfo)READER.getInfo(NATIVE_NAME)).getPAMDataset();
        Assert.assertEquals(pam.getPAMRasterBand().get(0), (Object)band);
    }

    @Test
    public void testNoPAMDataset() throws Exception {
        GeoTiffReader reader = new GeoTiffReader((Object)new File("./src/test/resources/org/geoserver/wms/wms_1_1_1/tazbm.tiff"));
        try {
            RasterAttributeTableVisitor visitor = new RasterAttributeTableVisitor(1000.0, "tazbm", (GridCoverage2DReader)reader);
            this.getRatStyle().accept((StyleVisitor)visitor);
            Assert.assertNull((Object)visitor.getAttributeTableEnricher());
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternalPam() throws Exception {
        File source = new File(ROOT, "rat.tiff");
        File target = new File("./target/not_rat.tiff");
        FileUtils.copyFile((File)source, (File)target);
        GeoTiffReader reader = new GeoTiffReader((Object)target);
        try {
            RasterAttributeTableVisitor visitor = new RasterAttributeTableVisitor(1000.0, "tazbm", (GridCoverage2DReader)reader);
            this.getRatStyle().accept((StyleVisitor)visitor);
            Assert.assertNull((Object)visitor.getAttributeTableEnricher());
        }
        finally {
            reader.dispose();
        }
    }

    private Style getRatStyle() throws FileNotFoundException {
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        parser.setInput(new File(ROOT, "rat.sld"));
        StyledLayerDescriptor sld = parser.parseSLD();
        return ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0];
    }
}

