/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.featureinfo.VectorRenderingLayerIdentifier;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.w3c.dom.Document;

public class RenderingBasedFeatureInfoTest
extends WMSTestSupport {
    private static final XpathEngine XPATH = XMLUnit.newXpathEngine();
    public static QName GRID;
    public static QName REPEATED;
    public static QName GIANT_POLYGON;
    public static QName GEOM_FUNCTION;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle("box-offset", "box-offset.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("transparent-fill", "transparent-fill.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        File styles = new File(testData.getDataDirectoryRoot(), "styles");
        File symbol = new File("./src/test/resources/org/geoserver/wms/featureinfo/box-offset.png");
        FileUtils.copyFileToDirectory((File)symbol, (File)styles);
        testData.addVectorLayer(GRID, Collections.emptyMap(), "grid.properties", RenderingBasedFeatureInfoTest.class, this.getCatalog());
        testData.addVectorLayer(REPEATED, Collections.emptyMap(), "repeated_lines.properties", RenderingBasedFeatureInfoTest.class, this.getCatalog());
        testData.addVectorLayer(GIANT_POLYGON, Collections.emptyMap(), "giantPolygon.properties", SystemTestData.class, this.getCatalog());
        testData.addVectorLayer(GEOM_FUNCTION, Collections.emptyMap(), "geom-function.properties", RenderingBasedFeatureInfoTest.class, this.getCatalog());
        testData.addStyle("ranged", "ranged.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("dynamic", "dynamic.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("symbol-uom", "symbol-uom.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("two-rules", "two-rules.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("two-fts", "two-fts.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("dashed", "dashed.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("dashed-exp", "dashed-exp.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("polydash", "polydash.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("doublepoly", "doublepoly.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("pureLabel", "purelabel.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("transform", "transform.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("geom-function", "geom-function.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @After
    public void cleanup() {
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setFeaturesReprojectionDisabled(false);
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @Test
    public void testHitAreaSize() throws Exception {
        GetFeatureInfoRequest request = new GetFeatureInfoRequest();
        GetMapRequest getMapRequest = new GetMapRequest();
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        layers.add(new MapLayerInfo(this.getCatalog().getLayerByName(MockData.BRIDGES.getLocalPart())));
        getMapRequest.setLayers(layers);
        getMapRequest.setSRS("EPSG:4326");
        getMapRequest.setBbox(new Envelope(1.955E-4, 2.035E-4, 6.96E-4, 7.04E-4));
        getMapRequest.setWidth(100);
        getMapRequest.setHeight(100);
        getMapRequest.setFormat("image/png");
        request.setGetMapRequest(getMapRequest);
        request.setQueryLayers(layers);
        request.setXPixel(45);
        request.setYPixel(45);
        FeatureInfoRequestParameters params = new FeatureInfoRequestParameters(request);
        VectorRenderingLayerIdentifier vrli = new VectorRenderingLayerIdentifier(this.getWMS(), null);
        Assert.assertEquals((long)0L, (long)vrli.identify(params, 10).size());
    }

    @Test
    public void testBoxOffset() throws Exception {
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        String url = "wms?REQUEST=GetFeatureInfo&BBOX=1.9E-4,6.9E-4,2.1E-4,7.1E-4&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=cite%3ABridges&Layers=cite%3ABridges&WIDTH=100&HEIGHT=100&format=image%2Fpng&styles=box-offset&srs=EPSG%3A4326&version=1.1.1&x=50&y=63&feature_count=50";
        JSONObject result1 = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)1L, (long)result1.getJSONArray("features").size());
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        JSONObject result2 = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)0L, (long)result2.getJSONArray("features").size());
    }

    @Test
    public void testRangedSize() throws Exception {
        String url = "wms?REQUEST=GetFeatureInfo&BBOX=0.000196%2C0.000696%2C0.000204%2C0.000704&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=cite%3ABridges&FEATURE_COUNT=50&Layers=cite%3ABridges&WIDTH=100&HEIGHT=100&format=image%2Fpng&styles=ranged&srs=EPSG%3A4326&version=1.1.1&x=49&y=65&feature_count=50";
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        JSONObject result1 = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)1L, (long)result1.getJSONArray("features").size());
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        JSONObject result2 = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)0L, (long)result2.getJSONArray("features").size());
    }

    @Test
    public void testDynamicSize() throws Exception {
        String baseUrl = "wms?REQUEST=GetFeatureInfo&BBOX=0.000196%2C0.000696%2C0.000204%2C0.000704&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=cite%3ABridges&FEATURE_COUNT=50&Layers=cite%3ABridges&WIDTH=100&HEIGHT=100&format=image%2Fpng&styles=dynamic&srs=EPSG%3A4326&version=1.1.1&feature_count=50";
        String url = baseUrl + "&x=49&y=60";
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        JSONObject result1 = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)0L, (long)result1.getJSONArray("features").size());
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        JSONObject result2 = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)1L, (long)result2.getJSONArray("features").size());
        url = baseUrl + "&x=54&y=50&buffer=10";
        JSONObject result3 = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)1L, (long)result3.getJSONArray("features").size());
    }

    @Test
    public void testUom() throws Exception {
        String url = "wms?REQUEST=GetFeatureInfo&BBOX=0.000196%2C0.000696%2C0.000204%2C0.000704&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=cite%3ABridges&FEATURE_COUNT=50&Layers=cite%3ABridges&WIDTH=100&HEIGHT=100&format=image%2Fpng&styles=symbol-uom&srs=EPSG%3A4326&version=1.1.1&x=49&y=60&feature_count=50";
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        JSONObject result = (JSONObject)this.getAsJSON(url);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testTwoRules() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=two-rules&width=20&height=20&x=10&y=10&info_format=application/json&feature_count=50";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testTwoFeatureTypeStyles() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=two-fts&width=20&height=20&x=10&y=10&info_format=application/json";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testFillStrokeDashArray() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=polydash&width=20&height=20&x=10&y=10&info_format=application/json";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testTransparentFill() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=transparent-fill&width=20&height=20&x=10&y=10&info_format=application/json";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testGenericGeometry() throws Exception {
        String layer = this.getLayerId(MockData.GENERICENTITY);
        String request = "wms?REQUEST=GetFeatureInfo&BBOX=-2.73291%2C55.220703%2C8.510254%2C69.720703&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=" + layer + "&Layers=" + layer + "&WIDTH=397&HEIGHT=512&format=image%2Fpng&styles=line&srs=EPSG%3A4326&version=1.1.1&x=284&y=269";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testDashed() throws Exception {
        String layer = this.getLayerId(MockData.GENERICENTITY);
        String request = "wms?REQUEST=GetFeatureInfo&&BBOX=0.778809%2C45.421875%2C12.021973%2C59.921875&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=" + layer + "&Layers=" + layer + "&WIDTH=397&HEIGHT=512&format=image%2Fpng&styles=dashed&srs=EPSG%3A4326&version=1.1.1&x=182&y=241";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testDashedWithExpressions() throws Exception {
        String layer = this.getLayerId(MockData.GENERICENTITY);
        String request = "wms?REQUEST=GetFeatureInfo&&BBOX=0.778809%2C45.421875%2C12.021973%2C59.921875&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=" + layer + "&Layers=" + layer + "&WIDTH=397&HEIGHT=512&format=image%2Fpng&styles=dashed-exp&srs=EPSG%3A4326&version=1.1.1&x=182&y=241";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testDoublePoly() throws Exception {
        String layer = this.getLayerId(GRID);
        String request = "wms?REQUEST=GetFeatureInfo&&BBOX=0,0,3,3&SERVICE=WMS&INFO_FORMAT=application/json&FEATURE_COUNT=50&QUERY_LAYERS=" + layer + "&Layers=" + layer + "&WIDTH=90&HEIGHT=90&format=image%2Fpng&styles=doublepoly&srs=EPSG%3A4326&version=1.1.1&x=36&y=36";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testRepeatedLine() throws Exception {
        String layer = this.getLayerId(REPEATED);
        String request = "wms?REQUEST=GetFeatureInfo&&BBOX=499900,499900,500100,500100&SERVICE=WMS&INFO_FORMAT=application/json&FEATURE_COUNT=50&QUERY_LAYERS=" + layer + "&Layers=" + layer + "&WIDTH=11&HEIGHT=11&format=image%2Fpng&styles=line&srs=EPSG%3A32615&version=1.1.1&x=5&y=5";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)2L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testPureLabelGenericGeometry() throws Exception {
        String layer = this.getLayerId(MockData.GENERICENTITY);
        String request = "wms?REQUEST=GetFeatureInfo&&BBOX=0.778809%2C45.421875%2C12.021973%2C59.921875&SERVICE=WMS&INFO_FORMAT=application/json&QUERY_LAYERS=" + layer + "&Layers=" + layer + "&WIDTH=397&HEIGHT=512&format=image%2Fpng&styles=pureLabel&srs=EPSG%3A4326&version=1.1.1&x=182&y=241";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testPureLabelPolygon() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=pureLabel&width=20&height=20&x=10&y=10&info_format=application/json";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapWrapping() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        Boolean original = (Boolean)wms.getMetadata().get(WMS.MAP_WRAPPING_KEY, Boolean.class);
        try {
            wms.getMetadata().put(WMS.MAP_WRAPPING_KEY, (Serializable)Boolean.TRUE);
            gs.save((ServiceInfo)wms);
            String layer = this.getLayerId(GIANT_POLYGON);
            String request = "wms?version=1.1.1&bbox=170,-10,190,10&format=image/png&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=polygon&width=100&height=100&x=60&y=0&srs=EPSG:4326&info_format=application/json";
            JSONObject result = (JSONObject)this.getAsJSON(request);
            Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
            String disableRequest = request + "&format_options=mapWrapping:false";
            result = (JSONObject)this.getAsJSON(disableRequest);
            Assert.assertEquals((long)0L, (long)result.getJSONArray("features").size());
            String enableRequest = request + "&format_options=mapWrapping:true";
            result = (JSONObject)this.getAsJSON(enableRequest);
            Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
            wms.getMetadata().put(WMS.MAP_WRAPPING_KEY, (Serializable)Boolean.FALSE);
            gs.save((ServiceInfo)wms);
            result = (JSONObject)this.getAsJSON(request);
            Assert.assertEquals((long)0L, (long)result.getJSONArray("features").size());
            result = (JSONObject)this.getAsJSON(disableRequest);
            Assert.assertEquals((long)0L, (long)result.getJSONArray("features").size());
            result = (JSONObject)this.getAsJSON(enableRequest);
            Assert.assertEquals((long)0L, (long)result.getJSONArray("features").size());
        }
        finally {
            wms.getMetadata().put(WMS.MAP_WRAPPING_KEY, (Serializable)original);
            gs.save((ServiceInfo)wms);
        }
    }

    @Test
    public void testCalculatedScale() throws Exception {
        int mapWidth = 1000;
        int mapHeight = 500;
        Envelope mapbbox = new Envelope(-2.0, 2.0, -1.0, 1.0);
        ReferencedEnvelope mapEnvelope = new ReferencedEnvelope(mapbbox, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        final HashMap hints = new HashMap();
        double originalScale = RendererUtilities.calculateScale((ReferencedEnvelope)mapEnvelope, (int)mapWidth, (int)mapHeight, hints);
        double originalOGCScale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)mapEnvelope, (int)mapWidth, hints);
        final MutableDouble calculatedScale = new MutableDouble(0.0);
        final MutableDouble calculatedOGCScale = new MutableDouble(0.0);
        VectorRenderingLayerIdentifier vrli = new VectorRenderingLayerIdentifier(this.getWMS(), null){

            protected GetMapOutputFormat createMapOutputFormat(BufferedImage image, VectorRenderingLayerIdentifier.FeatureInfoRenderListener featureInfoListener) {
                return new AbstractMapOutputFormat("image/png", new String[]{"png"}){

                    public WebMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
                        try {
                            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope((Envelope)mapContent.getViewport().getBounds(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                            calculatedScale.setValue(RendererUtilities.calculateScale((ReferencedEnvelope)referencedEnvelope, (int)mapContent.getMapWidth(), (int)mapContent.getMapHeight(), (Map)hints));
                            calculatedOGCScale.setValue(RendererUtilities.calculateOGCScale((ReferencedEnvelope)referencedEnvelope, (int)mapContent.getMapWidth(), (Map)hints));
                        }
                        catch (FactoryException | TransformException e) {
                            throw new ServiceException(e);
                        }
                        return null;
                    }

                    public MapProducerCapabilities getCapabilities(String format) {
                        return null;
                    }
                };
            }
        };
        GetFeatureInfoRequest request = new GetFeatureInfoRequest();
        GetMapRequest getMapRequest = new GetMapRequest();
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        layers.add(new MapLayerInfo(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart())));
        getMapRequest.setLayers(layers);
        getMapRequest.setSRS("EPSG:4326");
        getMapRequest.setBbox(mapbbox);
        getMapRequest.setWidth(mapWidth);
        getMapRequest.setHeight(mapHeight);
        request.setGetMapRequest(getMapRequest);
        request.setQueryLayers(layers);
        FeatureInfoRequestParameters params = new FeatureInfoRequestParameters(request);
        vrli.identify(params, 10);
        Assert.assertEquals((double)originalScale, (double)calculatedScale.doubleValue(), (double)(originalScale * 0.01));
        Assert.assertEquals((double)originalOGCScale, (double)calculatedOGCScale.doubleValue(), (double)(originalScale * 0.01));
    }

    @Test
    public void testRenderingTransform() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=image/png&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=transform&transparent=true&srs=EPSG:4326&width=20&height=20&x=10&y=10&info_format=application/json&feature_count=50";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    @Test
    public void testGetFeatureInfoReprojectionWithoutRendering() throws Exception {
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        String url = "wms?REQUEST=GetFeatureInfo&BBOX=21.1507032494,76.8104486492,23.3770930655,79.0368384649&SERVICE=WMS&INFO_FORMAT=text/xml; subtype=gml/3.1.1&QUERY_LAYERS=cite%3ABridges&Layers=cite%3ABridges&WIDTH=100&HEIGHT=100&format=image%2Fpng&styles=box-offset&srs=EPSG%3A3857&version=1.1.1&x=50&y=63&feature_count=50";
        Document result = this.getAsDOM(url);
        String srs = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/cite:Bridges[@gml:id='Bridges.1107531599613']/cite:the_geom/gml:Point/@srsName", result);
        MatcherAssert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)srs.contains("3857"), (Matcher)CoreMatchers.is((Object)true));
        String rawCoordinates = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/cite:Bridges[@gml:id='Bridges.1107531599613']/cite:the_geom/gml:Point/gml:pos/text()", result);
        this.checkCoordinates(rawCoordinates, 1.0E-4, 22.26389816, 77.92364356);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setFeaturesReprojectionDisabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        result = this.getAsDOM(url);
        srs = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/cite:Bridges[@gml:id='Bridges.1107531599613']/cite:the_geom/gml:Point/@srsName", result);
        MatcherAssert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)srs.contains("4326"), (Matcher)CoreMatchers.is((Object)true));
        rawCoordinates = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/cite:Bridges[@gml:id='Bridges.1107531599613']/cite:the_geom/gml:Point/gml:pos/text()", result);
        this.checkCoordinates(rawCoordinates, 1.0E-4, 2.0E-4, 7.0E-4);
    }

    @Test
    public void testGetFeatureInfoReprojectionWithRendering() throws Exception {
        String url = "wms?REQUEST=GetFeatureInfo&BBOX=-304226.149584,7404818.42511,947357.141801,10978414.0796&SERVICE=WMS&INFO_FORMAT=text/xml; subtype=gml/3.1.1&QUERY_LAYERS=GenericEntity&Layers=GenericEntity&WIDTH=397&HEIGHT=512&format=image%2Fpng&styles=line&srs=EPSG%3A3857&version=1.1.1&x=284&y=269";
        Document result = this.getAsDOM(url);
        String srs = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/sf:GenericEntity[@gml:id='GenericEntity.f004']/sf:attribut.geom/gml:Polygon/@srsName", result);
        MatcherAssert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)srs.contains("3857"), (Matcher)CoreMatchers.is((Object)true));
        String exteriorLinearRing = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/sf:GenericEntity[@gml:id='GenericEntity.f004']/sf:attribut.geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList/text()", result);
        this.checkCoordinates(exteriorLinearRing, 1.0E-4, 0.0, 8511908.69220489, 0.0, 9349764.17414691, 695746.81745796, 9349764.17414691, 695746.81745796, 8511908.69220489, 0.0, 8511908.69220489);
        String interiorLinearRing = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/sf:GenericEntity[@gml:id='GenericEntity.f004']/sf:attribut.geom/gml:Polygon/gml:interior/gml:LinearRing/gml:posList/text()", result);
        this.checkCoordinates(interiorLinearRing, 1.0E-4, 222638.98158655, 8741545.4358357, 222638.98158655, 8978686.31934769, 445277.96317309, 8859142.8005657, 222638.98158655, 8741545.4358357);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setFeaturesReprojectionDisabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        result = this.getAsDOM(url);
        srs = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/sf:GenericEntity[@gml:id='GenericEntity.f004']/sf:attribut.geom/gml:Polygon/@srsName", result);
        MatcherAssert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)srs.contains("4326"), (Matcher)CoreMatchers.is((Object)true));
        exteriorLinearRing = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/sf:GenericEntity[@gml:id='GenericEntity.f004']/sf:attribut.geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList/text()", result);
        this.checkCoordinates(exteriorLinearRing, 1.0E-4, 0.0, 60.5, 0.0, 64.0, 6.25, 64.0, 6.25, 60.5, 0.0, 60.5);
        interiorLinearRing = XPATH.evaluate("//wfs:FeatureCollection/gml:featureMembers/sf:GenericEntity[@gml:id='GenericEntity.f004']/sf:attribut.geom/gml:Polygon/gml:interior/gml:LinearRing/gml:posList/text()", result);
        this.checkCoordinates(interiorLinearRing, 1.0E-4, 2.0, 61.5, 2.0, 62.5, 4.0, 62.0, 2.0, 61.5);
    }

    @Test
    public void testGeomFunction() throws Exception {
        String layer = this.getLayerId(GEOM_FUNCTION);
        String request = "wms?version=1.1.1&bbox=1.2,0.2,1.8,0.7&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=geom-function&width=20&height=20&x=10&y=10&info_format=application/json&feature_count=50";
        JSONObject result = (JSONObject)this.getAsJSON(request);
        Assert.assertEquals((long)1L, (long)result.getJSONArray("features").size());
    }

    private void checkCoordinates(String rawCoordinates, double precision, double ... expected) {
        MatcherAssert.assertThat((Object)rawCoordinates, (Matcher)CoreMatchers.notNullValue());
        rawCoordinates = rawCoordinates.trim();
        String[] coordinates = rawCoordinates.split("\\s");
        MatcherAssert.assertThat((Object)coordinates.length, (Matcher)CoreMatchers.is((Object)expected.length));
        for (int i = 0; i < coordinates.length; ++i) {
            RenderingBasedFeatureInfoTest.checkNumberSimilar(coordinates[i], expected[i], precision);
        }
    }

    static {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("gs", "http://geoserver.org");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("cite", "http://www.opengis.net/cite");
        namespaces.put("sf", "http://cite.opengeospatial.org/gmlsf");
        XPATH.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        GRID = new QName(MockData.CITE_URI, "grid", MockData.CITE_PREFIX);
        REPEATED = new QName(MockData.CITE_URI, "repeated", MockData.CITE_PREFIX);
        GIANT_POLYGON = new QName(MockData.CITE_URI, "giantPolygon", MockData.CITE_PREFIX);
        GEOM_FUNCTION = new QName(MockData.CITE_URI, "geom-function", MockData.CITE_PREFIX);
    }
}

