/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.kvp.URIKvpParser;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.kvp.PaletteManager;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geoserver.wms.map.MockHttpClientConnectionManager;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.style.Style;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GetMapKvpRequestReaderTest
extends KvpRequestReaderTestSupport {
    private static final Logger LOG = Logging.getLogger(GetMapKvpRequestReaderTest.class);
    GetMapKvpRequestReader reader;
    WMS wms;
    Dispatcher dispatcher;
    public static final String STATES_SLD = "<StyledLayerDescriptor version=\"1.0.0\"><UserLayer><Name>sf:states</Name><UserStyle><Name>UserSelection</Name><FeatureTypeStyle><Rule><Filter xmlns:gml=\"http://www.opengis.net/gml\"><PropertyIsEqualTo><PropertyName>STATE_ABBR</PropertyName><Literal>IL</Literal></PropertyIsEqualTo></Filter><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#FF0000</CssParameter></Fill></PolygonSymbolizer></Rule><Rule><LineSymbolizer><Stroke/></LineSymbolizer></Rule></FeatureTypeStyle></UserStyle></UserLayer></StyledLayerDescriptor>";

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        CatalogFactory cf = this.getCatalog().getFactory();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo gi = cf.createLayerGroup();
        gi.setName("testGroup");
        gi.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi.getStyles().add(this.getCatalog().getStyleByName("polygon"));
        cb.calculateLayerGroupBounds(gi);
        this.getCatalog().add(gi);
        LayerGroupInfo gi2 = cf.createLayerGroup();
        gi2.setName("testGroup2");
        gi2.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi2.getStyles().add(this.getCatalog().getStyleByName("raster"));
        gi2.getLayers().add(this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart()));
        gi2.getStyles().add(this.getCatalog().getStyleByName("raster"));
        cb.calculateLayerGroupBounds(gi2);
        this.getCatalog().add(gi2);
        LayerGroupInfo gi3 = cf.createLayerGroup();
        gi3.setName("testGroup3");
        gi3.getLayers().add(this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart()));
        gi3.getStyles().add(this.getCatalog().getStyleByName("raster"));
        gi3.getLayers().add(this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart()));
        gi3.getStyles().add(this.getCatalog().getStyleByName("raster"));
        cb.calculateLayerGroupBounds(gi3);
        this.getCatalog().add(gi3);
    }

    protected void oneTimeTearDown() throws Exception {
        super.oneTimeTearDown();
        GeoServerLoader.setLegacy((boolean)false);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dispatcher = (Dispatcher)applicationContext.getBean("dispatcher");
        GeoServer geoserver = this.getGeoServer();
        WMSInfo wmsInfo = (WMSInfo)geoserver.getService(WMSInfo.class);
        WMSInfoImpl impl = (WMSInfoImpl)ModificationProxy.unwrap((Object)wmsInfo);
        impl.setAllowedURLsForAuthForwarding(Collections.singletonList("http://localhost/geoserver/rest/sldurl"));
        this.wms = new WMS(geoserver);
        this.reader = new GetMapKvpRequestReader(this.wms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSldEntityResolver() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        GeoServerInfo geoserverInfo = wms.getGeoServer().getGlobal();
        try {
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(true));
            this.getGeoServer().save(geoserverInfo);
            Assert.assertNotNull((Object)wms.getGeoServer().getGlobal().isXmlExternalEntitiesEnabled());
            Assert.assertTrue((boolean)wms.getGeoServer().getGlobal().isXmlExternalEntitiesEnabled());
            GetMapKvpRequestReader reader = new GetMapKvpRequestReader(wms);
            Assert.assertNull((Object)reader.getEntityResolverProvider().getEntityResolver());
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(false));
            this.getGeoServer().save(geoserverInfo);
            reader = new GetMapKvpRequestReader(wms);
            Assert.assertNotNull((Object)reader.getEntityResolverProvider().getEntityResolver());
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
            reader = new GetMapKvpRequestReader(wms);
            Assert.assertNotNull((Object)reader.getEntityResolverProvider().getEntityResolver());
        }
        finally {
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
        }
    }

    @Test
    public void testCreateRequest() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        Assert.assertNotNull((Object)request);
    }

    @Test
    public void testReadMandatory() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        String layer = MockData.BASIC_POLYGONS.getLocalPart();
        Assert.assertEquals((long)1L, (long)request.getLayers().size());
        Assert.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(layer));
        Assert.assertEquals((long)1L, (long)request.getStyles().size());
        Style expected = this.getCatalog().getStyleByName(layer).getStyle();
        Style style = (Style)request.getStyles().get(0);
        Assert.assertEquals((Object)expected, (Object)style);
        Assert.assertEquals((Object)"image/jpeg", (Object)request.getFormat());
        Assert.assertEquals((long)600L, (long)request.getHeight());
        Assert.assertEquals((long)800L, (long)request.getWidth());
        Assert.assertNotNull((Object)request.getBbox());
        Assert.assertEquals((double)-10.0, (double)request.getBbox().getMinX(), (double)0.0);
        Assert.assertEquals((double)-10.0, (double)request.getBbox().getMinY(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)request.getBbox().getMaxX(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)request.getBbox().getMaxY(), (double)0.0);
        Assert.assertEquals((Object)"epsg:3003", (Object)request.getSRS());
    }

    @Test
    public void testReadOptional() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("bgcolor", "000000");
        kvp.put("transparent", "true");
        kvp.put("tiled", "true");
        kvp.put("tilesorigin", "1.2,3.4");
        kvp.put("buffer", "1");
        kvp.put("palette", "SAFE");
        kvp.put("time", "2006-02-27T22:08:12Z");
        kvp.put("elevation", "4");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertEquals((Object)Color.BLACK, (Object)request.getBgColor());
        Assert.assertTrue((boolean)request.isTransparent());
        Assert.assertTrue((boolean)request.isTiled());
        Assert.assertEquals((Object)new Point2D.Double(1.2, 3.4), (Object)request.getTilesOrigin());
        Assert.assertEquals((long)1L, (long)request.getBuffer());
        Assert.assertEquals((Object)PaletteManager.safePalette, (Object)request.getPalette());
        Assert.assertEquals(Arrays.asList(4.0), (Object)request.getElevation());
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(2006, 1, 27, 22, 8, 12);
        List times = request.getTime();
        Assert.assertEquals((long)1L, (long)request.getTime().size());
        Assert.assertEquals((Object)cal.getTime(), (Object)((DateRange)times.get(0)).getMinValue());
    }

    @Test
    public void testDefaultStyle() throws Exception {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "," + MockData.BUILDINGS.getPrefix() + ":" + MockData.BUILDINGS.getLocalPart());
        raw.put("styles", ",");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        Assert.assertEquals((long)2L, (long)request.getStyles().size());
        LayerInfo basicPolygons = this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart());
        LayerInfo buildings = this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart());
        Assert.assertEquals((Object)basicPolygons.getDefaultStyle().getStyle(), request.getStyles().get(0));
        Assert.assertEquals((Object)buildings.getDefaultStyle().getStyle(), request.getStyles().get(1));
    }

    @Test
    public void testInterpolations() throws Exception {
        HashMap<String, Object> kvp = new HashMap<String, Object>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", "bicubic");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getInterpolations());
        Assert.assertEquals((long)1L, (long)request.getInterpolations().size());
        Assert.assertNotNull(request.getInterpolations().get(0));
        Assert.assertTrue((boolean)(request.getInterpolations().get(0) instanceof InterpolationBicubic));
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", "bicubic,,bilinear");
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getInterpolations());
        Assert.assertEquals((long)3L, (long)request.getInterpolations().size());
        Assert.assertNotNull(request.getInterpolations().get(0));
        Assert.assertNull(request.getInterpolations().get(1));
        Assert.assertNotNull(request.getInterpolations().get(2));
        Assert.assertTrue((boolean)(request.getInterpolations().get(2) instanceof InterpolationBilinear));
    }

    @Test
    public void testFiltersForLayerGroups() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", "testGroup3");
        kvp.put("cql_filter", "ADDRESS='123 Main Street'");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getFilter());
        Assert.assertEquals((long)2L, (long)request.getFilter().size());
        Assert.assertNotNull((Object)request.getCQLFilter());
        Assert.assertEquals((long)2L, (long)request.getCQLFilter().size());
    }

    @Test
    public void testInterpolationsForLayerGroups() throws Exception {
        HashMap<String, Object> kvp = new HashMap<String, Object>();
        kvp.put("layers", "testGroup2");
        kvp.put("interpolations", "bicubic");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getInterpolations());
        Assert.assertEquals((long)2L, (long)request.getInterpolations().size());
        Assert.assertNotNull(request.getInterpolations().get(0));
        Assert.assertTrue((boolean)(request.getInterpolations().get(0) instanceof InterpolationBicubic));
        Assert.assertNotNull(request.getInterpolations().get(1));
        Assert.assertTrue((boolean)(request.getInterpolations().get(1) instanceof InterpolationBicubic));
        kvp.put("layers", "testGroup2,testGroup," + this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", "bicubic,bilinear,nearest neighbor");
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getInterpolations());
        Assert.assertEquals((long)4L, (long)request.getInterpolations().size());
        Assert.assertNotNull(request.getInterpolations().get(0));
        Assert.assertTrue((boolean)(request.getInterpolations().get(0) instanceof InterpolationBicubic));
        Assert.assertNotNull(request.getInterpolations().get(1));
        Assert.assertTrue((boolean)(request.getInterpolations().get(1) instanceof InterpolationBicubic));
        Assert.assertNotNull(request.getInterpolations().get(2));
        Assert.assertTrue((boolean)(request.getInterpolations().get(2) instanceof InterpolationBilinear));
        Assert.assertNotNull(request.getInterpolations().get(3));
        Assert.assertTrue((boolean)(request.getInterpolations().get(3) instanceof InterpolationNearest));
        kvp.put("layers", "testGroup2,testGroup," + this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", ",bilinear");
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getInterpolations());
        Assert.assertEquals((long)4L, (long)request.getInterpolations().size());
        Assert.assertNull(request.getInterpolations().get(0));
        Assert.assertNull(request.getInterpolations().get(1));
        Assert.assertNotNull(request.getInterpolations().get(2));
        Assert.assertTrue((boolean)(request.getInterpolations().get(2) instanceof InterpolationBilinear));
        Assert.assertNull(request.getInterpolations().get(3));
    }

    @Test
    public void testFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("filter", "<Filter><FeatureId id=\"foo\"/></Filter>");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getFilter());
        Assert.assertEquals((long)1L, (long)request.getFilter().size());
        Id fid = (Id)request.getFilter().get(0);
        Assert.assertEquals((long)1L, (long)fid.getIDs().size());
        Assert.assertEquals((Object)"foo", fid.getIDs().iterator().next());
    }

    @Test
    public void testCQLFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("cql_filter", "foo = bar");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getCQLFilter());
        Assert.assertEquals((long)1L, (long)request.getCQLFilter().size());
        MatcherAssert.assertThat((Object)((Filter)request.getCQLFilter().get(0)), (Matcher)CoreMatchers.instanceOf(PropertyIsEqualTo.class));
    }

    @Test
    public void testFeatureId() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("featureid", "foo");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getFeatureId());
        Assert.assertEquals((long)1L, (long)request.getFeatureId().size());
        Assert.assertEquals((Object)"foo", request.getFeatureId().get(0));
    }

    @Test
    public void testSortBy() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("sortBy", "FID D");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertEquals((long)1L, (long)request.getSortBy().size());
        List sort = (List)request.getSortBy().get(0);
        Assert.assertEquals((long)1L, (long)sort.size());
        this.assertSortBy((SortBy)sort.get(0), "FID", SortOrder.DESCENDING);
    }

    @Test
    public void testSortByGroup() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", "testGroup2");
        kvp.put("sortBy", "FID D");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertEquals((long)2L, (long)request.getSortBy().size());
        List sort1 = (List)request.getSortBy().get(0);
        Assert.assertEquals((long)1L, (long)sort1.size());
        this.assertSortBy((SortBy)sort1.get(0), "FID", SortOrder.DESCENDING);
        List sort2 = (List)request.getSortBy().get(0);
        Assert.assertEquals((long)1L, (long)sort2.size());
        this.assertSortBy((SortBy)sort2.get(0), "FID", SortOrder.DESCENDING);
    }

    @Test
    public void testSortByLessThanRequired() throws Exception {
        HashMap<String, Object> kvp = new HashMap<String, Object>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.LAKES));
        kvp.put("sortBy", "FID D");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"sortBy"));
        }
    }

    private void assertSortBy(SortBy sort, String propertyName, SortOrder direction) {
        Assert.assertEquals((Object)propertyName, (Object)sort.getPropertyName().getPropertyName());
        Assert.assertEquals((Object)direction, (Object)sort.getSortOrder());
    }

    @Test
    public void testSldNoDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        GetMapRequest request = this.reader.createRequest();
        this.reader.setLaxStyleMatchAllowed(false);
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)URIKvpParser.uriEncode((String)decoded), (Object)request.getSld().toURL().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"BasicPolygons", (Object)style.getName());
    }

    @Test
    public void testSldDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)URIKvpParser.uriEncode((String)decoded), (Object)request.getSld().toURL().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"TheLibraryModeStyle", (Object)style.getName());
    }

    @Test
    public void testSldCache() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setCacheConfiguration(new CacheConfiguration(true));
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        URL sld = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(sld.openStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        MockHttpClientConnectionManager manager = new MockHttpClientConnectionManager(builder.toString(), true);
        this.reader = new GetMapKvpRequestReader(wms, (HttpClientConnectionManager)manager);
        HashMap<String, String> kvp = new HashMap<String, String>();
        String url = "http://cached_sld";
        kvp.put("sld", url);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((long)manager.getConnections(), (long)1L);
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertEquals((long)manager.getConnections(), (long)1L);
    }

    @Test
    public void testSldCacheNotEnabled() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setCacheConfiguration(new CacheConfiguration(true));
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        URL sld = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(sld.openStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        MockHttpClientConnectionManager manager = new MockHttpClientConnectionManager(builder.toString(), false);
        this.reader = new GetMapKvpRequestReader(wms, (HttpClientConnectionManager)manager);
        HashMap<String, String> kvp = new HashMap<String, String>();
        String url = "http://cached_sld";
        kvp.put("sld", url);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((long)manager.getConnections(), (long)1L);
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertEquals((long)manager.getConnections(), (long)2L);
    }

    @Test
    public void testSldDisabled() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setDynamicStylingDisabled(Boolean.TRUE);
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        this.reader = new GetMapKvpRequestReader(wms);
        GetMapRequest request = this.reader.createRequest();
        boolean error = false;
        try {
            request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        }
        catch (ServiceException e) {
            error = true;
        }
        this.getGeoServer().remove((ServiceInfo)info);
        this.getGeoServer().add((ServiceInfo)oldInfo);
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testSldBodyDisabled() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("sld_body", STATES_SLD);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setDynamicStylingDisabled(Boolean.TRUE);
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        this.reader = new GetMapKvpRequestReader(wms);
        GetMapRequest request = this.reader.createRequest();
        boolean error = false;
        try {
            request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        }
        catch (ServiceException e) {
            error = true;
        }
        this.getGeoServer().remove((ServiceInfo)info);
        this.getGeoServer().add((ServiceInfo)oldInfo);
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testSldNamed() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("styles", "TheLibraryModeStyle");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)URIKvpParser.uriEncode((String)decoded), (Object)request.getSld().toURL().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"TheLibraryModeStyle", (Object)style.getName());
    }

    @Test
    public void testSldFailLookup() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    @Test
    public void testSldConnectionFailure() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = new URL("http://hostthatdoesnotexist/");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            Assert.assertNull((String)"Exception should not reveal its cause", (Object)e.getCause());
        }
    }

    @Test
    public void testSldRemoteHttp() throws Exception {
        String fakeBasicAuth = "FakeBasicAuth";
        String authHeader = "Authorization";
        BasicHeader expectedBasicHeader = new BasicHeader("Authorization", "FakeBasicAuth");
        GetMapRequest request = this.reader.createRequest();
        GetMapRequest spyRequest = (GetMapRequest)Mockito.spy((Object)request);
        Mockito.when((Object)spyRequest.getHttpRequestHeader("Authorization")).thenReturn((Object)"FakeBasicAuth");
        Header[] headers = new Header[1];
        URL url = new URL("http://localhost/geoserver/rest/sldurl/sample.sld");
        this.requestWithHeaders(spyRequest, url, headers, "Authorization");
        this.assertSameHeader(headers, expectedBasicHeader);
        url = new URL("http://not-allowed-endpoint/sample.sld");
        this.requestWithHeaders(spyRequest, url, headers, "Authorization");
        this.assertSameHeader(headers, null);
    }

    private void requestWithHeaders(GetMapRequest spyRequest, URL url, final Header[] headers, final String authHeader) throws Exception {
        String urlDecoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("sld", urlDecoded);
        try (final InputStream sld = GetMapKvpRequestReader.class.getResourceAsStream("BasicPolygonsLibraryNoDefault.sld");){
            GetMapKvpRequestReader reqReader = new GetMapKvpRequestReader(this.wms, null){

                protected CloseableHttpResponse executeRequest(HttpCacheContext cacheContext, HttpGet httpget) throws IOException {
                    CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
                    HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
                    Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
                    Mockito.when((Object)entity.getContent()).thenReturn((Object)sld);
                    Header[] httpHeaders = httpget.containsHeader(authHeader) ? httpget.getHeaders(authHeader) : null;
                    headers[0] = httpHeaders != null ? httpHeaders[0] : null;
                    return response;
                }
            };
            reqReader.read((Object)spyRequest, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        }
    }

    private void assertSameHeader(Header[] headers, BasicHeader expectedBasicHeader) {
        if (expectedBasicHeader == null) {
            Assert.assertNull((Object)headers[0]);
        } else {
            Assert.assertEquals((Object)expectedBasicHeader.toString(), (Object)headers[0].toString());
        }
    }

    @Test
    public void testSldNotExist() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = new URL(GetMapKvpRequestReaderTest.class.getResource(""), "does-not-exist");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            Assert.assertNull((String)"Exception should not reveal its cause", (Object)e.getCause());
        }
    }

    @Test
    public void testSldNotXML() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReaderTest.class.getResource("paletted.tif");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            Assert.assertNull((String)"Exception should not reveal its cause", (Object)e.getCause());
        }
    }

    @Test
    public void testSldNotSld() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReaderTest.class.getResource("WMSPostLayerGroupNonDefaultStyle.xml");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            Assert.assertNull((String)"Exception should not reveal its cause", (Object)e.getCause());
        }
    }

    @Test
    public void testSldFeatureTypeConstraints() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsFeatureTypeConstaint.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)URIKvpParser.uriEncode((String)decoded), (Object)request.getSld().toURL().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"TheLibraryModeStyle", (Object)style.getName());
        Assert.assertEquals((long)1L, (long)request.getLayers().size());
        MapLayerInfo layer = (MapLayerInfo)request.getLayers().get(0);
        Assert.assertEquals((Object)this.getLayerId(MockData.BASIC_POLYGONS), (Object)layer.getName());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Assert.assertEquals((long)1L, (long)layer.getLayerFeatureConstraints().length);
        Assert.assertEquals((Object)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"xyz")), (Object)layer.getLayerFeatureConstraints()[0].getFilter());
    }

    @Test
    public void testSldLibraryFeatureTypeConstraints() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsFeatureTypeConstaint.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("styles", "TheLibraryModeStyle");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)URIKvpParser.uriEncode((String)decoded), (Object)request.getSld().toURL().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"TheLibraryModeStyle", (Object)style.getName());
        Assert.assertEquals((long)1L, (long)request.getLayers().size());
        MapLayerInfo layer = (MapLayerInfo)request.getLayers().get(0);
        Assert.assertEquals((Object)this.getLayerId(MockData.BASIC_POLYGONS), (Object)layer.getName());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Assert.assertEquals((long)1L, (long)layer.getLayerFeatureConstraints().length);
        Assert.assertEquals((Object)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"xyz")), (Object)layer.getLayerFeatureConstraints()[0].getFilter());
    }

    @Test
    public void testWmtVer() throws Exception {
        this.dispatcher.setCiteCompliant(true);
        String request = "wms?SERVICE=WMS&&WiDtH=200&FoRmAt=image/png&LaYeRs=cite:Lakes&StYlEs=&BbOx=0,-0.0020,0.0040,0&ReQuEsT=GetMap&HeIgHt=100&SrS=EPSG:4326&WmTvEr=1.1.1";
        Assert.assertEquals((Object)"image/png", (Object)this.getAsServletResponse(request).getContentType());
    }

    @Test
    public void testRemoteWFS() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://demo.opengeo.org/geoserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        Assert.assertEquals((Object)"WFS", (Object)request.getRemoteOwsType());
        Assert.assertEquals((Object)new URL("http://demo.opengeo.org/geoserver/wfs?"), (Object)request.getRemoteOwsURL());
        Assert.assertEquals((long)1L, (long)request.getLayers().size());
        Assert.assertEquals((long)PublishedType.REMOTE.getCode().intValue(), (long)((MapLayerInfo)request.getLayers().get(0)).getType());
        Assert.assertEquals((Object)"topp:states", (Object)((MapLayerInfo)request.getLayers().get(0)).getName());
    }

    @Test
    public void testRemoteWFSNoStyle() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://demo.opengeo.org/geoserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        try {
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            Assert.fail((String)"This should have thrown an exception because of the missing style");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)"NoDefaultStyle", (Object)e.getCode());
        }
    }

    @Test
    public void testRemoteWFSInvalidURL() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://phantom.openplans.org:8080/crapserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        try {
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            Assert.fail((String)"This should have thrown an exception because of the non existent layer");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)"RemoteOWSFailure", (Object)e.getCode());
        }
    }

    @Test
    public void testGroupInSLD() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("srs", "epsg:4326");
        kvp.put("bbox", "124.38035938267053,-58.45445933799711,169.29632161732948,-24.767487662002893");
        kvp.put("width", "640");
        kvp.put("height", "480");
        kvp.put("format", "image/png");
        URL url = GetMapKvpRequestReader.class.getResource("BaseMapGroup.sld");
        kvp.put("sld", URLDecoder.decode(url.toString(), "UTF-8"));
        kvp.put("version", "1.1.1");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertEquals((long)1L, (long)request.getLayers().size());
        Assert.assertEquals((long)1L, (long)request.getStyles().size());
        Assert.assertEquals((Object)this.getLayerId(MockData.BASIC_POLYGONS), (Object)((MapLayerInfo)request.getLayers().get(0)).getName());
        Style expectedStyle = this.getCatalog().getStyleByName("polygon").getStyle();
        Assert.assertEquals((Object)expectedStyle, request.getStyles().get(0));
    }

    @Test
    public void testViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        Assert.assertEquals((long)1L, (long)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        Assert.assertEquals((Object)"ABCD", viewParams.get("str"));
    }

    @Test
    public void testMultipleViewParams() throws Exception {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD,where:WHERE PERSONS > 10;str:FOO");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        Assert.assertEquals((long)2L, (long)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        Assert.assertEquals((Object)"ABCD", viewParams.get("str"));
        viewParams = (Map)viewParamsList.get(1);
        Assert.assertEquals((Object)"WHERE PERSONS > 10", viewParams.get("where"));
        Assert.assertEquals((Object)"FOO", viewParams.get("str"));
    }

    private HashMap setupBaseViewParamsRequest() {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        return raw;
    }

    @Test
    public void testFanOutViewParams() throws Exception {
        HashMap raw = this.setupBaseViewParamsRequest();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        Assert.assertEquals((long)2L, (long)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        Assert.assertEquals((Object)"ABCD", viewParams.get("str"));
        viewParams = (Map)viewParamsList.get(1);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        Assert.assertEquals((Object)"ABCD", viewParams.get("str"));
    }

    @Test
    public void testFanOutViewParamsGroupFirst() throws Exception {
        HashMap raw = this.setupBaseViewParamsRequest();
        raw.put("layers", "testGroup2," + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("viewParams", "test:123,where:WHERE PERSONS > 1000000,str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        Assert.assertEquals((long)4L, (long)viewParamsList.size());
        Assert.assertEquals(Map.of("test", "123"), viewParamsList.get(0));
        Assert.assertEquals(Map.of("test", "123"), viewParamsList.get(1));
        Assert.assertEquals(Map.of("where", "WHERE PERSONS > 1000000"), viewParamsList.get(2));
        Assert.assertEquals(Map.of("str", "ABCD"), viewParamsList.get(3));
    }

    @Test
    public void testFanOutViewParamsGroupMid() throws Exception {
        HashMap raw = this.setupBaseViewParamsRequest();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + ",testGroup2," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000,test:123,str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        Assert.assertEquals((long)4L, (long)viewParamsList.size());
        Assert.assertEquals(Map.of("where", "WHERE PERSONS > 1000000"), viewParamsList.get(0));
        Assert.assertEquals(Map.of("test", "123"), viewParamsList.get(1));
        Assert.assertEquals(Map.of("test", "123"), viewParamsList.get(2));
        Assert.assertEquals(Map.of("str", "ABCD"), viewParamsList.get(3));
    }

    @Test
    public void testFanOutViewParamsGroupLast() throws Exception {
        HashMap raw = this.setupBaseViewParamsRequest();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS) + ",testGroup2");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000,str:ABCD,test:123");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        Assert.assertEquals((long)4L, (long)viewParamsList.size());
        Assert.assertEquals(Map.of("where", "WHERE PERSONS > 1000000"), viewParamsList.get(0));
        Assert.assertEquals(Map.of("str", "ABCD"), viewParamsList.get(1));
        Assert.assertEquals(Map.of("test", "123"), viewParamsList.get(2));
        Assert.assertEquals(Map.of("test", "123"), viewParamsList.get(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingLayersAndStylesParametersWithSld() throws Exception {
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("sld", decoded);
        raw.put("format", "image/jpeg");
        raw.put("crs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "true");
        raw.put("request", "GetMap");
        raw.put("version", "1.3.0");
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        }
        finally {
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingCrsParameterInGetMapRequest11() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "true");
        raw.put("request", "GetMap");
        raw.put("version", "1.1.0");
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        }
        finally {
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    private void validateMissingParameterInGetMapRequest13(String paramToRemove) throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("crs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "true");
        raw.put("request", "GetMap");
        raw.put("version", "1.3.0");
        raw.remove(paramToRemove);
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            throw new Exception("Shouldn't get here");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Shouldn't get here")));
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
            return;
        }
    }

    @Test
    public void testMissingStylesParameterInGetMapRequest13() throws Exception {
        this.validateMissingParameterInGetMapRequest13("styles");
    }

    @Test
    public void testMissingCrsParameterInGetMapRequest13() throws Exception {
        this.validateMissingParameterInGetMapRequest13("crs");
    }

    @Test
    public void testTransparencyValueInInspireGetMapRequest() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("crs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "ZZZZZZ");
        raw.put("request", "GetMap");
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            throw new Exception("Shouldn't get here");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Shouldn't get here")));
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSldTooLongLookup() throws Exception {
        HttpServer server = this.createServer();
        GeoServer geoServer = this.getGeoServer();
        WMSInfo wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
        wmsInfo.setRemoteStyleMaxRequestTime(1000);
        geoServer.save((ServiceInfo)wmsInfo);
        try {
            WMS wms = new WMS(this.getGeoServer());
            this.reader = new GetMapKvpRequestReader(wms);
            server.start();
            int port = server.getAddress().getPort();
            HashMap<String, String> kvp = new HashMap<String, String>();
            URL url = new URL("http://localhost:" + port + "/sld/style.sld");
            kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
            kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
            kvp.put("styles", "ThisStyleDoesNotExists");
            GetMapRequest request = this.reader.createRequest();
            Instant startInstant = Instant.now();
            try {
                this.reader.setLaxStyleMatchAllowed(false);
                request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
                Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
            }
            catch (ServiceException e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
            long millis = Instant.now().toEpochMilli() - startInstant.toEpochMilli();
            Assert.assertTrue((String)"Max timeout should be 2 seconds", (millis < 2000L ? 1 : 0) != 0);
        }
        finally {
            server.stop(0);
            wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
            wmsInfo.setRemoteStyleMaxRequestTime(60000);
            geoServer.save((ServiceInfo)wmsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSldTimeoutLookup() throws Exception {
        HttpServer server = this.createServer();
        GeoServer geoServer = this.getGeoServer();
        WMSInfo wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
        wmsInfo.setRemoteStyleTimeout(1000);
        geoServer.save((ServiceInfo)wmsInfo);
        try {
            WMS wms = new WMS(this.getGeoServer());
            this.reader = new GetMapKvpRequestReader(wms);
            server.start();
            int port = server.getAddress().getPort();
            HashMap<String, String> kvp = new HashMap<String, String>();
            URL url = new URL("http://localhost:" + port + "/sld/style.sld");
            kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
            kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
            kvp.put("styles", "ThisStyleDoesNotExists");
            GetMapRequest request = this.reader.createRequest();
            Instant startInstant = Instant.now();
            try {
                this.reader.setLaxStyleMatchAllowed(false);
                request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
                Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
            }
            catch (ServiceException e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
            long millis = Instant.now().toEpochMilli() - startInstant.toEpochMilli();
            Assert.assertTrue((String)"Max timeout should be 2 seconds", (millis < 2000L ? 1 : 0) != 0);
        }
        finally {
            server.stop(0);
            wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
            wmsInfo.setRemoteStyleTimeout(30000);
            geoServer.save((ServiceInfo)wmsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXMLMultipleViewParams() throws Exception {
        try {
            Request owsRequest = new Request();
            owsRequest.setRawKvp(new HashMap());
            owsRequest.getRawKvp().put("viewParamsFormat", "XML");
            Dispatcher.REQUEST.set(owsRequest);
            HashMap<String, Object> raw = new HashMap<String, Object>();
            raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
            raw.put("styles", "");
            raw.put("format", "image/jpeg");
            raw.put("srs", "epsg:3003");
            raw.put("bbox", "-10,-10,10,10");
            raw.put("height", "600");
            raw.put("width", "800");
            raw.put("request", "GetMap");
            raw.put("service", "wms");
            raw.put("viewParams", "<VP><PS><P n=\"where\">WHERE PERSONS &gt; 1000000</P><P n=\"str\">ABCD</P></PS><PS><P n=\"where\">WHERE PERSONS &gt; 10</P><P n=\"str\">FOO</P></PS></VP>");
            GetMapRequest request = this.reader.createRequest();
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            List viewParamsList = request.getViewParams();
            Assert.assertEquals((long)2L, (long)viewParamsList.size());
            Map viewParams = (Map)viewParamsList.get(0);
            Assert.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
            Assert.assertEquals((Object)"ABCD", viewParams.get("str"));
            viewParams = (Map)viewParamsList.get(1);
            Assert.assertEquals((Object)"WHERE PERSONS > 10", viewParams.get("where"));
            Assert.assertEquals((Object)"FOO", viewParams.get("str"));
        }
        finally {
            Dispatcher.REQUEST.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXMLMultipleViewParamsServiceException() throws Exception {
        ServiceException serviceException = null;
        try {
            Request owsRequest = new Request();
            owsRequest.setRawKvp(new HashMap());
            owsRequest.getRawKvp().put("viewParamsFormat", "unknown-format");
            Dispatcher.REQUEST.set(owsRequest);
            HashMap<String, Object> raw = new HashMap<String, Object>();
            raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
            raw.put("styles", "");
            raw.put("format", "image/jpeg");
            raw.put("srs", "epsg:3003");
            raw.put("bbox", "-10,-10,10,10");
            raw.put("height", "600");
            raw.put("width", "800");
            raw.put("request", "GetMap");
            raw.put("service", "wms");
            raw.put("viewParams", "<VP><PS><P n=\"where\">WHERE PERSONS &gt; 1000000</P><P n=\"str\">ABCD</P></PS><PS><P n=\"where\">WHERE PERSONS &gt; 10</P><P n=\"str\">FOO</P></PS></VP>");
            GetMapRequest request = this.reader.createRequest();
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        }
        catch (ServiceException ex) {
            serviceException = ex;
        }
        finally {
            Dispatcher.REQUEST.set(null);
        }
        Assert.assertNotNull((String)"ServiceException not catched", (Object)((Object)serviceException));
        Assert.assertEquals((Object)serviceException.getLocator(), (Object)"viewParamsFormat");
        Assert.assertEquals((Object)serviceException.getCode(), (Object)"InvalidParameterValue");
    }

    private HttpServer createServer() throws IOException {
        HttpServer server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
        LOG.log(Level.INFO, "Creating a mock http server at port: {0}", server.getAddress().getPort());
        server.createContext("/sld", this.createLongResponseHandler());
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
        server.setExecutor(threadPoolExecutor);
        return server;
    }

    private HttpHandler createLongResponseHandler() {
        HttpHandler handler = t -> {
            try {
                t.sendResponseHeaders(200, 5000000000L);
                TimeUnit.SECONDS.sleep(4L);
                OutputStream outputStream = t.getResponseBody();
                outputStream.write("This is a bad style".getBytes());
                outputStream.flush();
                outputStream.close();
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
        };
        return handler;
    }
}

