/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.utfgrid;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.junit.Assert;

class UTFGridTester {
    private JSONArray keys;
    private JSONObject data;
    private JSONArray grid;

    UTFGridTester(JSON json) {
        this(json, 256, 256, 4);
    }

    UTFGridTester(JSON json, int width, int height, int resolution) {
        JSONObject utfGrid = (JSONObject)json;
        Assert.assertTrue((String)"Missing grid property", (boolean)utfGrid.has("grid"));
        Assert.assertTrue((String)"Missing keys property", (boolean)utfGrid.has("keys"));
        Assert.assertTrue((String)"Missing data property", (boolean)utfGrid.has("data"));
        this.keys = utfGrid.getJSONArray("keys");
        this.data = utfGrid.getJSONObject("data");
        for (int i = 0; i < this.keys.size(); ++i) {
            String key = this.keys.getString(i);
            if (i == 0) {
                Assert.assertEquals((Object)"", (Object)key);
                continue;
            }
            Assert.assertEquals((Object)("" + i), (Object)key);
            Assert.assertTrue((boolean)this.data.has(key));
        }
        this.grid = utfGrid.getJSONArray("grid");
        int gridWidth = width / resolution;
        int gridHeight = height / resolution;
        Assert.assertEquals((long)this.grid.size(), (long)gridHeight);
        for (int r = 0; r < gridHeight; ++r) {
            String gridRow = this.grid.getString(r);
            Assert.assertEquals((long)gridWidth, (long)gridRow.length());
            for (int c = 0; c < gridWidth; ++c) {
                char code = gridRow.charAt(c);
                if (code == ' ') continue;
                Assert.assertTrue(((code = this.gridToKey(code)) < this.keys.size() ? 1 : 0) != 0);
                Assert.assertTrue((boolean)this.data.has(String.valueOf((int)code)));
            }
        }
    }

    int getKeyCount() {
        return this.keys.size();
    }

    JSONObject getFeature(char code) {
        String key = "" + this.gridToKey(code);
        return this.data.getJSONObject(key);
    }

    void assertGridPixel(char code, int row, int col) {
        String gridRow = this.grid.getString(row);
        Assert.assertEquals((String)("Expected '" + code + "' but was '" + gridRow.charAt(col) + "'."), (long)code, (long)gridRow.charAt(col));
    }

    private char gridToKey(char code) {
        if (code >= ']') {
            code = (char)(code - '\u0001');
        }
        if (code >= '#') {
            code = (char)(code - '\u0001');
        }
        code = (char)(code - 32);
        return code;
    }
}

