/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.junit.After;
import org.junit.Test;
import org.w3c.dom.Document;

public class CapabilitiesBBOXForEachCRSTest
extends WMSTestSupport {
    void addSRSAndSetFlag() {
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getSRS().add("4326");
        wms.getSRS().add("3005");
        wms.getSRS().add("3857");
        wms.setBBOXForEachCRS(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @After
    public void removeSRS() {
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getSRS().remove("4326");
        wms.getSRS().remove("3005");
        wms.getSRS().remove("3857");
        wms.setBBOXForEachCRS(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @Test
    public void testBBOXForEachCRS() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        String layer = MockData.PRIMITIVEGEOFEATURE.getLocalPart();
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:4326']"), (Document)doc);
        XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)doc);
        XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3857']"), (Document)doc);
        this.addSRSAndSetFlag();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:4326']"), (Document)doc);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)doc);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3857']"), (Document)doc);
    }

    @Test
    public void testRootLayer() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:4326']", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:3005']", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:3857']", (Document)doc);
        this.addSRSAndSetFlag();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:4326']", (Document)doc);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:3005']", (Document)doc);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:3857']", (Document)doc);
    }
}

