/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CapabilitiesModifyingTest
extends GeoServerSystemTestSupport {
    @Before
    public void resetWmsConfigChanges() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.OGC_EXCEPTION_REPORT);
        this.getGeoServer().save(global);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        for (FeatureTypeInfo ft : catalog.getFeatureTypes()) {
            ft.setLatLonBoundingBox(null);
            catalog.save((ResourceInfo)ft);
        }
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.LAKES)));
        lg.getStyles().add(null);
        lg.setName("test");
        lg.setMode(LayerGroupInfo.Mode.NAMED);
        catalog.add(lg);
    }

    @Test
    public void testMisconfiguredLayerGeneratesErrorDocumentInDefaultConfig() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&request=GetCapabilities&version=1.1.1");
        Assert.assertTrue((String)("Response does not contain ServiceExceptionReport: " + response.getContentAsString()), (boolean)response.getContentAsString().endsWith("</ServiceExceptionReport>"));
    }

    @Test
    public void testMisconfiguredLayerIsSkippedWhenWMSServiceIsConfiguredThatWay() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        Document caps = this.getAsDOM("wms?service=WMS&request=GetCapabilities&version=1.1.1");
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)caps.getDocumentElement().getTagName());
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//Layer/Name/text()", (Document)caps);
    }

    @Test
    public void testMisconfiguredLayerGeneratesErrorDocumentInDefaultConfig_1_3_0() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&request=GetCapabilities&version=1.3.0");
        Assert.assertTrue((String)("Response does not contain ServiceExceptionReport: " + response.getContentAsString()), (boolean)response.getContentAsString().endsWith("</ServiceExceptionReport>"));
    }

    @Test
    public void testMisconfiguredLayerIsSkippedWhenWMSServiceIsConfiguredThatWay_1_3_0() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        Document caps = this.getAsDOM("wms?service=WMS&request=GetCapabilities&version=1.3.0");
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)caps.getDocumentElement().getTagName());
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//Layer/Name/text()", (Document)caps);
    }
}

