/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.io.Serializable;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class CapabilitiesRootLayerTest
extends WMSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        DataStoreInfo info = catalog.getDataStoreByName(MockData.SF_PREFIX);
        info.setEnabled(false);
        catalog.save((StoreInfo)info);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        testData.addStyle(ws, "Lakes", "Lakes.sld", SystemTestData.class, catalog);
        testData.addStyle(ws, "tiger_roads", "tiger_roads.sld", SystemTestData.class, catalog);
        StyleInfo lakesStyle = catalog.getStyleByName(ws, "Lakes");
        LayerInfo lakesLayer = catalog.getLayerByName(MockData.LAKES.getLocalPart());
        lakesLayer.setDefaultStyle(lakesStyle);
        StyleInfo tigerRoadsStyle = catalog.getStyleByName(ws, "tiger_roads");
        lakesLayer.getStyles().add(tigerRoadsStyle);
        catalog.save(lakesLayer);
        for (LayerGroupInfo layerGroupInfo : catalog.getLayerGroups()) {
            catalog.remove(layerGroupInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerNotRemoved() throws Exception {
        WMSInfo info = this.getWMS().getServiceInfo();
        info.getMetadata().put(WMS.ROOT_LAYER_IN_CAPABILITIES_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
            Document dom = this.dom(this.get("lakes_and_places/wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"lakes_and_places", (String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
            info.getMetadata().remove((Object)WMS.ROOT_LAYER_IN_CAPABILITIES_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerRemovedGroupConfig() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
            group.getMetadata().put("rootInCapabilities", (Serializable)Boolean.valueOf(false));
            Document dom = this.dom(this.get("lakes_and_places/wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"lakes_and_places", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerRemovedLayerConfig() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo layer = catalog.getLayerByName(MockData.LAKES.getLocalPart());
        try {
            layer.getMetadata().put("rootInCapabilities", (Serializable)Boolean.valueOf(false));
            catalog.save(layer);
            Document dom = this.dom(this.get("cite/Lakes/wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"Lakes", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
        }
        finally {
            layer.getMetadata().put("rootInCapabilities", null);
            catalog.save(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerRemovedLayerIfSingleConfig() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo layer = catalog.getLayerByName(MockData.LAKES.getLocalPart());
        for (LayerInfo layerInfo : catalog.getLayers()) {
            if (layerInfo.getName().equals(MockData.LAKES.getLocalPart())) continue;
            layerInfo.setAdvertised(false);
            catalog.save(layerInfo);
        }
        try {
            layer.getMetadata().put("rootInCapabilities", (Serializable)Boolean.valueOf(false));
            catalog.save(layer);
            Document dom = this.dom(this.get("/cite/wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"Lakes", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
        }
        finally {
            layer.getMetadata().put("rootInCapabilities", null);
            catalog.save(layer);
            for (LayerInfo layerInfo : catalog.getLayers()) {
                if (layerInfo.getName().equals(MockData.LAKES.getLocalPart())) continue;
                layerInfo.setAdvertised(true);
                catalog.save(layerInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerRemovedRequestParam() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
            Document dom = this.dom(this.get("lakes_and_places/wms?request=GetCapabilities&version=1.1.0&rootLayer=false"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"lakes_and_places", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerRemovedRequestParamHasGreaterPriority() throws Exception {
        WMSInfo info = this.getWMS().getServiceInfo();
        info.getMetadata().put(WMS.ROOT_LAYER_IN_CAPABILITIES_KEY, (Serializable)Boolean.valueOf(false));
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
            group.getMetadata().put("rootInCapabilities", (Serializable)Boolean.valueOf(false));
            Document dom = this.dom(this.get("lakes_and_places/wms?request=GetCapabilities&version=1.1.0&rootLayer=true"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"lakes_and_places", (String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
            info.getMetadata().remove((Object)WMS.ROOT_LAYER_IN_CAPABILITIES_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerRemovedGroupConfigHasPriorityOnService() throws Exception {
        WMSInfo info = this.getWMS().getServiceInfo();
        info.getMetadata().put(WMS.ROOT_LAYER_IN_CAPABILITIES_KEY, (Serializable)Boolean.valueOf(false));
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
            group.getMetadata().put("rootInCapabilities", (Serializable)Boolean.valueOf(true));
            Document dom = this.dom(this.get("lakes_and_places/wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"lakes_and_places", (String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
            info.getMetadata().remove((Object)WMS.ROOT_LAYER_IN_CAPABILITIES_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRootLayerRemovedWMSService() throws Exception {
        WMSInfo info = this.getWMS().getServiceInfo();
        info.getMetadata().put(WMS.ROOT_LAYER_IN_CAPABILITIES_KEY, (Serializable)Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)info);
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
            Document dom = this.dom(this.get("lakes_and_places/wms?request=GetCapabilities&version=1.1.0"), true);
            XMLAssert.assertXpathEvaluatesTo((String)"lakes_and_places", (String)"/WMT_MS_Capabilities/Capability/Layer/Name", (Document)dom);
        }
        finally {
            if (group != null) {
                catalog.remove(group);
            }
            info.getMetadata().remove((Object)WMS.ROOT_LAYER_IN_CAPABILITIES_KEY);
        }
    }
}

