/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayerGroupWorkspaceTest
extends WMSTestSupport {
    LayerGroupInfo global;
    LayerGroupInfo global2;
    LayerGroupInfo sf;
    LayerGroupInfo cite;
    LayerGroupInfo nested;
    LayerGroupInfo world;

    @Before
    public void prepare() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.getSRS().add("4326");
        gs.save((ServiceInfo)wms);
        Catalog cat = this.getCatalog();
        this.global = this.createLayerGroup(cat, "base", "base default", new PublishedInfo[]{this.layer(cat, MockData.LAKES), this.layer(cat, MockData.FORESTS)});
        cat.add(this.global);
        this.global2 = this.createLayerGroup(cat, "base2", "base default", new PublishedInfo[]{this.layer(cat, MockData.LAKES), this.layer(cat, MockData.FORESTS)});
        cat.add(this.global2);
        this.sf = this.createLayerGroup(cat, "base", "sf base", new PublishedInfo[]{this.layer(cat, MockData.PRIMITIVEGEOFEATURE), this.layer(cat, MockData.AGGREGATEGEOFEATURE)});
        this.sf.setWorkspace(cat.getWorkspaceByName("sf"));
        cat.add(this.sf);
        this.cite = this.createLayerGroup(cat, "base", "cite base", new PublishedInfo[]{this.layer(cat, MockData.BRIDGES), this.layer(cat, MockData.BUILDINGS)});
        this.cite.setWorkspace(cat.getWorkspaceByName("cite"));
        cat.add(this.cite);
        this.world = this.createLayerGroup(cat, "world", "world base", new PublishedInfo[]{this.layer(cat, MockData.WORLD), this.layer(cat, MockData.WORLD)});
        cat.add(this.world);
    }

    @After
    public void rollback() throws Exception {
        Catalog cat = this.getCatalog();
        if (this.nested != null) {
            cat.remove(this.nested);
        }
        cat.remove(this.cite);
        cat.remove(this.sf);
        cat.remove(this.global);
        cat.remove(this.global2);
        cat.remove(this.world);
    }

    LayerInfo layer(Catalog cat, QName name) {
        return cat.getLayerByName(this.getLayerId(name));
    }

    LayerGroupInfo createLayerGroup(Catalog cat, String name, String title, PublishedInfo ... layers) throws Exception {
        LayerGroupInfo group = cat.getFactory().createLayerGroup();
        group.setName(name);
        group.setTitle("title for layer group " + title);
        group.setAbstract("abstract for layer group " + title);
        for (PublishedInfo layer : layers) {
            group.getLayers().add(layer);
            group.getStyles().add(null);
        }
        new CatalogBuilder(cat).calculateLayerGroupBounds(group);
        return group;
    }

    @Test
    public void testAddLayerGroup() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo lg = this.createLayerGroup(cat, "base", "base", new PublishedInfo[]{this.layer(cat, MockData.LOCKS)});
        try {
            cat.add(lg);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGlobalCapabilities() throws Exception {
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"//Layer/Name[text() = 'base']", (Document)dom);
        this.assertBounds(this.global, "base", dom);
        XMLAssert.assertXpathExists((String)"//Layer/Name[text() = 'sf:base']", (Document)dom);
        this.assertBounds(this.sf, "sf:base", dom);
        XMLAssert.assertXpathExists((String)"//Layer/Name[text() = 'cite:base']", (Document)dom);
        this.assertBounds(this.cite, "cite:base", dom);
        String layer = "base";
        XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)dom);
        this.addSRSAndSetFlag();
        dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1", true);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:4326']"), (Document)dom);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)dom);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3857']"), (Document)dom);
    }

    @Test
    public void testLayerGroupTitleInCapabilities() throws Exception {
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"//Layer/Title[text() = 'title for layer group base default']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Layer/Title[text() = 'title for layer group sf base']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Layer/Title[text() = 'title for layer group cite base']", (Document)dom);
    }

    @Test
    public void testLayerGroupAbstractInCapabilities() throws Exception {
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"//Layer/Abstract[text() = 'abstract for layer group base default']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Layer/Abstract[text() = 'abstract for layer group sf base']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Layer/Abstract[text() = 'abstract for layer group cite base']", (Document)dom);
    }

    @Test
    public void testSingleLayerGroupInCapabilities() throws Exception {
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'base']/Layer", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Forests']", (Document)dom);
    }

    @Test
    public void testNamedLayerGroupInCapabilities() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo layerGroup = cat.getLayerGroupByName("base");
        layerGroup.setMode(LayerGroupInfo.Mode.NAMED);
        cat.save(layerGroup);
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Forests']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name[text() = 'base']]/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name[text() = 'base']]/Layer/Name[text() = 'cite:Forests']", (Document)dom);
    }

    @Test
    public void testContainerLayerGroupInCapabilities() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo layerGroup = cat.getLayerGroupByName("base");
        layerGroup.setMode(LayerGroupInfo.Mode.CONTAINER);
        cat.save(layerGroup);
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Title[text() = 'title for layer group base default']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Forests']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Title[text() = 'title for layer group base default']]/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Title[text() = 'title for layer group base default']]/Layer/Name[text() = 'cite:Forests']", (Document)dom);
    }

    @Test
    public void testEoLayerGroupInCapabilities() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo layerGroup = cat.getLayerGroupByName("base");
        layerGroup.setMode(LayerGroupInfo.Mode.EO);
        layerGroup.setRootLayer(this.layer(cat, MockData.BUILDINGS));
        layerGroup.setRootLayerStyle(cat.getStyleByName("Buildings"));
        cat.save(layerGroup);
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Forests']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name[text() = 'base']]/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name[text() = 'base']]/Layer/Name[text() = 'cite:Forests']", (Document)dom);
    }

    @Test
    public void testWorkspaceCapabilities() throws Exception {
        Document dom = this.getAsDOM("sf/wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"//Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//Layer/Name[text() = 'sf:base']", (Document)dom);
        this.assertBounds(this.sf, "base", dom);
        String layer = "base";
        XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)dom);
        this.addSRSAndSetFlag();
        dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1", true);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:4326']"), (Document)dom);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)dom);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3857']"), (Document)dom);
        layer = "world";
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3857']"), (Document)dom);
    }

    @Test
    public void testGlobalGetMap() throws Exception {
        Document dom = this.getAsDOM("wms/reflect?layers=base&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Lakes,cite:Forests']", (Document)dom);
        dom = this.getAsDOM("wms/reflect?layers=sf:base&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'sf:PrimitiveGeoFeature,sf:AggregateGeoFeature']", (Document)dom);
        dom = this.getAsDOM("wms/reflect?layers=cite:base&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Bridges,cite:Buildings']", (Document)dom);
    }

    @Test
    public void testWorkspaceGetMap() throws Exception {
        Document dom = this.getAsDOM("sf/wms?request=reflect&layers=base&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'PrimitiveGeoFeature,AggregateGeoFeature']", (Document)dom);
        dom = this.getAsDOM("cite/wms?request=reflect&layers=base&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'Bridges,Buildings']", (Document)dom);
        dom = this.getAsDOM("sf/wms?request=reflect&layers=cite:base&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'PrimitiveGeoFeature,AggregateGeoFeature']", (Document)dom);
    }

    @Test
    public void testSharedLayersInCapabilities() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo global = cat.getLayerGroupByName("base");
        global.setMode(LayerGroupInfo.Mode.NAMED);
        cat.save(global);
        LayerGroupInfo global2 = cat.getLayerGroupByName("base2");
        global2.setMode(LayerGroupInfo.Mode.NAMED);
        cat.save(global2);
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base2']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Forests']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'base']/Layer[Name = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'base']/Layer[Name = 'cite:Forests']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'base2']/Layer[Name = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'base2']/Layer[Name = 'cite:Forests']", (Document)dom);
    }

    @Test
    public void testNestedSingleInCapabilities() throws Exception {
        Catalog cat = this.getCatalog();
        this.nested = this.createLayerGroup(cat, "nested", "nested", new PublishedInfo[]{this.layer(cat, MockData.BRIDGES), this.global});
        this.nested.setMode(LayerGroupInfo.Mode.NAMED);
        cat.add(this.nested);
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'nested']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Bridges']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'cite:Bridges']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'base']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'base']/Layer[Name = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'base']/Layer[Name = 'cite:Forests']", (Document)dom);
    }

    @Test
    public void testNestedNamedInCapabilities() throws Exception {
        Catalog cat = this.getCatalog();
        this.nested = this.createLayerGroup(cat, "nested", "nested", new PublishedInfo[]{this.layer(cat, MockData.BRIDGES), this.global});
        this.nested.setMode(LayerGroupInfo.Mode.NAMED);
        cat.add(this.nested);
        LayerGroupInfo global = cat.getLayerGroupByName("base");
        global.setMode(LayerGroupInfo.Mode.NAMED);
        cat.save(global);
        Document dom = this.getAsDOM("wms?request=getcapabilities&version=1.1.1");
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'nested']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Bridges']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'cite:Forests']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer/Name[text() = 'base']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'cite:Bridges']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'base']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'base']/Layer[Name = 'cite:Lakes']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'nested']/Layer[Name = 'base']/Layer[Name = 'cite:Forests']", (Document)dom);
    }

    @Test
    public void testNestedNamedGetMap() throws Exception {
        Catalog cat = this.getCatalog();
        this.nested = this.createLayerGroup(cat, "nested", "nested", new PublishedInfo[]{this.layer(cat, MockData.BRIDGES), this.global});
        this.nested.setMode(LayerGroupInfo.Mode.NAMED);
        cat.add(this.nested);
        LayerGroupInfo global = cat.getLayerGroupByName("base");
        global.setMode(LayerGroupInfo.Mode.NAMED);
        cat.save(global);
        Document dom = this.getAsDOM("wms?request=reflect&layers=nested&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Bridges,cite:Lakes,cite:Forests']", (Document)dom);
    }

    @Test
    public void testNestedSharedGetMap() throws Exception {
        Catalog cat = this.getCatalog();
        this.nested = this.createLayerGroup(cat, "nested", "nested", new PublishedInfo[]{this.global, this.global2});
        this.nested.setMode(LayerGroupInfo.Mode.NAMED);
        cat.add(this.nested);
        Document dom = this.getAsDOM("wms?request=reflect&layers=nested&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Lakes,cite:Forests,cite:Lakes,cite:Forests']", (Document)dom);
    }

    @Test
    public void testNestedSingleGetMap() throws Exception {
        Catalog cat = this.getCatalog();
        this.nested = this.createLayerGroup(cat, "nested", "nested", new PublishedInfo[]{this.layer(cat, MockData.BRIDGES), this.global});
        this.nested.setMode(LayerGroupInfo.Mode.NAMED);
        cat.add(this.nested);
        Document dom = this.getAsDOM("wms?request=reflect&layers=nested&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Bridges,cite:Lakes,cite:Forests']", (Document)dom);
    }

    void assertBounds(LayerGroupInfo lg, String name, Document dom) throws Exception {
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(Math.round(lg.getBounds().getMinX())), (String)("round(//Layer[Name/text() = '" + name + "']/BoundingBox/@minx)"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(Math.round(lg.getBounds().getMaxX())), (String)("round(//Layer[Name/text() = '" + name + "']/BoundingBox/@maxx)"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(Math.round(lg.getBounds().getMinY())), (String)("round(//Layer[Name/text() = '" + name + "']/BoundingBox/@miny)"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(Math.round(lg.getBounds().getMaxY())), (String)("round(//Layer[Name/text() = '" + name + "']/BoundingBox/@maxy)"), (Document)dom);
    }

    void addSRSAndSetFlag() {
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getSRS().add("4326");
        wms.getSRS().add("3005");
        wms.getSRS().add("3857");
        wms.setBBOXForEachCRS(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @After
    public void removeSRS() {
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getSRS().remove("4326");
        wms.getSRS().remove("3005");
        wms.getSRS().remove("3857");
        wms.setBBOXForEachCRS(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @Test
    public void testGetCapabilitiesGroupOrder() throws Exception {
        Document doc = this.getAsDOM("/wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        List<String> originalList = this.layerGroupNameList(doc);
        Assert.assertFalse((boolean)originalList.isEmpty());
        List normal = originalList.stream().map(x -> this.removeLayerPrefix((String)x)).collect(Collectors.toList());
        List ordered = normal.stream().sorted().collect(Collectors.toList());
        Assert.assertEquals(ordered, normal);
    }

    @Test
    public void testWorkspaceGetCapabilitiesGroupOrder() throws Exception {
        Document doc = this.getAsDOM("sf/wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathExists((String)"//Layer/Name[text() = 'base']", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"//Layer/Name[text() = 'sf:base']", (Document)doc);
        this.assertBounds(this.sf, "base", doc);
        String layer = "base";
        XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)doc);
        List<String> originalList = this.layerGroupNameList(doc);
        Assert.assertFalse((boolean)originalList.isEmpty());
        List normal = originalList.stream().map(x -> this.removeLayerPrefix((String)x)).collect(Collectors.toList());
        List ordered = normal.stream().sorted().collect(Collectors.toList());
        Assert.assertEquals(ordered, normal);
    }

    private String removeLayerPrefix(String prefixedName) {
        if (prefixedName.indexOf(":") > -1) {
            return prefixedName.split(":")[1];
        }
        return prefixedName;
    }

    private List<String> layerGroupNameList(Document doc) throws Exception {
        List<Node> nlist = this.xpathList("//WMT_MS_Capabilities/Capability/Layer/Layer[not(@opaque)]/Name", doc);
        ArrayList<String> result = new ArrayList<String>();
        nlist.forEach(x -> result.add(x.getTextContent().trim()));
        return result;
    }

    private List<Node> xpathList(String xpathString, Document doc) throws XPathExpressionException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathString);
        NodeList nlist = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (int i = 0; i < nlist.getLength(); ++i) {
            nodeList.add(nlist.item(i));
        }
        return nodeList;
    }
}

