/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.util.Filter;
import org.geoserver.wms.WMS;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.FontCache;
import org.geotools.renderer.style.GraphicCache;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class WMSLifecycleHandler
implements GeoServerLifecycleHandler,
ApplicationListener {
    static final Logger LOGGER = Logging.getLogger(WMSLifecycleHandler.class);
    GeoServerDataDirectory data;
    WMS wmsConfig;

    public WMSLifecycleHandler(GeoServerDataDirectory data, WMS wmsConfig) {
        this.data = data;
        this.wmsConfig = wmsConfig;
    }

    public void onDispose() {
    }

    public void beforeReload() {
    }

    public void onReload() {
        this.onReset();
    }

    public void onReset() {
        Iterator it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
        while (it.hasNext()) {
            ExternalGraphicFactory egf = (ExternalGraphicFactory)it.next();
            if (!(egf instanceof GraphicCache)) continue;
            ((GraphicCache)egf).clearCache();
        }
        this.reloadFontCache();
    }

    void reloadFontCache() {
        List<Font> fonts = this.loadFontsFromDataDirectory();
        FontCache cache = FontCache.getDefaultInstance();
        cache.resetCache();
        for (Font font : fonts) {
            cache.registerFont(font);
        }
    }

    List<Font> loadFontsFromDataDirectory() {
        ArrayList<Font> result = new ArrayList<Font>();
        for (Resource file : Resources.list((Resource)this.data.getStyles(new String[0]), (Filter)new Resources.ExtensionFilter(new String[]{"TTF", "OTF"}), (boolean)true)) {
            try {
                Font font = Font.createFont(0, file.file());
                result.add(font);
                LOGGER.log(Level.INFO, "Loaded font file " + file + ", loaded font '" + font.getName() + "' in family '" + font.getFamily() + "'");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load font file " + file, e);
            }
        }
        return result;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.reloadFontCache();
        }
    }
}

