/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.impl.AbstractCatalogValidator;
import org.geoserver.wms.WMS;
import org.geotools.util.factory.GeoTools;

public class WMSValidator
extends AbstractCatalogValidator {
    public void validate(LayerInfo lyr, boolean isNew) {
        if (!lyr.isEnabled()) {
            return;
        }
        if (lyr.getResource() == null || (lyr.getResource().getSRS() == null || lyr.getResource().getLatLonBoundingBox() == null) && WMS.isWmsExposable(lyr)) {
            throw new RuntimeException("Layer's resource is not fully configured");
        }
        if (lyr.getType() == PublishedType.RASTER) {
            if (!(lyr.getResource() instanceof CoverageInfo)) {
                throw new RuntimeException("Layer with type RASTER doesn't have a coverage associated");
            }
            CoverageInfo cvinfo = (CoverageInfo)lyr.getResource();
            try {
                cvinfo.getCatalog().getResourcePool().getGridCoverageReader(cvinfo, GeoTools.getDefaultHints());
            }
            catch (Throwable t) {
                throw new RuntimeException("Couldn't connect to raster layer's resource");
            }
        } else if (lyr.getType() == PublishedType.VECTOR) {
            if (!(lyr.getResource() instanceof FeatureTypeInfo)) {
                throw new RuntimeException("Layer with type VECTOR doesn't have a featuretype associated");
            }
        } else if (lyr.getType() == PublishedType.WMTS) {
            if (!(lyr.getResource() instanceof WMTSLayerInfo)) {
                throw new RuntimeException("WMTS Layer doesn't have the correct resource");
            }
        } else if (lyr.getType() == PublishedType.WMS) {
            if (!(lyr.getResource() instanceof WMSLayerInfo)) {
                throw new RuntimeException("WMS Layer doesn't have the correct resource");
            }
        } else {
            throw new RuntimeException("Layer is neither RASTER nor VECTOR type");
        }
        if ((lyr.getDefaultStyle() == null || lyr.getStyles().contains(null)) && WMS.isWmsExposable(lyr)) {
            throw new RuntimeException("Layer has null styles!");
        }
    }
}

