/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geotools.api.filter.expression.Expression;
import org.geotools.util.logging.Logging;

public class ScaleLineDecoration
implements MapDecoration {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.responses");
    private static Map<String, Double> INCHES_PER_UNIT = new HashMap<String, Double>();
    public static final String topOutUnits = "km";
    public static final String topInUnits = "m";
    public static final String bottomOutUnits = "mi";
    public static final String bottomInUnits = "ft";
    public static final int suggestedWidth = 100;
    private float fontSize = 10.0f;
    private float dpi = 90.71429f;
    private Color bgcolor = Color.WHITE;
    private Color fgcolor = Color.BLACK;
    private Boolean transparent = Boolean.FALSE;
    private MeasurementSystem measurementSystem = MeasurementSystem.BOTH;

    @Override
    public void loadOptions(Map<String, Expression> options) {
        Color tmp;
        if (options.get("fontsize") != null) {
            try {
                this.fontSize = MapDecorationLayout.getOption(options, "fontsize", Float.class).floatValue();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'fontsize' must be a float.", e);
            }
        }
        if (options.get("dpi") != null) {
            try {
                this.dpi = MapDecorationLayout.getOption(options, "dpi", Float.class).floatValue();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'dpi' must be a float.", e);
            }
        }
        if ((tmp = MapDecorationLayout.parseColor(MapDecorationLayout.getOption(options, "bgcolor"))) != null) {
            this.bgcolor = tmp;
        }
        if ((tmp = MapDecorationLayout.parseColor(MapDecorationLayout.getOption(options, "fgcolor"))) != null) {
            this.fgcolor = tmp;
        }
        if (options.get("transparent") != null) {
            try {
                this.transparent = MapDecorationLayout.getOption(options, "transparent", Boolean.class);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'transparent' must be a boolean.", e);
            }
        }
        if (options.get("measurement-system") != null) {
            try {
                this.measurementSystem = MeasurementSystem.mapToEnum(MapDecorationLayout.getOption(options, "measurement-system"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'measurement-system' must be one of 'metric', 'imperial' or 'both'.", e);
            }
        }
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) {
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont());
        return new Dimension(100, 8 + (metrics.getHeight() + metrics.getDescent()) * 2);
    }

    public int getBarLength(double maxLength) {
        int digits = (int)(Math.log(maxLength) / Math.log(10.0));
        double pow10 = Math.pow(10.0, digits);
        int firstCharacter = (int)(maxLength / pow10);
        int barLength = firstCharacter > 5 ? 5 : (firstCharacter > 2 ? 2 : 1);
        return (int)((double)barLength * pow10);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContent) throws Exception {
        String bottomUnits;
        String topUnits;
        double maxSizeData;
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        Font oldFont = g2d.getFont();
        Object oldAntialias = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setFont(oldFont.deriveFont(this.fontSize));
        double scaleDenominator = mapContent.getScaleDenominator(true);
        String curMapUnits = topInUnits;
        double normalizedScale = scaleDenominator > 1.0 ? 1.0 / scaleDenominator : scaleDenominator;
        double resolution = 1.0 / (normalizedScale * INCHES_PER_UNIT.get(curMapUnits) * (double)this.dpi);
        int maxWidth = 100;
        if ((double)maxWidth > paintArea.getWidth()) {
            maxWidth = (int)paintArea.getWidth();
        }
        if ((maxSizeData = (double)(maxWidth -= 6) * resolution * INCHES_PER_UNIT.get(curMapUnits)) > 100000.0) {
            topUnits = topOutUnits;
            bottomUnits = bottomOutUnits;
        } else {
            topUnits = topInUnits;
            bottomUnits = bottomInUnits;
        }
        double topMax = maxSizeData / INCHES_PER_UNIT.get(topUnits);
        double bottomMax = maxSizeData / INCHES_PER_UNIT.get(bottomUnits);
        int topRounded = this.getBarLength(topMax);
        int bottomRounded = this.getBarLength(bottomMax);
        topMax = (double)topRounded / INCHES_PER_UNIT.get(curMapUnits) * INCHES_PER_UNIT.get(topUnits);
        bottomMax = (double)bottomRounded / INCHES_PER_UNIT.get(curMapUnits) * INCHES_PER_UNIT.get(bottomUnits);
        int topPx = (int)(topMax / resolution);
        int bottomPx = (int)(bottomMax / resolution);
        int centerY = (int)paintArea.getCenterY();
        int leftX = (int)paintArea.getMinX() + ((int)paintArea.getWidth() - Math.max(topPx, bottomPx)) / 2;
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont());
        int prongHeight = metrics.getHeight() + metrics.getDescent();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (!this.transparent.booleanValue()) {
            Rectangle frame = new Rectangle(leftX - 4, centerY - prongHeight - 4, Math.max(topPx, bottomPx) + 8, 8 + prongHeight * 2);
            g2d.setColor(this.bgcolor);
            g2d.fill(frame);
            --frame.height;
            --frame.width;
            g2d.setColor(this.fgcolor);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.draw(frame);
        } else {
            g2d.setColor(this.fgcolor);
        }
        g2d.setStroke(new BasicStroke(2.0f));
        if (this.measurementSystem == MeasurementSystem.METRIC || this.measurementSystem == MeasurementSystem.BOTH) {
            g2d.drawLine(leftX, centerY, leftX, centerY - prongHeight);
            g2d.drawLine(leftX + topPx, centerY, leftX + topPx, centerY - prongHeight);
            g2d.drawLine(leftX, centerY, leftX + topPx, centerY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialias);
            String topText = topRounded + " " + topUnits;
            g2d.drawString(topText, leftX + (topPx - metrics.stringWidth(topText)) / 2, centerY - prongHeight + metrics.getAscent());
        }
        if (this.measurementSystem == MeasurementSystem.IMPERIAL || this.measurementSystem == MeasurementSystem.BOTH) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.drawLine(leftX, centerY + prongHeight, leftX, centerY);
            g2d.drawLine(leftX + bottomPx, centerY, leftX + bottomPx, centerY + prongHeight);
            g2d.drawLine(leftX, centerY, leftX + bottomPx, centerY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialias);
            String bottomText = bottomRounded + " " + bottomUnits;
            g2d.drawString(bottomText, leftX + (bottomPx - metrics.stringWidth(bottomText)) / 2, centerY + metrics.getHeight());
        }
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        g2d.setFont(oldFont);
    }

    static {
        INCHES_PER_UNIT.put("inches", 1.0);
        INCHES_PER_UNIT.put(bottomInUnits, 12.0);
        INCHES_PER_UNIT.put(bottomOutUnits, 63360.0);
        INCHES_PER_UNIT.put(topInUnits, 39.3701);
        INCHES_PER_UNIT.put(topOutUnits, 39370.1);
        INCHES_PER_UNIT.put("dd", 4374754.0);
        INCHES_PER_UNIT.put("yd", 36.0);
    }

    static enum MeasurementSystem {
        METRIC,
        IMPERIAL,
        BOTH;


        static MeasurementSystem mapToEnum(String type) throws Exception {
            switch (type) {
                case "metric": {
                    return METRIC;
                }
                case "imperial": {
                    return IMPERIAL;
                }
                case "both": {
                    return BOTH;
                }
            }
            throw new Exception("Wrong input parameter");
        }
    }
}

