/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.xml.transform.TransformerException;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.describelayer.DescribeLayerModel;
import org.geoserver.wms.describelayer.DescribeLayerResponse;
import org.geoserver.wms.describelayer.DescribeLayerTransformer;

public class XMLDescribeLayerResponse
extends DescribeLayerResponse {
    public static final String DESCLAYER_MIME_TYPE = "application/vnd.ogc.wms_xml";
    protected final WMS wms;

    public XMLDescribeLayerResponse(WMS wms) {
        super(DESCLAYER_MIME_TYPE);
        this.wms = wms;
    }

    public XMLDescribeLayerResponse(WMS wms, String type) {
        super(type);
        this.wms = wms;
    }

    @Override
    public void write(DescribeLayerModel results, DescribeLayerRequest request, OutputStream out) throws ServiceException, IOException {
        DescribeLayerTransformer transformer = new DescribeLayerTransformer(request.getBaseUrl());
        Charset encoding = this.wms.getCharSet();
        transformer.setEncoding(encoding);
        if (this.wms.getGeoServer().getSettings().isVerbose()) {
            transformer.setIndentation(2);
        }
        try {
            transformer.transform(request, out);
            out.flush();
        }
        catch (TransformerException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

