/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.featureinfo.FeatureCollectionDecorator;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml2.bindings.GML2EncodingUtils;

public class GML3FeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    public static final String FORMAT = "application/vnd.ogc.gml/3.1.1";
    private GML3OutputFormat outputFormat;

    public GML3FeatureInfoOutputFormat(GML3OutputFormat outputFormat) {
        this(outputFormat, FORMAT);
    }

    protected GML3FeatureInfoOutputFormat(GML3OutputFormat outputFormat, String format) {
        super(format);
        this.outputFormat = outputFormat;
    }

    @Override
    public void write(FeatureCollectionType results, GetFeatureInfoRequest fInfoReq, OutputStream out) throws ServiceException, IOException {
        FeatureCollectionType features = WfsFactory.eINSTANCE.createFeatureCollectionType();
        GetFeatureType gfreq = WfsFactory.eINSTANCE.createGetFeatureType();
        gfreq.setBaseUrl(fInfoReq.getBaseUrl());
        for (int i = 0; i < results.getFeature().size(); ++i) {
            FeatureCollection fc = (FeatureCollection)results.getFeature().get(i);
            Name name = FeatureCollectionDecorator.getName(fc);
            QName qname = new QName(name.getNamespaceURI(), name.getLocalPart());
            features.getFeature().add((Object)fc);
            QueryType qt = WfsFactory.eINSTANCE.createQueryType();
            qt.setTypeName(Collections.singletonList(qname));
            String srsName = GML2EncodingUtils.toURI((CoordinateReferenceSystem)fc.getSchema().getCoordinateReferenceSystem());
            if (srsName != null) {
                try {
                    qt.setSrsName(new URI(srsName));
                }
                catch (URISyntaxException e) {
                    throw new ServiceException("Unable to determite coordinate system for featureType " + fc.getSchema().getName().getLocalPart() + ".  Schema told us '" + srsName + "'", (Throwable)e);
                }
            }
            gfreq.getQuery().add((Object)qt);
        }
        Service serviceDesc = new Service("wms", null, null, Collections.emptyList());
        Operation opDescriptor = new Operation("", serviceDesc, null, new Object[]{gfreq});
        this.outputFormat.write((Object)features, out, opDescriptor);
    }
}

