/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageTypeSpecifier;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.RenderingVariables;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.featureinfo.AbstractVectorLayerIdentifier;
import org.geoserver.wms.featureinfo.DynamicBufferEstimator;
import org.geoserver.wms.featureinfo.DynamicSizeStyleExtractor;
import org.geoserver.wms.featureinfo.FeatureInfoStylePreprocessor;
import org.geoserver.wms.featureinfo.LayerIdentifierUtils;
import org.geoserver.wms.featureinfo.ListComplexFeatureCollection;
import org.geoserver.wms.featureinfo.VectorBasicLayerIdentifier;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.Filters;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.GraphicsAwareDpiRescaleStyleVisitor;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.StyleAttributeExtractor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class VectorRenderingLayerIdentifier
extends AbstractVectorLayerIdentifier
implements ExtensionPriority {
    static final Logger LOGGER = Logging.getLogger(VectorRenderingLayerIdentifier.class);
    private static final String FEATURE_INFO_RENDERING_ENABLED_KEY = "org.geoserver.wms.featureinfo.render.enabled";
    protected static final int MIN_BUFFER_SIZE = Integer.getInteger("org.geoserver.wms.featureinfo.minBuffer", 3);
    public static boolean RENDERING_FEATUREINFO_ENABLED;
    private WMS wms;
    private VectorBasicLayerIdentifier fallback;
    private static final FilterFactory FF;

    public VectorRenderingLayerIdentifier(WMS wms, VectorBasicLayerIdentifier fallback) {
        this.wms = wms;
        this.fallback = fallback;
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        if (!RENDERING_FEATUREINFO_ENABLED) {
            return false;
        }
        return super.canHandle(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters params, int maxFeatures) throws Exception {
        LOGGER.log(Level.FINER, "Applying rendering based feature info identifier");
        if (!(params.getLayer().getFeatureSource(true, params.getRequestedCRS()).getSchema() instanceof SimpleFeatureType)) {
            return this.fallback.identify(params, maxFeatures);
        }
        Style style = this.preprocessStyle(params.getStyle(), params.getLayer().getFeature().getFeatureType());
        int userBuffer = params.getBuffer() > 0 ? params.getBuffer() : MIN_BUFFER_SIZE;
        int buffer = this.getBuffer(userBuffer);
        List<Rule> rules = this.getActiveRules(style, params.getScaleDenominator());
        if (rules.isEmpty()) {
            return null;
        }
        GetMapRequest getMap = params.getGetMapRequest();
        getMap.getFormatOptions().put("antialias", "NONE");
        WMSMapContent mc = new WMSMapContent(getMap);
        try {
            mc.setTransparent(true);
            mc.setBuffer(params.getBuffer());
            mc.getViewport().setBounds(new ReferencedEnvelope(getMap.getBbox(), getMap.getCrs()));
            mc.setMapWidth(getMap.getWidth());
            mc.setMapHeight(getMap.getHeight());
            FeatureLayer layer = this.getLayer(params, style);
            mc.addLayer((Layer)layer);
            RenderingVariables.setupEnvironmentVariables(mc);
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)params.getRequestedBounds(), (Rectangle)new Rectangle(params.getWidth(), params.getHeight()));
            AffineTransform screenToWorld = worldToScreen.createInverse();
            this.rescaleRules(rules, params);
            int radius = this.getSearchRadius(params, rules, layer, getMap, screenToWorld);
            if (radius < buffer) {
                radius = buffer;
            }
            Envelope targetRasterSpace = new Envelope((double)(params.getX() - radius), (double)(params.getX() + radius), (double)(params.getY() - radius), (double)(params.getY() + radius));
            Envelope targetModelSpace = JTS.transform((Envelope)targetRasterSpace, (MathTransform)new AffineTransform2D(screenToWorld));
            int paintAreaSize = radius * 2;
            BufferedImage image = ImageTypeSpecifier.createFromBufferedImageType(2).createBufferedImage(paintAreaSize, paintAreaSize);
            image.setAccelerationPriority(0.0f);
            int mid = radius;
            int hitAreaSize = buffer * 2 + 1;
            if (hitAreaSize > paintAreaSize) {
                hitAreaSize = paintAreaSize;
            }
            Rectangle hitArea = new Rectangle(mid - buffer, mid - buffer, hitAreaSize, hitAreaSize);
            FeatureInfoRenderListener featureInfoListener = new FeatureInfoRenderListener(image, hitArea, maxFeatures, params.getPropertyNames());
            mc.getViewport().setBounds(new ReferencedEnvelope(targetModelSpace, getMap.getCrs()));
            mc.setMapWidth(paintAreaSize);
            mc.setMapHeight(paintAreaSize);
            GetMapOutputFormat rim = this.createMapOutputFormat(image, featureInfoListener);
            rim.produceMap(mc);
            List<SimpleFeature> features = featureInfoListener.getFeatures();
            List<FeatureCollection> list = this.aggregateByFeatureType(features, params.getRequestedCRS());
            return list;
        }
        finally {
            mc.dispose();
        }
    }

    protected int getBuffer(int userBuffer) {
        if (this.wms.getMaxBuffer() <= 0) {
            return userBuffer;
        }
        return Math.min(userBuffer, this.wms.getMaxBuffer());
    }

    protected GetMapOutputFormat createMapOutputFormat(final BufferedImage image, final FeatureInfoRenderListener featureInfoListener) {
        return new RenderedImageMapOutputFormat(this.wms){
            private Graphics2D graphics;

            @Override
            protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
                return image;
            }

            @Override
            protected Graphics2D getGraphics(boolean transparent, Color bgColor, RenderedImage preparedImage, Map<RenderingHints.Key, Object> hintsMap) {
                this.graphics = super.getGraphics(transparent, bgColor, preparedImage, hintsMap);
                return this.graphics;
            }

            @Override
            protected void onBeforeRender(StreamingRenderer renderer) {
                Map hints = renderer.getRendererHints();
                hints.put("optimizeFTSRendering", Boolean.FALSE);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                featureInfoListener.setGraphics(this.graphics);
                featureInfoListener.setRenderer(renderer);
                renderer.addRenderListener((RenderListener)featureInfoListener);
            }
        };
    }

    private void rescaleRules(List<Rule> rules, FeatureInfoRequestParameters params) {
        Rule rescaled;
        int i;
        HashMap<String, Integer> rendererParams = new HashMap<String, Integer>();
        Integer requestedDpi = (Integer)params.getGetMapRequest().getFormatOptions().get("dpi");
        if (requestedDpi != null) {
            rendererParams.put("dpi", requestedDpi);
        }
        double standardDpi = RendererUtilities.getDpi(rendererParams);
        if (requestedDpi != null && standardDpi != (double)requestedDpi.intValue()) {
            double scaleFactor = (double)requestedDpi.intValue() / standardDpi;
            GraphicsAwareDpiRescaleStyleVisitor dpiVisitor = new GraphicsAwareDpiRescaleStyleVisitor(scaleFactor);
            for (i = 0; i < rules.size(); ++i) {
                rules.get(i).accept((StyleVisitor)dpiVisitor);
                rescaled = (Rule)dpiVisitor.getCopy();
                rules.set(i, rescaled);
            }
        }
        double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio((double)params.getScaleDenominator(), rendererParams);
        UomRescaleStyleVisitor uomVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
        for (i = 0; i < rules.size(); ++i) {
            rules.get(i).accept((StyleVisitor)uomVisitor);
            rescaled = (Rule)uomVisitor.getCopy();
            rules.set(i, rescaled);
        }
    }

    private Style preprocessStyle(Style style, FeatureType schema) {
        FeatureInfoStylePreprocessor preprocessor = new FeatureInfoStylePreprocessor(schema);
        style.accept((StyleVisitor)preprocessor);
        Style result = (Style)preprocessor.getCopy();
        return result;
    }

    private List<FeatureCollection> aggregateByFeatureType(List<? extends Feature> features, CoordinateReferenceSystem targetcrs) {
        HashMap<FeatureType, ArrayList<Feature>> map = new HashMap<FeatureType, ArrayList<Feature>>();
        for (Feature feature : features) {
            FeatureType type = feature.getType();
            ArrayList<Feature> list = (ArrayList<Feature>)map.get(type);
            if (list == null) {
                list = new ArrayList<Feature>();
                map.put(type, list);
            }
            list.add(feature);
        }
        ArrayList<FeatureCollection> result = new ArrayList<FeatureCollection>();
        for (Map.Entry entry : map.entrySet()) {
            FeatureType type = (FeatureType)entry.getKey();
            List list = (List)entry.getValue();
            if (type instanceof SimpleFeatureType) {
                ArrayList sf = new ArrayList(list);
                result.add((FeatureCollection)new ListFeatureCollection((SimpleFeatureType)type, sf));
                continue;
            }
            result.add((FeatureCollection)new ListComplexFeatureCollection(type, list));
        }
        if (!this.wms.isFeaturesReprojectionDisabled()) {
            return LayerIdentifierUtils.reproject(result, targetcrs);
        }
        return result;
    }

    private FeatureLayer getLayer(FeatureInfoRequestParameters params, Style style) throws IOException {
        Integer startIndex;
        List<Object> times = params.getTimes();
        List<Object> elevations = params.getElevations();
        Filter layerFilter = params.getFilter();
        MapLayerInfo layer = params.getLayer();
        GetMapRequest getMapRequest = params.getGetMapRequest();
        FeatureTypeInfo featureInfo = layer.getFeature();
        this.wms.validateVectorDimensions(times, elevations, featureInfo, getMapRequest);
        Filter dimensionFilter = this.wms.getDimensionFilter(times, elevations, featureInfo, getMapRequest);
        Filter filter = Filters.and((FilterFactory)FF, (Filter)dimensionFilter, (Filter)layerFilter);
        GetMapRequest getMap = getMapRequest;
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource = super.handleClipParam(params, layer.getFeatureSource(true, getMap.getCrs()));
        Query definitionQuery = new Query(featureSource.getSchema().getName().getLocalPart());
        definitionQuery.setVersion(getMap.getFeatureVersion());
        definitionQuery.setFilter(filter);
        definitionQuery.setSortBy(params.getSort());
        Map<String, String> viewParams = params.getViewParams();
        if (viewParams != null) {
            definitionQuery.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams));
        }
        if ((startIndex = getMap.getStartIndex()) != null) {
            QueryCapabilities queryCapabilities = featureSource.getQueryCapabilities();
            if (queryCapabilities.isOffsetSupported()) {
                definitionQuery.setStartIndex(startIndex);
            } else {
                throw new ServiceException("startIndex is not supported for the " + layer.getName() + " layer");
            }
        }
        int maxFeatures = getMap.getMaxFeatures() != null ? getMap.getMaxFeatures() : Integer.MAX_VALUE;
        definitionQuery.setMaxFeatures(maxFeatures);
        FeatureLayer result = new FeatureLayer(new FeatureInfoFeatureSource<FeatureType, Feature>(featureSource, params.getPropertyNames()), style);
        result.setQuery(definitionQuery);
        return result;
    }

    private int getSearchRadius(FeatureInfoRequestParameters params, List<Rule> rules, FeatureLayer layer, GetMapRequest getMap, AffineTransform screenToWorld) throws TransformException, FactoryException, IOException {
        int requestBuffer = params.getBuffer();
        if (requestBuffer > 0) {
            return requestBuffer;
        }
        Integer layerBuffer = null;
        LayerInfo layerInfo = params.getLayer().getLayerInfo();
        if (layerInfo != null) {
            layerBuffer = (Integer)layerInfo.getMetadata().get("buffer", Integer.class);
        }
        if (layerBuffer != null && layerBuffer > 0) {
            return layerBuffer;
        }
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        for (Rule rule : rules) {
            rule.accept((StyleVisitor)estimator);
        }
        int estimatedRadius = estimator.getBuffer() / 2;
        if (estimator.isEstimateAccurate()) {
            if (estimatedRadius < MIN_BUFFER_SIZE) {
                return MIN_BUFFER_SIZE;
            }
            return estimatedRadius;
        }
        DynamicSizeStyleExtractor extractor = new DynamicSizeStyleExtractor();
        ArrayList<Rule> dynamicRules = new ArrayList<Rule>();
        for (Rule rule : rules) {
            rule.accept((StyleVisitor)extractor);
            Rule copy = (Rule)extractor.getCopy();
            if (copy == null) continue;
            dynamicRules.add(copy);
        }
        if (dynamicRules.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No dynamic rules found, even if the estimator initially though so, using the static analysis result: " + estimatedRadius);
            }
            return estimatedRadius;
        }
        FeatureSource fs = layer.getFeatureSource();
        Envelope targetRasterSpace = new Envelope((double)(-estimatedRadius), (double)(params.getWidth() + estimatedRadius), (double)(-estimatedRadius), (double)(params.getWidth() + estimatedRadius));
        Envelope expanded = JTS.transform((Envelope)targetRasterSpace, (MathTransform)new AffineTransform2D(screenToWorld));
        ReferencedEnvelope renderingBBOX = new ReferencedEnvelope(expanded, getMap.getCrs());
        ReferencedEnvelope queryBBOX = renderingBBOX.transform(fs.getSchema().getCoordinateReferenceSystem(), true);
        Query query = layer.getQuery();
        BBOX bbox = FF.bbox((Expression)FF.property(""), (BoundingBox)queryBBOX);
        if (query.getFilter() == null || query.getFilter() == Filter.INCLUDE) {
            query.setFilter((Filter)bbox);
        } else {
            And and = FF.and(query.getFilter(), (Filter)bbox);
            query.setFilter((Filter)and);
        }
        String[] dynamicProperties = this.getDynamicProperties(dynamicRules);
        query.setPropertyNames(dynamicProperties);
        DynamicBufferEstimator dbe = new DynamicBufferEstimator();
        fs.getFeatures(query).accepts(feature -> {
            dbe.setFeature(feature);
            for (Rule rule : dynamicRules) {
                rule.accept((StyleVisitor)dbe);
            }
        }, null);
        int dynamicBuffer = dbe.getBuffer();
        return Math.max(dynamicBuffer / 2, estimatedRadius);
    }

    private String[] getDynamicProperties(List<Rule> dynamicRules) {
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        for (Rule rule : dynamicRules) {
            rule.accept((StyleVisitor)extractor);
        }
        return extractor.getAttributeNames();
    }

    public int getPriority() {
        return 50;
    }

    static {
        FF = CommonFactoryFinder.getFilterFactory();
        String value = System.getProperty(FEATURE_INFO_RENDERING_ENABLED_KEY, "true");
        RENDERING_FEATUREINFO_ENABLED = Boolean.valueOf(value);
        if (!RENDERING_FEATUREINFO_ENABLED) {
            LOGGER.info("Rendering based GetFeatureInfo disabled since org.geoserver.wms.featureinfo.render.enabled is set to " + value);
        }
    }

    static class FeatureInfoFeatureSource<T extends FeatureType, F extends Feature>
    extends DecoratingFeatureSource<T, F> {
        String[] propertyNames;

        public FeatureInfoFeatureSource(FeatureSource<T, F> delegate, String[] propertyNames) {
            super(delegate);
            this.propertyNames = propertyNames;
        }

        public FeatureCollection<T, F> getFeatures(Query query) throws IOException {
            Query q = new Query(query);
            if (query.getHints() != null) {
                Hints newHints = new Hints((RenderingHints)query.getHints());
                newHints.remove((Object)Hints.SCREENMAP);
                q.setHints(newHints);
            }
            if (this.propertyNames == null || this.propertyNames.length == 0) {
                q.setProperties(Query.ALL_PROPERTIES);
            } else if (query.getPropertyNames() == null || query.getPropertyNames().length == 0) {
                q.setPropertyNames(this.propertyNames);
            } else {
                LinkedHashSet<String> names = new LinkedHashSet<String>(Arrays.asList(this.propertyNames));
                names.addAll(Arrays.asList(q.getPropertyNames()));
                String[] newNames = names.toArray(new String[names.size()]);
                q.setPropertyNames(newNames);
            }
            return super.getFeatures(q);
        }

        public Set<RenderingHints.Key> getSupportedHints() {
            Set hints = ((FeatureSource)this.delegate).getSupportedHints();
            HashSet<RenderingHints.Key> result = hints == null ? new HashSet<RenderingHints.Key>() : new HashSet(hints);
            result.remove(Hints.FEATURE_DETACHED);
            result.add((RenderingHints.Key)Hints.SCREENMAP);
            return result;
        }
    }

    static final class FeatureInfoRenderListener
    implements RenderListener {
        private final int scanlineStride;
        private Rectangle hitArea;
        List<SimpleFeature> features = new ArrayList<SimpleFeature>();
        String[] propertyNames;
        SimpleFeatureBuilder retypeBuilder;
        private int maxFeatures;
        ColorModel cm;
        BufferedImage bi;
        StreamingRenderer renderer;
        Feature previous;
        Graphics2D graphics;

        public FeatureInfoRenderListener(BufferedImage bi, Rectangle hitArea, int maxFeatures, String[] propertyNames) {
            this.verifyColorModel(bi);
            Raster raster = this.getRaster(bi);
            this.scanlineStride = raster.getDataBuffer().getSize() / raster.getHeight();
            this.hitArea = hitArea;
            this.maxFeatures = maxFeatures;
            this.cm = bi.getColorModel();
            this.bi = bi;
        }

        public void setGraphics(Graphics2D graphics) {
            this.graphics = graphics;
        }

        public void setRenderer(StreamingRenderer renderer) {
            this.renderer = renderer;
        }

        public List<SimpleFeature> getFeatures() {
            return this.features;
        }

        private void verifyColorModel(BufferedImage bi) {
            ColorModel cm = bi.getColorModel();
            if (!(cm instanceof DirectColorModel)) {
                throw new IllegalArgumentException("Invalid color model, it should be a DirectColorModel");
            }
            DirectColorModel dcm = (DirectColorModel)cm;
            if (dcm.getNumColorComponents() != 3 || !dcm.hasAlpha()) {
                throw new IllegalArgumentException("Invalid color model, it should be a 3 bands DirectColorModel with alpha");
            }
        }

        private Raster getRaster(BufferedImage image) {
            WritableRaster raster = image.getRaster();
            if (raster.getParent() != null) {
                throw new IllegalArgumentException("The provided raster is a child of another image");
            }
            return raster;
        }

        public void featureRenderer(SimpleFeature feature) {
            if (feature == this.previous) {
                this.cleanHitArea();
                return;
            }
            Raster raster = this.getRaster(this.bi);
            int[] pixels = ((DataBufferInt)raster.getDataBuffer()).getData();
            boolean hit = false;
            for (int row = this.hitArea.y; row < this.hitArea.y + this.hitArea.height && !hit; ++row) {
                int idx = row * this.scanlineStride + this.hitArea.x;
                for (int col = this.hitArea.x; col < this.hitArea.x + this.hitArea.width && !hit; ++col) {
                    int color = pixels[idx];
                    int alpha = this.cm.getAlpha(color);
                    if (!hit && alpha > 0) {
                        hit = true;
                    }
                    ++idx;
                }
            }
            if (hit) {
                this.previous = feature;
                if (this.features.size() < this.maxFeatures) {
                    SimpleFeature retyped = this.retype(feature);
                    this.features.add(retyped);
                } else {
                    this.renderer.stopRendering();
                }
            }
            this.cleanHitArea();
        }

        private SimpleFeature retype(SimpleFeature feature) {
            if (this.propertyNames == null) {
                return feature;
            }
            if (this.retypeBuilder == null) {
                SimpleFeatureType targetType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)feature.getFeatureType(), (String[])this.propertyNames);
                this.retypeBuilder = new SimpleFeatureBuilder(targetType);
            }
            return SimpleFeatureBuilder.retype((SimpleFeature)feature, (SimpleFeatureBuilder)this.retypeBuilder);
        }

        private void cleanHitArea() {
            Composite oldComposite = this.graphics.getComposite();
            this.graphics.setComposite(AlphaComposite.getInstance(2));
            this.graphics.setColor(new Color(0, true));
            this.graphics.fillRect(this.hitArea.x, this.hitArea.y, this.hitArea.width, this.hitArea.height);
            this.graphics.setComposite(oldComposite);
        }

        public void errorOccurred(Exception e) {
        }
    }
}

