/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.legendgraphic.AbstractGetLegendGraphicResponse;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphic;
import org.geoserver.wms.legendgraphic.LegendGraphic;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.image.ImageWorker;
import org.springframework.util.Assert;

public class GIFLegendGraphicResponse
extends AbstractGetLegendGraphicResponse {
    public GIFLegendGraphicResponse() {
        super(BufferedImageLegendGraphic.class, "image/gif");
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        Assert.isInstanceOf(BufferedImageLegendGraphic.class, (Object)value);
        return "image/gif";
    }

    public void write(Object legend, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(BufferedImageLegendGraphic.class, (Object)legend);
        BufferedImage legendGraphic = (BufferedImage)((LegendGraphic)legend).getLegend();
        RenderedImage forcedIndexed8Bitmask = ImageUtils.forceIndexed8Bitmask(legendGraphic, null);
        ImageWorker imageWorker = new ImageWorker(forcedIndexed8Bitmask);
        imageWorker.writeGIF((Object)output, "LZW", 0.75f);
    }
}

