/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.RenderedImage;
import java.util.stream.IntStream;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;

class Tally {
    static final long UNLIMITED = -1L;
    private final long maxMemory;
    private long usedMemory;

    public Tally(long maxMemory) {
        this.maxMemory = maxMemory;
        this.usedMemory = 0L;
    }

    public Tally(WMS wms) {
        this.maxMemory = wms != null && wms.getMaxRequestMemory() > 0 ? (long)wms.getMaxRequestMemory() * 1024L : -1L;
    }

    public void addImage(RenderedImage image) {
        if (this.maxMemory != -1L) {
            long imageSize = Tally.computeImageSize(image);
            if (this.usedMemory + imageSize > this.maxMemory) {
                throw new ServiceException("Max legend graphic memory usage exceeded.", "MaxMemoryExceeded");
            }
            this.usedMemory += imageSize;
        }
    }

    public static long computeImageSize(RenderedImage image) {
        int pixelSize = IntStream.of(image.getSampleModel().getSampleSize()).sum() / 8;
        return (long)image.getWidth() * (long)image.getHeight() * (long)pixelSize;
    }

    public Tally getRemaining() {
        return new Tally(this.maxMemory - this.usedMemory);
    }

    public Tally getFull() {
        return new Tally(this.maxMemory);
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }
}

