/*

  OpenLayers.js -- OpenLayers Map Viewer Library

  Copyright 2005-2011 OpenLayers Contributors, released under the FreeBSD
  license. Please see http://svn.openlayers.org/trunk/openlayers/license.txt
  for the full text of the license.

  Includes compressed code under the following licenses:

  (For uncompressed versions of the code used please see the
  OpenLayers SVN repository: <http://openlayers.org/>)

*/

/* Contains portions of Prototype.js:
 *
 * Prototype JavaScript framework, version 1.4.0
 *  (c) 2005 Sam Stephenson <sam@conio.net>
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
 *--------------------------------------------------------------------------*/

/**  
*  
*  Contains portions of Rico <http://openrico.org/>
* 
*  Copyright 2005 Sabre Airline Solutions  
*  
*  Licensed under the Apache License, Version 2.0 (the "License"); you
*  may not use this file except in compliance with the License. You
*  may obtain a copy of the License at
*  
*         http://www.apache.org/licenses/LICENSE-2.0  
*  
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
*  implied. See the License for the specific language governing
*  permissions and limitations under the License. 
*
**/

/**
 * Contains XMLHttpRequest.js <http://code.google.com/p/xmlhttprequest/>
 * Copyright 2007 Sergey Ilinsky (http://www.ilinsky.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 */

/**
 * Contains portions of Gears <http://code.google.com/apis/gears/>
 *
 * Copyright 2007, Google Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. Neither the name of Google Inc. nor the names of its contributors may be
 *     used to endorse or promote products derived from this software without
 *     specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sets up google.gears.*, which is *the only* supported way to access Gears.
 *
 * Circumvent this file at your own risk!
 *
 * In the future, Gears may automatically define google.gears.* without this
 * file. Gears may use these objects to transparently fix bugs and compatibility
 * issues. Applications that use the code below will continue to work seamlessly
 * when that happens.
 */

/**
 * OpenLayers.Util.pagePosition is based on Yahoo's getXY method, which is
 * Copyright (c) 2006, Yahoo! Inc.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with or
 * without modification, are permitted provided that the following conditions
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * 
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * 
 * * Neither the name of Yahoo! Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission of Yahoo! Inc.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */var OpenLayers={VERSION_NUMBER:"Release 2.11",singleFile:!0,_getScriptLocation:function(){for(var a=/(^|(.*?\/))(OpenLayers.js)(\?|$)/,b=document.getElementsByTagName("script"),c,d="",e=0,f=b.length;e<f;e++)if(c=b[e].getAttribute("src"))if(c=c.match(a)){d=c[1];break}return function(){return d}}()};
(function(){var a="object"==typeof OpenLayers&&OpenLayers.singleFile,b=!a?"lib/OpenLayers.js":"OpenLayers.js",c=window.OpenLayers;window.OpenLayers={_getScriptLocation:function(){for(var a=RegExp("(^|(.*?\\/))("+b+")(\\?|$)"),c=document.getElementsByTagName("script"),d,e="",f=0,s=c.length;f<s;f++)if(d=c[f].getAttribute("src"))if(d=d.match(a)){e=d[1];break}return function(){return e}}()};if(!a){c||(c="OpenLayers/BaseTypes/Class.js,OpenLayers/Util.js,OpenLayers/BaseTypes.js,OpenLayers/BaseTypes/Bounds.js,OpenLayers/BaseTypes/Date.js,OpenLayers/BaseTypes/Element.js,OpenLayers/BaseTypes/LonLat.js,OpenLayers/BaseTypes/Pixel.js,OpenLayers/BaseTypes/Size.js,OpenLayers/Console.js,OpenLayers/Tween.js,OpenLayers/Kinetic.js,Rico/Corner.js,Rico/Color.js,OpenLayers/Ajax.js,OpenLayers/Events.js,OpenLayers/Request.js,OpenLayers/Request/XMLHttpRequest.js,OpenLayers/Projection.js,OpenLayers/Map.js,OpenLayers/Layer.js,OpenLayers/Icon.js,OpenLayers/Marker.js,OpenLayers/Marker/Box.js,OpenLayers/Popup.js,OpenLayers/Tile.js,OpenLayers/Tile/Image.js,OpenLayers/Tile/Image/IFrame.js,OpenLayers/Tile/WFS.js,OpenLayers/Layer/Image.js,OpenLayers/Layer/SphericalMercator.js,OpenLayers/Layer/EventPane.js,OpenLayers/Layer/FixedZoomLevels.js,OpenLayers/Layer/Google.js,OpenLayers/Layer/Google/v3.js,OpenLayers/Layer/VirtualEarth.js,OpenLayers/Layer/Yahoo.js,OpenLayers/Layer/HTTPRequest.js,OpenLayers/Layer/Grid.js,OpenLayers/Layer/MapGuide.js,OpenLayers/Layer/MapServer.js,OpenLayers/Layer/MapServer/Untiled.js,OpenLayers/Layer/KaMap.js,OpenLayers/Layer/KaMapCache.js,OpenLayers/Layer/MultiMap.js,OpenLayers/Layer/Markers.js,OpenLayers/Layer/Text.js,OpenLayers/Layer/WorldWind.js,OpenLayers/Layer/ArcGIS93Rest.js,OpenLayers/Layer/WMS.js,OpenLayers/Layer/WMS/Untiled.js,OpenLayers/Layer/WMS/Post.js,OpenLayers/Layer/WMTS.js,OpenLayers/Layer/ArcIMS.js,OpenLayers/Layer/GeoRSS.js,OpenLayers/Layer/Boxes.js,OpenLayers/Layer/XYZ.js,OpenLayers/Layer/Bing.js,OpenLayers/Layer/TMS.js,OpenLayers/Layer/TileCache.js,OpenLayers/Layer/Zoomify.js,OpenLayers/Layer/ArcGISCache.js,OpenLayers/Popup/Anchored.js,OpenLayers/Popup/AnchoredBubble.js,OpenLayers/Popup/Framed.js,OpenLayers/Popup/FramedCloud.js,OpenLayers/Feature.js,OpenLayers/Feature/Vector.js,OpenLayers/Feature/WFS.js,OpenLayers/Handler.js,OpenLayers/Handler/Click.js,OpenLayers/Handler/Hover.js,OpenLayers/Handler/Point.js,OpenLayers/Handler/Path.js,OpenLayers/Handler/Polygon.js,OpenLayers/Handler/Feature.js,OpenLayers/Handler/Drag.js,OpenLayers/Handler/Pinch.js,OpenLayers/Handler/RegularPolygon.js,OpenLayers/Handler/Box.js,OpenLayers/Handler/MouseWheel.js,OpenLayers/Handler/Keyboard.js,OpenLayers/Control.js,OpenLayers/Control/Attribution.js,OpenLayers/Control/Button.js,OpenLayers/Control/ZoomBox.js,OpenLayers/Control/ZoomToMaxExtent.js,OpenLayers/Control/DragPan.js,OpenLayers/Control/Navigation.js,OpenLayers/Control/PinchZoom.js,OpenLayers/Control/TouchNavigation.js,OpenLayers/Control/MouseDefaults.js,OpenLayers/Control/MousePosition.js,OpenLayers/Control/OverviewMap.js,OpenLayers/Control/KeyboardDefaults.js,OpenLayers/Control/PanZoom.js,OpenLayers/Control/PanZoomBar.js,OpenLayers/Control/ArgParser.js,OpenLayers/Control/Permalink.js,OpenLayers/Control/Scale.js,OpenLayers/Control/ScaleLine.js,OpenLayers/Control/Snapping.js,OpenLayers/Control/Split.js,OpenLayers/Control/LayerSwitcher.js,OpenLayers/Control/DrawFeature.js,OpenLayers/Control/DragFeature.js,OpenLayers/Control/ModifyFeature.js,OpenLayers/Control/Panel.js,OpenLayers/Control/SelectFeature.js,OpenLayers/Control/NavigationHistory.js,OpenLayers/Control/Measure.js,OpenLayers/Control/WMSGetFeatureInfo.js,OpenLayers/Control/WMTSGetFeatureInfo.js,OpenLayers/Control/Graticule.js,OpenLayers/Control/TransformFeature.js,OpenLayers/Control/SLDSelect.js,OpenLayers/Geometry.js,OpenLayers/Geometry/Rectangle.js,OpenLayers/Geometry/Collection.js,OpenLayers/Geometry/Point.js,OpenLayers/Geometry/MultiPoint.js,OpenLayers/Geometry/Curve.js,OpenLayers/Geometry/LineString.js,OpenLayers/Geometry/LinearRing.js,OpenLayers/Geometry/Polygon.js,OpenLayers/Geometry/MultiLineString.js,OpenLayers/Geometry/MultiPolygon.js,OpenLayers/Geometry/Surface.js,OpenLayers/Renderer.js,OpenLayers/Renderer/Elements.js,OpenLayers/Renderer/NG.js,OpenLayers/Renderer/SVG.js,OpenLayers/Renderer/SVG2.js,OpenLayers/Renderer/Canvas.js,OpenLayers/Renderer/VML.js,OpenLayers/Layer/Vector.js,OpenLayers/Layer/PointGrid.js,OpenLayers/Layer/Vector/RootContainer.js,OpenLayers/Strategy.js,OpenLayers/Strategy/Filter.js,OpenLayers/Strategy/Fixed.js,OpenLayers/Strategy/Cluster.js,OpenLayers/Strategy/Paging.js,OpenLayers/Strategy/BBOX.js,OpenLayers/Strategy/Save.js,OpenLayers/Strategy/Refresh.js,OpenLayers/Filter.js,OpenLayers/Filter/FeatureId.js,OpenLayers/Filter/Logical.js,OpenLayers/Filter/Comparison.js,OpenLayers/Filter/Spatial.js,OpenLayers/Filter/Function.js,OpenLayers/Protocol.js,OpenLayers/Protocol/HTTP.js,OpenLayers/Protocol/SQL.js,OpenLayers/Protocol/SQL/Gears.js,OpenLayers/Protocol/WFS.js,OpenLayers/Protocol/WFS/v1.js,OpenLayers/Protocol/WFS/v1_0_0.js,OpenLayers/Protocol/WFS/v1_1_0.js,OpenLayers/Protocol/Script.js,OpenLayers/Protocol/SOS.js,OpenLayers/Protocol/SOS/v1_0_0.js,OpenLayers/Layer/PointTrack.js,OpenLayers/Layer/GML.js,OpenLayers/Style.js,OpenLayers/Style2.js,OpenLayers/StyleMap.js,OpenLayers/Rule.js,OpenLayers/Format.js,OpenLayers/Format/QueryStringFilter.js,OpenLayers/Format/XML.js,OpenLayers/Format/XML/VersionedOGC.js,OpenLayers/Format/Context.js,OpenLayers/Format/ArcXML.js,OpenLayers/Format/ArcXML/Features.js,OpenLayers/Format/GML.js,OpenLayers/Format/GML/Base.js,OpenLayers/Format/GML/v2.js,OpenLayers/Format/GML/v3.js,OpenLayers/Format/Atom.js,OpenLayers/Format/KML.js,OpenLayers/Format/GeoRSS.js,OpenLayers/Format/WFS.js,OpenLayers/Format/WFSCapabilities.js,OpenLayers/Format/WFSCapabilities/v1.js,OpenLayers/Format/WFSCapabilities/v1_0_0.js,OpenLayers/Format/WFSCapabilities/v1_1_0.js,OpenLayers/Format/WFSDescribeFeatureType.js,OpenLayers/Format/WMSDescribeLayer.js,OpenLayers/Format/WMSDescribeLayer/v1_1.js,OpenLayers/Format/WKT.js,OpenLayers/Format/CQL.js,OpenLayers/Format/OSM.js,OpenLayers/Format/GPX.js,OpenLayers/Format/Filter.js,OpenLayers/Format/Filter/v1.js,OpenLayers/Format/Filter/v1_0_0.js,OpenLayers/Format/Filter/v1_1_0.js,OpenLayers/Format/SLD.js,OpenLayers/Format/SLD/v1.js,OpenLayers/Format/SLD/v1_0_0.js,OpenLayers/Format/OWSCommon.js,OpenLayers/Format/OWSCommon/v1.js,OpenLayers/Format/OWSCommon/v1_0_0.js,OpenLayers/Format/OWSCommon/v1_1_0.js,OpenLayers/Format/CSWGetDomain.js,OpenLayers/Format/CSWGetDomain/v2_0_2.js,OpenLayers/Format/CSWGetRecords.js,OpenLayers/Format/CSWGetRecords/v2_0_2.js,OpenLayers/Format/WFST.js,OpenLayers/Format/WFST/v1.js,OpenLayers/Format/WFST/v1_0_0.js,OpenLayers/Format/WFST/v1_1_0.js,OpenLayers/Format/Text.js,OpenLayers/Format/JSON.js,OpenLayers/Format/GeoJSON.js,OpenLayers/Format/WMC.js,OpenLayers/Format/WMC/v1.js,OpenLayers/Format/WMC/v1_0_0.js,OpenLayers/Format/WMC/v1_1_0.js,OpenLayers/Format/WCSGetCoverage.js,OpenLayers/Format/WMSCapabilities.js,OpenLayers/Format/WMSCapabilities/v1.js,OpenLayers/Format/WMSCapabilities/v1_1.js,OpenLayers/Format/WMSCapabilities/v1_1_0.js,OpenLayers/Format/WMSCapabilities/v1_1_1.js,OpenLayers/Format/WMSCapabilities/v1_3.js,OpenLayers/Format/WMSCapabilities/v1_3_0.js,OpenLayers/Format/WMSCapabilities/v1_1_1_WMSC.js,OpenLayers/Format/WMSGetFeatureInfo.js,OpenLayers/Format/SOSCapabilities.js,OpenLayers/Format/SOSCapabilities/v1_0_0.js,OpenLayers/Format/SOSGetFeatureOfInterest.js,OpenLayers/Format/SOSGetObservation.js,OpenLayers/Format/OWSContext.js,OpenLayers/Format/OWSContext/v0_3_1.js,OpenLayers/Format/WMTSCapabilities.js,OpenLayers/Format/WMTSCapabilities/v1_0_0.js,OpenLayers/Format/WPSCapabilities.js,OpenLayers/Format/WPSCapabilities/v1_0_0.js,OpenLayers/Format/WPSDescribeProcess.js,OpenLayers/Format/WPSExecute.js,OpenLayers/Format/XLS.js,OpenLayers/Format/XLS/v1.js,OpenLayers/Format/XLS/v1_1_0.js,OpenLayers/Format/OGCExceptionReport.js,OpenLayers/Layer/WFS.js,OpenLayers/Control/GetFeature.js,OpenLayers/Control/MouseToolbar.js,OpenLayers/Control/NavToolbar.js,OpenLayers/Control/PanPanel.js,OpenLayers/Control/Pan.js,OpenLayers/Control/ZoomIn.js,OpenLayers/Control/ZoomOut.js,OpenLayers/Control/ZoomPanel.js,OpenLayers/Control/EditingToolbar.js,OpenLayers/Control/Geolocate.js,OpenLayers/Symbolizer.js,OpenLayers/Symbolizer/Point.js,OpenLayers/Symbolizer/Line.js,OpenLayers/Symbolizer/Polygon.js,OpenLayers/Symbolizer/Text.js,OpenLayers/Symbolizer/Raster.js,OpenLayers/Lang.js,OpenLayers/Lang/en.js".split(","));
for(var a=Array(c.length),d=OpenLayers._getScriptLocation()+"lib/",e=0,f=c.length;e<f;e++)a[e]="<script src='"+d+c[e]+"'><\/script>";0<a.length&&document.write(a.join(""))}})();OpenLayers.VERSION_NUMBER="Release 2.11";
OpenLayers.String={startsWith:function(a,b){return 0==a.indexOf(b)},contains:function(a,b){return-1!=a.indexOf(b)},trim:function(a){return a.replace(/^\s\s*/,"").replace(/\s\s*$/,"")},camelize:function(a){for(var a=a.split("-"),b=a[0],c=1,d=a.length;c<d;c++)var e=a[c],b=b+(e.charAt(0).toUpperCase()+e.substring(1));return b},format:function(a,b,c){b||(b=window);return a.replace(OpenLayers.String.tokenRegEx,function(a,e){for(var f,g=e.split(/\.+/),h=0;h<g.length;h++)0==h&&(f=b),f=f[g[h]];"function"==
typeof f&&(f=c?f.apply(null,c):f());return"undefined"==typeof f?"undefined":f})},tokenRegEx:/\$\{([\w.]+?)\}/g,numberRegEx:/^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/,isNumeric:function(a){return OpenLayers.String.numberRegEx.test(a)},numericIf:function(a){return OpenLayers.String.isNumeric(a)?parseFloat(a):a}};
if(!String.prototype.startsWith)String.prototype.startsWith=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.startsWith"}));return OpenLayers.String.startsWith(this,a)};if(!String.prototype.contains)String.prototype.contains=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.contains"}));return OpenLayers.String.contains(this,a)};
if(!String.prototype.trim)String.prototype.trim=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.trim"}));return OpenLayers.String.trim(this)};if(!String.prototype.camelize)String.prototype.camelize=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.camelize"}));return OpenLayers.String.camelize(this)};
OpenLayers.Number={decimalSeparator:".",thousandsSeparator:",",limitSigDigs:function(a,b){var c=0;0<b&&(c=parseFloat(a.toPrecision(b)));return c},format:function(a,b,c,d){b="undefined"!=typeof b?b:0;c="undefined"!=typeof c?c:OpenLayers.Number.thousandsSeparator;d="undefined"!=typeof d?d:OpenLayers.Number.decimalSeparator;null!=b&&(a=parseFloat(a.toFixed(b)));var e=a.toString().split(".");1==e.length&&null==b&&(b=0);a=e[0];if(c)for(var f=/(-?[0-9]+)([0-9]{3})/;f.test(a);)a=a.replace(f,"$1"+c+"$2");
0==b?b=a:(c=1<e.length?e[1]:"0",null!=b&&(c+=Array(b-c.length+1).join("0")),b=a+d+c);return b}};if(!Number.prototype.limitSigDigs)Number.prototype.limitSigDigs=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Number.limitSigDigs"}));return OpenLayers.Number.limitSigDigs(this,a)};
OpenLayers.Function={bind:function(a,b){var c=Array.prototype.slice.apply(arguments,[2]);return function(){var d=c.concat(Array.prototype.slice.apply(arguments,[0]));return a.apply(b,d)}},bindAsEventListener:function(a,b){return function(c){return a.call(b,c||window.event)}},False:function(){return!1},True:function(){return!0},Void:function(){}};
if(!Function.prototype.bind)Function.prototype.bind=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Function.bind"}));Array.prototype.unshift.apply(arguments,[this]);return OpenLayers.Function.bind.apply(null,arguments)};
if(!Function.prototype.bindAsEventListener)Function.prototype.bindAsEventListener=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Function.bindAsEventListener"}));return OpenLayers.Function.bindAsEventListener(this,a)};OpenLayers.Array={filter:function(a,b,c){var d=[];if(Array.prototype.filter)d=a.filter(b,c);else{var e=a.length;if("function"!=typeof b)throw new TypeError;for(var f=0;f<e;f++)if(f in a){var g=a[f];b.call(c,g,f,a)&&d.push(g)}}return d}};
OpenLayers.Class=function(){var a=arguments.length,b=arguments[0],c=arguments[a-1],d="function"==typeof c.initialize?c.initialize:function(){b.prototype.initialize.apply(this,arguments)};1<a?(a=[d,b].concat(Array.prototype.slice.call(arguments).slice(1,a-1),c),OpenLayers.inherit.apply(null,a)):d.prototype=c;return d};OpenLayers.Class.isPrototype=function(){};OpenLayers.Class.create=function(){return function(){arguments&&arguments[0]!=OpenLayers.Class.isPrototype&&this.initialize.apply(this,arguments)}};
OpenLayers.Class.inherit=function(a){var b=function(){a.call(this)},c=[b].concat(Array.prototype.slice.call(arguments));OpenLayers.inherit.apply(null,c);return b.prototype};OpenLayers.inherit=function(a,b){var c=function(){};c.prototype=b.prototype;a.prototype=new c;var d,e;for(c=2,d=arguments.length;c<d;c++){e=arguments[c];if("function"===typeof e)e=e.prototype;OpenLayers.Util.extend(a.prototype,e)}};OpenLayers.Util=OpenLayers.Util||{};
OpenLayers.Util.extend=function(a,b){a=a||{};if(b){for(var c in b){var d=b[c];void 0!==d&&(a[c]=d)}if(!("function"==typeof window.Event&&b instanceof window.Event)&&b.hasOwnProperty&&b.hasOwnProperty("toString"))a.toString=b.toString}return a};OpenLayers.Util=OpenLayers.Util||{};OpenLayers.Util.getElement=function(){for(var a=[],b=0,c=arguments.length;b<c;b++){var d=arguments[b];"string"==typeof d&&(d=document.getElementById(d));if(1==arguments.length)return d;a.push(d)}return a};
OpenLayers.Util.isElement=function(a){return!!(a&&1===a.nodeType)};OpenLayers.Util.isArray=function(a){return"[object Array]"===Object.prototype.toString.call(a)};if("undefined"===typeof window.$)window.$=OpenLayers.Util.getElement;OpenLayers.Util.removeItem=function(a,b){for(var c=a.length-1;0<=c;c--)a[c]==b&&a.splice(c,1);return a};OpenLayers.Util.clearArray=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"array = []"}));a.length=0};
OpenLayers.Util.indexOf=function(a,b){if("function"==typeof a.indexOf)return a.indexOf(b);for(var c=0,d=a.length;c<d;c++)if(a[c]==b)return c;return-1};
OpenLayers.Util.modifyDOMElement=function(a,b,c,d,e,f,g,h){if(b)a.id=b;if(c)a.style.left=c.x+"px",a.style.top=c.y+"px";if(d)a.style.width=d.w+"px",a.style.height=d.h+"px";if(e)a.style.position=e;if(f)a.style.border=f;if(g)a.style.overflow=g;if(0<=parseFloat(h)&&1>parseFloat(h))a.style.filter="alpha(opacity="+100*h+")",a.style.opacity=h;else if(1==parseFloat(h))a.style.filter="",a.style.opacity=""};
OpenLayers.Util.createDiv=function(a,b,c,d,e,f,g,h){var i=document.createElement("div");if(d)i.style.backgroundImage="url("+d+")";a||(a=OpenLayers.Util.createUniqueID("OpenLayersDiv"));e||(e="absolute");OpenLayers.Util.modifyDOMElement(i,a,b,c,e,f,g,h);return i};
OpenLayers.Util.createImage=function(a,b,c,d,e,f,g,h){var i=document.createElement("img");a||(a=OpenLayers.Util.createUniqueID("OpenLayersDiv"));e||(e="relative");OpenLayers.Util.modifyDOMElement(i,a,b,c,e,f,null,g);if(h)i.style.display="none",OpenLayers.Event.observe(i,"load",OpenLayers.Function.bind(OpenLayers.Util.onImageLoad,i)),OpenLayers.Event.observe(i,"error",OpenLayers.Function.bind(OpenLayers.Util.onImageLoadError,i));i.style.alt=a;i.galleryImg="no";if(d)i.src=d;return i};
OpenLayers.Util.setOpacity=function(a,b){OpenLayers.Util.modifyDOMElement(a,null,null,null,null,null,null,b)};OpenLayers.Util.onImageLoad=function(){if(!this.viewRequestID||this.map&&this.viewRequestID==this.map.viewRequestID)this.style.display="";OpenLayers.Element.removeClass(this,"olImageLoadError")};OpenLayers.IMAGE_RELOAD_ATTEMPTS=0;
OpenLayers.Util.onImageLoadError=function(){this._attempts=this._attempts?this._attempts+1:1;if(this._attempts<=OpenLayers.IMAGE_RELOAD_ATTEMPTS){var a=this.urls;if(a&&OpenLayers.Util.isArray(a)&&1<a.length){var b=this.src.toString(),c,d;for(d=0;(c=a[d])&&!(-1!=b.indexOf(c));d++);var e=Math.floor(a.length*Math.random()),e=a[e];for(d=0;e==c&&4>d++;)e=Math.floor(a.length*Math.random()),e=a[e];this.src=b.replace(c,e)}else this.src=this.src}else OpenLayers.Element.addClass(this,"olImageLoadError");this.style.display=
""};OpenLayers.Util.alphaHackNeeded=null;OpenLayers.Util.alphaHack=function(){if(null==OpenLayers.Util.alphaHackNeeded){var a=navigator.appVersion.split("MSIE"),a=parseFloat(a[1]),b=!1;try{b=!!document.body.filters}catch(c){}OpenLayers.Util.alphaHackNeeded=b&&5.5<=a&&7>a}return OpenLayers.Util.alphaHackNeeded};
OpenLayers.Util.modifyAlphaImageDiv=function(a,b,c,d,e,f,g,h,i){OpenLayers.Util.modifyDOMElement(a,b,c,d,f,null,null,i);b=a.childNodes[0];if(e)b.src=e;OpenLayers.Util.modifyDOMElement(b,a.id+"_innerImage",null,d,"relative",g);if(OpenLayers.Util.alphaHack()){if("none"!=a.style.display)a.style.display="inline-block";null==h&&(h="scale");a.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+b.src+"', sizingMethod='"+h+"')";0<=parseFloat(a.style.opacity)&&1>parseFloat(a.style.opacity)&&
(a.style.filter+=" alpha(opacity="+100*a.style.opacity+")");b.style.filter="alpha(opacity=0)"}};
OpenLayers.Util.createAlphaImageDiv=function(a,b,c,d,e,f,g,h,i){var k=OpenLayers.Util.createDiv(),q=OpenLayers.Util.createImage(null,null,null,null,null,null,null,!1);k.appendChild(q);if(i)q.style.display="none",OpenLayers.Event.observe(q,"load",OpenLayers.Function.bind(OpenLayers.Util.onImageLoad,k)),OpenLayers.Event.observe(q,"error",OpenLayers.Function.bind(OpenLayers.Util.onImageLoadError,k));OpenLayers.Util.modifyAlphaImageDiv(k,a,b,c,d,e,f,g,h);return k};
OpenLayers.Util.upperCaseObject=function(a){var b={},c;for(c in a)b[c.toUpperCase()]=a[c];return b};OpenLayers.Util.applyDefaults=function(a,b){var a=a||{},c="function"==typeof window.Event&&b instanceof window.Event,d;for(d in b)if(void 0===a[d]||!c&&b.hasOwnProperty&&b.hasOwnProperty(d)&&!a.hasOwnProperty(d))a[d]=b[d];if(!c&&b&&b.hasOwnProperty&&b.hasOwnProperty("toString")&&!a.hasOwnProperty("toString"))a.toString=b.toString;return a};
OpenLayers.Util.getParameterString=function(a){var b=[],c;for(c in a){var d=a[c];if(null!=d&&"function"!=typeof d){if("object"==typeof d&&d.constructor==Array){for(var e=[],f,g=0,h=d.length;g<h;g++)f=d[g],e.push(encodeURIComponent(null===f||void 0===f?"":f));d=e.join(",")}else d=encodeURIComponent(d);b.push(encodeURIComponent(c)+"="+d)}}return b.join("&")};OpenLayers.Util.urlAppend=function(a,b){var c=a;if(b)var d=(a+" ").split(/[?&]/),c=c+(" "===d.pop()?b:d.length?"&"+b:"?"+b);return c};
OpenLayers.ImgPath="";OpenLayers.Util.getImagesLocation=function(){return OpenLayers.ImgPath||OpenLayers._getScriptLocation()+"img/"};OpenLayers.Util.Try=function(){for(var a=null,b=0,c=arguments.length;b<c;b++){var d=arguments[b];try{a=d();break}catch(e){}}return a};OpenLayers.Util.getXmlNodeValue=function(a){var b=null;OpenLayers.Util.Try(function(){b=a.text;if(!b)b=a.textContent;if(!b)b=a.firstChild.nodeValue},function(){b=a.textContent});return b};
OpenLayers.Util.mouseLeft=function(a,b){for(var c=a.relatedTarget?a.relatedTarget:a.toElement;c!=b&&null!=c;)c=c.parentNode;return c!=b};OpenLayers.Util.DEFAULT_PRECISION=14;OpenLayers.Util.toFloat=function(a,b){if(null==b)b=OpenLayers.Util.DEFAULT_PRECISION;"number"!==typeof a&&(a=parseFloat(a));return 0===b?a:parseFloat(a.toPrecision(b))};OpenLayers.Util.rad=function(a){return a*Math.PI/180};OpenLayers.Util.deg=function(a){return 180*a/Math.PI};
OpenLayers.Util.VincentyConstants={a:6378137,b:6356752.3142,f:1/298.257223563};
OpenLayers.Util.distVincenty=function(a,b){for(var c=OpenLayers.Util.VincentyConstants,d=c.a,e=c.b,c=c.f,f=OpenLayers.Util.rad(b.lon-a.lon),g=Math.atan((1-c)*Math.tan(OpenLayers.Util.rad(a.lat))),h=Math.atan((1-c)*Math.tan(OpenLayers.Util.rad(b.lat))),i=Math.sin(g),g=Math.cos(g),k=Math.sin(h),h=Math.cos(h),q=f,s=2*Math.PI,r=20;1.0E-12<Math.abs(q-s)&&0<--r;){var m=Math.sin(q),j=Math.cos(q),p=Math.sqrt(h*m*h*m+(g*k-i*h*j)*(g*k-i*h*j));if(0==p)return 0;var j=i*k+g*h*j,l=Math.atan2(p,j),n=Math.asin(g*
h*m/p),o=Math.cos(n)*Math.cos(n),m=j-2*i*k/o,t=c/16*o*(4+c*(4-3*o)),s=q,q=f+(1-t)*c*Math.sin(n)*(l+t*p*(m+t*j*(-1+2*m*m)))}if(0==r)return NaN;d=o*(d*d-e*e)/(e*e);c=d/1024*(256+d*(-128+d*(74-47*d)));return(e*(1+d/16384*(4096+d*(-768+d*(320-175*d))))*(l-c*p*(m+c/4*(j*(-1+2*m*m)-c/6*m*(-3+4*p*p)*(-3+4*m*m))))).toFixed(3)/1E3};
OpenLayers.Util.destinationVincenty=function(a,b,c){for(var d=OpenLayers.Util,e=d.VincentyConstants,f=e.a,g=e.b,h=e.f,e=a.lon,a=a.lat,i=d.rad(b),b=Math.sin(i),i=Math.cos(i),a=(1-h)*Math.tan(d.rad(a)),k=1/Math.sqrt(1+a*a),q=a*k,s=Math.atan2(a,i),a=k*b,r=1-a*a,f=r*(f*f-g*g)/(g*g),m=1+f/16384*(4096+f*(-768+f*(320-175*f))),j=f/1024*(256+f*(-128+f*(74-47*f))),f=c/(g*m),p=2*Math.PI;1.0E-12<Math.abs(f-p);)var l=Math.cos(2*s+f),n=Math.sin(f),o=Math.cos(f),t=j*n*(l+j/4*(o*(-1+2*l*l)-j/6*l*(-3+4*n*n)*(-3+4*
l*l))),p=f,f=c/(g*m)+t;c=q*n-k*o*i;g=Math.atan2(q*o+k*n*i,(1-h)*Math.sqrt(a*a+c*c));b=Math.atan2(n*b,k*o-q*n*i);i=h/16*r*(4+h*(4-3*r));l=b-(1-i)*h*a*(f+i*n*(l+i*o*(-1+2*l*l)));Math.atan2(a,-c);return new OpenLayers.LonLat(e+d.deg(l),d.deg(g))};
OpenLayers.Util.getParameters=function(a){var a=null===a||void 0===a?window.location.href:a,b="";if(OpenLayers.String.contains(a,"?"))var b=a.indexOf("?")+1,c=OpenLayers.String.contains(a,"#")?a.indexOf("#"):a.length,b=a.substring(b,c);for(var a={},b=b.split(/[&;]/),c=0,d=b.length;c<d;++c){var e=b[c].split("=");if(e[0]){var f=e[0];try{f=decodeURIComponent(f)}catch(g){f=unescape(f)}e=(e[1]||"").replace(/\+/g," ");try{e=decodeURIComponent(e)}catch(h){e=unescape(e)}e=e.split(",");1==e.length&&(e=e[0]);
a[f]=e}}return a};OpenLayers.Util.getArgs=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Util.getParameters"}));return OpenLayers.Util.getParameters(a)};OpenLayers.Util.lastSeqID=0;OpenLayers.Util.createUniqueID=function(a){null==a&&(a="id_");OpenLayers.Util.lastSeqID+=1;return a+OpenLayers.Util.lastSeqID};OpenLayers.INCHES_PER_UNIT={inches:1,ft:12,mi:63360,m:39.3701,km:39370.1,dd:4374754,yd:36};OpenLayers.INCHES_PER_UNIT["in"]=OpenLayers.INCHES_PER_UNIT.inches;
OpenLayers.INCHES_PER_UNIT.degrees=OpenLayers.INCHES_PER_UNIT.dd;OpenLayers.INCHES_PER_UNIT.nmi=1852*OpenLayers.INCHES_PER_UNIT.m;OpenLayers.METERS_PER_INCH=0.0254000508001016;
OpenLayers.Util.extend(OpenLayers.INCHES_PER_UNIT,{Inch:OpenLayers.INCHES_PER_UNIT.inches,Meter:1/OpenLayers.METERS_PER_INCH,Foot:0.3048006096012192/OpenLayers.METERS_PER_INCH,IFoot:0.3048/OpenLayers.METERS_PER_INCH,ClarkeFoot:0.3047972651151/OpenLayers.METERS_PER_INCH,SearsFoot:0.30479947153867626/OpenLayers.METERS_PER_INCH,GoldCoastFoot:0.3047997101815088/OpenLayers.METERS_PER_INCH,IInch:0.0254/OpenLayers.METERS_PER_INCH,MicroInch:2.54E-5/OpenLayers.METERS_PER_INCH,Mil:2.54E-8/OpenLayers.METERS_PER_INCH,
Centimeter:0.01/OpenLayers.METERS_PER_INCH,Kilometer:1E3/OpenLayers.METERS_PER_INCH,Yard:0.9144018288036576/OpenLayers.METERS_PER_INCH,SearsYard:0.914398414616029/OpenLayers.METERS_PER_INCH,IndianYard:0.9143985307444408/OpenLayers.METERS_PER_INCH,IndianYd37:0.91439523/OpenLayers.METERS_PER_INCH,IndianYd62:0.9143988/OpenLayers.METERS_PER_INCH,IndianYd75:0.9143985/OpenLayers.METERS_PER_INCH,IndianFoot:0.30479951/OpenLayers.METERS_PER_INCH,IndianFt37:0.30479841/OpenLayers.METERS_PER_INCH,IndianFt62:0.3047996/
OpenLayers.METERS_PER_INCH,IndianFt75:0.3047995/OpenLayers.METERS_PER_INCH,Mile:1609.3472186944373/OpenLayers.METERS_PER_INCH,IYard:0.9144/OpenLayers.METERS_PER_INCH,IMile:1609.344/OpenLayers.METERS_PER_INCH,NautM:1852/OpenLayers.METERS_PER_INCH,"Lat-66":110943.31648893273/OpenLayers.METERS_PER_INCH,"Lat-83":110946.25736872235/OpenLayers.METERS_PER_INCH,Decimeter:0.1/OpenLayers.METERS_PER_INCH,Millimeter:0.0010/OpenLayers.METERS_PER_INCH,Dekameter:10/OpenLayers.METERS_PER_INCH,Decameter:10/OpenLayers.METERS_PER_INCH,
Hectometer:100/OpenLayers.METERS_PER_INCH,GermanMeter:1.0000135965/OpenLayers.METERS_PER_INCH,CaGrid:0.999738/OpenLayers.METERS_PER_INCH,ClarkeChain:20.1166194976/OpenLayers.METERS_PER_INCH,GunterChain:20.11684023368047/OpenLayers.METERS_PER_INCH,BenoitChain:20.116782494375872/OpenLayers.METERS_PER_INCH,SearsChain:20.11676512155/OpenLayers.METERS_PER_INCH,ClarkeLink:0.201166194976/OpenLayers.METERS_PER_INCH,GunterLink:0.2011684023368047/OpenLayers.METERS_PER_INCH,BenoitLink:0.20116782494375873/OpenLayers.METERS_PER_INCH,
SearsLink:0.2011676512155/OpenLayers.METERS_PER_INCH,Rod:5.02921005842012/OpenLayers.METERS_PER_INCH,IntnlChain:20.1168/OpenLayers.METERS_PER_INCH,IntnlLink:0.201168/OpenLayers.METERS_PER_INCH,Perch:5.02921005842012/OpenLayers.METERS_PER_INCH,Pole:5.02921005842012/OpenLayers.METERS_PER_INCH,Furlong:201.1684023368046/OpenLayers.METERS_PER_INCH,Rood:3.778266898/OpenLayers.METERS_PER_INCH,CapeFoot:0.3047972615/OpenLayers.METERS_PER_INCH,Brealey:375/OpenLayers.METERS_PER_INCH,ModAmFt:0.304812252984506/
OpenLayers.METERS_PER_INCH,Fathom:1.8288/OpenLayers.METERS_PER_INCH,"NautM-UK":1853.184/OpenLayers.METERS_PER_INCH,"50kilometers":5E4/OpenLayers.METERS_PER_INCH,"150kilometers":15E4/OpenLayers.METERS_PER_INCH});
OpenLayers.Util.extend(OpenLayers.INCHES_PER_UNIT,{mm:OpenLayers.INCHES_PER_UNIT.Meter/1E3,cm:OpenLayers.INCHES_PER_UNIT.Meter/100,dm:100*OpenLayers.INCHES_PER_UNIT.Meter,km:1E3*OpenLayers.INCHES_PER_UNIT.Meter,kmi:OpenLayers.INCHES_PER_UNIT.nmi,fath:OpenLayers.INCHES_PER_UNIT.Fathom,ch:OpenLayers.INCHES_PER_UNIT.IntnlChain,link:OpenLayers.INCHES_PER_UNIT.IntnlLink,"us-in":OpenLayers.INCHES_PER_UNIT.inches,"us-ft":OpenLayers.INCHES_PER_UNIT.Foot,"us-yd":OpenLayers.INCHES_PER_UNIT.Yard,"us-ch":OpenLayers.INCHES_PER_UNIT.GunterChain,
"us-mi":OpenLayers.INCHES_PER_UNIT.Mile,"ind-yd":OpenLayers.INCHES_PER_UNIT.IndianYd37,"ind-ft":OpenLayers.INCHES_PER_UNIT.IndianFt37,"ind-ch":20.11669506/OpenLayers.METERS_PER_INCH});OpenLayers.DOTS_PER_INCH=72;OpenLayers.Util.normalizeScale=function(a){return 1<a?1/a:a};OpenLayers.Util.getResolutionFromScale=function(a,b){var c;a&&(null==b&&(b="degrees"),c=1/(OpenLayers.Util.normalizeScale(a)*OpenLayers.INCHES_PER_UNIT[b]*OpenLayers.DOTS_PER_INCH));return c};
OpenLayers.Util.getScaleFromResolution=function(a,b){null==b&&(b="degrees");return a*OpenLayers.INCHES_PER_UNIT[b]*OpenLayers.DOTS_PER_INCH};OpenLayers.Util.safeStopPropagation=function(a){OpenLayers.Event.stop(a,!0)};
OpenLayers.Util.pagePosition=function(a){var b=[0,0],c=OpenLayers.Util.getViewportElement();if(!a||a==window||a==c)return b;var d=OpenLayers.IS_GECKO&&document.getBoxObjectFor&&"absolute"==OpenLayers.Element.getStyle(a,"position")&&(""==a.style.top||""==a.style.left),e=null;if(a.getBoundingClientRect)a=a.getBoundingClientRect(),e=c.scrollTop,b[0]=a.left+c.scrollLeft,b[1]=a.top+e;else if(document.getBoxObjectFor&&!d)a=document.getBoxObjectFor(a),c=document.getBoxObjectFor(c),b[0]=a.screenX-c.screenX,
b[1]=a.screenY-c.screenY;else{b[0]=a.offsetLeft;b[1]=a.offsetTop;e=a.offsetParent;if(e!=a)for(;e;)b[0]+=e.offsetLeft,b[1]+=e.offsetTop,e=e.offsetParent;c=OpenLayers.BROWSER_NAME;if("opera"==c||"safari"==c&&"absolute"==OpenLayers.Element.getStyle(a,"position"))b[1]-=document.body.offsetTop;for(e=a.offsetParent;e&&e!=document.body;){b[0]-=e.scrollLeft;if("opera"!=c||"TR"!=e.tagName)b[1]-=e.scrollTop;e=e.offsetParent}}return b};
OpenLayers.Util.getViewportElement=function(){var a=arguments.callee.viewportElement;if(void 0==a)a="msie"==OpenLayers.BROWSER_NAME&&"CSS1Compat"!=document.compatMode?document.body:document.documentElement,arguments.callee.viewportElement=a;return a};
OpenLayers.Util.isEquivalentUrl=function(a,b,c){c=c||{};OpenLayers.Util.applyDefaults(c,{ignoreCase:!0,ignorePort80:!0,ignoreHash:!0});var a=OpenLayers.Util.createUrlObject(a,c),b=OpenLayers.Util.createUrlObject(b,c),d;for(d in a)if("args"!==d&&a[d]!=b[d])return!1;for(d in a.args){if(a.args[d]!=b.args[d])return!1;delete b.args[d]}for(d in b.args)return!1;return!0};
OpenLayers.Util.createUrlObject=function(a,b){b=b||{};if(!/^\w+:\/\//.test(a)){var c=window.location,d=c.port?":"+c.port:"",d=c.protocol+"//"+c.host.split(":").shift()+d;0===a.indexOf("/")?a=d+a:(c=c.pathname.split("/"),c.pop(),a=d+c.join("/")+"/"+a)}b.ignoreCase&&(a=a.toLowerCase());c=document.createElement("a");c.href=a;d={};d.host=c.host.split(":").shift();d.protocol=c.protocol;d.port=b.ignorePort80?"80"==c.port||"0"==c.port?"":c.port:""==c.port||"0"==c.port?"80":c.port;d.hash=b.ignoreHash||"#"===
c.hash?"":c.hash;var e=c.search;e||(e=a.indexOf("?"),e=-1!=e?a.substr(e):"");d.args=OpenLayers.Util.getParameters(e);d.pathname="/"==c.pathname.charAt(0)?c.pathname:"/"+c.pathname;return d};OpenLayers.Util.removeTail=function(a){var b=null,b=a.indexOf("?"),c=a.indexOf("#");return b=-1==b?-1!=c?a.substr(0,c):a:-1!=c?a.substr(0,Math.min(b,c)):a.substr(0,b)};OpenLayers.IS_GECKO=function(){var a=navigator.userAgent.toLowerCase();return-1==a.indexOf("webkit")&&-1!=a.indexOf("gecko")}();
OpenLayers.BROWSER_NAME=function(){var a="",b=navigator.userAgent.toLowerCase();-1!=b.indexOf("opera")?a="opera":-1!=b.indexOf("msie")?a="msie":-1!=b.indexOf("safari")?a="safari":-1!=b.indexOf("mozilla")&&(a=-1!=b.indexOf("firefox")?"firefox":"mozilla");return a}();OpenLayers.Util.getBrowserName=function(){return OpenLayers.BROWSER_NAME};
OpenLayers.Util.getRenderedDimensions=function(a,b,c){var d,e,f=document.createElement("div");f.style.visibility="hidden";var g=c&&c.containerElement?c.containerElement:document.body;if(b)if(b.w)d=b.w,f.style.width=d+"px";else if(b.h)e=b.h,f.style.height=e+"px";if(c&&c.displayClass)f.className=c.displayClass;b=document.createElement("div");b.innerHTML=a;b.style.overflow="visible";if(b.childNodes){a=0;for(c=b.childNodes.length;a<c;a++)if(b.childNodes[a].style)b.childNodes[a].style.overflow="visible"}f.appendChild(b);
g.appendChild(f);a=!1;for(c=f.parentNode;c&&"body"!=c.tagName.toLowerCase();){var h=OpenLayers.Element.getStyle(c,"position");if("absolute"==h){a=!0;break}else if(h&&"static"!=h)break;c=c.parentNode}if(!a)f.style.position="absolute";if(!d)d=parseInt(b.scrollWidth),f.style.width=d+"px";e||(e=parseInt(b.scrollHeight));f.removeChild(b);g.removeChild(f);return new OpenLayers.Size(d,e)};
OpenLayers.Util.getScrollbarWidth=function(){var a=OpenLayers.Util._scrollbarWidth;if(null==a){var b=null,c=null,b=a=0,b=document.createElement("div");b.style.position="absolute";b.style.top="-1000px";b.style.left="-1000px";b.style.width="100px";b.style.height="50px";b.style.overflow="hidden";c=document.createElement("div");c.style.width="100%";c.style.height="200px";b.appendChild(c);document.body.appendChild(b);a=c.offsetWidth;b.style.overflow="scroll";b=c.offsetWidth;document.body.removeChild(document.body.lastChild);
OpenLayers.Util._scrollbarWidth=a-b;a=OpenLayers.Util._scrollbarWidth}return a};
OpenLayers.Util.getFormattedLonLat=function(a,b,c){c||(c="dms");var a=(a+540)%360-180,d=Math.abs(a),e=Math.floor(d),f=d=(d-e)/(1/60),d=Math.floor(d),f=Math.round(10*((f-d)/(1/60))),f=f/10;60<=f&&(f-=60,d+=1,60<=d&&(d-=60,e+=1));10>e&&(e="0"+e);e+="\u00b0";0<=c.indexOf("dm")&&(10>d&&(d="0"+d),e+=d+"'",0<=c.indexOf("dms")&&(10>f&&(f="0"+f),e+=f+'"'));return e="lon"==b?e+(0>a?OpenLayers.i18n("W"):OpenLayers.i18n("E")):e+(0>a?OpenLayers.i18n("S"):OpenLayers.i18n("N"))};
OpenLayers.Rico=OpenLayers.Rico||{};
OpenLayers.Rico.Corner={round:function(a,b){a=OpenLayers.Util.getElement(a);this._setOptions(b);var c=this.options.color;"fromElement"==this.options.color&&(c=this._background(a));var d=this.options.bgColor;"fromParent"==this.options.bgColor&&(d=this._background(a.offsetParent));this._roundCornersImpl(a,c,d)},changeColor:function(a,b){a.style.backgroundColor=b;for(var c=a.parentNode.getElementsByTagName("span"),d=0;d<c.length;d++)c[d].style.backgroundColor=b},changeOpacity:function(a,b){var c="alpha(opacity="+
100*b+")";a.style.opacity=b;a.style.filter=c;for(var d=a.parentNode.getElementsByTagName("span"),e=0;e<d.length;e++)d[e].style.opacity=b,d[e].style.filter=c},reRound:function(a,b){var c=a.parentNode.childNodes[2];a.parentNode.removeChild(a.parentNode.childNodes[0]);a.parentNode.removeChild(c);this.round(a.parentNode,b)},_roundCornersImpl:function(a,b,c){this.options.border&&this._renderBorder(a,c);this._isTopRounded()&&this._roundTopCorners(a,b,c);this._isBottomRounded()&&this._roundBottomCorners(a,
b,c)},_renderBorder:function(a,b){var c="1px solid "+this._borderColor(b);a.innerHTML="<div "+("style='border-left: "+c+";"+("border-right: "+c)+"'")+">"+a.innerHTML+"</div>"},_roundTopCorners:function(a,b,c){for(var d=this._createCorner(c),e=0;e<this.options.numSlices;e++)d.appendChild(this._createCornerSlice(b,c,e,"top"));a.style.paddingTop=0;a.insertBefore(d,a.firstChild)},_roundBottomCorners:function(a,b,c){for(var d=this._createCorner(c),e=this.options.numSlices-1;0<=e;e--)d.appendChild(this._createCornerSlice(b,
c,e,"bottom"));a.style.paddingBottom=0;a.appendChild(d)},_createCorner:function(a){var b=document.createElement("div");b.style.backgroundColor=this._isTransparent()?"transparent":a;return b},_createCornerSlice:function(a,b,c,d){var e=document.createElement("span"),f=e.style;f.backgroundColor=a;f.display="block";f.height="1px";f.overflow="hidden";f.fontSize="1px";a=this._borderColor(a,b);if(this.options.border&&0==c)f.borderTopStyle="solid",f.borderTopWidth="1px",f.borderLeftWidth="0px",f.borderRightWidth=
"0px",f.borderBottomWidth="0px",f.height="0px",f.borderColor=a;else if(a)f.borderColor=a,f.borderStyle="solid",f.borderWidth="0px 1px";if(!this.options.compact&&c==this.options.numSlices-1)f.height="2px";this._setMargin(e,c,d);this._setBorder(e,c,d);return e},_setOptions:function(a){this.options={corners:"all",color:"fromElement",bgColor:"fromParent",blend:!0,border:!1,compact:!1};OpenLayers.Util.extend(this.options,a||{});this.options.numSlices=this.options.compact?2:4;if(this._isTransparent())this.options.blend=
!1},_whichSideTop:function(){return this._hasString(this.options.corners,"all","top")||0<=this.options.corners.indexOf("tl")&&0<=this.options.corners.indexOf("tr")?"":0<=this.options.corners.indexOf("tl")?"left":0<=this.options.corners.indexOf("tr")?"right":""},_whichSideBottom:function(){return this._hasString(this.options.corners,"all","bottom")||0<=this.options.corners.indexOf("bl")&&0<=this.options.corners.indexOf("br")?"":0<=this.options.corners.indexOf("bl")?"left":0<=this.options.corners.indexOf("br")?
"right":""},_borderColor:function(a,b){return"transparent"==a?b:this.options.border?this.options.border:this.options.blend?this._blend(b,a):""},_setMargin:function(a,b,c){b=this._marginSize(b);c="top"==c?this._whichSideTop():this._whichSideBottom();"left"==c?(a.style.marginLeft=b+"px",a.style.marginRight="0px"):"right"==c?(a.style.marginRight=b+"px",a.style.marginLeft="0px"):(a.style.marginLeft=b+"px",a.style.marginRight=b+"px")},_setBorder:function(a,b,c){b=this._borderSize(b);c="top"==c?this._whichSideTop():
this._whichSideBottom();"left"==c?(a.style.borderLeftWidth=b+"px",a.style.borderRightWidth="0px"):"right"==c?(a.style.borderRightWidth=b+"px",a.style.borderLeftWidth="0px"):(a.style.borderLeftWidth=b+"px",a.style.borderRightWidth=b+"px");if(!1!=this.options.border)a.style.borderLeftWidth=b+"px",a.style.borderRightWidth=b+"px"},_marginSize:function(a){if(this._isTransparent())return 0;var b=[5,3,2,1],c=[3,2,1,0],d=[2,1],e=[1,0];return this.options.compact&&this.options.blend?e[a]:this.options.compact?
d[a]:this.options.blend?c[a]:b[a]},_borderSize:function(a){var b=[5,3,2,1],c=[2,1,1,1],d=[1,0],e=[0,2,0,0];return this.options.compact&&(this.options.blend||this._isTransparent())?1:this.options.compact?d[a]:this.options.blend?c[a]:this.options.border?e[a]:this._isTransparent()?b[a]:0},_hasString:function(a){for(var b=1;b<arguments.length;b++)if(0<=a.indexOf(arguments[b]))return!0;return!1},_blend:function(a,b){var c=OpenLayers.Rico.Color.createFromHex(a);c.blend(OpenLayers.Rico.Color.createFromHex(b));
return c},_background:function(a){try{return OpenLayers.Rico.Color.createColorFromBackground(a).asHex()}catch(b){return"#ffffff"}},_isTransparent:function(){return"transparent"==this.options.color},_isTopRounded:function(){return this._hasString(this.options.corners,"all","top","tl","tr")},_isBottomRounded:function(){return this._hasString(this.options.corners,"all","bottom","bl","br")},_hasSingleTextChild:function(a){return 1==a.childNodes.length&&3==a.childNodes[0].nodeType}};
OpenLayers.Console={log:function(){},debug:function(){},info:function(){},warn:function(){},error:function(){},userError:function(a){alert(a)},assert:function(){},dir:function(){},dirxml:function(){},trace:function(){},group:function(){},groupEnd:function(){},time:function(){},timeEnd:function(){},profile:function(){},profileEnd:function(){},count:function(){},CLASS_NAME:"OpenLayers.Console"};
(function(){for(var a=document.getElementsByTagName("script"),b=0,c=a.length;b<c;++b)if(-1!=a[b].src.indexOf("firebug.js")&&console){OpenLayers.Util.extend(OpenLayers.Console,console);break}})();
OpenLayers.Tween=OpenLayers.Class({INTERVAL:10,easing:null,begin:null,finish:null,duration:null,callbacks:null,time:null,interval:null,playing:!1,initialize:function(a){this.easing=a?a:OpenLayers.Easing.Expo.easeOut},start:function(a,b,c,d){this.playing=!0;this.begin=a;this.finish=b;this.duration=c;this.callbacks=d.callbacks;this.time=0;if(this.interval)window.clearInterval(this.interval),this.interval=null;this.callbacks&&this.callbacks.start&&this.callbacks.start.call(this,this.begin);this.interval=
window.setInterval(OpenLayers.Function.bind(this.play,this),this.INTERVAL)},stop:function(){if(this.playing)this.callbacks&&this.callbacks.done&&this.callbacks.done.call(this,this.finish),window.clearInterval(this.interval),this.interval=null,this.playing=!1},play:function(){var a={},b;for(b in this.begin){var c=this.begin[b],d=this.finish[b];(null==c||null==d||isNaN(c)||isNaN(d))&&OpenLayers.Console.error("invalid value for Tween");a[b]=this.easing.apply(this,[this.time,c,d-c,this.duration])}this.time++;
this.callbacks&&this.callbacks.eachStep&&this.callbacks.eachStep.call(this,a);this.time>this.duration&&this.stop()},CLASS_NAME:"OpenLayers.Tween"});OpenLayers.Easing={CLASS_NAME:"OpenLayers.Easing"};OpenLayers.Easing.Linear={easeIn:function(a,b,c,d){return c*a/d+b},easeOut:function(a,b,c,d){return c*a/d+b},easeInOut:function(a,b,c,d){return c*a/d+b},CLASS_NAME:"OpenLayers.Easing.Linear"};
OpenLayers.Easing.Expo={easeIn:function(a,b,c,d){return 0==a?b:c*Math.pow(2,10*(a/d-1))+b},easeOut:function(a,b,c,d){return a==d?b+c:c*(-Math.pow(2,-10*a/d)+1)+b},easeInOut:function(a,b,c,d){return 0==a?b:a==d?b+c:1>(a/=d/2)?c/2*Math.pow(2,10*(a-1))+b:c/2*(-Math.pow(2,-10*--a)+2)+b},CLASS_NAME:"OpenLayers.Easing.Expo"};
OpenLayers.Easing.Quad={easeIn:function(a,b,c,d){return c*(a/=d)*a+b},easeOut:function(a,b,c,d){return-c*(a/=d)*(a-2)+b},easeInOut:function(a,b,c,d){return 1>(a/=d/2)?c/2*a*a+b:-c/2*(--a*(a-2)-1)+b},CLASS_NAME:"OpenLayers.Easing.Quad"};
OpenLayers.Lang={code:null,defaultCode:"en",getCode:function(){OpenLayers.Lang.code||OpenLayers.Lang.setCode();return OpenLayers.Lang.code},setCode:function(a){var b;a||(a="msie"==OpenLayers.BROWSER_NAME?navigator.userLanguage:navigator.language);a=a.split("-");a[0]=a[0].toLowerCase();"object"==typeof OpenLayers.Lang[a[0]]&&(b=a[0]);if(a[1]){var c=a[0]+"-"+a[1].toUpperCase();"object"==typeof OpenLayers.Lang[c]&&(b=c)}if(!b)OpenLayers.Console.warn("Failed to find OpenLayers.Lang."+a.join("-")+" dictionary, falling back to default language"),
b=OpenLayers.Lang.defaultCode;OpenLayers.Lang.code=b},translate:function(a,b){var c=OpenLayers.Lang[OpenLayers.Lang.getCode()];(c=c&&c[a])||(c=a);b&&(c=OpenLayers.String.format(c,b));return c}};OpenLayers.i18n=OpenLayers.Lang.translate;
OpenLayers.Bounds=OpenLayers.Class({left:null,bottom:null,right:null,top:null,centerLonLat:null,initialize:function(a,b,c,d){if(null!=a)this.left=OpenLayers.Util.toFloat(a);if(null!=b)this.bottom=OpenLayers.Util.toFloat(b);if(null!=c)this.right=OpenLayers.Util.toFloat(c);if(null!=d)this.top=OpenLayers.Util.toFloat(d)},clone:function(){return new OpenLayers.Bounds(this.left,this.bottom,this.right,this.top)},equals:function(a){var b=!1;null!=a&&(b=this.left==a.left&&this.right==a.right&&this.top==a.top&&
this.bottom==a.bottom);return b},toString:function(){return[this.left,this.bottom,this.right,this.top].join()},toArray:function(a){return!0===a?[this.bottom,this.left,this.top,this.right]:[this.left,this.bottom,this.right,this.top]},toBBOX:function(a,b){null==a&&(a=6);var c=Math.pow(10,a),d=Math.round(this.left*c)/c,e=Math.round(this.bottom*c)/c,f=Math.round(this.right*c)/c,c=Math.round(this.top*c)/c;return!0===b?e+","+d+","+c+","+f:d+","+e+","+f+","+c},toGeometry:function(){return new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing([new OpenLayers.Geometry.Point(this.left,
this.bottom),new OpenLayers.Geometry.Point(this.right,this.bottom),new OpenLayers.Geometry.Point(this.right,this.top),new OpenLayers.Geometry.Point(this.left,this.top)])])},getWidth:function(){return this.right-this.left},getHeight:function(){return this.top-this.bottom},getSize:function(){return new OpenLayers.Size(this.getWidth(),this.getHeight())},getCenterPixel:function(){return new OpenLayers.Pixel((this.left+this.right)/2,(this.bottom+this.top)/2)},getCenterLonLat:function(){if(!this.centerLonLat)this.centerLonLat=
new OpenLayers.LonLat((this.left+this.right)/2,(this.bottom+this.top)/2);return this.centerLonLat},scale:function(a,b){null==b&&(b=this.getCenterLonLat());var c,d;"OpenLayers.LonLat"==b.CLASS_NAME?(c=b.lon,d=b.lat):(c=b.x,d=b.y);return new OpenLayers.Bounds((this.left-c)*a+c,(this.bottom-d)*a+d,(this.right-c)*a+c,(this.top-d)*a+d)},add:function(a,b){if(null==a||null==b){var c=OpenLayers.i18n("boundsAddError");OpenLayers.Console.error(c);return null}return new OpenLayers.Bounds(this.left+a,this.bottom+
b,this.right+a,this.top+b)},extend:function(a){var b=null;if(a){switch(a.CLASS_NAME){case "OpenLayers.LonLat":b=new OpenLayers.Bounds(a.lon,a.lat,a.lon,a.lat);break;case "OpenLayers.Geometry.Point":b=new OpenLayers.Bounds(a.x,a.y,a.x,a.y);break;case "OpenLayers.Bounds":b=a}if(b){this.centerLonLat=null;if(null==this.left||b.left<this.left)this.left=b.left;if(null==this.bottom||b.bottom<this.bottom)this.bottom=b.bottom;if(null==this.right||b.right>this.right)this.right=b.right;if(null==this.top||b.top>
this.top)this.top=b.top}}},containsLonLat:function(a,b){return this.contains(a.lon,a.lat,b)},containsPixel:function(a,b){return this.contains(a.x,a.y,b)},contains:function(a,b,c){null==c&&(c=!0);if(null==a||null==b)return!1;var a=OpenLayers.Util.toFloat(a),b=OpenLayers.Util.toFloat(b),d=!1;return d=c?a>=this.left&&a<=this.right&&b>=this.bottom&&b<=this.top:a>this.left&&a<this.right&&b>this.bottom&&b<this.top},intersectsBounds:function(a,b){null==b&&(b=!0);var c=!1,d=this.left==a.right||this.right==
a.left||this.top==a.bottom||this.bottom==a.top;if(b||!d)var c=a.top>=this.bottom&&a.top<=this.top||this.top>a.bottom&&this.top<a.top,d=a.left>=this.left&&a.left<=this.right||this.left>=a.left&&this.left<=a.right,e=a.right>=this.left&&a.right<=this.right||this.right>=a.left&&this.right<=a.right,c=(a.bottom>=this.bottom&&a.bottom<=this.top||this.bottom>=a.bottom&&this.bottom<=a.top||c)&&(d||e);return c},containsBounds:function(a,b,c){null==b&&(b=!1);null==c&&(c=!0);var d=this.contains(a.left,a.bottom,
c),e=this.contains(a.right,a.bottom,c),f=this.contains(a.left,a.top,c),a=this.contains(a.right,a.top,c);return b?d||e||f||a:d&&e&&f&&a},determineQuadrant:function(a){var b="",c=this.getCenterLonLat(),b=b+(a.lat<c.lat?"b":"t");return b+=a.lon<c.lon?"l":"r"},transform:function(a,b){this.centerLonLat=null;var c=OpenLayers.Projection.transform({x:this.left,y:this.bottom},a,b),d=OpenLayers.Projection.transform({x:this.right,y:this.bottom},a,b),e=OpenLayers.Projection.transform({x:this.left,y:this.top},
a,b),f=OpenLayers.Projection.transform({x:this.right,y:this.top},a,b);this.left=Math.min(c.x,e.x);this.bottom=Math.min(c.y,d.y);this.right=Math.max(d.x,f.x);this.top=Math.max(e.y,f.y);return this},wrapDateLine:function(a,b){var b=b||{},c=b.leftTolerance||0,d=b.rightTolerance||0,e=this.clone();if(a){for(;e.left<a.left&&e.right-d<=a.left;)e=e.add(a.getWidth(),0);for(;e.left+c>=a.right&&e.right>a.right;)e=e.add(-a.getWidth(),0)}return e},CLASS_NAME:"OpenLayers.Bounds"});
OpenLayers.Bounds.fromString=function(a,b){var c=a.split(",");return OpenLayers.Bounds.fromArray(c,b)};OpenLayers.Bounds.fromArray=function(a,b){return!0===b?new OpenLayers.Bounds(parseFloat(a[1]),parseFloat(a[0]),parseFloat(a[3]),parseFloat(a[2])):new OpenLayers.Bounds(parseFloat(a[0]),parseFloat(a[1]),parseFloat(a[2]),parseFloat(a[3]))};OpenLayers.Bounds.fromSize=function(a){return new OpenLayers.Bounds(0,a.h,a.w,0)};
OpenLayers.Bounds.oppositeQuadrant=function(a){var b;b=""+("t"==a.charAt(0)?"b":"t");return b+="l"==a.charAt(1)?"r":"l"};
OpenLayers.Element={visible:function(a){return"none"!=OpenLayers.Util.getElement(a).style.display},toggle:function(){for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]),d=OpenLayers.Element.visible(c)?"hide":"show";OpenLayers.Element[d](c)}},hide:function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"element.style.display = 'none';"}));for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]);if(c)c.style.display=
"none"}},show:function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"element.style.display = '';"}));for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]);if(c)c.style.display=""}},remove:function(a){a=OpenLayers.Util.getElement(a);a.parentNode.removeChild(a)},getHeight:function(a){a=OpenLayers.Util.getElement(a);return a.offsetHeight},getDimensions:function(a){a=OpenLayers.Util.getElement(a);if("none"!=OpenLayers.Element.getStyle(a,"display"))return{width:a.offsetWidth,
height:a.offsetHeight};var b=a.style,c=b.visibility,d=b.position,e=b.display;b.visibility="hidden";b.position="absolute";b.display="";var f=a.clientWidth,a=a.clientHeight;b.display=e;b.position=d;b.visibility=c;return{width:f,height:a}},hasClass:function(a,b){var c=a.className;return!!c&&RegExp("(^|\\s)"+b+"(\\s|$)").test(c)},addClass:function(a,b){OpenLayers.Element.hasClass(a,b)||(a.className+=(a.className?" ":"")+b);return a},removeClass:function(a,b){var c=a.className;if(c)a.className=OpenLayers.String.trim(c.replace(RegExp("(^|\\s+)"+
b+"(\\s+|$)")," "));return a},toggleClass:function(a,b){OpenLayers.Element.hasClass(a,b)?OpenLayers.Element.removeClass(a,b):OpenLayers.Element.addClass(a,b);return a},getStyle:function(a,b){var a=OpenLayers.Util.getElement(a),c=null;if(a&&a.style){c=a.style[OpenLayers.String.camelize(b)];c||(document.defaultView&&document.defaultView.getComputedStyle?c=(c=document.defaultView.getComputedStyle(a,null))?c.getPropertyValue(b):null:a.currentStyle&&(c=a.currentStyle[OpenLayers.String.camelize(b)]));var d=
["left","top","right","bottom"];window.opera&&-1!=OpenLayers.Util.indexOf(d,b)&&"static"==OpenLayers.Element.getStyle(a,"position")&&(c="auto")}return"auto"==c?null:c}};
OpenLayers.LonLat=OpenLayers.Class({lon:0,lat:0,initialize:function(a,b){this.lon=OpenLayers.Util.toFloat(a);this.lat=OpenLayers.Util.toFloat(b)},toString:function(){return"lon="+this.lon+",lat="+this.lat},toShortString:function(){return this.lon+", "+this.lat},clone:function(){return new OpenLayers.LonLat(this.lon,this.lat)},add:function(a,b){if(null==a||null==b){var c=OpenLayers.i18n("lonlatAddError");OpenLayers.Console.error(c);return null}return new OpenLayers.LonLat(this.lon+OpenLayers.Util.toFloat(a),
this.lat+OpenLayers.Util.toFloat(b))},equals:function(a){var b=!1;null!=a&&(b=this.lon==a.lon&&this.lat==a.lat||isNaN(this.lon)&&isNaN(this.lat)&&isNaN(a.lon)&&isNaN(a.lat));return b},transform:function(a,b){var c=OpenLayers.Projection.transform({x:this.lon,y:this.lat},a,b);this.lon=c.x;this.lat=c.y;return this},wrapDateLine:function(a){var b=this.clone();if(a){for(;b.lon<a.left;)b.lon+=a.getWidth();for(;b.lon>a.right;)b.lon-=a.getWidth()}return b},CLASS_NAME:"OpenLayers.LonLat"});
OpenLayers.LonLat.fromString=function(a){a=a.split(",");return new OpenLayers.LonLat(a[0],a[1])};OpenLayers.LonLat.fromArray=function(a){var b=OpenLayers.Util.isArray(a);return new OpenLayers.LonLat(b&&a[0],b&&a[1])};
OpenLayers.Pixel=OpenLayers.Class({x:0,y:0,initialize:function(a,b){this.x=parseFloat(a);this.y=parseFloat(b)},toString:function(){return"x="+this.x+",y="+this.y},clone:function(){return new OpenLayers.Pixel(this.x,this.y)},equals:function(a){var b=!1;null!=a&&(b=this.x==a.x&&this.y==a.y||isNaN(this.x)&&isNaN(this.y)&&isNaN(a.x)&&isNaN(a.y));return b},distanceTo:function(a){return Math.sqrt(Math.pow(this.x-a.x,2)+Math.pow(this.y-a.y,2))},add:function(a,b){if(null==a||null==b){var c=OpenLayers.i18n("pixelAddError");
OpenLayers.Console.error(c);return null}return new OpenLayers.Pixel(this.x+a,this.y+b)},offset:function(a){var b=this.clone();a&&(b=this.add(a.x,a.y));return b},CLASS_NAME:"OpenLayers.Pixel"});
OpenLayers.Size=OpenLayers.Class({w:0,h:0,initialize:function(a,b){this.w=parseFloat(a);this.h=parseFloat(b)},toString:function(){return"w="+this.w+",h="+this.h},clone:function(){return new OpenLayers.Size(this.w,this.h)},equals:function(a){var b=!1;null!=a&&(b=this.w==a.w&&this.h==a.h||isNaN(this.w)&&isNaN(this.h)&&isNaN(a.w)&&isNaN(a.h));return b},CLASS_NAME:"OpenLayers.Size"});
OpenLayers.Event={observers:!1,KEY_BACKSPACE:8,KEY_TAB:9,KEY_RETURN:13,KEY_ESC:27,KEY_LEFT:37,KEY_UP:38,KEY_RIGHT:39,KEY_DOWN:40,KEY_DELETE:46,element:function(a){return a.target||a.srcElement},isSingleTouch:function(a){return a.touches&&1==a.touches.length},isMultiTouch:function(a){return a.touches&&1<a.touches.length},isLeftClick:function(a){return a.which&&1==a.which||a.button&&1==a.button},isRightClick:function(a){return a.which&&3==a.which||a.button&&2==a.button},stop:function(a,b){if(!b)a.preventDefault?
a.preventDefault():a.returnValue=!1;a.stopPropagation?a.stopPropagation():a.cancelBubble=!0},findElement:function(a,b){for(var c=OpenLayers.Event.element(a);c.parentNode&&(!c.tagName||c.tagName.toUpperCase()!=b.toUpperCase());)c=c.parentNode;return c},observe:function(a,b,c,d){a=OpenLayers.Util.getElement(a);d=d||!1;if("keypress"==b&&(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||a.attachEvent))b="keydown";if(!this.observers)this.observers={};if(!a._eventCacheID){var e="eventCacheID_";a.id&&
(e=a.id+"_"+e);a._eventCacheID=OpenLayers.Util.createUniqueID(e)}e=a._eventCacheID;this.observers[e]||(this.observers[e]=[]);this.observers[e].push({element:a,name:b,observer:c,useCapture:d});a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent("on"+b,c)},stopObservingElement:function(a){a=OpenLayers.Util.getElement(a)._eventCacheID;this._removeElementObservers(OpenLayers.Event.observers[a])},_removeElementObservers:function(a){if(a)for(var b=a.length-1;0<=b;b--){var c=a[b];OpenLayers.Event.stopObserving.apply(this,
[c.element,c.name,c.observer,c.useCapture])}},stopObserving:function(a,b,c,d){var d=d||!1,a=OpenLayers.Util.getElement(a),e=a._eventCacheID;if("keypress"==b&&(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||a.detachEvent))b="keydown";var f=!1,g=OpenLayers.Event.observers[e];if(g)for(var h=0;!f&&h<g.length;){var i=g[h];if(i.name==b&&i.observer==c&&i.useCapture==d){g.splice(h,1);0==g.length&&delete OpenLayers.Event.observers[e];f=!0;break}h++}f&&(a.removeEventListener?a.removeEventListener(b,
c,d):a&&a.detachEvent&&a.detachEvent("on"+b,c));return f},unloadCache:function(){if(OpenLayers.Event&&OpenLayers.Event.observers){for(var a in OpenLayers.Event.observers)OpenLayers.Event._removeElementObservers.apply(this,[OpenLayers.Event.observers[a]]);OpenLayers.Event.observers=!1}},CLASS_NAME:"OpenLayers.Event"};OpenLayers.Event.observe(window,"unload",OpenLayers.Event.unloadCache,!1);if(window.Event)OpenLayers.Util.applyDefaults(window.Event,OpenLayers.Event);else var Event=OpenLayers.Event;
OpenLayers.Events=OpenLayers.Class({BROWSER_EVENTS:"mouseover,mouseout,mousedown,mouseup,mousemove,click,dblclick,rightclick,dblrightclick,resize,focus,blur,touchstart,touchmove,touchend".split(","),listeners:null,object:null,element:null,eventTypes:null,eventHandler:null,fallThrough:null,includeXY:!1,clearMouseListener:null,initialize:function(a,b,c,d,e){OpenLayers.Util.extend(this,e);this.object=a;this.fallThrough=d;this.listeners={};this.eventHandler=OpenLayers.Function.bindAsEventListener(this.handleBrowserEvent,
this);this.clearMouseListener=OpenLayers.Function.bind(this.clearMouseCache,this);this.eventTypes=[];if(null!=c){a=0;for(d=c.length;a<d;a++)this.addEventType(c[a])}null!=b&&this.attachToElement(b)},destroy:function(){this.element&&(OpenLayers.Event.stopObservingElement(this.element),this.element.hasScrollEvent&&OpenLayers.Event.stopObserving(window,"scroll",this.clearMouseListener));this.eventHandler=this.fallThrough=this.eventTypes=this.object=this.listeners=this.element=null},addEventType:function(a){this.listeners[a]||
(this.eventTypes.push(a),this.listeners[a]=[])},attachToElement:function(a){this.element&&OpenLayers.Event.stopObservingElement(this.element);this.element=a;for(var b=0,c=this.BROWSER_EVENTS.length;b<c;b++){var d=this.BROWSER_EVENTS[b];this.addEventType(d);OpenLayers.Event.observe(a,d,this.eventHandler)}OpenLayers.Event.observe(a,"dragstart",OpenLayers.Event.stop)},on:function(a){for(var b in a)"scope"!=b&&this.register(b,a.scope,a[b])},register:function(a,b,c){if(null!=c&&-1!=OpenLayers.Util.indexOf(this.eventTypes,
a)){if(null==b)b=this.object;this.listeners[a].push({obj:b,func:c})}},registerPriority:function(a,b,c){if(null!=c){if(null==b)b=this.object;a=this.listeners[a];null!=a&&a.unshift({obj:b,func:c})}},un:function(a){for(var b in a)"scope"!=b&&this.unregister(b,a.scope,a[b])},unregister:function(a,b,c){if(null==b)b=this.object;a=this.listeners[a];if(null!=a)for(var d=0,e=a.length;d<e;d++)if(a[d].obj==b&&a[d].func==c){a.splice(d,1);break}},remove:function(a){null!=this.listeners[a]&&(this.listeners[a]=
[])},triggerEvent:function(a,b){var c=this.listeners[a];if(c&&0!=c.length){null==b&&(b={});b.object=this.object;b.element=this.element;if(!b.type)b.type=a;for(var c=c.slice(),d,e=0,f=c.length;e<f&&!(d=c[e],d=d.func.apply(d.obj,[b]),void 0!=d&&!1==d);e++);this.fallThrough||OpenLayers.Event.stop(b,!0);return d}},handleBrowserEvent:function(a){var b=a.type,c=this.listeners[b];if(c&&0!=c.length){if((c=a.touches)&&c[0]){for(var d=0,e=0,f=c.length,g,h=0;h<f;++h)g=c[h],d+=g.clientX,e+=g.clientY;a.clientX=
d/f;a.clientY=e/f}if(this.includeXY)a.xy=this.getMousePosition(a);this.triggerEvent(b,a)}},clearMouseCache:function(){this.element.scrolls=null;this.element.lefttop=null;var a=document.body;if(a&&(!(0!=a.scrollTop||0!=a.scrollLeft)||!navigator.userAgent.match(/iPhone/i)))this.element.offsets=null},getMousePosition:function(a){if(this.includeXY){if(!this.element.hasScrollEvent)OpenLayers.Event.observe(window,"scroll",this.clearMouseListener),this.element.hasScrollEvent=!0}else this.clearMouseCache();
if(!this.element.scrolls){var b=OpenLayers.Util.getViewportElement();this.element.scrolls=[b.scrollLeft,b.scrollTop]}if(!this.element.lefttop)this.element.lefttop=[document.documentElement.clientLeft||0,document.documentElement.clientTop||0];if(!this.element.offsets)this.element.offsets=OpenLayers.Util.pagePosition(this.element);return new OpenLayers.Pixel(a.clientX+this.element.scrolls[0]-this.element.offsets[0]-this.element.lefttop[0],a.clientY+this.element.scrolls[1]-this.element.offsets[1]-this.element.lefttop[1])},
CLASS_NAME:"OpenLayers.Events"});
OpenLayers.Map=OpenLayers.Class({Z_INDEX_BASE:{BaseLayer:100,Overlay:325,Feature:725,Popup:750,Control:1E3},EVENT_TYPES:"preaddlayer,addlayer,preremovelayer,removelayer,changelayer,movestart,move,moveend,zoomend,popupopen,popupclose,addmarker,removemarker,clearmarkers,mouseover,mouseout,mousemove,dragstart,drag,dragend,changebaselayer".split(","),id:null,fractionalZoom:!1,events:null,allOverlays:!1,div:null,dragging:!1,size:null,viewPortDiv:null,layerContainerOrigin:null,layerContainerDiv:null,layers:null,
controls:null,popups:null,baseLayer:null,center:null,resolution:null,zoom:0,panRatio:1.5,viewRequestID:0,tileSize:null,projection:"EPSG:4326",units:"degrees",resolutions:null,maxResolution:1.40625,minResolution:null,maxScale:null,minScale:null,maxExtent:null,minExtent:null,restrictedExtent:null,numZoomLevels:16,theme:null,displayProjection:null,fallThrough:!0,panTween:null,eventListeners:null,panMethod:OpenLayers.Easing.Expo.easeOut,panDuration:50,paddingForPopups:null,minPx:null,maxPx:null,initialize:function(a,
b){1===arguments.length&&"object"===typeof a&&(a=(b=a)&&b.div);this.tileSize=new OpenLayers.Size(OpenLayers.Map.TILE_WIDTH,OpenLayers.Map.TILE_HEIGHT);this.maxExtent=new OpenLayers.Bounds(-180,-90,180,90);this.paddingForPopups=new OpenLayers.Bounds(15,15,15,15);this.theme=OpenLayers._getScriptLocation()+"theme/default/style.css";OpenLayers.Util.extend(this,b);this.layers=[];this.id=OpenLayers.Util.createUniqueID("OpenLayers.Map_");this.div=OpenLayers.Util.getElement(a);if(!this.div)this.div=document.createElement("div"),
this.div.style.height="1px",this.div.style.width="1px";OpenLayers.Element.addClass(this.div,"olMap");var c=this.id+"_OpenLayers_ViewPort";this.viewPortDiv=OpenLayers.Util.createDiv(c,null,null,null,"relative",null,"hidden");this.viewPortDiv.style.width="100%";this.viewPortDiv.style.height="100%";this.viewPortDiv.className="olMapViewport";this.div.appendChild(this.viewPortDiv);c=document.createElement("div");c.id=this.id+"_events";c.style.position="absolute";c.style.width="100%";c.style.height="100%";
c.style.zIndex=this.Z_INDEX_BASE.Control-1;this.viewPortDiv.appendChild(c);this.eventsDiv=c;this.events=new OpenLayers.Events(this,this.eventsDiv,this.EVENT_TYPES,this.fallThrough,{includeXY:!0});c=this.id+"_OpenLayers_Container";this.layerContainerDiv=OpenLayers.Util.createDiv(c);this.layerContainerDiv.style.zIndex=this.Z_INDEX_BASE.Popup-1;this.eventsDiv.appendChild(this.layerContainerDiv);this.updateSize();if(this.eventListeners instanceof Object)this.events.on(this.eventListeners);this.events.register("movestart",
this,this.updateSize);OpenLayers.String.contains(navigator.appName,"Microsoft")?this.events.register("resize",this,this.updateSize):(this.updateSizeDestroy=OpenLayers.Function.bind(this.updateSize,this),OpenLayers.Event.observe(window,"resize",this.updateSizeDestroy));if(this.theme){for(var c=!0,d=document.getElementsByTagName("link"),e=0,f=d.length;e<f;++e)if(OpenLayers.Util.isEquivalentUrl(d.item(e).href,this.theme)){c=!1;break}c&&(c=document.createElement("link"),c.setAttribute("rel","stylesheet"),
c.setAttribute("type","text/css"),c.setAttribute("href",this.theme),document.getElementsByTagName("head")[0].appendChild(c))}if(null==this.controls)this.controls=null!=OpenLayers.Control?[new OpenLayers.Control.Navigation,new OpenLayers.Control.PanZoom,new OpenLayers.Control.ArgParser,new OpenLayers.Control.Attribution]:[];e=0;for(f=this.controls.length;e<f;e++)this.addControlToMap(this.controls[e]);this.popups=[];this.unloadDestroy=OpenLayers.Function.bind(this.destroy,this);OpenLayers.Event.observe(window,
"unload",this.unloadDestroy);b&&b.layers&&(delete this.center,this.addLayers(b.layers),b.center&&this.setCenter(b.center,b.zoom))},render:function(a){this.div=OpenLayers.Util.getElement(a);OpenLayers.Element.addClass(this.div,"olMap");this.viewPortDiv.parentNode.removeChild(this.viewPortDiv);this.div.appendChild(this.viewPortDiv);this.updateSize()},unloadDestroy:null,updateSizeDestroy:null,destroy:function(){if(!this.unloadDestroy)return!1;if(this.panTween)this.panTween.stop(),this.panTween=null;
OpenLayers.Event.stopObserving(window,"unload",this.unloadDestroy);this.unloadDestroy=null;this.updateSizeDestroy?OpenLayers.Event.stopObserving(window,"resize",this.updateSizeDestroy):this.events.unregister("resize",this,this.updateSize);this.paddingForPopups=null;if(null!=this.controls){for(var a=this.controls.length-1;0<=a;--a)this.controls[a].destroy();this.controls=null}if(null!=this.layers){for(a=this.layers.length-1;0<=a;--a)this.layers[a].destroy(!1);this.layers=null}this.viewPortDiv&&this.div.removeChild(this.viewPortDiv);
this.viewPortDiv=null;if(this.eventListeners)this.events.un(this.eventListeners),this.eventListeners=null;this.events.destroy();this.events=null},setOptions:function(a){var b=this.minPx&&a.restrictedExtent!=this.restrictedExtent;OpenLayers.Util.extend(this,a);b&&this.moveTo(this.getCachedCenter(),this.zoom,{forceZoomChange:!0})},getTileSize:function(){return this.tileSize},getBy:function(a,b,c){var d="function"==typeof c.test;return OpenLayers.Array.filter(this[a],function(a){return a[b]==c||d&&c.test(a[b])})},
getLayersBy:function(a,b){return this.getBy("layers",a,b)},getLayersByName:function(a){return this.getLayersBy("name",a)},getLayersByClass:function(a){return this.getLayersBy("CLASS_NAME",a)},getControlsBy:function(a,b){return this.getBy("controls",a,b)},getControlsByClass:function(a){return this.getControlsBy("CLASS_NAME",a)},getLayer:function(a){for(var b=null,c=0,d=this.layers.length;c<d;c++){var e=this.layers[c];if(e.id==a){b=e;break}}return b},setLayerZIndex:function(a,b){a.setZIndex(this.Z_INDEX_BASE[a.isBaseLayer?
"BaseLayer":"Overlay"]+5*b)},resetLayersZIndex:function(){for(var a=0,b=this.layers.length;a<b;a++)this.setLayerZIndex(this.layers[a],a)},addLayer:function(a){for(var b=0,c=this.layers.length;b<c;b++)if(this.layers[b]==a)return a=OpenLayers.i18n("layerAlreadyAdded",{layerName:a.name}),OpenLayers.Console.warn(a),!1;if(!1!==this.events.triggerEvent("preaddlayer",{layer:a})){if(this.allOverlays)a.isBaseLayer=!1;a.div.className="olLayerDiv";a.div.style.overflow="";this.setLayerZIndex(a,this.layers.length);
a.isFixed?this.viewPortDiv.appendChild(a.div):this.layerContainerDiv.appendChild(a.div);this.layers.push(a);a.setMap(this);a.isBaseLayer||this.allOverlays&&!this.baseLayer?null==this.baseLayer?this.setBaseLayer(a):a.setVisibility(!1):a.redraw();this.events.triggerEvent("addlayer",{layer:a});a.events.triggerEvent("added",{map:this,layer:a});a.afterAdd()}},addLayers:function(a){for(var b=0,c=a.length;b<c;b++)this.addLayer(a[b])},removeLayer:function(a,b){if(!1!==this.events.triggerEvent("preremovelayer",
{layer:a})){null==b&&(b=!0);a.isFixed?this.viewPortDiv.removeChild(a.div):this.layerContainerDiv.removeChild(a.div);OpenLayers.Util.removeItem(this.layers,a);a.removeMap(this);a.map=null;if(this.baseLayer==a&&(this.baseLayer=null,b))for(var c=0,d=this.layers.length;c<d;c++){var e=this.layers[c];if(e.isBaseLayer||this.allOverlays){this.setBaseLayer(e);break}}this.resetLayersZIndex();this.events.triggerEvent("removelayer",{layer:a});a.events.triggerEvent("removed",{map:this,layer:a})}},getNumLayers:function(){return this.layers.length},
getLayerIndex:function(a){return OpenLayers.Util.indexOf(this.layers,a)},setLayerIndex:function(a,b){var c=this.getLayerIndex(a);if(0>b)b=0;else if(b>this.layers.length)b=this.layers.length;if(c!=b){this.layers.splice(c,1);this.layers.splice(b,0,a);for(var c=0,d=this.layers.length;c<d;c++)this.setLayerZIndex(this.layers[c],c);this.events.triggerEvent("changelayer",{layer:a,property:"order"});this.allOverlays&&(0===b?this.setBaseLayer(a):this.baseLayer!==this.layers[0]&&this.setBaseLayer(this.layers[0]))}},
raiseLayer:function(a,b){var c=this.getLayerIndex(a)+b;this.setLayerIndex(a,c)},setBaseLayer:function(a){if(a!=this.baseLayer&&-1!=OpenLayers.Util.indexOf(this.layers,a)){var b=this.getCachedCenter(),c=OpenLayers.Util.getResolutionFromScale(this.getScale(),a.units);null!=this.baseLayer&&!this.allOverlays&&this.baseLayer.setVisibility(!1);this.baseLayer=a;this.viewRequestID++;(!this.allOverlays||this.baseLayer.visibility)&&this.baseLayer.setVisibility(!0);null!=b&&(a=this.getZoomForResolution(c||this.resolution,
!0),this.setCenter(b,a,!1,!0));this.events.triggerEvent("changebaselayer",{layer:this.baseLayer})}},addControl:function(a,b){this.controls.push(a);this.addControlToMap(a,b)},addControls:function(a,b){for(var c=1===arguments.length?[]:b,d=0,e=a.length;d<e;d++)this.addControl(a[d],c[d]?c[d]:null)},addControlToMap:function(a,b){a.outsideViewport=null!=a.div;if(this.displayProjection&&!a.displayProjection)a.displayProjection=this.displayProjection;a.setMap(this);var c=a.draw(b);if(c&&!a.outsideViewport)c.style.zIndex=
this.Z_INDEX_BASE.Control+this.controls.length,this.viewPortDiv.appendChild(c);a.autoActivate&&a.activate()},getControl:function(a){for(var b=null,c=0,d=this.controls.length;c<d;c++){var e=this.controls[c];if(e.id==a){b=e;break}}return b},removeControl:function(a){a&&a==this.getControl(a.id)&&(a.div&&a.div.parentNode==this.viewPortDiv&&this.viewPortDiv.removeChild(a.div),OpenLayers.Util.removeItem(this.controls,a))},addPopup:function(a,b){if(b)for(var c=this.popups.length-1;0<=c;--c)this.removePopup(this.popups[c]);
a.map=this;this.popups.push(a);if(c=a.draw())c.style.zIndex=this.Z_INDEX_BASE.Popup+this.popups.length,this.layerContainerDiv.appendChild(c)},removePopup:function(a){OpenLayers.Util.removeItem(this.popups,a);if(a.div)try{this.layerContainerDiv.removeChild(a.div)}catch(b){}a.map=null},getSize:function(){var a=null;null!=this.size&&(a=this.size.clone());return a},updateSize:function(){var a=this.getCurrentSize();if(a&&!isNaN(a.h)&&!isNaN(a.w)){this.events.clearMouseCache();var b=this.getSize();if(null==
b)this.size=b=a;if(!a.equals(b)){this.size=a;a=0;for(b=this.layers.length;a<b;a++)this.layers[a].onMapResize();a=this.getCachedCenter();if(null!=this.baseLayer&&null!=a)b=this.getZoom(),this.zoom=null,this.setCenter(a,b)}}},getCurrentSize:function(){var a=new OpenLayers.Size(this.div.clientWidth,this.div.clientHeight);if(0==a.w&&0==a.h||isNaN(a.w)&&isNaN(a.h))a.w=this.div.offsetWidth,a.h=this.div.offsetHeight;if(0==a.w&&0==a.h||isNaN(a.w)&&isNaN(a.h))a.w=parseInt(this.div.style.width),a.h=parseInt(this.div.style.height);
return a},calculateBounds:function(a,b){var c=null;null==a&&(a=this.getCachedCenter());null==b&&(b=this.getResolution());if(null!=a&&null!=b)var d=this.getSize(),c=d.w*b,d=d.h*b,c=new OpenLayers.Bounds(a.lon-c/2,a.lat-d/2,a.lon+c/2,a.lat+d/2);return c},getCenter:function(){var a=null,b=this.getCachedCenter();b&&(a=b.clone());return a},getCachedCenter:function(){if(!this.center&&this.size)this.center=this.getLonLatFromViewPortPx(new OpenLayers.Pixel(this.size.w/2,this.size.h/2));return this.center},
getZoom:function(){return this.zoom},pan:function(a,b,c){c=OpenLayers.Util.applyDefaults(c,{animate:!0,dragging:!1});if(c.dragging)(0!=a||0!=b)&&this.moveByPx(a,b);else{var d=this.getViewPortPxFromLonLat(this.getCachedCenter()),a=d.add(a,b);if(this.dragging||!a.equals(d))d=this.getLonLatFromViewPortPx(a),c.animate?this.panTo(d):(this.moveTo(d),this.dragging=!1,this.events.triggerEvent("moveend"))}},panTo:function(a){if(this.panMethod&&this.getExtent().scale(this.panRatio).containsLonLat(a)){if(!this.panTween)this.panTween=
new OpenLayers.Tween(this.panMethod);var b=this.getCachedCenter();if(!a.equals(b)){var b=this.getPixelFromLonLat(b),c=this.getPixelFromLonLat(a),d=0,e=0;this.panTween.start({x:0,y:0},{x:c.x-b.x,y:c.y-b.y},this.panDuration,{callbacks:{eachStep:OpenLayers.Function.bind(function(a){this.moveByPx(a.x-d,a.y-e);d=Math.round(a.x);e=Math.round(a.y)},this),done:OpenLayers.Function.bind(function(){this.moveTo(a);this.dragging=!1;this.events.triggerEvent("moveend")},this)}})}}else this.setCenter(a)},setCenter:function(a,
b,c,d){this.panTween&&this.panTween.stop();this.moveTo(a,b,{dragging:c,forceZoomChange:d})},moveByPx:function(a,b){var c=this.size.w/2,d=this.size.h/2,e=c+a,f=d+b,g=this.baseLayer.wrapDateLine,h=0,i=0;this.restrictedExtent&&(h=c,i=d,g=!1);a=g||e<=this.maxPx.x-h&&e>=this.minPx.x+h?Math.round(a):0;b=f<=this.maxPx.y-i&&f>=this.minPx.y+i?Math.round(b):0;c=this.minPx.x;d=this.maxPx.x;if(a||b){if(!this.dragging)this.dragging=!0,this.events.triggerEvent("movestart");this.center=null;if(a)this.layerContainerDiv.style.left=
parseInt(this.layerContainerDiv.style.left)-a+"px",this.minPx.x-=a,this.maxPx.x-=a,g&&(this.maxPx.x>d&&(this.maxPx.x-=d-c),this.minPx.x<c&&(this.minPx.x+=d-c));if(b)this.layerContainerDiv.style.top=parseInt(this.layerContainerDiv.style.top)-b+"px",this.minPx.y-=b,this.maxPx.y-=b;for(c=0,d=this.layers.length;c<d;++c)if(g=this.layers[c],g.visibility&&(g===this.baseLayer||g.inRange))g.moveByPx(a,b),g.events.triggerEvent("move");this.events.triggerEvent("move")}},moveTo:function(a,b,c){c||(c={});null!=
b&&(b=parseFloat(b),this.fractionalZoom||(b=Math.round(b)));var d=c.dragging||this.dragging,e=c.forceZoomChange;if(!this.getCachedCenter()&&!this.isValidLonLat(a))a=this.maxExtent.getCenterLonLat(),this.center=a.clone();if(null!=this.restrictedExtent){if(null==a)a=this.center;null==b&&(b=this.getZoom());var f=this.getResolutionForZoom(b),f=this.calculateBounds(a,f);if(!this.restrictedExtent.containsBounds(f)){var g=this.restrictedExtent.getCenterLonLat();f.getWidth()>this.restrictedExtent.getWidth()?
a=new OpenLayers.LonLat(g.lon,a.lat):f.left<this.restrictedExtent.left?a=a.add(this.restrictedExtent.left-f.left,0):f.right>this.restrictedExtent.right&&(a=a.add(this.restrictedExtent.right-f.right,0));f.getHeight()>this.restrictedExtent.getHeight()?a=new OpenLayers.LonLat(a.lon,g.lat):f.bottom<this.restrictedExtent.bottom?a=a.add(0,this.restrictedExtent.bottom-f.bottom):f.top>this.restrictedExtent.top&&(a=a.add(0,this.restrictedExtent.top-f.top))}}e=e||this.isValidZoomLevel(b)&&b!=this.getZoom();
f=this.isValidLonLat(a)&&!a.equals(this.center);if(e||f||d){d||this.events.triggerEvent("movestart");if(f)!e&&this.center&&this.centerLayerContainer(a),this.center=a.clone();a=e?this.getResolutionForZoom(b):this.getResolution();if(e||null==this.layerContainerOrigin){this.layerContainerOrigin=this.getCachedCenter();this.layerContainerDiv.style.left="0px";this.layerContainerDiv.style.top="0px";var h=this.getMaxExtent({restricted:!0}),f=h.getCenterLonLat(),g=this.center.lon-f.lon,i=f.lat-this.center.lat,
f=Math.round(h.getWidth()/a),h=Math.round(h.getHeight()/a),g=(this.size.w-f)/2-g/a,i=(this.size.h-h)/2-i/a;this.minPx=new OpenLayers.Pixel(g,i);this.maxPx=new OpenLayers.Pixel(g+f,i+h)}if(e)this.zoom=b,this.resolution=a,this.viewRequestID++;a=this.getExtent();this.baseLayer.visibility&&(this.baseLayer.moveTo(a,e,c.dragging),c.dragging||this.baseLayer.events.triggerEvent("moveend",{zoomChanged:e}));a=this.baseLayer.getExtent();for(b=this.layers.length-1;0<=b;--b)if(f=this.layers[b],f!==this.baseLayer&&
!f.isBaseLayer){g=f.calculateInRange();if(f.inRange!=g)(f.inRange=g)||f.display(!1),this.events.triggerEvent("changelayer",{layer:f,property:"visibility"});g&&f.visibility&&(f.moveTo(a,e,c.dragging),c.dragging||f.events.triggerEvent("moveend",{zoomChanged:e}))}this.events.triggerEvent("move");d||this.events.triggerEvent("moveend");if(e){b=0;for(c=this.popups.length;b<c;b++)this.popups[b].updatePosition();this.events.triggerEvent("zoomend")}}},centerLayerContainer:function(a){var b=this.getViewPortPxFromLonLat(this.layerContainerOrigin),
c=this.getViewPortPxFromLonLat(a);if(null!=b&&null!=c){var d=parseInt(this.layerContainerDiv.style.left),a=parseInt(this.layerContainerDiv.style.top),e=Math.round(b.x-c.x),b=Math.round(b.y-c.y);this.layerContainerDiv.style.left=e+"px";this.layerContainerDiv.style.top=b+"px";d-=e;a-=b;this.minPx.x-=d;this.maxPx.x-=d;this.minPx.y-=a;this.maxPx.y-=a}},isValidZoomLevel:function(a){return null!=a&&0<=a&&a<this.getNumZoomLevels()},isValidLonLat:function(a){var b=!1;null!=a&&(b=this.getMaxExtent().containsLonLat(a));
return b},getProjection:function(){var a=this.getProjectionObject();return a?a.getCode():null},getProjectionObject:function(){var a=null;if(null!=this.baseLayer)a=this.baseLayer.projection;return a},getMaxResolution:function(){var a=null;if(null!=this.baseLayer)a=this.baseLayer.maxResolution;return a},getMaxExtent:function(a){var b=null;if(a&&a.restricted&&this.restrictedExtent)b=this.restrictedExtent;else if(null!=this.baseLayer)b=this.baseLayer.maxExtent;return b},getNumZoomLevels:function(){var a=
null;if(null!=this.baseLayer)a=this.baseLayer.numZoomLevels;return a},getExtent:function(){var a=null;null!=this.baseLayer&&(a=this.baseLayer.getExtent());return a},getResolution:function(){var a=null;null!=this.baseLayer?a=this.baseLayer.getResolution():!0===this.allOverlays&&0<this.layers.length&&(a=this.layers[0].getResolution());return a},getUnits:function(){var a=null;if(null!=this.baseLayer)a=this.baseLayer.units;return a},getScale:function(){var a=null;null!=this.baseLayer&&(a=this.getResolution(),
a=OpenLayers.Util.getScaleFromResolution(a,this.baseLayer.units));return a},getZoomForExtent:function(a,b){var c=null;null!=this.baseLayer&&(c=this.baseLayer.getZoomForExtent(a,b));return c},getResolutionForZoom:function(a){var b=null;this.baseLayer&&(b=this.baseLayer.getResolutionForZoom(a));return b},getZoomForResolution:function(a,b){var c=null;null!=this.baseLayer&&(c=this.baseLayer.getZoomForResolution(a,b));return c},zoomTo:function(a){this.isValidZoomLevel(a)&&this.setCenter(null,a)},zoomIn:function(){this.zoomTo(this.getZoom()+
1)},zoomOut:function(){this.zoomTo(this.getZoom()-1)},zoomToExtent:function(a,b){var c=a.getCenterLonLat();if(this.baseLayer.wrapDateLine){c=this.getMaxExtent();for(a=a.clone();a.right<a.left;)a.right+=c.getWidth();c=a.getCenterLonLat().wrapDateLine(c)}this.setCenter(c,this.getZoomForExtent(a,b))},zoomToMaxExtent:function(a){this.zoomToExtent(this.getMaxExtent({restricted:a?a.restricted:!0}))},zoomToScale:function(a,b){var c=OpenLayers.Util.getResolutionFromScale(a,this.baseLayer.units),d=this.getSize(),
e=d.w*c,c=d.h*c,d=this.getCachedCenter();this.zoomToExtent(new OpenLayers.Bounds(d.lon-e/2,d.lat-c/2,d.lon+e/2,d.lat+c/2),b)},getLonLatFromViewPortPx:function(a){var b=null;null!=this.baseLayer&&(b=this.baseLayer.getLonLatFromViewPortPx(a));return b},getViewPortPxFromLonLat:function(a){var b=null;null!=this.baseLayer&&(b=this.baseLayer.getViewPortPxFromLonLat(a));return b},getLonLatFromPixel:function(a){return this.getLonLatFromViewPortPx(a)},getPixelFromLonLat:function(a){a=this.getViewPortPxFromLonLat(a);
a.x=Math.round(a.x);a.y=Math.round(a.y);return a},getGeodesicPixelSize:function(a){var b=a?this.getLonLatFromPixel(a):this.getCachedCenter()||new OpenLayers.LonLat(0,0),c=this.getResolution(),a=b.add(-c/2,0),d=b.add(c/2,0),e=b.add(0,-c/2),b=b.add(0,c/2),c=new OpenLayers.Projection("EPSG:4326"),f=this.getProjectionObject()||c;f.equals(c)||(a.transform(f,c),d.transform(f,c),e.transform(f,c),b.transform(f,c));return new OpenLayers.Size(OpenLayers.Util.distVincenty(a,d),OpenLayers.Util.distVincenty(e,
b))},getViewPortPxFromLayerPx:function(a){var b=null;if(null!=a)var b=parseInt(this.layerContainerDiv.style.left),c=parseInt(this.layerContainerDiv.style.top),b=a.add(b,c);return b},getLayerPxFromViewPortPx:function(a){var b=null;if(null!=a){var b=-parseInt(this.layerContainerDiv.style.left),c=-parseInt(this.layerContainerDiv.style.top),b=a.add(b,c);if(isNaN(b.x)||isNaN(b.y))b=null}return b},getLonLatFromLayerPx:function(a){a=this.getViewPortPxFromLayerPx(a);return this.getLonLatFromViewPortPx(a)},
getLayerPxFromLonLat:function(a){return this.getLayerPxFromViewPortPx(this.getPixelFromLonLat(a))},CLASS_NAME:"OpenLayers.Map"});OpenLayers.Map.TILE_WIDTH=256;OpenLayers.Map.TILE_HEIGHT=256;
OpenLayers.Projection=OpenLayers.Class({proj:null,projCode:null,titleRegEx:/\+title=[^\+]*/,initialize:function(a,b){OpenLayers.Util.extend(this,b);this.projCode=a;if(window.Proj4js)this.proj=new Proj4js.Proj(a)},getCode:function(){return this.proj?this.proj.srsCode:this.projCode},getUnits:function(){return this.proj?this.proj.units:null},toString:function(){return this.getCode()},equals:function(a){var b=!1;a&&(window.Proj4js&&this.proj.defData&&a.proj.defData?b=this.proj.defData.replace(this.titleRegEx,
"")==a.proj.defData.replace(this.titleRegEx,""):a.getCode&&(b=this.getCode(),a=a.getCode(),b=b==a||!!OpenLayers.Projection.transforms[b]&&OpenLayers.Projection.transforms[b][a]===OpenLayers.Projection.nullTransform));return b},destroy:function(){delete this.proj;delete this.projCode},CLASS_NAME:"OpenLayers.Projection"});OpenLayers.Projection.transforms={};
OpenLayers.Projection.addTransform=function(a,b,c){OpenLayers.Projection.transforms[a]||(OpenLayers.Projection.transforms[a]={});OpenLayers.Projection.transforms[a][b]=c};OpenLayers.Projection.transform=function(a,b,c){if(b.proj&&c.proj)a=Proj4js.transform(b.proj,c.proj,a);else if(b&&c&&OpenLayers.Projection.transforms[b.getCode()]&&OpenLayers.Projection.transforms[b.getCode()][c.getCode()])OpenLayers.Projection.transforms[b.getCode()][c.getCode()](a);return a};
OpenLayers.Projection.nullTransform=function(a){return a};
OpenLayers.Layer=OpenLayers.Class({id:null,name:null,div:null,opacity:null,alwaysInRange:null,EVENT_TYPES:"loadstart,loadend,loadcancel,visibilitychanged,move,moveend,added,removed".split(","),RESOLUTION_PROPERTIES:"scales,resolutions,maxScale,minScale,maxResolution,minResolution,numZoomLevels,maxZoomLevel".split(","),events:null,map:null,isBaseLayer:!1,alpha:!1,displayInLayerSwitcher:!0,visibility:!0,attribution:null,inRange:!1,imageSize:null,imageOffset:null,options:null,eventListeners:null,gutter:0,
projection:null,units:null,scales:null,resolutions:null,maxExtent:null,minExtent:null,maxResolution:null,minResolution:null,numZoomLevels:null,minScale:null,maxScale:null,displayOutsideMaxExtent:!1,wrapDateLine:!1,transitionEffect:null,SUPPORTED_TRANSITIONS:["resize"],metadata:{},initialize:function(a,b){this.addOptions(b);this.name=a;if(null==this.id&&(this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_"),this.div=OpenLayers.Util.createDiv(this.id),this.div.style.width="100%",this.div.style.height=
"100%",this.div.dir="ltr",this.events=new OpenLayers.Events(this,this.div,this.EVENT_TYPES),this.eventListeners instanceof Object))this.events.on(this.eventListeners);if(this.wrapDateLine)this.displayOutsideMaxExtent=!0},destroy:function(a){null==a&&(a=!0);null!=this.map&&this.map.removeLayer(this,a);this.options=this.div=this.name=this.map=this.projection=null;this.events&&(this.eventListeners&&this.events.un(this.eventListeners),this.events.destroy());this.events=this.eventListeners=null},clone:function(a){null==
a&&(a=new OpenLayers.Layer(this.name,this.getOptions()));OpenLayers.Util.applyDefaults(a,this);a.map=null;return a},getOptions:function(){var a={},b;for(b in this.options)a[b]=this[b];return a},setName:function(a){if(a!=this.name)this.name=a,null!=this.map&&this.map.events.triggerEvent("changelayer",{layer:this,property:"name"})},addOptions:function(a,b){if(null==this.options)this.options={};OpenLayers.Util.extend(this.options,a);OpenLayers.Util.extend(this,a);if("string"==typeof this.projection)this.projection=
new OpenLayers.Projection(this.projection);if(this.projection&&this.projection.getUnits())this.units=this.projection.getUnits();if(this.map){var c=this.map.getResolution(),d=this.RESOLUTION_PROPERTIES.concat(["projection","units","minExtent","maxExtent"]),e;for(e in a)if(a.hasOwnProperty(e)&&0<=OpenLayers.Util.indexOf(d,e)){this.initResolutions();b&&this.map.baseLayer===this&&(this.map.setCenter(this.map.getCenter(),this.map.getZoomForResolution(c),!1,!0),this.map.events.triggerEvent("changebaselayer",
{layer:this}));break}}},onMapResize:function(){},redraw:function(){var a=!1;if(this.map){this.inRange=this.calculateInRange();var b=this.getExtent();b&&this.inRange&&this.visibility&&(this.moveTo(b,!0,!1),this.events.triggerEvent("moveend",{zoomChanged:!0}),a=!0)}return a},moveTo:function(){var a=this.visibility;this.isBaseLayer||(a=a&&this.inRange);this.display(a)},moveByPx:function(){},setMap:function(a){if(null==this.map){this.map=a;this.maxExtent=this.maxExtent||this.map.maxExtent;this.minExtent=
this.minExtent||this.map.minExtent;this.projection=this.projection||this.map.projection;if("string"==typeof this.projection)this.projection=new OpenLayers.Projection(this.projection);this.units=this.projection.getUnits()||this.units||this.map.units;this.initResolutions();if(!this.isBaseLayer)this.inRange=this.calculateInRange(),this.div.style.display=this.visibility&&this.inRange?"":"none";this.setTileSize()}},afterAdd:function(){},removeMap:function(){},getImageSize:function(){return this.imageSize||
this.tileSize},setTileSize:function(a){this.tileSize=a=a?a:this.tileSize?this.tileSize:this.map.getTileSize();if(this.gutter)this.imageOffset=new OpenLayers.Pixel(-this.gutter,-this.gutter),this.imageSize=new OpenLayers.Size(a.w+2*this.gutter,a.h+2*this.gutter)},getVisibility:function(){return this.visibility},setVisibility:function(a){if(a!=this.visibility)this.visibility=a,this.display(a),this.redraw(),null!=this.map&&this.map.events.triggerEvent("changelayer",{layer:this,property:"visibility"}),
this.events.triggerEvent("visibilitychanged")},display:function(a){if(a!=("none"!=this.div.style.display))this.div.style.display=a&&this.calculateInRange()?"block":"none"},calculateInRange:function(){var a=!1;this.alwaysInRange?a=!0:this.map&&(a=this.map.getResolution(),a=a>=this.minResolution&&a<=this.maxResolution);return a},setIsBaseLayer:function(a){if(a!=this.isBaseLayer)this.isBaseLayer=a,null!=this.map&&this.map.events.triggerEvent("changebaselayer",{layer:this})},initResolutions:function(){var a,
b,c,d={},e=!0;for(a=0,b=this.RESOLUTION_PROPERTIES.length;a<b;a++)c=this.RESOLUTION_PROPERTIES[a],d[c]=this.options[c],e&&this.options[c]&&(e=!1);if(null==this.alwaysInRange)this.alwaysInRange=e;if(null==d.resolutions)d.resolutions=this.resolutionsFromScales(d.scales);if(null==d.resolutions)d.resolutions=this.calculateResolutions(d);if(null==d.resolutions){for(a=0,b=this.RESOLUTION_PROPERTIES.length;a<b;a++)c=this.RESOLUTION_PROPERTIES[a],d[c]=null!=this.options[c]?this.options[c]:this.map[c];if(null==
d.resolutions)d.resolutions=this.resolutionsFromScales(d.scales);if(null==d.resolutions)d.resolutions=this.calculateResolutions(d)}var f;if(this.options.maxResolution&&"auto"!==this.options.maxResolution)f=this.options.maxResolution;this.options.minScale&&(f=OpenLayers.Util.getResolutionFromScale(this.options.minScale,this.units));var g;if(this.options.minResolution&&"auto"!==this.options.minResolution)g=this.options.minResolution;this.options.maxScale&&(g=OpenLayers.Util.getResolutionFromScale(this.options.maxScale,
this.units));d.resolutions&&(d.resolutions.sort(function(a,b){return b-a}),f||(f=d.resolutions[0]),g||(g=d.resolutions[d.resolutions.length-1]));if(this.resolutions=d.resolutions){b=this.resolutions.length;this.scales=Array(b);for(a=0;a<b;a++)this.scales[a]=OpenLayers.Util.getScaleFromResolution(this.resolutions[a],this.units);this.numZoomLevels=b}if(this.minResolution=g)this.maxScale=OpenLayers.Util.getScaleFromResolution(g,this.units);if(this.maxResolution=f)this.minScale=OpenLayers.Util.getScaleFromResolution(f,
this.units)},resolutionsFromScales:function(a){if(null!=a){var b,c,d;d=a.length;b=Array(d);for(c=0;c<d;c++)b[c]=OpenLayers.Util.getResolutionFromScale(a[c],this.units);return b}},calculateResolutions:function(a){var b,c,d=a.maxResolution;null!=a.minScale?d=OpenLayers.Util.getResolutionFromScale(a.minScale,this.units):"auto"==d&&null!=this.maxExtent&&(b=this.map.getSize(),c=this.maxExtent.getWidth()/b.w,b=this.maxExtent.getHeight()/b.h,d=Math.max(c,b));c=a.minResolution;null!=a.maxScale?c=OpenLayers.Util.getResolutionFromScale(a.maxScale,
this.units):"auto"==a.minResolution&&null!=this.minExtent&&(b=this.map.getSize(),c=this.minExtent.getWidth()/b.w,b=this.minExtent.getHeight()/b.h,c=Math.max(c,b));b=a.maxZoomLevel;a=a.numZoomLevels;"number"===typeof c&&"number"===typeof d&&void 0===a?a=Math.floor(Math.log(d/c)/Math.log(2))+1:void 0===a&&null!=b&&(a=b+1);if(!("number"!==typeof a||0>=a||"number"!==typeof d&&"number"!==typeof c)){b=Array(a);var e=2;"number"==typeof c&&"number"==typeof d&&(e=Math.pow(d/c,1/(a-1)));var f;if("number"===
typeof d)for(f=0;f<a;f++)b[f]=d/Math.pow(e,f);else for(f=0;f<a;f++)b[a-1-f]=c*Math.pow(e,f);return b}},getResolution:function(){return this.getResolutionForZoom(this.map.getZoom())},getExtent:function(){return this.map.calculateBounds()},getZoomForExtent:function(a,b){var c=this.map.getSize();return this.getZoomForResolution(Math.max(a.getWidth()/c.w,a.getHeight()/c.h),b)},getDataExtent:function(){},getResolutionForZoom:function(a){a=Math.max(0,Math.min(a,this.resolutions.length-1));if(this.map.fractionalZoom)var b=
Math.floor(a),c=Math.ceil(a),a=this.resolutions[b]-(a-b)*(this.resolutions[b]-this.resolutions[c]);else a=this.resolutions[Math.round(a)];return a},getZoomForResolution:function(a,b){var c,d;if(this.map.fractionalZoom){var e=0,f=this.resolutions[e],g=this.resolutions[this.resolutions.length-1],h;for(c=0,d=this.resolutions.length;c<d;++c)if(h=this.resolutions[c],h>=a&&(f=h,e=c),h<=a){g=h;break}c=f-g;c=0<c?e+(f-a)/c:e}else{f=Number.POSITIVE_INFINITY;for(c=0,d=this.resolutions.length;c<d;c++)if(b){e=
Math.abs(this.resolutions[c]-a);if(e>f)break;f=e}else if(this.resolutions[c]<a)break;c=Math.max(0,c-1)}return c},getLonLatFromViewPortPx:function(a){var b=null,c=this.map;if(null!=a&&c.minPx){var b=c.getResolution(),d=c.getMaxExtent({restricted:!0}),b=new OpenLayers.LonLat((a.x-c.minPx.x)*b+d.left,(c.minPx.y-a.y)*b+d.top);this.wrapDateLine&&(b=b.wrapDateLine(this.maxExtent))}return b},getViewPortPxFromLonLat:function(a){var b=null;if(null!=a)var b=this.map.getResolution(),c=this.map.getExtent(),b=
new OpenLayers.Pixel(1/b*(a.lon-c.left),1/b*(c.top-a.lat));return b},setOpacity:function(a){if(a!=this.opacity){this.opacity=a;for(var b=0,c=this.div.childNodes.length;b<c;++b)OpenLayers.Util.modifyDOMElement(this.div.childNodes[b].firstChild,null,null,null,null,null,null,a);null!=this.map&&this.map.events.triggerEvent("changelayer",{layer:this,property:"opacity"})}},getZIndex:function(){return this.div.style.zIndex},setZIndex:function(a){this.div.style.zIndex=a},adjustBounds:function(a){if(this.gutter)var b=
this.gutter*this.map.getResolution(),a=new OpenLayers.Bounds(a.left-b,a.bottom-b,a.right+b,a.top+b);this.wrapDateLine&&(b={rightTolerance:this.getResolution(),leftTolerance:this.getResolution()},a=a.wrapDateLine(this.maxExtent,b));return a},CLASS_NAME:"OpenLayers.Layer"});
OpenLayers.Layer.HTTPRequest=OpenLayers.Class(OpenLayers.Layer,{URL_HASH_FACTOR:(Math.sqrt(5)-1)/2,url:null,params:null,reproject:!1,initialize:function(a,b,c,d){OpenLayers.Layer.prototype.initialize.apply(this,[a,d]);this.url=b;this.params=OpenLayers.Util.extend({},c)},destroy:function(){this.params=this.url=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},clone:function(a){null==a&&(a=new OpenLayers.Layer.HTTPRequest(this.name,this.url,this.params,this.getOptions()));return a=OpenLayers.Layer.prototype.clone.apply(this,
[a])},setUrl:function(a){this.url=a},mergeNewParams:function(a){this.params=OpenLayers.Util.extend(this.params,a);a=this.redraw();null!=this.map&&this.map.events.triggerEvent("changelayer",{layer:this,property:"params"});return a},redraw:function(a){return a?this.mergeNewParams({_olSalt:Math.random()}):OpenLayers.Layer.prototype.redraw.apply(this,[])},selectUrl:function(a,b){for(var c=1,d=0,e=a.length;d<e;d++)c*=a.charCodeAt(d)*this.URL_HASH_FACTOR,c-=Math.floor(c);return b[Math.floor(c*b.length)]},
getFullRequestString:function(a,b){var c=b||this.url,d=OpenLayers.Util.extend({},this.params),d=OpenLayers.Util.extend(d,a),e=OpenLayers.Util.getParameterString(d);OpenLayers.Util.isArray(c)&&(c=this.selectUrl(e,c));var e=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getParameters(c)),f;for(f in d)f.toUpperCase()in e&&delete d[f];e=OpenLayers.Util.getParameterString(d);return OpenLayers.Util.urlAppend(c,e)},CLASS_NAME:"OpenLayers.Layer.HTTPRequest"});
OpenLayers.Layer.Grid=OpenLayers.Class(OpenLayers.Layer.HTTPRequest,{tileSize:null,tileOriginCorner:"bl",tileOrigin:null,tileOptions:null,grid:null,singleTile:!1,ratio:1.5,buffer:0,numLoadingTiles:0,tileLoadingDelay:100,timerId:null,initialize:function(a,b,c,d){OpenLayers.Layer.HTTPRequest.prototype.initialize.apply(this,arguments);this.events.addEventType("tileloaded");this.grid=[];this._moveGriddedTiles=OpenLayers.Function.bind(this.moveGriddedTiles,this)},removeMap:function(){if(null!=this.timerId)window.clearTimeout(this.timerId),
this.timerId=null},destroy:function(){this.clearGrid();this.tileSize=this.grid=null;OpenLayers.Layer.HTTPRequest.prototype.destroy.apply(this,arguments)},clearGrid:function(){if(this.grid){for(var a=0,b=this.grid.length;a<b;a++)for(var c=this.grid[a],d=0,e=c.length;d<e;d++){var f=c[d];this.removeTileMonitoringHooks(f);f.destroy()}this.grid=[]}},clone:function(a){null==a&&(a=new OpenLayers.Layer.Grid(this.name,this.url,this.params,this.getOptions()));a=OpenLayers.Layer.HTTPRequest.prototype.clone.apply(this,
[a]);if(null!=this.tileSize)a.tileSize=this.tileSize.clone();a.grid=[];return a},moveTo:function(a,b,c){OpenLayers.Layer.HTTPRequest.prototype.moveTo.apply(this,arguments);a=a||this.map.getExtent();if(null!=a){var d=!this.grid.length||b,e=this.getTilesBounds();this.singleTile?(d||!c&&!e.containsBounds(a))&&this.initSingleTile(a):d||!e.containsBounds(a,!0)?this.initGriddedTiles(a):this.scheduleMoveGriddedTiles()}},moveByPx:function(){this.singleTile||this.scheduleMoveGriddedTiles()},scheduleMoveGriddedTiles:function(){null!=
this.timerId&&window.clearTimeout(this.timerId);this.timerId=window.setTimeout(this._moveGriddedTiles,this.tileLoadingDelay)},setTileSize:function(a){if(this.singleTile)a=this.map.getSize(),a.h=parseInt(a.h*this.ratio),a.w=parseInt(a.w*this.ratio);OpenLayers.Layer.HTTPRequest.prototype.setTileSize.apply(this,[a])},getGridBounds:function(){OpenLayers.Console.warn("The getGridBounds() function is deprecated. It will be removed in 3.0. Please use getTilesBounds() instead.");return this.getTilesBounds()},
getTilesBounds:function(){var a=null;if(this.grid.length)var a=this.grid[this.grid.length-1][0],b=this.grid[0][this.grid[0].length-1],a=new OpenLayers.Bounds(a.bounds.left,a.bounds.bottom,b.bounds.right,b.bounds.top);return a},initSingleTile:function(a){var b=a.getCenterLonLat(),c=a.getWidth()*this.ratio,a=a.getHeight()*this.ratio,b=new OpenLayers.Bounds(b.lon-c/2,b.lat-a/2,b.lon+c/2,b.lat+a/2),c=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(b.left,b.top));this.grid.length||(this.grid[0]=[]);
(a=this.grid[0][0])?a.moveTo(b,c):(a=this.addTile(b,c),this.addTileMonitoringHooks(a),a.draw(),this.grid[0][0]=a);this.removeExcessTiles(1,1)},calculateGridLayout:function(a,b,c){var d=c*this.tileSize.w,c=c*this.tileSize.h,e=a.left-b.lon,f=Math.floor(e/d)-this.buffer,e=-(e/d-f)*this.tileSize.w,f=b.lon+f*d,a=a.top-(b.lat+c),g=Math.ceil(a/c)+this.buffer;return{tilelon:d,tilelat:c,tileoffsetlon:f,tileoffsetlat:b.lat+g*c,tileoffsetx:e,tileoffsety:-(g-a/c)*this.tileSize.h}},getTileOrigin:function(){var a=
this.tileOrigin;if(!a)var a=this.getMaxExtent(),b={tl:["left","top"],tr:["right","top"],bl:["left","bottom"],br:["right","bottom"]}[this.tileOriginCorner],a=new OpenLayers.LonLat(a[b[0]],a[b[1]]);return a},initGriddedTiles:function(a){var b=this.map.getSize(),c=Math.ceil(b.h/this.tileSize.h)+Math.max(1,2*this.buffer),b=Math.ceil(b.w/this.tileSize.w)+Math.max(1,2*this.buffer),d=this.getTileOrigin(),e=this.map.getResolution(),f=this.calculateGridLayout(a,d,e),d=Math.round(f.tileoffsetx),e=Math.round(f.tileoffsety),
g=f.tileoffsetlon,h=f.tileoffsetlat,i=f.tilelon,f=f.tilelat;this.origin=new OpenLayers.Pixel(d,e);var k=d,q=g,s=0,r=parseInt(this.map.layerContainerDiv.style.left),m=parseInt(this.map.layerContainerDiv.style.top);do{var j=this.grid[s++];j||(j=[],this.grid.push(j));var g=q,d=k,p=0;do{var l=new OpenLayers.Bounds(g,h,g+i,h+f),n=d,n=n-r,o=e,o=o-m,n=new OpenLayers.Pixel(n,o);(o=j[p++])?o.moveTo(l,n,!1):(o=this.addTile(l,n),this.addTileMonitoringHooks(o),j.push(o));g+=i;d+=this.tileSize.w}while(g<=a.right+
i*this.buffer||p<b);h-=f;e+=this.tileSize.h}while(h>=a.bottom-f*this.buffer||s<c);this.removeExcessTiles(s,p);this.spiralTileLoad()},getMaxExtent:function(){return this.maxExtent},spiralTileLoad:function(){for(var a=[],b=["right","down","left","up"],c=0,d=-1,e=OpenLayers.Util.indexOf(b,"right"),f=0;f<b.length;){var g=c,h=d;switch(b[e]){case "right":h++;break;case "down":g++;break;case "left":h--;break;case "up":g--}var i=null;g<this.grid.length&&0<=g&&h<this.grid[0].length&&0<=h&&(i=this.grid[g][h]);
null!=i&&!i.queued?(a.unshift(i),i.queued=!0,f=0,c=g,d=h):(e=(e+1)%4,f++)}b=0;for(c=a.length;b<c;b++)i=a[b],i.draw(),i.queued=!1},addTile:function(a,b){return new OpenLayers.Tile.Image(this,b,a,null,this.tileSize,this.tileOptions)},addTileMonitoringHooks:function(a){a.onLoadStart=function(){0==this.numLoadingTiles&&this.events.triggerEvent("loadstart");this.numLoadingTiles++};a.events.register("loadstart",this,a.onLoadStart);a.onLoadEnd=function(){this.numLoadingTiles--;this.events.triggerEvent("tileloaded");
0==this.numLoadingTiles&&this.events.triggerEvent("loadend")};a.events.register("loadend",this,a.onLoadEnd);a.events.register("unload",this,a.onLoadEnd)},removeTileMonitoringHooks:function(a){a.unload();a.events.un({loadstart:a.onLoadStart,loadend:a.onLoadEnd,unload:a.onLoadEnd,scope:this})},moveGriddedTiles:function(){var a=!0,b=this.buffer||1,c=this.grid[0][0].position,d=parseInt(this.map.layerContainerDiv.style.left),e=parseInt(this.map.layerContainerDiv.style.top),c=c.add(d,e);c.x>-this.tileSize.w*
(b-1)?this.shiftColumn(!0):c.x<-this.tileSize.w*b?this.shiftColumn(!1):c.y>-this.tileSize.h*(b-1)?this.shiftRow(!0):c.y<-this.tileSize.h*b?this.shiftRow(!1):a=!1;if(a)this.timerId=window.setTimeout(this._moveGriddedTiles,0)},shiftRow:function(a){for(var b=this.grid,c=b[a?0:this.grid.length-1],d=this.map.getResolution(),e=a?-this.tileSize.h:this.tileSize.h,d=d*-e,f=a?b.pop():b.shift(),g=0,h=c.length;g<h;g++){var i=c[g],k=i.bounds.clone(),i=i.position.clone();k.bottom+=d;k.top+=d;i.y+=e;f[g].moveTo(k,
i)}a?b.unshift(f):b.push(f)},shiftColumn:function(a){for(var b=a?-this.tileSize.w:this.tileSize.w,c=this.map.getResolution()*b,d=0,e=this.grid.length;d<e;d++){var f=this.grid[d],g=f[a?0:f.length-1],h=g.bounds.clone(),g=g.position.clone();h.left+=c;h.right+=c;g.x+=b;var i=a?this.grid[d].pop():this.grid[d].shift();i.moveTo(h,g);a?f.unshift(i):f.push(i)}},removeExcessTiles:function(a,b){for(;this.grid.length>a;)for(var c=this.grid.pop(),d=0,e=c.length;d<e;d++){var f=c[d];this.removeTileMonitoringHooks(f);
f.destroy()}for(;this.grid[0].length>b;){d=0;for(e=this.grid.length;d<e;d++)c=this.grid[d],f=c.pop(),this.removeTileMonitoringHooks(f),f.destroy()}},onMapResize:function(){this.singleTile&&(this.clearGrid(),this.setTileSize())},getTileBounds:function(a){var b=this.maxExtent,c=this.getResolution(),d=c*this.tileSize.w,c=c*this.tileSize.h,e=this.getLonLatFromViewPortPx(a),a=b.left+d*Math.floor((e.lon-b.left)/d),b=b.bottom+c*Math.floor((e.lat-b.bottom)/c);return new OpenLayers.Bounds(a,b,a+d,b+c)},CLASS_NAME:"OpenLayers.Layer.Grid"});
OpenLayers.Request={DEFAULT_CONFIG:{method:"GET",url:window.location.href,async:!0,user:void 0,password:void 0,params:null,proxy:OpenLayers.ProxyHost,headers:{},data:null,callback:function(){},success:null,failure:null,scope:null},URL_SPLIT_REGEX:/([^:]*:)\/\/([^:]*:?[^@]*@)?([^:\/\?]*):?([^\/\?]*)/,events:new OpenLayers.Events(this,null,["complete","success","failure"]),issue:function(a){var b=OpenLayers.Util.extend(this.DEFAULT_CONFIG,{proxy:OpenLayers.ProxyHost}),a=OpenLayers.Util.applyDefaults(a,
b),c=new OpenLayers.Request.XMLHttpRequest,d=OpenLayers.Util.urlAppend(a.url,OpenLayers.Util.getParameterString(a.params||{})),b=0!=d.indexOf("http"),e=!b&&d.match(this.URL_SPLIT_REGEX);if(e){var f=window.location,b=e[1]==f.protocol&&e[3]==f.hostname,e=e[4],f=f.port;if(80!=e&&""!=e||"80"!=f&&""!=f)b=b&&e==f}b||(a.proxy?d="function"==typeof a.proxy?a.proxy(d):a.proxy+encodeURIComponent(d):OpenLayers.Console.warn(OpenLayers.i18n("proxyNeeded"),{url:d}));c.open(a.method,d,a.async,a.user,a.password);
for(var g in a.headers)c.setRequestHeader(g,a.headers[g]);var h=this.events,i=this;c.onreadystatechange=function(){c.readyState==OpenLayers.Request.XMLHttpRequest.DONE&&!1!==h.triggerEvent("complete",{request:c,config:a,requestUrl:d})&&i.runCallbacks({request:c,config:a,requestUrl:d})};!1===a.async?c.send(a.data):window.setTimeout(function(){0!==c.readyState&&c.send(a.data)},0);return c},runCallbacks:function(a){var b=a.request,c=a.config,d=c.scope?OpenLayers.Function.bind(c.callback,c.scope):c.callback,
e;c.success&&(e=c.scope?OpenLayers.Function.bind(c.success,c.scope):c.success);var f;c.failure&&(f=c.scope?OpenLayers.Function.bind(c.failure,c.scope):c.failure);if("file:"==OpenLayers.Util.createUrlObject(c.url).protocol&&b.responseText)b.status=200;d(b);if(!b.status||200<=b.status&&300>b.status)this.events.triggerEvent("success",a),e&&e(b);if(b.status&&(200>b.status||300<=b.status))this.events.triggerEvent("failure",a),f&&f(b)},GET:function(a){a=OpenLayers.Util.extend(a,{method:"GET"});return OpenLayers.Request.issue(a)},
POST:function(a){a=OpenLayers.Util.extend(a,{method:"POST"});a.headers=a.headers?a.headers:{};"CONTENT-TYPE"in OpenLayers.Util.upperCaseObject(a.headers)||(a.headers["Content-Type"]="application/xml");return OpenLayers.Request.issue(a)},PUT:function(a){a=OpenLayers.Util.extend(a,{method:"PUT"});a.headers=a.headers?a.headers:{};"CONTENT-TYPE"in OpenLayers.Util.upperCaseObject(a.headers)||(a.headers["Content-Type"]="application/xml");return OpenLayers.Request.issue(a)},DELETE:function(a){a=OpenLayers.Util.extend(a,
{method:"DELETE"});return OpenLayers.Request.issue(a)},HEAD:function(a){a=OpenLayers.Util.extend(a,{method:"HEAD"});return OpenLayers.Request.issue(a)},OPTIONS:function(a){a=OpenLayers.Util.extend(a,{method:"OPTIONS"});return OpenLayers.Request.issue(a)}};
(function(){function a(){this._object=f&&!i?new f:new window.ActiveXObject("Microsoft.XMLHTTP");this._listeners=[]}function b(){return new a}function c(a){b.onreadystatechange&&b.onreadystatechange.apply(a);a.dispatchEvent({type:"readystatechange",bubbles:!1,cancelable:!1,timeStamp:new Date+0})}function d(a){try{a.responseText=a._object.responseText}catch(b){}try{var c=a._object,d=c.responseXML,e=c.responseText;if(h&&e&&d&&!d.documentElement&&c.getResponseHeader("Content-Type").match(/[^\/]+\/[^\+]+\+xml/))d=
new window.ActiveXObject("Microsoft.XMLDOM"),d.async=!1,d.validateOnParse=!1,d.loadXML(e);a.responseXML=d&&(h&&0!=d.parseError||!d.documentElement||d.documentElement&&"parsererror"==d.documentElement.tagName)?null:d}catch(f){}try{a.status=a._object.status}catch(g){}try{a.statusText=a._object.statusText}catch(i){}}function e(a){a._object.onreadystatechange=new window.Function}var f=window.XMLHttpRequest,g=!!window.controllers,h=window.document.all&&!window.opera,i=h&&window.navigator.userAgent.match(/MSIE 7.0/);
b.prototype=a.prototype;if(g&&f.wrapped)b.wrapped=f.wrapped;b.UNSENT=0;b.OPENED=1;b.HEADERS_RECEIVED=2;b.LOADING=3;b.DONE=4;b.prototype.readyState=b.UNSENT;b.prototype.responseText="";b.prototype.responseXML=null;b.prototype.status=0;b.prototype.statusText="";b.prototype.priority="NORMAL";b.prototype.onreadystatechange=null;b.onreadystatechange=null;b.onopen=null;b.onsend=null;b.onabort=null;b.prototype.open=function(a,f,i,r,m){delete this._headers;3>arguments.length&&(i=!0);this._async=i;var j=this,
p=this.readyState,l;h&&i&&(l=function(){p!=b.DONE&&(e(j),j.abort())},window.attachEvent("onunload",l));b.onopen&&b.onopen.apply(this,arguments);4<arguments.length?this._object.open(a,f,i,r,m):3<arguments.length?this._object.open(a,f,i,r):this._object.open(a,f,i);this.readyState=b.OPENED;c(this);this._object.onreadystatechange=function(){if(!g||i)j.readyState=j._object.readyState,d(j),j._aborted?j.readyState=b.UNSENT:(j.readyState==b.DONE&&(delete j._data,e(j),h&&i&&window.detachEvent("onunload",l)),
p!=j.readyState&&c(j),p=j.readyState)}};b.prototype.send=function(a){b.onsend&&b.onsend.apply(this,arguments);arguments.length||(a=null);a&&a.nodeType&&(a=window.XMLSerializer?(new window.XMLSerializer).serializeToString(a):a.xml,oRequest._headers["Content-Type"]||oRequest._object.setRequestHeader("Content-Type","application/xml"));this._data=a;this._object.send(this._data);if(g&&!this._async){this.readyState=b.OPENED;for(d(this);this.readyState<b.DONE&&!(this.readyState++,c(this),this._aborted););
}};b.prototype.abort=function(){b.onabort&&b.onabort.apply(this,arguments);if(this.readyState>b.UNSENT)this._aborted=!0;this._object.abort();e(this);this.readyState=b.UNSENT;delete this._data};b.prototype.getAllResponseHeaders=function(){return this._object.getAllResponseHeaders()};b.prototype.getResponseHeader=function(a){return this._object.getResponseHeader(a)};b.prototype.setRequestHeader=function(a,b){if(!this._headers)this._headers={};this._headers[a]=b;return this._object.setRequestHeader(a,
b)};b.prototype.addEventListener=function(a,b,c){for(var d=0,e;e=this._listeners[d];d++)if(e[0]==a&&e[1]==b&&e[2]==c)return;this._listeners.push([a,b,c])};b.prototype.removeEventListener=function(a,b,c){for(var d=0,e;(e=this._listeners[d])&&!(e[0]==a&&e[1]==b&&e[2]==c);d++);e&&this._listeners.splice(d,1)};b.prototype.dispatchEvent=function(a){a={type:a.type,target:this,currentTarget:this,eventPhase:2,bubbles:a.bubbles,cancelable:a.cancelable,timeStamp:a.timeStamp,stopPropagation:function(){},preventDefault:function(){},
initEvent:function(){}};"readystatechange"==a.type&&this.onreadystatechange&&(this.onreadystatechange.handleEvent||this.onreadystatechange).apply(this,[a]);for(var b=0,c;c=this._listeners[b];b++)c[0]==a.type&&!c[2]&&(c[1].handleEvent||c[1]).apply(this,[a])};b.prototype.toString=function(){return"[object XMLHttpRequest]"};b.toString=function(){return"[XMLHttpRequest]"};if(!window.Function.prototype.apply)window.Function.prototype.apply=function(a,b){b||(b=[]);a.__func=this;a.__func(b[0],b[1],b[2],
b[3],b[4]);delete a.__func};OpenLayers.Request.XMLHttpRequest=b})();OpenLayers.ProxyHost="";OpenLayers.nullHandler=function(a){OpenLayers.Console.userError(OpenLayers.i18n("unhandledRequest",{statusText:a.statusText}))};OpenLayers.loadURL=function(a,b,c,d,e){"string"==typeof b&&(b=OpenLayers.Util.getParameters(b));return OpenLayers.Request.GET({url:a,params:b,success:d?d:OpenLayers.nullHandler,failure:e?e:OpenLayers.nullHandler,scope:c})};
OpenLayers.parseXMLString=function(a){var b=a.indexOf("<");0<b&&(a=a.substring(b));return OpenLayers.Util.Try(function(){var b=new ActiveXObject("Microsoft.XMLDOM");b.loadXML(a);return b},function(){return(new DOMParser).parseFromString(a,"text/xml")},function(){var b=new XMLHttpRequest;b.open("GET","data:text/xml;charset=utf-8,"+encodeURIComponent(a),!1);b.overrideMimeType&&b.overrideMimeType("text/xml");b.send(null);return b.responseXML})};
OpenLayers.Ajax={emptyFunction:function(){},getTransport:function(){return OpenLayers.Util.Try(function(){return new XMLHttpRequest},function(){return new ActiveXObject("Msxml2.XMLHTTP")},function(){return new ActiveXObject("Microsoft.XMLHTTP")})||!1},activeRequestCount:0};
OpenLayers.Ajax.Responders={responders:[],register:function(a){for(var b=0;b<this.responders.length;b++)if(a==this.responders[b])return;this.responders.push(a)},unregister:function(a){OpenLayers.Util.removeItem(this.reponders,a)},dispatch:function(a,b,c){for(var d,e=0;e<this.responders.length;e++)if(d=this.responders[e],d[a]&&"function"==typeof d[a])try{d[a].apply(d,[b,c])}catch(f){}}};OpenLayers.Ajax.Responders.register({onCreate:function(){OpenLayers.Ajax.activeRequestCount++},onComplete:function(){OpenLayers.Ajax.activeRequestCount--}});
OpenLayers.Ajax.Base=OpenLayers.Class({initialize:function(a){this.options={method:"post",asynchronous:!0,contentType:"application/xml",parameters:""};OpenLayers.Util.extend(this.options,a||{});this.options.method=this.options.method.toLowerCase();if("string"==typeof this.options.parameters)this.options.parameters=OpenLayers.Util.getParameters(this.options.parameters)}});
OpenLayers.Ajax.Request=OpenLayers.Class(OpenLayers.Ajax.Base,{_complete:!1,initialize:function(a,b){OpenLayers.Ajax.Base.prototype.initialize.apply(this,[b]);OpenLayers.ProxyHost&&OpenLayers.String.startsWith(a,"http")&&(a=OpenLayers.ProxyHost+encodeURIComponent(a));this.transport=OpenLayers.Ajax.getTransport();this.request(a)},request:function(a){this.url=a;this.method=this.options.method;a=OpenLayers.Util.extend({},this.options.parameters);if("get"!=this.method&&"post"!=this.method)a._method=this.method,
this.method="post";this.parameters=a;if(a=OpenLayers.Util.getParameterString(a))"get"==this.method?this.url+=(-1<this.url.indexOf("?")?"&":"?")+a:/Konqueror|Safari|KHTML/.test(navigator.userAgent)&&(a+="&_=");try{var b=new OpenLayers.Ajax.Response(this);if(this.options.onCreate)this.options.onCreate(b);OpenLayers.Ajax.Responders.dispatch("onCreate",this,b);this.transport.open(this.method.toUpperCase(),this.url,this.options.asynchronous);this.options.asynchronous&&window.setTimeout(OpenLayers.Function.bind(this.respondToReadyState,
this,1),10);this.transport.onreadystatechange=OpenLayers.Function.bind(this.onStateChange,this);this.setRequestHeaders();this.body="post"==this.method?this.options.postBody||a:null;this.transport.send(this.body);if(!this.options.asynchronous&&this.transport.overrideMimeType)this.onStateChange()}catch(c){this.dispatchException(c)}},onStateChange:function(){var a=this.transport.readyState;1<a&&!(4==a&&this._complete)&&this.respondToReadyState(this.transport.readyState)},setRequestHeaders:function(){var a=
{"X-Requested-With":"XMLHttpRequest",Accept:"text/javascript, text/html, application/xml, text/xml, */*",OpenLayers:!0};if("post"==this.method&&(a["Content-type"]=this.options.contentType+(this.options.encoding?"; charset="+this.options.encoding:""),this.transport.overrideMimeType&&2005>(navigator.userAgent.match(/Gecko\/(\d{4})/)||[0,2005])[1]))a.Connection="close";if("object"==typeof this.options.requestHeaders){var b=this.options.requestHeaders;if("function"==typeof b.push)for(var c=0,d=b.length;c<
d;c+=2)a[b[c]]=b[c+1];else for(c in b)a[c]=b[c]}for(var e in a)this.transport.setRequestHeader(e,a[e])},success:function(){var a=this.getStatus();return!a||200<=a&&300>a},getStatus:function(){try{return this.transport.status||0}catch(a){return 0}},respondToReadyState:function(a){var a=OpenLayers.Ajax.Request.Events[a],b=new OpenLayers.Ajax.Response(this);if("Complete"==a){try{this._complete=!0,(this.options["on"+b.status]||this.options["on"+(this.success()?"Success":"Failure")]||OpenLayers.Ajax.emptyFunction)(b)}catch(c){this.dispatchException(c)}b.getHeader("Content-type")}try{(this.options["on"+
a]||OpenLayers.Ajax.emptyFunction)(b),OpenLayers.Ajax.Responders.dispatch("on"+a,this,b)}catch(d){this.dispatchException(d)}if("Complete"==a)this.transport.onreadystatechange=OpenLayers.Ajax.emptyFunction},getHeader:function(a){try{return this.transport.getResponseHeader(a)}catch(b){return null}},dispatchException:function(a){var b=this.options.onException;if(b)b(this,a),OpenLayers.Ajax.Responders.dispatch("onException",this,a);else{for(var b=!1,c=OpenLayers.Ajax.Responders.responders,d=0;d<c.length;d++)if(c[d].onException){b=
!0;break}if(b)OpenLayers.Ajax.Responders.dispatch("onException",this,a);else throw a;}}});OpenLayers.Ajax.Request.Events=["Uninitialized","Loading","Loaded","Interactive","Complete"];
OpenLayers.Ajax.Response=OpenLayers.Class({status:0,statusText:"",initialize:function(a){this.request=a;var a=this.transport=a.transport,b=this.readyState=a.readyState;if(2<b&&(!window.attachEvent||window.opera)||4==b)this.status=this.getStatus(),this.statusText=this.getStatusText(),this.responseText=null==a.responseText?"":""+a.responseText;if(4==b)a=a.responseXML,this.responseXML=void 0===a?null:a},getStatus:OpenLayers.Ajax.Request.prototype.getStatus,getStatusText:function(){try{return this.transport.statusText||
""}catch(a){return""}},getHeader:OpenLayers.Ajax.Request.prototype.getHeader,getResponseHeader:function(a){return this.transport.getResponseHeader(a)}});OpenLayers.Ajax.getElementsByTagNameNS=function(a,b,c,d){var e=null;return e=a.getElementsByTagNameNS?a.getElementsByTagNameNS(b,d):a.getElementsByTagName(c+":"+d)};OpenLayers.Ajax.serializeXMLToString=function(a){return(new XMLSerializer).serializeToString(a)};OpenLayers.Rico=OpenLayers.Rico||{};
OpenLayers.Rico.Color=OpenLayers.Class({initialize:function(a,b,c){this.rgb={r:a,g:b,b:c}},setRed:function(a){this.rgb.r=a},setGreen:function(a){this.rgb.g=a},setBlue:function(a){this.rgb.b=a},setHue:function(a){var b=this.asHSB();b.h=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},setSaturation:function(a){var b=this.asHSB();b.s=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},setBrightness:function(a){var b=this.asHSB();b.b=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},
darken:function(a){var b=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,Math.max(b.b-a,0))},brighten:function(a){var b=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,Math.min(b.b+a,1))},blend:function(a){this.rgb.r=Math.floor((this.rgb.r+a.rgb.r)/2);this.rgb.g=Math.floor((this.rgb.g+a.rgb.g)/2);this.rgb.b=Math.floor((this.rgb.b+a.rgb.b)/2)},isBright:function(){this.asHSB();return 0.5<this.asHSB().b},isDark:function(){return!this.isBright()},asRGB:function(){return"rgb("+
this.rgb.r+","+this.rgb.g+","+this.rgb.b+")"},asHex:function(){return"#"+this.rgb.r.toColorPart()+this.rgb.g.toColorPart()+this.rgb.b.toColorPart()},asHSB:function(){return OpenLayers.Rico.Color.RGBtoHSB(this.rgb.r,this.rgb.g,this.rgb.b)},toString:function(){return this.asHex()}});
OpenLayers.Rico.Color.createFromHex=function(a){if(4==a.length)for(var b=a,a="#",c=1;4>c;c++)a+=b.charAt(c)+b.charAt(c);0==a.indexOf("#")&&(a=a.substring(1));b=a.substring(0,2);c=a.substring(2,4);a=a.substring(4,6);return new OpenLayers.Rico.Color(parseInt(b,16),parseInt(c,16),parseInt(a,16))};
OpenLayers.Rico.Color.createColorFromBackground=function(a){var b=OpenLayers.Element.getStyle(OpenLayers.Util.getElement(a),"backgroundColor");if("transparent"==b&&a.parentNode)return OpenLayers.Rico.Color.createColorFromBackground(a.parentNode);if(null==b)return new OpenLayers.Rico.Color(255,255,255);return 0==b.indexOf("rgb(")?(a=b.substring(4,b.length-1).split(","),new OpenLayers.Rico.Color(parseInt(a[0]),parseInt(a[1]),parseInt(a[2]))):0==b.indexOf("#")?OpenLayers.Rico.Color.createFromHex(b):
new OpenLayers.Rico.Color(255,255,255)};
OpenLayers.Rico.Color.HSBtoRGB=function(a,b,c){var d=0,e=0,f=0;if(0==b)f=e=d=parseInt(255*c+0.5);else{var a=6*(a-Math.floor(a)),g=a-Math.floor(a),h=c*(1-b),i=c*(1-b*g),b=c*(1-b*(1-g));switch(parseInt(a)){case 0:d=255*c+0.5;e=255*b+0.5;f=255*h+0.5;break;case 1:d=255*i+0.5;e=255*c+0.5;f=255*h+0.5;break;case 2:d=255*h+0.5;e=255*c+0.5;f=255*b+0.5;break;case 3:d=255*h+0.5;e=255*i+0.5;f=255*c+0.5;break;case 4:d=255*b+0.5;e=255*h+0.5;f=255*c+0.5;break;case 5:d=255*c+0.5,e=255*h+0.5,f=255*i+0.5}}return{r:parseInt(d),
g:parseInt(e),b:parseInt(f)}};OpenLayers.Rico.Color.RGBtoHSB=function(a,b,c){var d,e=a>b?a:b;c>e&&(e=c);var f=a<b?a:b;c<f&&(f=c);d=0!=e?(e-f)/e:0;if(0==d)a=0;else{var g=(e-a)/(e-f),h=(e-b)/(e-f),c=(e-c)/(e-f),a=(a==e?c-h:b==e?2+g-c:4+h-g)/6;0>a&&(a+=1)}return{h:a,s:d,b:e/255}};
OpenLayers.Control=OpenLayers.Class({id:null,map:null,div:null,type:null,allowSelection:!1,displayClass:"",title:"",autoActivate:!1,active:null,handler:null,eventListeners:null,events:null,EVENT_TYPES:["activate","deactivate"],initialize:function(a){this.displayClass=this.CLASS_NAME.replace("OpenLayers.","ol").replace(/\./g,"");OpenLayers.Util.extend(this,a);this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);if(this.eventListeners instanceof Object)this.events.on(this.eventListeners);if(null==
this.id)this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){if(this.events)this.eventListeners&&this.events.un(this.eventListeners),this.events.destroy(),this.events=null;this.eventListeners=null;if(this.handler)this.handler.destroy(),this.handler=null;if(this.handlers){for(var a in this.handlers)this.handlers.hasOwnProperty(a)&&"function"==typeof this.handlers[a].destroy&&this.handlers[a].destroy();this.handlers=null}if(this.map)this.map.removeControl(this),this.map=null;
this.div=null},setMap:function(a){this.map=a;this.handler&&this.handler.setMap(a)},draw:function(a){if(null==this.div){this.div=OpenLayers.Util.createDiv(this.id);this.div.className=this.displayClass;if(!this.allowSelection)this.div.className+=" olControlNoSelect",this.div.setAttribute("unselectable","on",0),this.div.onselectstart=OpenLayers.Function.False;if(""!=this.title)this.div.title=this.title}if(null!=a)this.position=a.clone();this.moveTo(this.position);return this.div},moveTo:function(a){if(null!=
a&&null!=this.div)this.div.style.left=a.x+"px",this.div.style.top=a.y+"px"},activate:function(){if(this.active)return!1;this.handler&&this.handler.activate();this.active=!0;this.map&&OpenLayers.Element.addClass(this.map.viewPortDiv,this.displayClass.replace(/ /g,"")+"Active");this.events.triggerEvent("activate");return!0},deactivate:function(){return this.active?(this.handler&&this.handler.deactivate(),this.active=!1,this.map&&OpenLayers.Element.removeClass(this.map.viewPortDiv,this.displayClass.replace(/ /g,
"")+"Active"),this.events.triggerEvent("deactivate"),!0):!1},CLASS_NAME:"OpenLayers.Control"});OpenLayers.Control.TYPE_BUTTON=1;OpenLayers.Control.TYPE_TOGGLE=2;OpenLayers.Control.TYPE_TOOL=3;
OpenLayers.Control.PanZoom=OpenLayers.Class(OpenLayers.Control,{slideFactor:50,slideRatio:null,buttons:null,position:null,initialize:function(a){this.position=new OpenLayers.Pixel(OpenLayers.Control.PanZoom.X,OpenLayers.Control.PanZoom.Y);OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.removeButtons();this.position=this.buttons=null;OpenLayers.Control.prototype.destroy.apply(this,arguments)},draw:function(a){OpenLayers.Control.prototype.draw.apply(this,arguments);
a=this.position;this.buttons=[];var b=new OpenLayers.Size(18,18),c=new OpenLayers.Pixel(a.x+b.w/2,a.y);this._addButton("panup","north-mini.png",c,b);a.y=c.y+b.h;this._addButton("panleft","west-mini.png",a,b);this._addButton("panright","east-mini.png",a.add(b.w,0),b);this._addButton("pandown","south-mini.png",c.add(0,2*b.h),b);this._addButton("zoomin","zoom-plus-mini.png",c.add(0,3*b.h+5),b);this._addButton("zoomworld","zoom-world-mini.png",c.add(0,4*b.h+5),b);this._addButton("zoomout","zoom-minus-mini.png",
c.add(0,5*b.h+5),b);return this.div},_addButton:function(a,b,c,d){b=OpenLayers.Util.getImagesLocation()+b;c=OpenLayers.Util.createAlphaImageDiv(this.id+"_"+a,c,d,b,"absolute");c.style.cursor="pointer";this.div.appendChild(c);OpenLayers.Event.observe(c,"mousedown",OpenLayers.Function.bindAsEventListener(this.buttonDown,c));OpenLayers.Event.observe(c,"dblclick",OpenLayers.Function.bindAsEventListener(this.doubleClick,c));OpenLayers.Event.observe(c,"click",OpenLayers.Function.bindAsEventListener(this.doubleClick,
c));c.action=a;c.map=this.map;if(this.slideRatio)var e=this.slideRatio,a=function(a){return this.map.getSize()[a]*e};else var f=this.slideFactor,a=function(){return f};c.getSlideFactor=a;this.buttons.push(c);return c},_removeButton:function(a){OpenLayers.Event.stopObservingElement(a);a.map=null;a.getSlideFactor=null;this.div.removeChild(a);OpenLayers.Util.removeItem(this.buttons,a)},removeButtons:function(){for(var a=this.buttons.length-1;0<=a;--a)this._removeButton(this.buttons[a])},doubleClick:function(a){OpenLayers.Event.stop(a);
return!1},buttonDown:function(a){if(OpenLayers.Event.isLeftClick(a)){switch(this.action){case "panup":this.map.pan(0,-this.getSlideFactor("h"));break;case "pandown":this.map.pan(0,this.getSlideFactor("h"));break;case "panleft":this.map.pan(-this.getSlideFactor("w"),0);break;case "panright":this.map.pan(this.getSlideFactor("w"),0);break;case "zoomin":this.map.zoomIn();break;case "zoomout":this.map.zoomOut();break;case "zoomworld":this.map.zoomToMaxExtent()}OpenLayers.Event.stop(a)}},CLASS_NAME:"OpenLayers.Control.PanZoom"});
OpenLayers.Control.PanZoom.X=4;OpenLayers.Control.PanZoom.Y=4;
OpenLayers.Control.PanZoomBar=OpenLayers.Class(OpenLayers.Control.PanZoom,{zoomStopWidth:18,zoomStopHeight:11,slider:null,sliderEvents:null,zoombarDiv:null,divEvents:null,zoomWorldIcon:!1,panIcons:!0,forceFixedZoomLevel:!1,mouseDragStart:null,deltaY:null,zoomStart:null,destroy:function(){this._removeZoomBar();this.map.events.un({changebaselayer:this.redraw,scope:this});OpenLayers.Control.PanZoom.prototype.destroy.apply(this,arguments);delete this.mouseDragStart;delete this.zoomStart},setMap:function(a){OpenLayers.Control.PanZoom.prototype.setMap.apply(this,
arguments);this.map.events.register("changebaselayer",this,this.redraw)},redraw:function(){null!=this.div&&(this.removeButtons(),this._removeZoomBar());this.draw()},draw:function(a){OpenLayers.Control.prototype.draw.apply(this,arguments);a=this.position.clone();this.buttons=[];var b=new OpenLayers.Size(18,18);if(this.panIcons){var c=new OpenLayers.Pixel(a.x+b.w/2,a.y),d=b.w;this.zoomWorldIcon&&(c=new OpenLayers.Pixel(a.x+b.w,a.y));this._addButton("panup","north-mini.png",c,b);a.y=c.y+b.h;this._addButton("panleft",
"west-mini.png",a,b);this.zoomWorldIcon&&(this._addButton("zoomworld","zoom-world-mini.png",a.add(b.w,0),b),d*=2);this._addButton("panright","east-mini.png",a.add(d,0),b);this._addButton("pandown","south-mini.png",c.add(0,2*b.h),b);this._addButton("zoomin","zoom-plus-mini.png",c.add(0,3*b.h+5),b);c=this._addZoomBar(c.add(0,4*b.h+5));this._addButton("zoomout","zoom-minus-mini.png",c,b)}else this._addButton("zoomin","zoom-plus-mini.png",a,b),c=this._addZoomBar(a.add(0,b.h)),this._addButton("zoomout",
"zoom-minus-mini.png",c,b),this.zoomWorldIcon&&(c=c.add(0,b.h+3),this._addButton("zoomworld","zoom-world-mini.png",c,b));return this.div},_addZoomBar:function(a){var b=OpenLayers.Util.getImagesLocation(),c=this.id+"_"+this.map.id,d=this.map.getNumZoomLevels()-1-this.map.getZoom(),d=OpenLayers.Util.createAlphaImageDiv(c,a.add(-1,d*this.zoomStopHeight),new OpenLayers.Size(20,9),b+"slider.png","absolute");d.style.cursor="move";this.slider=d;this.sliderEvents=new OpenLayers.Events(this,d,null,!0,{includeXY:!0});
this.sliderEvents.on({touchstart:this.zoomBarDown,touchmove:this.zoomBarDrag,touchend:this.zoomBarUp,mousedown:this.zoomBarDown,mousemove:this.zoomBarDrag,mouseup:this.zoomBarUp,dblclick:this.doubleClick,click:this.doubleClick});var e=new OpenLayers.Size;e.h=this.zoomStopHeight*this.map.getNumZoomLevels();e.w=this.zoomStopWidth;c=null;OpenLayers.Util.alphaHack()?(c=this.id+"_"+this.map.id,c=OpenLayers.Util.createAlphaImageDiv(c,a,new OpenLayers.Size(e.w,this.zoomStopHeight),b+"zoombar.png","absolute",
null,"crop"),c.style.height=e.h+"px"):c=OpenLayers.Util.createDiv("OpenLayers_Control_PanZoomBar_Zoombar"+this.map.id,a,e,b+"zoombar.png");c.style.cursor="pointer";this.zoombarDiv=c;this.divEvents=new OpenLayers.Events(this,c,null,!0,{includeXY:!0});this.divEvents.on({touchmove:this.passEventToSlider,mousedown:this.divClick,mousemove:this.passEventToSlider,dblclick:this.doubleClick,click:this.doubleClick});this.div.appendChild(c);this.startTop=parseInt(c.style.top);this.div.appendChild(d);this.map.events.register("zoomend",
this,this.moveZoomBar);return a=a.add(0,this.zoomStopHeight*this.map.getNumZoomLevels())},_removeZoomBar:function(){this.sliderEvents.un({touchmove:this.zoomBarDrag,mousedown:this.zoomBarDown,mousemove:this.zoomBarDrag,mouseup:this.zoomBarUp,dblclick:this.doubleClick,click:this.doubleClick});this.sliderEvents.destroy();this.divEvents.un({touchmove:this.passEventToSlider,mousedown:this.divClick,mousemove:this.passEventToSlider,dblclick:this.doubleClick,click:this.doubleClick});this.divEvents.destroy();
this.div.removeChild(this.zoombarDiv);this.zoombarDiv=null;this.div.removeChild(this.slider);this.slider=null;this.map.events.unregister("zoomend",this,this.moveZoomBar)},passEventToSlider:function(a){this.sliderEvents.handleBrowserEvent(a)},divClick:function(a){if(OpenLayers.Event.isLeftClick(a)){var b=a.xy.y/this.zoomStopHeight;if(this.forceFixedZoomLevel||!this.map.fractionalZoom)b=Math.floor(b);b=this.map.getNumZoomLevels()-1-b;b=Math.min(Math.max(b,0),this.map.getNumZoomLevels()-1);this.map.zoomTo(b);
OpenLayers.Event.stop(a)}},zoomBarDown:function(a){if(OpenLayers.Event.isLeftClick(a)||OpenLayers.Event.isSingleTouch(a))this.map.events.on({touchmove:this.passEventToSlider,mousemove:this.passEventToSlider,mouseup:this.passEventToSlider,scope:this}),this.mouseDragStart=a.xy.clone(),this.zoomStart=a.xy.clone(),this.div.style.cursor="move",this.zoombarDiv.offsets=null,OpenLayers.Event.stop(a)},zoomBarDrag:function(a){if(null!=this.mouseDragStart){var b=this.mouseDragStart.y-a.xy.y,c=OpenLayers.Util.pagePosition(this.zoombarDiv);
if(0<a.clientY-c[1]&&a.clientY-c[1]<parseInt(this.zoombarDiv.style.height)-2)this.slider.style.top=parseInt(this.slider.style.top)-b+"px",this.mouseDragStart=a.xy.clone();this.deltaY=this.zoomStart.y-a.xy.y;OpenLayers.Event.stop(a)}},zoomBarUp:function(a){if((OpenLayers.Event.isLeftClick(a)||"touchend"===a.type)&&this.mouseDragStart){this.div.style.cursor="";this.map.events.un({touchmove:this.passEventToSlider,mouseup:this.passEventToSlider,mousemove:this.passEventToSlider,scope:this});var b=this.map.zoom;
!this.forceFixedZoomLevel&&this.map.fractionalZoom?(b+=this.deltaY/this.zoomStopHeight,b=Math.min(Math.max(b,0),this.map.getNumZoomLevels()-1)):(b+=this.deltaY/this.zoomStopHeight,b=Math.max(Math.round(b),0));this.map.zoomTo(b);this.zoomStart=this.mouseDragStart=null;this.deltaY=0;OpenLayers.Event.stop(a)}},moveZoomBar:function(){this.slider.style.top=(this.map.getNumZoomLevels()-1-this.map.getZoom())*this.zoomStopHeight+this.startTop+1+"px"},CLASS_NAME:"OpenLayers.Control.PanZoomBar"});
OpenLayers.Handler=OpenLayers.Class({id:null,control:null,map:null,keyMask:null,active:!1,evt:null,initialize:function(a,b,c){OpenLayers.Util.extend(this,c);this.control=a;this.callbacks=b;(a=this.map||a.map)&&this.setMap(a);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},setMap:function(a){this.map=a},checkModifiers:function(a){return null==this.keyMask?!0:((a.shiftKey?OpenLayers.Handler.MOD_SHIFT:0)|(a.ctrlKey?OpenLayers.Handler.MOD_CTRL:0)|(a.altKey?OpenLayers.Handler.MOD_ALT:0))==
this.keyMask},activate:function(){if(this.active)return!1;for(var a=OpenLayers.Events.prototype.BROWSER_EVENTS,b=0,c=a.length;b<c;b++)this[a[b]]&&this.register(a[b],this[a[b]]);return this.active=!0},deactivate:function(){if(!this.active)return!1;for(var a=OpenLayers.Events.prototype.BROWSER_EVENTS,b=0,c=a.length;b<c;b++)this[a[b]]&&this.unregister(a[b],this[a[b]]);this.active=!1;return!0},callback:function(a,b){a&&this.callbacks[a]&&this.callbacks[a].apply(this.control,b)},register:function(a,b){this.map.events.registerPriority(a,
this,b);this.map.events.registerPriority(a,this,this.setEvent)},unregister:function(a,b){this.map.events.unregister(a,this,b);this.map.events.unregister(a,this,this.setEvent)},setEvent:function(a){this.evt=a;return!0},destroy:function(){this.deactivate();this.control=this.map=null},CLASS_NAME:"OpenLayers.Handler"});OpenLayers.Handler.MOD_NONE=0;OpenLayers.Handler.MOD_SHIFT=1;OpenLayers.Handler.MOD_CTRL=2;OpenLayers.Handler.MOD_ALT=4;
OpenLayers.Handler.Drag=OpenLayers.Class(OpenLayers.Handler,{started:!1,stopDown:!0,dragging:!1,touch:!1,last:null,start:null,lastMoveEvt:null,oldOnselectstart:null,interval:0,timeoutId:null,documentDrag:!1,documentEvents:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments);if(!0===this.documentDrag){var d=this;this._docMove=function(a){d.mousemove({xy:{x:a.clientX,y:a.clientY},element:document})};this._docUp=function(a){d.mouseup({xy:{x:a.clientX,y:a.clientY}})}}},
dragstart:function(a){var b=!0;this.dragging=!1;if(this.checkModifiers(a)&&(OpenLayers.Event.isLeftClick(a)||OpenLayers.Event.isSingleTouch(a))){this.started=!0;this.last=this.start=a.xy;OpenLayers.Element.addClass(this.map.viewPortDiv,"olDragDown");this.down(a);this.callback("down",[a.xy]);OpenLayers.Event.stop(a);if(!this.oldOnselectstart)this.oldOnselectstart=document.onselectstart?document.onselectstart:OpenLayers.Function.True;document.onselectstart=OpenLayers.Function.False;b=!this.stopDown}else this.started=
!1,this.last=this.start=null;return b},dragmove:function(a){this.lastMoveEvt=a;if(this.started&&!this.timeoutId&&(a.xy.x!=this.last.x||a.xy.y!=this.last.y)){!0===this.documentDrag&&this.documentEvents&&(a.element===document?(this.adjustXY(a),this.setEvent(a)):this.removeDocumentEvents());if(0<this.interval)this.timeoutId=setTimeout(OpenLayers.Function.bind(this.removeTimeout,this),this.interval);this.dragging=!0;this.move(a);this.callback("move",[a.xy]);if(!this.oldOnselectstart)this.oldOnselectstart=
document.onselectstart,document.onselectstart=OpenLayers.Function.False;this.last=a.xy}return!0},dragend:function(a){if(this.started){!0===this.documentDrag&&this.documentEvents&&(this.adjustXY(a),this.removeDocumentEvents());var b=this.start!=this.last;this.dragging=this.started=!1;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");this.up(a);this.callback("up",[a.xy]);b&&this.callback("done",[a.xy]);document.onselectstart=this.oldOnselectstart}return!0},down:function(){},move:function(){},
up:function(){},out:function(){},mousedown:function(a){return this.dragstart(a)},touchstart:function(a){if(!this.touch)this.touch=!0,this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,mousemove:this.mousemove,click:this.click,scope:this});return this.dragstart(a)},mousemove:function(a){return this.dragmove(a)},touchmove:function(a){return this.dragmove(a)},removeTimeout:function(){this.timeoutId=null;this.dragging&&this.mousemove(this.lastMoveEvt)},mouseup:function(a){return this.dragend(a)},
touchend:function(a){a.xy=this.last;return this.dragend(a)},mouseout:function(a){if(this.started&&OpenLayers.Util.mouseLeft(a,this.map.eventsDiv))if(!0===this.documentDrag)this.addDocumentEvents();else{var b=this.start!=this.last;this.dragging=this.started=!1;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");this.out(a);this.callback("out",[]);b&&this.callback("done",[a.xy]);if(document.onselectstart)document.onselectstart=this.oldOnselectstart}return!0},click:function(){return this.start==
this.last},activate:function(){var a=!1;if(OpenLayers.Handler.prototype.activate.apply(this,arguments))this.dragging=!1,a=!0;return a},deactivate:function(){var a=!1;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments))this.dragging=this.started=this.touch=!1,this.last=this.start=null,a=!0,OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");return a},adjustXY:function(a){var b=OpenLayers.Util.pagePosition(this.map.viewPortDiv);a.xy.x-=b[0];a.xy.y-=b[1]},addDocumentEvents:function(){OpenLayers.Element.addClass(document.body,
"olDragDown");this.documentEvents=!0;OpenLayers.Event.observe(document,"mousemove",this._docMove);OpenLayers.Event.observe(document,"mouseup",this._docUp)},removeDocumentEvents:function(){OpenLayers.Element.removeClass(document.body,"olDragDown");this.documentEvents=!1;OpenLayers.Event.stopObserving(document,"mousemove",this._docMove);OpenLayers.Event.stopObserving(document,"mouseup",this._docUp)},CLASS_NAME:"OpenLayers.Handler.Drag"});
OpenLayers.Handler.Box=OpenLayers.Class(OpenLayers.Handler,{dragHandler:null,boxDivClassName:"olHandlerBoxZoomBox",boxOffsets:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.dragHandler=new OpenLayers.Handler.Drag(this,{down:this.startBox,move:this.moveBox,out:this.removeBox,up:this.endBox},{keyMask:this.keyMask})},destroy:function(){OpenLayers.Handler.prototype.destroy.apply(this,arguments);if(this.dragHandler)this.dragHandler.destroy(),this.dragHandler=
null},setMap:function(a){OpenLayers.Handler.prototype.setMap.apply(this,arguments);this.dragHandler&&this.dragHandler.setMap(a)},startBox:function(){this.callback("start",[]);this.zoomBox=OpenLayers.Util.createDiv("zoomBox",new OpenLayers.Pixel(-9999,-9999));this.zoomBox.className=this.boxDivClassName;this.zoomBox.style.zIndex=this.map.Z_INDEX_BASE.Popup-1;this.map.eventsDiv.appendChild(this.zoomBox);OpenLayers.Element.addClass(this.map.eventsDiv,"olDrawBox")},moveBox:function(a){var b=this.dragHandler.start.x,
c=this.dragHandler.start.y,d=Math.abs(b-a.x),e=Math.abs(c-a.y),f=this.getBoxOffsets();this.zoomBox.style.width=d+f.width+1+"px";this.zoomBox.style.height=e+f.height+1+"px";this.zoomBox.style.left=(a.x<b?b-d-f.left:b-f.left)+"px";this.zoomBox.style.top=(a.y<c?c-e-f.top:c-f.top)+"px"},endBox:function(a){var b;if(5<Math.abs(this.dragHandler.start.x-a.x)||5<Math.abs(this.dragHandler.start.y-a.y)){var c=this.dragHandler.start;b=Math.min(c.y,a.y);var d=Math.max(c.y,a.y),e=Math.min(c.x,a.x),a=Math.max(c.x,
a.x);b=new OpenLayers.Bounds(e,d,a,b)}else b=this.dragHandler.start.clone();this.removeBox();this.callback("done",[b])},removeBox:function(){this.map.eventsDiv.removeChild(this.zoomBox);this.boxOffsets=this.zoomBox=null;OpenLayers.Element.removeClass(this.map.eventsDiv,"olDrawBox")},activate:function(){return OpenLayers.Handler.prototype.activate.apply(this,arguments)?(this.dragHandler.activate(),!0):!1},deactivate:function(){return OpenLayers.Handler.prototype.deactivate.apply(this,arguments)?(this.dragHandler.deactivate()&&
this.zoomBox&&this.removeBox(),!0):!1},getBoxOffsets:function(){if(!this.boxOffsets){var a=document.createElement("div");a.style.position="absolute";a.style.border="1px solid black";a.style.width="3px";document.body.appendChild(a);var b=3==a.clientWidth;document.body.removeChild(a);var a=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-left-width")),c=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-right-width")),d=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-top-width")),
e=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-bottom-width"));this.boxOffsets={left:a,right:c,top:d,bottom:e,width:!1===b?a+c:0,height:!1===b?d+e:0}}return this.boxOffsets},CLASS_NAME:"OpenLayers.Handler.Box"});
OpenLayers.Control.ZoomBox=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,out:!1,alwaysZoom:!1,draw:function(){this.handler=new OpenLayers.Handler.Box(this,{done:this.zoomBox},{keyMask:this.keyMask})},zoomBox:function(a){if(a instanceof OpenLayers.Bounds){var b;if(this.out){b=Math.abs(a.right-a.left);var c=Math.abs(a.top-a.bottom);b=Math.min(this.map.size.h/c,this.map.size.w/b);var c=this.map.getExtent(),d=this.map.getLonLatFromPixel(a.getCenterPixel()),a=d.lon-c.getWidth()/
2*b,e=d.lon+c.getWidth()/2*b,f=d.lat-c.getHeight()/2*b;b=d.lat+c.getHeight()/2*b;b=new OpenLayers.Bounds(a,f,e,b)}else b=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom)),c=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top)),b=new OpenLayers.Bounds(b.lon,b.lat,c.lon,c.lat);c=this.map.getZoom();this.map.zoomToExtent(b);c==this.map.getZoom()&&!0==this.alwaysZoom&&this.map.zoomTo(c+(this.out?-1:1))}else this.out?this.map.setCenter(this.map.getLonLatFromPixel(a),this.map.getZoom()-
1):this.map.setCenter(this.map.getLonLatFromPixel(a),this.map.getZoom()+1)},CLASS_NAME:"OpenLayers.Control.ZoomBox"});
OpenLayers.Control.DragPan=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,panned:!1,interval:1,documentDrag:!1,kinetic:null,enableKinetic:!1,kineticInterval:10,draw:function(){if(this.enableKinetic){var a={interval:this.kineticInterval};"object"===typeof this.enableKinetic&&(a=OpenLayers.Util.extend(a,this.enableKinetic));this.kinetic=new OpenLayers.Kinetic(a)}this.handler=new OpenLayers.Handler.Drag(this,{move:this.panMap,done:this.panMapDone,down:this.panMapStart},{interval:this.interval,
documentDrag:this.documentDrag})},panMapStart:function(){this.kinetic&&this.kinetic.begin()},panMap:function(a){this.kinetic&&this.kinetic.update(a);this.panned=!0;this.map.pan(this.handler.last.x-a.x,this.handler.last.y-a.y,{dragging:!0,animate:!1})},panMapDone:function(a){if(this.panned){var b=null;this.kinetic&&(b=this.kinetic.end(a));this.map.pan(this.handler.last.x-a.x,this.handler.last.y-a.y,{dragging:!!b,animate:!1});if(b){var c=this;this.kinetic.move(b,function(a,b,f){c.map.pan(a,b,{dragging:!f,
animate:!1})})}this.panned=!1}},CLASS_NAME:"OpenLayers.Control.DragPan"});
OpenLayers.Handler.MouseWheel=OpenLayers.Class(OpenLayers.Handler,{wheelListener:null,mousePosition:null,interval:0,delta:0,cumulative:!0,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.wheelListener=OpenLayers.Function.bindAsEventListener(this.onWheelEvent,this)},destroy:function(){OpenLayers.Handler.prototype.destroy.apply(this,arguments);this.wheelListener=null},onWheelEvent:function(a){if(this.map&&this.checkModifiers(a)){for(var b=!1,c=!1,d=!1,e=
OpenLayers.Event.element(a);null!=e&&!d&&!b;){if(!b)try{var f=e.currentStyle?e.currentStyle.overflow:document.defaultView.getComputedStyle(e,null).getPropertyValue("overflow"),b=f&&"auto"==f||"scroll"==f}catch(g){}if(!c)for(var d=0,h=this.map.layers.length;d<h;d++)if(e==this.map.layers[d].div||e==this.map.layers[d].pane){c=!0;break}d=e==this.map.div;e=e.parentNode}if(!b&&d){if(c){b=0;if(!a)a=window.event;a.wheelDelta?(b=a.wheelDelta/120,window.opera&&9.2>window.opera.version()&&(b=-b)):a.detail&&
(b=-a.detail/3);this.delta+=b;this.interval?(window.clearTimeout(this._timeoutId),this._timeoutId=window.setTimeout(OpenLayers.Function.bind(function(){this.wheelZoom(a)},this),this.interval)):this.wheelZoom(a)}OpenLayers.Event.stop(a)}}},wheelZoom:function(a){var b=this.delta;this.delta=0;if(b){if(this.mousePosition)a.xy=this.mousePosition;if(!a.xy)a.xy=this.map.getPixelFromLonLat(this.map.getCenter());0>b?this.callback("down",[a,this.cumulative?b:-1]):this.callback("up",[a,this.cumulative?b:1])}},
mousemove:function(a){this.mousePosition=a.xy},activate:function(a){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){var b=this.wheelListener;OpenLayers.Event.observe(window,"DOMMouseScroll",b);OpenLayers.Event.observe(window,"mousewheel",b);OpenLayers.Event.observe(document,"mousewheel",b);return!0}return!1},deactivate:function(a){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){var b=this.wheelListener;OpenLayers.Event.stopObserving(window,"DOMMouseScroll",b);OpenLayers.Event.stopObserving(window,
"mousewheel",b);OpenLayers.Event.stopObserving(document,"mousewheel",b);return!0}return!1},CLASS_NAME:"OpenLayers.Handler.MouseWheel"});
OpenLayers.Handler.Click=OpenLayers.Class(OpenLayers.Handler,{delay:300,single:!0,"double":!1,pixelTolerance:0,dblclickTolerance:13,stopSingle:!1,stopDouble:!1,timerId:null,touch:!1,down:null,last:null,first:null,rightclickTimerId:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments)},touchstart:function(a){if(!this.touch)this.unregisterMouseListeners(),this.touch=!0;this.down=this.getEventInfo(a);this.last=this.getEventInfo(a);return!0},touchmove:function(a){this.last=
this.getEventInfo(a);return!0},touchend:function(a){if(this.down)a.xy=this.last.xy,a.lastTouches=this.last.touches,this.handleSingle(a),this.down=null;return!0},unregisterMouseListeners:function(){this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,click:this.click,dblclick:this.dblclick,scope:this})},mousedown:function(a){this.down=this.getEventInfo(a);this.last=this.getEventInfo(a);return!0},mouseup:function(a){var b=!0;this.checkModifiers(a)&&this.control.handleRightClicks&&OpenLayers.Event.isRightClick(a)&&
(b=this.rightclick(a));return b},rightclick:function(a){if(this.passesTolerance(a)){if(null!=this.rightclickTimerId)return this.clearTimer(),this.callback("dblrightclick",[a]),!this.stopDouble;a=this["double"]?OpenLayers.Util.extend({},a):this.callback("rightclick",[a]);a=OpenLayers.Function.bind(this.delayedRightCall,this,a);this.rightclickTimerId=window.setTimeout(a,this.delay)}return!this.stopSingle},delayedRightCall:function(a){this.rightclickTimerId=null;a&&this.callback("rightclick",[a])},click:function(a){if(!this.last)this.last=
this.getEventInfo(a);this.handleSingle(a);return!this.stopSingle},dblclick:function(a){this.handleDouble(a);return!this.stopDouble},handleDouble:function(a){this["double"]&&this.passesDblclickTolerance(a)&&this.callback("dblclick",[a])},handleSingle:function(a){if(this.passesTolerance(a))null!=this.timerId?(this.last.touches&&1===this.last.touches.length&&(this["double"]&&OpenLayers.Event.stop(a),this.handleDouble(a)),(!this.last.touches||2!==this.last.touches.length)&&this.clearTimer()):(this.first=
this.getEventInfo(a),this.queuePotentialClick(this.single?OpenLayers.Util.extend({},a):null))},queuePotentialClick:function(a){this.timerId=window.setTimeout(OpenLayers.Function.bind(this.delayedCall,this,a),this.delay)},passesTolerance:function(a){var b=!0;if(null!=this.pixelTolerance&&this.down&&this.down.xy&&(b=this.pixelTolerance>=this.down.xy.distanceTo(a.xy))&&this.touch&&this.down.touches.length===this.last.touches.length)for(var a=0,c=this.down.touches.length;a<c;++a)if(this.getTouchDistance(this.down.touches[a],
this.last.touches[a])>this.pixelTolerance){b=!1;break}return b},getTouchDistance:function(a,b){return Math.sqrt(Math.pow(a.clientX-b.clientX,2)+Math.pow(a.clientY-b.clientY,2))},passesDblclickTolerance:function(){var a=!0;this.down&&this.first&&(a=this.down.xy.distanceTo(this.first.xy)<=this.dblclickTolerance);return a},clearTimer:function(){if(null!=this.timerId)window.clearTimeout(this.timerId),this.timerId=null;if(null!=this.rightclickTimerId)window.clearTimeout(this.rightclickTimerId),this.rightclickTimerId=
null},delayedCall:function(a){this.timerId=null;a&&this.callback("click",[a])},getEventInfo:function(a){var b;if(a.touches){var c=a.touches.length;b=Array(c);for(var d,e=0;e<c;e++)d=a.touches[e],b[e]={clientX:d.clientX,clientY:d.clientY}}return{xy:a.xy,touches:b}},deactivate:function(){var a=!1;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments))this.clearTimer(),this.last=this.first=this.down=null,this.touch=!1,a=!0;return a},CLASS_NAME:"OpenLayers.Handler.Click"});
OpenLayers.Control.Navigation=OpenLayers.Class(OpenLayers.Control,{dragPan:null,dragPanOptions:null,pinchZoom:null,pinchZoomOptions:null,documentDrag:!1,zoomBox:null,zoomBoxEnabled:!0,zoomWheelEnabled:!0,mouseWheelOptions:null,handleRightClicks:!1,zoomBoxKeyMask:OpenLayers.Handler.MOD_SHIFT,autoActivate:!0,initialize:function(a){this.handlers={};OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.deactivate();this.dragPan&&this.dragPan.destroy();this.dragPan=null;
this.zoomBox&&this.zoomBox.destroy();this.zoomBox=null;this.pinchZoom&&this.pinchZoom.destroy();this.pinchZoom=null;OpenLayers.Control.prototype.destroy.apply(this,arguments)},activate:function(){this.dragPan.activate();this.zoomWheelEnabled&&this.handlers.wheel.activate();this.handlers.click.activate();this.zoomBoxEnabled&&this.zoomBox.activate();this.pinchZoom&&this.pinchZoom.activate();return OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){this.pinchZoom&&this.pinchZoom.deactivate();
this.zoomBox.deactivate();this.dragPan.deactivate();this.handlers.click.deactivate();this.handlers.wheel.deactivate();return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},draw:function(){if(this.handleRightClicks)this.map.viewPortDiv.oncontextmenu=OpenLayers.Function.False;this.handlers.click=new OpenLayers.Handler.Click(this,{click:this.defaultClick,dblclick:this.defaultDblClick,dblrightclick:this.defaultDblRightClick},{"double":!0,stopDouble:!0});this.dragPan=new OpenLayers.Control.DragPan(OpenLayers.Util.extend({map:this.map,
documentDrag:this.documentDrag},this.dragPanOptions));this.zoomBox=new OpenLayers.Control.ZoomBox({map:this.map,keyMask:this.zoomBoxKeyMask});this.dragPan.draw();this.zoomBox.draw();this.handlers.wheel=new OpenLayers.Handler.MouseWheel(this,{up:this.wheelUp,down:this.wheelDown},this.mouseWheelOptions);if(OpenLayers.Control.PinchZoom)this.pinchZoom=new OpenLayers.Control.PinchZoom(OpenLayers.Util.extend({map:this.map},this.pinchZoomOptions))},defaultClick:function(a){a.lastTouches&&2==a.lastTouches.length&&
this.map.zoomOut()},defaultDblClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),this.map.zoom+1)},defaultDblRightClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),this.map.zoom-1)},wheelChange:function(a,b){var c=this.map.getZoom(),d=this.map.getZoom()+Math.round(b),d=Math.max(d,0),d=Math.min(d,this.map.getNumZoomLevels());if(d!==c){var e=this.map.getSize(),c=e.w/2-a.xy.x,e=a.xy.y-e.h/2,f=this.map.baseLayer.getResolutionForZoom(d),g=this.map.getLonLatFromPixel(a.xy);
this.map.setCenter(new OpenLayers.LonLat(g.lon+c*f,g.lat+e*f),d)}},wheelUp:function(a,b){this.wheelChange(a,b||1)},wheelDown:function(a,b){this.wheelChange(a,b||-1)},disableZoomBox:function(){this.zoomBoxEnabled=!1;this.zoomBox.deactivate()},enableZoomBox:function(){this.zoomBoxEnabled=!0;this.active&&this.zoomBox.activate()},disableZoomWheel:function(){this.zoomWheelEnabled=!1;this.handlers.wheel.deactivate()},enableZoomWheel:function(){this.zoomWheelEnabled=!0;this.active&&this.handlers.wheel.activate()},
CLASS_NAME:"OpenLayers.Control.Navigation"});
OpenLayers.Tile=OpenLayers.Class({EVENT_TYPES:["loadstart","loadend","reload","unload"],events:null,id:null,layer:null,url:null,bounds:null,size:null,position:null,isLoading:!1,initialize:function(a,b,c,d,e,f){this.layer=a;this.position=b.clone();this.bounds=c.clone();this.url=d;if(e)this.size=e.clone();this.id=OpenLayers.Util.createUniqueID("Tile_");this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);OpenLayers.Util.extend(this,f)},unload:function(){if(this.isLoading)this.isLoading=!1,
this.events.triggerEvent("unload")},destroy:function(){this.position=this.size=this.bounds=this.layer=null;this.events.destroy();this.events=null},clone:function(a){null==a&&(a=new OpenLayers.Tile(this.layer,this.position,this.bounds,this.url,this.size));OpenLayers.Util.applyDefaults(a,this);return a},draw:function(){var a=this.layer.maxExtent;this.shouldDraw=a&&this.bounds.intersectsBounds(a,!1)||this.layer.displayOutsideMaxExtent;this.clear();return this.shouldDraw},moveTo:function(a,b,c){null==
c&&(c=!0);this.bounds=a.clone();this.position=b.clone();c&&this.draw()},clear:function(){},getBoundsFromBaseLayer:function(a){var b=OpenLayers.i18n("reprojectDeprecated",{layerName:this.layer.name});OpenLayers.Console.warn(b);b=this.layer.map.getLonLatFromLayerPx(a);a=a.clone();a.x+=this.size.w;a.y+=this.size.h;a=this.layer.map.getLonLatFromLayerPx(a);if(b.lon>a.lon)0>b.lon?b.lon=-180-(b.lon+180):a.lon=180+a.lon+180;return new OpenLayers.Bounds(b.lon,a.lat,a.lon,b.lat)},showTile:function(){this.shouldDraw&&
this.show()},show:function(){},hide:function(){},CLASS_NAME:"OpenLayers.Tile"});
OpenLayers.Tile.Image=OpenLayers.Class(OpenLayers.Tile,{url:null,imgDiv:null,frame:null,layerAlphaHack:null,isBackBuffer:!1,isFirstDraw:!0,backBufferTile:null,maxGetUrlLength:null,initialize:function(a,b,c,d,e,f){OpenLayers.Tile.prototype.initialize.apply(this,arguments);null!=this.maxGetUrlLength&&OpenLayers.Util.extend(this,OpenLayers.Tile.Image.IFrame);this.url=d;this.frame=document.createElement("div");this.frame.style.overflow="hidden";this.frame.style.position="absolute";this.layerAlphaHack=
this.layer.alpha&&OpenLayers.Util.alphaHack()},destroy:function(){null!=this.imgDiv&&this.removeImgDiv();this.imgDiv=null;null!=this.frame&&this.frame.parentNode==this.layer.div&&this.layer.div.removeChild(this.frame);this.frame=null;if(this.backBufferTile)this.backBufferTile.destroy(),this.backBufferTile=null;this.layer.events.unregister("loadend",this,this.resetBackBuffer);OpenLayers.Tile.prototype.destroy.apply(this,arguments)},clone:function(a){null==a&&(a=new OpenLayers.Tile.Image(this.layer,
this.position,this.bounds,this.url,this.size));a=OpenLayers.Tile.prototype.clone.apply(this,[a]);a.imgDiv=null;return a},draw:function(){if(this.layer!=this.layer.map.baseLayer&&this.layer.reproject)this.bounds=this.getBoundsFromBaseLayer(this.position);var a=OpenLayers.Tile.prototype.draw.apply(this,arguments);if(-1!=OpenLayers.Util.indexOf(this.layer.SUPPORTED_TRANSITIONS,this.layer.transitionEffect)||this.layer.singleTile)if(a){if(!this.backBufferTile)this.backBufferTile=this.clone(),this.backBufferTile.hide(),
this.backBufferTile.isBackBuffer=!0,this.events.register("loadend",this,this.resetBackBuffer),this.layer.events.register("loadend",this,this.resetBackBuffer);this.startTransition()}else this.backBufferTile&&this.backBufferTile.clear();else if(a&&this.isFirstDraw)this.events.register("loadend",this,this.showTile),this.isFirstDraw=!1;if(!a)return!1;this.isLoading?this.events.triggerEvent("reload"):(this.isLoading=!0,this.events.triggerEvent("loadstart"));return this.renderTile()},resetBackBuffer:function(){this.showTile();
if(this.backBufferTile&&(this.isFirstDraw||!this.layer.numLoadingTiles)){this.isFirstDraw=!1;var a=this.layer.maxExtent;if(a&&this.bounds.intersectsBounds(a,!1))this.backBufferTile.position=this.position,this.backBufferTile.bounds=this.bounds,this.backBufferTile.size=this.size,this.backBufferTile.imageSize=this.layer.getImageSize(this.bounds)||this.size,this.backBufferTile.imageOffset=this.layer.imageOffset,this.backBufferTile.resolution=this.layer.getResolution(),this.backBufferTile.renderTile();
this.backBufferTile.hide()}},renderTile:function(){this.layer.async?(this.initImgDiv(),this.layer.getURLasync(this.bounds,this,"url",this.positionImage)):(this.url=this.layer.getURL(this.bounds),this.initImgDiv(),this.positionImage());return!0},positionImage:function(){if(null!==this.layer){OpenLayers.Util.modifyDOMElement(this.frame,null,this.position,this.size);var a=this.layer.getImageSize(this.bounds);this.layerAlphaHack?OpenLayers.Util.modifyAlphaImageDiv(this.imgDiv,null,null,a,this.url):(OpenLayers.Util.modifyDOMElement(this.imgDiv,
null,null,a),this.imgDiv.src=this.url)}},clear:function(){if(this.imgDiv&&(this.hide(),OpenLayers.Tile.Image.useBlankTile))this.imgDiv.src=OpenLayers.Util.getImagesLocation()+"blank.gif"},initImgDiv:function(){if(null==this.imgDiv){var a=this.layer.imageOffset,b=this.layer.getImageSize(this.bounds);this.imgDiv=this.layerAlphaHack?OpenLayers.Util.createAlphaImageDiv(null,a,b,null,"relative",null,null,null,!0):OpenLayers.Util.createImage(null,a,b,null,"relative",null,null,!0);if(OpenLayers.Util.isArray(this.layer.url))this.imgDiv.urls=
this.layer.url.slice();this.imgDiv.className="olTileImage";this.frame.style.zIndex=this.isBackBuffer?0:1;this.frame.appendChild(this.imgDiv);this.layer.div.appendChild(this.frame);null!=this.layer.opacity&&OpenLayers.Util.modifyDOMElement(this.imgDiv,null,null,null,null,null,null,this.layer.opacity);this.imgDiv.map=this.layer.map;var c=function(){if(this.isLoading)this.isLoading=!1,this.events.triggerEvent("loadend")};this.layerAlphaHack?OpenLayers.Event.observe(this.imgDiv.childNodes[0],"load",OpenLayers.Function.bind(c,
this)):OpenLayers.Event.observe(this.imgDiv,"load",OpenLayers.Function.bind(c,this));OpenLayers.Event.observe(this.imgDiv,"error",OpenLayers.Function.bind(function(){this.imgDiv._attempts>OpenLayers.IMAGE_RELOAD_ATTEMPTS&&c.call(this)},this))}this.imgDiv.viewRequestID=this.layer.map.viewRequestID},removeImgDiv:function(){OpenLayers.Event.stopObservingElement(this.imgDiv);if(this.imgDiv.parentNode==this.frame)this.frame.removeChild(this.imgDiv),this.imgDiv.map=null;this.imgDiv.urls=null;var a=this.imgDiv.firstChild;
a?(OpenLayers.Event.stopObservingElement(a),this.imgDiv.removeChild(a),delete a):this.imgDiv.src=OpenLayers.Util.getImagesLocation()+"blank.gif"},checkImgURL:function(){this.layer&&(OpenLayers.Util.isEquivalentUrl(this.layerAlphaHack?this.imgDiv.firstChild.src:this.imgDiv.src,this.url)||this.hide())},startTransition:function(){if(this.backBufferTile&&this.backBufferTile.imgDiv){var a=1;this.backBufferTile.resolution&&(a=this.backBufferTile.resolution/this.layer.getResolution());if(1!=a){if("resize"==
this.layer.transitionEffect){var b=new OpenLayers.LonLat(this.backBufferTile.bounds.left,this.backBufferTile.bounds.top),c=new OpenLayers.Size(this.backBufferTile.size.w*a,this.backBufferTile.size.h*a),b=this.layer.map.getLayerPxFromLonLat(b);OpenLayers.Util.modifyDOMElement(this.backBufferTile.frame,null,b,c);c=this.backBufferTile.imageSize;c=new OpenLayers.Size(c.w*a,c.h*a);(b=this.backBufferTile.imageOffset)&&(b=new OpenLayers.Pixel(b.x*a,b.y*a));OpenLayers.Util.modifyDOMElement(this.backBufferTile.imgDiv,
null,b,c);this.backBufferTile.show()}}else this.layer.singleTile?this.backBufferTile.show():this.backBufferTile.hide()}},show:function(){this.frame.style.display="";if(-1!=OpenLayers.Util.indexOf(this.layer.SUPPORTED_TRANSITIONS,this.layer.transitionEffect)&&!0===OpenLayers.IS_GECKO)this.frame.scrollLeft=this.frame.scrollLeft},hide:function(){this.frame.style.display="none"},CLASS_NAME:"OpenLayers.Tile.Image"});OpenLayers.Tile.Image.useBlankTile="safari"==OpenLayers.BROWSER_NAME||"opera"==OpenLayers.BROWSER_NAME;
OpenLayers.Layer.WMS=OpenLayers.Class(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{service:"WMS",version:"1.1.1",request:"GetMap",styles:"",format:"image/jpeg"},reproject:!1,isBaseLayer:!0,encodeBBOX:!1,noMagic:!1,yx:{"EPSG:4326":!0},initialize:function(a,b,c,d){var e=[],c=OpenLayers.Util.upperCaseObject(c);if(1.3<=parseFloat(c.VERSION)&&!c.EXCEPTIONS)c.EXCEPTIONS="INIMAGE";e.push(a,b,c,d);OpenLayers.Layer.Grid.prototype.initialize.apply(this,e);OpenLayers.Util.applyDefaults(this.params,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));
if(!this.noMagic&&this.params.TRANSPARENT&&"true"==this.params.TRANSPARENT.toString().toLowerCase()){if(null==d||!d.isBaseLayer)this.isBaseLayer=!1;if("image/jpeg"==this.params.FORMAT)this.params.FORMAT=OpenLayers.Util.alphaHack()?"image/gif":"image/png"}},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments)},clone:function(a){null==a&&(a=new OpenLayers.Layer.WMS(this.name,this.url,this.params,this.getOptions()));return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,
[a])},reverseAxisOrder:function(){return 1.3<=parseFloat(this.params.VERSION)&&!!this.yx[this.map.getProjectionObject().getCode()]},getURL:function(a){var a=this.adjustBounds(a),b=this.getImageSize(),c={},d=this.reverseAxisOrder();c.BBOX=this.encodeBBOX?a.toBBOX(null,d):a.toArray(d);c.WIDTH=b.w;c.HEIGHT=b.h;return this.getFullRequestString(c)},mergeNewParams:function(a){a=[OpenLayers.Util.upperCaseObject(a)];return OpenLayers.Layer.Grid.prototype.mergeNewParams.apply(this,a)},getFullRequestString:function(a,
b){var c=this.map.getProjectionObject(),c=this.projection&&this.projection.equals(c)?this.projection.getCode():c.getCode(),c="none"==c?null:c;1.3<=parseFloat(this.params.VERSION)?this.params.CRS=c:this.params.SRS=c;if("boolean"==typeof this.params.TRANSPARENT)a.TRANSPARENT=this.params.TRANSPARENT?"TRUE":"FALSE";return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments)},CLASS_NAME:"OpenLayers.Layer.WMS"});
OpenLayers.Control.MousePosition=OpenLayers.Class(OpenLayers.Control,{autoActivate:!0,element:null,prefix:"",separator:", ",suffix:"",numDigits:5,granularity:10,emptyString:null,lastXy:null,displayProjection:null,destroy:function(){this.deactivate();OpenLayers.Control.prototype.destroy.apply(this,arguments)},activate:function(){return OpenLayers.Control.prototype.activate.apply(this,arguments)?(this.map.events.register("mousemove",this,this.redraw),this.map.events.register("mouseout",this,this.reset),
this.redraw(),!0):!1},deactivate:function(){return OpenLayers.Control.prototype.deactivate.apply(this,arguments)?(this.map.events.unregister("mousemove",this,this.redraw),this.map.events.unregister("mouseout",this,this.reset),this.element.innerHTML="",!0):!1},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element)this.div.left="",this.div.top="",this.element=this.div;return this.div},redraw:function(a){var b;if(null==a)this.reset();else if(null==this.lastXy||Math.abs(a.xy.x-
this.lastXy.x)>this.granularity||Math.abs(a.xy.y-this.lastXy.y)>this.granularity)this.lastXy=a.xy;else if(b=this.map.getLonLatFromPixel(a.xy))if(this.displayProjection&&b.transform(this.map.getProjectionObject(),this.displayProjection),this.lastXy=a.xy,a=this.formatOutput(b),a!=this.element.innerHTML)this.element.innerHTML=a},reset:function(){if(null!=this.emptyString)this.element.innerHTML=this.emptyString},formatOutput:function(a){var b=parseInt(this.numDigits);return this.prefix+a.lon.toFixed(b)+
this.separator+a.lat.toFixed(b)+this.suffix},CLASS_NAME:"OpenLayers.Control.MousePosition"});OpenLayers.Format=OpenLayers.Class({options:null,externalProjection:null,internalProjection:null,data:null,keepData:!1,initialize:function(a){OpenLayers.Util.extend(this,a);this.options=a},destroy:function(){},read:function(){OpenLayers.Console.userError(OpenLayers.i18n("readNotImplemented"))},write:function(){OpenLayers.Console.userError(OpenLayers.i18n("writeNotImplemented"))},CLASS_NAME:"OpenLayers.Format"});
OpenLayers.Lang.en={unhandledRequest:"Unhandled request return ${statusText}",Permalink:"Permalink",Overlays:"Overlays","Base Layer":"Base Layer",readNotImplemented:"Read not implemented.",writeNotImplemented:"Write not implemented.",noFID:"Can't update a feature for which there is no FID.",errorLoadingGML:"Error in loading GML file ${url}",browserNotSupported:"Your browser does not support vector rendering. Currently supported renderers are:\n${renderers}",componentShouldBe:"addFeatures : component should be an ${geomType}",
getFeatureError:"getFeatureFromEvent called on layer with no renderer. This usually means you destroyed a layer, but not some handler which is associated with it.",minZoomLevelError:"The minZoomLevel property is only intended for use with the FixedZoomLevels-descendent layers. That this wfs layer checks for minZoomLevel is a relic of thepast. We cannot, however, remove it without possibly breaking OL based applications that may depend on it. Therefore we are deprecating it -- the minZoomLevel check below will be removed at 3.0. Please instead use min/max resolution setting as described here: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS Transaction: SUCCESS ${response}",commitFailed:"WFS Transaction: FAILED ${response}",googleWarning:"The Google Layer was unable to load correctly.<br><br>To get rid of this message, select a new BaseLayer in the layer switcher in the upper-right corner.<br><br>Most likely, this is because the Google Maps library script was either not included, or does not contain the correct API key for your site.<br><br>Developers: For help getting this working correctly, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>click here</a>",
getLayerWarning:"The ${layerType} Layer was unable to load correctly.<br><br>To get rid of this message, select a new BaseLayer in the layer switcher in the upper-right corner.<br><br>Most likely, this is because the ${layerLib} library script was not correctly included.<br><br>Developers: For help getting this working correctly, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>click here</a>","Scale = 1 : ${scaleDenom}":"Scale = 1 : ${scaleDenom}",W:"W",E:"E",N:"N",S:"S",Graticule:"Graticule",
layerAlreadyAdded:"You tried to add the layer: ${layerName} to the map, but it has already been added",reprojectDeprecated:"You are using the 'reproject' option on the ${layerName} layer. This option is deprecated: its use was designed to support displaying data over commercial basemaps, but that functionality should now be achieved by using Spherical Mercator support. More information is available from http://trac.openlayers.org/wiki/SphericalMercator.",methodDeprecated:"This method has been deprecated and will be removed in 3.0. Please use ${newMethod} instead.",
boundsAddError:"You must pass both x and y values to the add function.",lonlatAddError:"You must pass both lon and lat values to the add function.",pixelAddError:"You must pass both x and y values to the add function.",unsupportedGeometryType:"Unsupported geometry type: ${geomType}",filterEvaluateNotImplemented:"evaluate is not implemented for this filter type.",proxyNeeded:"You probably need to set OpenLayers.ProxyHost to access ${url}.See http://trac.osgeo.org/openlayers/wiki/FrequentlyAskedQuestions#ProxyHost",
end:""};
OpenLayers.Layer.WMS.Untiled=OpenLayers.Class(OpenLayers.Layer.WMS,{singleTile:!0,initialize:function(a,b,c,d){OpenLayers.Layer.WMS.prototype.initialize.apply(this,arguments);OpenLayers.Console.warn("The OpenLayers.Layer.WMS.Untiled class is deprecated and will be removed in 3.0. Instead, you should use the normal OpenLayers.Layer.WMS class, passing it the option 'singleTile' as true.")},clone:function(a){null==a&&(a=new OpenLayers.Layer.WMS.Untiled(this.name,this.url,this.params,this.getOptions()));return a=
OpenLayers.Layer.WMS.prototype.clone.apply(this,[a])},CLASS_NAME:"OpenLayers.Layer.WMS.Untiled"});
OpenLayers.Format.XML=OpenLayers.Class(OpenLayers.Format,{namespaces:null,namespaceAlias:null,defaultPrefix:null,readers:{},writers:{},xmldom:null,initialize:function(a){if(window.ActiveXObject)this.xmldom=new ActiveXObject("Microsoft.XMLDOM");OpenLayers.Format.prototype.initialize.apply(this,[a]);this.namespaces=OpenLayers.Util.extend({},this.namespaces);this.namespaceAlias={};for(var b in this.namespaces)this.namespaceAlias[this.namespaces[b]]=b},destroy:function(){this.xmldom=null;OpenLayers.Format.prototype.destroy.apply(this,
arguments)},setNamespace:function(a,b){this.namespaces[a]=b;this.namespaceAlias[b]=a},read:function(a){var b=a.indexOf("<");0<b&&(a=a.substring(b));b=OpenLayers.Util.Try(OpenLayers.Function.bind(function(){var b;b=window.ActiveXObject&&!this.xmldom?new ActiveXObject("Microsoft.XMLDOM"):this.xmldom;b.loadXML(a);return b},this),function(){return(new DOMParser).parseFromString(a,"text/xml")},function(){var b=new XMLHttpRequest;b.open("GET","data:text/xml;charset=utf-8,"+encodeURIComponent(a),!1);b.overrideMimeType&&
b.overrideMimeType("text/xml");b.send(null);return b.responseXML});if(this.keepData)this.data=b;return b},write:function(a){if(this.xmldom)a=a.xml;else{var b=new XMLSerializer;if(1==a.nodeType){var c=document.implementation.createDocument("","",null);c.importNode&&(a=c.importNode(a,!0));c.appendChild(a);a=b.serializeToString(c)}else a=b.serializeToString(a)}return a},createElementNS:function(a,b){return this.xmldom?"string"==typeof a?this.xmldom.createNode(1,b,a):this.xmldom.createNode(1,b,""):document.createElementNS(a,
b)},createTextNode:function(a){"string"!==typeof a&&(a=""+a);return this.xmldom?this.xmldom.createTextNode(a):document.createTextNode(a)},getElementsByTagNameNS:function(a,b,c){var d=[];if(a.getElementsByTagNameNS)d=a.getElementsByTagNameNS(b,c);else for(var a=a.getElementsByTagName("*"),e,f,g=0,h=a.length;g<h;++g)if(e=a[g],f=e.prefix?e.prefix+":"+c:c,"*"==c||f==e.nodeName)("*"==b||b==e.namespaceURI)&&d.push(e);return d},getAttributeNodeNS:function(a,b,c){var d=null;if(a.getAttributeNodeNS)d=a.getAttributeNodeNS(b,
c);else for(var a=a.attributes,e,f,g=0,h=a.length;g<h;++g)if(e=a[g],e.namespaceURI==b&&(f=e.prefix?e.prefix+":"+c:c,f==e.nodeName)){d=e;break}return d},getAttributeNS:function(a,b,c){var d="";if(a.getAttributeNS)d=a.getAttributeNS(b,c)||"";else if(a=this.getAttributeNodeNS(a,b,c))d=a.nodeValue;return d},getChildValue:function(a,b){var c=b||"";if(a)for(var d=a.firstChild;d;d=d.nextSibling)switch(d.nodeType){case 3:case 4:c+=d.nodeValue}return c},concatChildValues:function(a,b){for(var c="",d=a.firstChild,
e;d;)(e=d.nodeValue)&&(c+=e),d=d.nextSibling;""==c&&void 0!=b&&(c=b);return c},isSimpleContent:function(a){for(var b=!0,a=a.firstChild;a;a=a.nextSibling)if(1===a.nodeType){b=!1;break}return b},contentType:function(a){for(var b=!1,c=!1,d=OpenLayers.Format.XML.CONTENT_TYPE.EMPTY,a=a.firstChild;a;a=a.nextSibling){switch(a.nodeType){case 1:c=!0;break;case 8:break;default:b=!0}if(c&&b)break}if(c&&b)d=OpenLayers.Format.XML.CONTENT_TYPE.MIXED;else{if(c)return OpenLayers.Format.XML.CONTENT_TYPE.COMPLEX;if(b)return OpenLayers.Format.XML.CONTENT_TYPE.SIMPLE}return d},
hasAttributeNS:function(a,b,c){var d=!1;return d=a.hasAttributeNS?a.hasAttributeNS(b,c):!!this.getAttributeNodeNS(a,b,c)},setAttributeNS:function(a,b,c,d){if(a.setAttributeNS)a.setAttributeNS(b,c,d);else if(this.xmldom)b?(b=a.ownerDocument.createNode(2,c,b),b.nodeValue=d,a.setAttributeNode(b)):a.setAttribute(c,d);else throw"setAttributeNS not implemented";},createElementNSPlus:function(a,b){var b=b||{},c=b.uri||this.namespaces[b.prefix];c||(c=a.indexOf(":"),c=this.namespaces[a.substring(0,c)]);c||
(c=this.namespaces[this.defaultPrefix]);c=this.createElementNS(c,a);b.attributes&&this.setAttributes(c,b.attributes);var d=b.value;null!=d&&c.appendChild(this.createTextNode(d));return c},setAttributes:function(a,b){var c,d,e;for(e in b)null!=b[e]&&b[e].toString&&(c=b[e].toString(),d=this.namespaces[e.substring(0,e.indexOf(":"))]||null,this.setAttributeNS(a,d,e,c))},readNode:function(a,b){b||(b={});var c=this.readers[a.namespaceURI?this.namespaceAlias[a.namespaceURI]:this.defaultPrefix];if(c){var d=
a.localName||a.nodeName.split(":").pop();(c=c[d]||c["*"])&&c.apply(this,[a,b])}return b},readChildNodes:function(a,b){b||(b={});for(var c=a.childNodes,d,e=0,f=c.length;e<f;++e)d=c[e],1==d.nodeType&&this.readNode(d,b);return b},writeNode:function(a,b,c){var d,e=a.indexOf(":");0<e?(d=a.substring(0,e),a=a.substring(e+1)):d=c?this.namespaceAlias[c.namespaceURI]:this.defaultPrefix;b=this.writers[d][a].apply(this,[b]);c&&c.appendChild(b);return b},getChildEl:function(a,b,c){return a&&this.getThisOrNextEl(a.firstChild,
b,c)},getNextEl:function(a,b,c){return a&&this.getThisOrNextEl(a.nextSibling,b,c)},getThisOrNextEl:function(a,b,c){a:for(;a;a=a.nextSibling)switch(a.nodeType){case 1:if((!b||b===(a.localName||a.nodeName.split(":").pop()))&&(!c||c===a.namespaceURI))break a;a=null;break a;case 3:if(/^\s*$/.test(a.nodeValue))break;case 4:case 6:case 12:case 10:case 11:a=null;break a}return a||null},lookupNamespaceURI:function(a,b){var c=null;if(a)if(a.lookupNamespaceURI)c=a.lookupNamespaceURI(b);else a:switch(a.nodeType){case 1:if(null!==
a.namespaceURI&&a.prefix===b){c=a.namespaceURI;break a}if(c=a.attributes.length)for(var d,e=0;e<c;++e)if(d=a.attributes[e],"xmlns"===d.prefix&&d.name==="xmlns:"+b){c=d.value||null;break a}else if("xmlns"===d.name&&null===b){c=d.value||null;break a}c=this.lookupNamespaceURI(a.parentNode,b);break a;case 2:c=this.lookupNamespaceURI(a.ownerElement,b);break a;case 9:c=this.lookupNamespaceURI(a.documentElement,b);break a;case 6:case 12:case 10:case 11:break a;default:c=this.lookupNamespaceURI(a.parentNode,
b)}return c},getXMLDoc:function(){if(!OpenLayers.Format.XML.document&&!this.xmldom)if(document.implementation&&document.implementation.createDocument)OpenLayers.Format.XML.document=document.implementation.createDocument("","",null);else if(!this.xmldom&&window.ActiveXObject)this.xmldom=new ActiveXObject("Microsoft.XMLDOM");return OpenLayers.Format.XML.document||this.xmldom},CLASS_NAME:"OpenLayers.Format.XML"});OpenLayers.Format.XML.CONTENT_TYPE={EMPTY:0,SIMPLE:1,COMPLEX:2,MIXED:3};
OpenLayers.Format.XML.lookupNamespaceURI=OpenLayers.Function.bind(OpenLayers.Format.XML.prototype.lookupNamespaceURI,OpenLayers.Format.XML.prototype);OpenLayers.Format.XML.document=null;
OpenLayers.Control.Scale=OpenLayers.Class(OpenLayers.Control,{element:null,geodesic:!1,initialize:function(a,b){OpenLayers.Control.prototype.initialize.apply(this,[b]);this.element=OpenLayers.Util.getElement(a)},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element)this.element=document.createElement("div"),this.div.appendChild(this.element);this.map.events.register("moveend",this,this.updateScale);this.updateScale();return this.div},updateScale:function(){var a;
if(!0===this.geodesic){if(!this.map.getUnits())return;a=OpenLayers.INCHES_PER_UNIT;a=(this.map.getGeodesicPixelSize().w||1.0E-6)*a.km*OpenLayers.DOTS_PER_INCH}else a=this.map.getScale();if(a)a=9500<=a&&95E4>=a?Math.round(a/1E3)+"K":95E4<=a?Math.round(a/1E6)+"M":Math.round(a),this.element.innerHTML=OpenLayers.i18n("Scale = 1 : ${scaleDenom}",{scaleDenom:a})},CLASS_NAME:"OpenLayers.Control.Scale"});
