/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.auth.AbstractAuthenticationProviderTest;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.jdbc.JDBCConnectAuthProvider;
import org.geoserver.security.jdbc.config.JDBCConnectAuthProviderConfig;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class JDBCConnectAuthProviderTest
extends AbstractAuthenticationProviderTest {
    protected JDBCConnectAuthProviderConfig createAuthConfg(String name, String userGroupServiceName) {
        JDBCConnectAuthProviderConfig config = new JDBCConnectAuthProviderConfig();
        config.setName(name);
        config.setClassName(JDBCConnectAuthProvider.class.getName());
        config.setUserGroupServiceName(userGroupServiceName);
        config.setConnectURL("jdbc:h2:target/h2/security");
        config.setDriverClassName("org.h2.Driver");
        return config;
    }

    @Test
    public void testAuthentificationWithoutUserGroupService() throws Exception {
        JDBCConnectAuthProviderConfig config = this.createAuthConfg("jdbc1", null);
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)config);
        GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider("jdbc1");
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"sa", (Object)"");
        token.setDetails((Object)"details");
        Assert.assertTrue((boolean)provider.supports(token.getClass()));
        Assert.assertFalse((boolean)provider.supports(RememberMeAuthenticationToken.class));
        Authentication auth = provider.authenticate((Authentication)token);
        Assert.assertNotNull((Object)auth);
        Assert.assertEquals((Object)"sa", (Object)auth.getPrincipal());
        Assert.assertNull((Object)auth.getCredentials());
        Assert.assertEquals((Object)"details", (Object)auth.getDetails());
        Assert.assertEquals((long)1L, (long)auth.getAuthorities().size());
        this.checkForAuthenticatedRole(auth);
        token = new UsernamePasswordAuthenticationToken((Object)"abc", (Object)"def");
        boolean fail = false;
        try {
            if (provider.authenticate((Authentication)token) == null) {
                fail = true;
            }
        }
        catch (BadCredentialsException ex) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
    }

    @Test
    public void testAuthentificationWithUserGroupService() throws Exception {
        GeoServerRoleService roleService = this.createRoleService("jdbc2");
        GeoServerUserGroupService ugService = this.createUserGroupService("jdbc2");
        JDBCConnectAuthProviderConfig config = this.createAuthConfg("jdbc2", ugService.getName());
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)config);
        GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider("jdbc2");
        GeoServerUserGroupStore ugStore = ugService.createStore();
        GeoServerUser sa = ugStore.createUserObject("sa", "", true);
        ugStore.addUser(sa);
        ugStore.store();
        GeoServerRoleStore roleStore = roleService.createStore();
        roleStore.addRole(GeoServerRole.ADMIN_ROLE);
        roleStore.associateRoleToUser(GeoServerRole.ADMIN_ROLE, sa.getUsername());
        roleStore.store();
        this.getSecurityManager().setActiveRoleService(roleService);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"sa", (Object)"");
        token.setDetails((Object)"details");
        Assert.assertTrue((boolean)provider.supports(token.getClass()));
        Assert.assertFalse((boolean)provider.supports(RememberMeAuthenticationToken.class));
        Authentication auth = provider.authenticate((Authentication)token);
        Assert.assertNotNull((Object)auth);
        Assert.assertEquals((Object)"sa", (Object)auth.getPrincipal());
        Assert.assertNull((Object)auth.getCredentials());
        Assert.assertEquals((Object)"details", (Object)auth.getDetails());
        Assert.assertEquals((long)2L, (long)auth.getAuthorities().size());
        this.checkForAuthenticatedRole(auth);
        Assert.assertTrue((boolean)auth.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        ugStore = ugService.createStore();
        sa.setEnabled(false);
        ugStore.updateUser(sa);
        ugStore.store();
        Assert.assertNull((Object)provider.authenticate((Authentication)token));
        token = new UsernamePasswordAuthenticationToken((Object)"abc", (Object)"def");
        boolean fail = false;
        try {
            if (provider.authenticate((Authentication)token) == null) {
                fail = true;
            }
        }
        catch (BadCredentialsException | UsernameNotFoundException ex) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
    }

    @Test
    public void testAuthentificationWithRoleAssociation() throws Exception {
        GeoServerRoleService roleService = this.createRoleService("jdbc3");
        JDBCConnectAuthProviderConfig config = this.createAuthConfg("jdbc3", null);
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)config);
        GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider("jdbc3");
        GeoServerRoleStore roleStore = roleService.createStore();
        roleStore.addRole(GeoServerRole.ADMIN_ROLE);
        roleStore.associateRoleToUser(GeoServerRole.ADMIN_ROLE, "sa");
        roleStore.store();
        this.getSecurityManager().setActiveRoleService(roleService);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"sa", (Object)"");
        token.setDetails((Object)"details");
        Assert.assertTrue((boolean)provider.supports(token.getClass()));
        Assert.assertFalse((boolean)provider.supports(RememberMeAuthenticationToken.class));
        Authentication auth = provider.authenticate((Authentication)token);
        Assert.assertNotNull((Object)auth);
        Assert.assertEquals((Object)"sa", (Object)auth.getPrincipal());
        Assert.assertNull((Object)auth.getCredentials());
        Assert.assertEquals((Object)"details", (Object)auth.getDetails());
        Assert.assertEquals((long)2L, (long)auth.getAuthorities().size());
        this.checkForAuthenticatedRole(auth);
        Assert.assertTrue((boolean)auth.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        token = new UsernamePasswordAuthenticationToken((Object)"abc", (Object)"def");
        boolean fail = false;
        try {
            if (provider.authenticate((Authentication)token) == null) {
                fail = true;
            }
        }
        catch (BadCredentialsException | UsernameNotFoundException ex) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
    }
}

