/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.impl.AbstractRoleServiceTest;
import org.geoserver.security.jdbc.AbstractJDBCService;
import org.geoserver.security.jdbc.JDBCRoleStore;
import org.geoserver.security.jdbc.JDBCTestSupport;
import org.geoserver.security.jdbc.LiveDbmsDataSecurity;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class JDBCRoleServiceTest
extends AbstractRoleServiceTest {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.jdbc");

    protected abstract String getFixtureId();

    @After
    public void dropExistingTables() throws Exception {
        if (this.store != null) {
            JDBCRoleStore jdbcStore = (JDBCRoleStore)this.store;
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)jdbcStore, jdbcStore.getConnection());
            this.store.store();
        }
    }

    @Before
    public void init() throws IOException {
        Assume.assumeTrue((boolean)((SystemTestData)this.getTestData()).isTestDataAvailable());
        this.service = this.getSecurityManager().loadRoleService(this.getFixtureId());
        this.store = this.createStore(this.service);
    }

    public GeoServerRoleService createRoleService(String serviceName) throws Exception {
        return JDBCTestSupport.createRoleService(this.getFixtureId(), (LiveDbmsDataSecurity)this.getTestData(), this.getSecurityManager());
    }

    public GeoServerRoleStore createStore(GeoServerRoleService service) throws IOException {
        JDBCRoleStore store = (JDBCRoleStore)super.createStore(service);
        try {
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)store, store.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        store.createTables();
        store.store();
        return store;
    }

    @Test
    public void testRoleDatabaseSetup() {
        try {
            JDBCRoleStore jdbcStore = (JDBCRoleStore)this.store;
            Assert.assertTrue((boolean)jdbcStore.tablesAlreadyCreated());
            jdbcStore.checkDDLStatements();
            jdbcStore.checkDMLStatements();
            jdbcStore.clear();
            jdbcStore.dropTables();
            jdbcStore.store();
            Assert.assertFalse((boolean)jdbcStore.tablesAlreadyCreated());
            jdbcStore.load();
        }
        catch (IOException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    protected SystemTestData createTestData() throws Exception {
        if ("h2".equalsIgnoreCase(this.getFixtureId())) {
            return super.createTestData();
        }
        return new LiveDbmsDataSecurity(this.getFixtureId());
    }

    protected boolean isJDBCTest() {
        return true;
    }
}

