/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.AbstractUserDetailsServiceTest;
import org.geoserver.security.jdbc.AbstractJDBCService;
import org.geoserver.security.jdbc.JDBCRoleStore;
import org.geoserver.security.jdbc.JDBCTestSupport;
import org.geoserver.security.jdbc.JDBCUserGroupStore;
import org.geoserver.security.jdbc.LiveDbmsDataSecurity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class JDBCUserDetailsServiceTest
extends AbstractUserDetailsServiceTest {
    protected abstract String getFixtureId();

    @Before
    public void init() {
        Assume.assumeTrue((boolean)((SystemTestData)this.getTestData()).isTestDataAvailable());
    }

    public GeoServerUserGroupService createUserGroupService(String serviceName) throws Exception {
        return JDBCTestSupport.createUserGroupService(this.getFixtureId(), (LiveDbmsDataSecurity)this.getTestData(), this.getSecurityManager());
    }

    public GeoServerRoleService createRoleService(String serviceName) throws Exception {
        return JDBCTestSupport.createRoleService(this.getFixtureId(), (LiveDbmsDataSecurity)this.getTestData(), this.getSecurityManager());
    }

    public GeoServerRoleStore createStore(GeoServerRoleService service) throws IOException {
        JDBCRoleStore store = (JDBCRoleStore)super.createStore(service);
        try {
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)store, store.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        store.createTables();
        store.store();
        return store;
    }

    public GeoServerUserGroupStore createStore(GeoServerUserGroupService service) throws IOException {
        JDBCUserGroupStore store = (JDBCUserGroupStore)super.createStore(service);
        try {
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)store, store.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        store.createTables();
        store.store();
        return store;
    }

    @After
    public void dropTables() throws Exception {
        if (this.roleStore != null) {
            JDBCRoleStore jdbcStore1 = (JDBCRoleStore)this.roleStore;
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)jdbcStore1, jdbcStore1.getConnection());
            this.roleStore.store();
        }
        if (this.usergroupStore != null) {
            JDBCUserGroupStore jdbcStore2 = (JDBCUserGroupStore)this.usergroupStore;
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)jdbcStore2, jdbcStore2.getConnection());
            this.usergroupStore.store();
        }
    }

    protected void setServices(String serviceName) throws Exception {
        if (this.getSecurityManager().loadRoleService(this.getFixtureId()) == null) {
            super.setServices(this.getFixtureId());
        } else {
            this.roleService = this.getSecurityManager().loadRoleService(this.getFixtureId());
            this.roleStore = this.createStore(this.roleService);
            this.usergroupService = this.getSecurityManager().loadUserGroupService(this.getFixtureId());
            this.usergroupStore = this.createStore(this.usergroupService);
            this.getSecurityManager().setActiveRoleService(this.roleService);
        }
    }

    protected boolean isJDBCTest() {
        return true;
    }

    protected SystemTestData createTestData() throws Exception {
        if ("h2".equalsIgnoreCase(this.getFixtureId())) {
            return super.createTestData();
        }
        return new LiveDbmsDataSecurity(this.getFixtureId());
    }

    @Test
    public void testConfiguration() throws Exception {
        this.setServices("config");
        Assert.assertEquals((Object)this.roleService, (Object)this.getSecurityManager().getActiveRoleService());
        Assert.assertEquals((Object)this.usergroupService.getName(), (Object)this.getSecurityManager().loadUserGroupService(this.getFixtureId()).getName());
        Assert.assertTrue((boolean)this.roleService.canCreateStore());
        Assert.assertTrue((boolean)this.usergroupService.canCreateStore());
    }
}

