/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.AbstractUserGroupServiceTest;
import org.geoserver.security.jdbc.AbstractJDBCService;
import org.geoserver.security.jdbc.JDBCTestSupport;
import org.geoserver.security.jdbc.JDBCUserGroupStore;
import org.geoserver.security.jdbc.LiveDbmsDataSecurity;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class JDBCUserGroupServiceTest
extends AbstractUserGroupServiceTest {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.jdbc");

    protected abstract String getFixtureId();

    @Before
    public void init() {
        Assume.assumeTrue((boolean)((SystemTestData)this.getTestData()).isTestDataAvailable());
    }

    @After
    public void dropExistingTables() throws Exception {
        if (this.store != null) {
            JDBCUserGroupStore jdbcStore = (JDBCUserGroupStore)this.store;
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)jdbcStore, jdbcStore.getConnection());
            this.store.store();
        }
    }

    public void setServiceAndStore() throws Exception {
        if (((SystemTestData)this.getTestData()).isTestDataAvailable()) {
            this.service = this.getSecurityManager().loadUserGroupService(this.getFixtureId());
            this.store = this.createStore(this.service);
        }
    }

    protected SecurityUserGroupServiceConfig createConfigObject(String name) {
        try {
            return JDBCTestSupport.createConfigObject(this.getFixtureId(), (LiveDbmsDataSecurity)this.getTestData(), this.getSecurityManager());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GeoServerUserGroupService createUserGroupService(String serviceName) throws Exception {
        return JDBCTestSupport.createUserGroupService(this.getFixtureId(), (LiveDbmsDataSecurity)this.getTestData(), this.getSecurityManager());
    }

    public GeoServerUserGroupStore createStore(GeoServerUserGroupService service) throws IOException {
        JDBCUserGroupStore store = (JDBCUserGroupStore)super.createStore(service);
        try {
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)store, store.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        store.createTables();
        store.store();
        return store;
    }

    @Test
    public void testUserGroupDatabaseSetup() throws IOException {
        JDBCUserGroupStore jdbcStore = (JDBCUserGroupStore)this.store;
        Assert.assertTrue((boolean)jdbcStore.tablesAlreadyCreated());
        jdbcStore.checkDDLStatements();
        jdbcStore.checkDMLStatements();
        jdbcStore.clear();
        jdbcStore.dropTables();
        jdbcStore.store();
        Assert.assertFalse((boolean)jdbcStore.tablesAlreadyCreated());
        jdbcStore.load();
    }

    protected SystemTestData createTestData() throws Exception {
        if ("h2".equalsIgnoreCase(this.getFixtureId())) {
            return super.createTestData();
        }
        return new LiveDbmsDataSecurity(this.getFixtureId());
    }

    protected boolean isJDBCTest() {
        return true;
    }
}

