/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.AbstractRoleService;
import org.geoserver.security.jdbc.JDBCConnectAuthProvider;
import org.geoserver.security.jdbc.JDBCRoleService;
import org.geoserver.security.jdbc.JDBCUserGroupService;
import org.geoserver.security.jdbc.JdbcSecurityConfigValidator;
import org.geoserver.security.jdbc.config.JDBCConnectAuthProviderConfig;
import org.geoserver.security.jdbc.config.JDBCRoleServiceConfig;
import org.geoserver.security.jdbc.config.JDBCUserGroupServiceConfig;
import org.geoserver.security.password.GeoServerPlainTextPasswordEncoder;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidatorTest;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;

public class JdbcSecurityConfigValidatorTest
extends SecurityConfigValidatorTest {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");

    protected SecurityUserGroupServiceConfig createUGConfig(String name, Class<?> aClass, String encoder, String policyName) {
        JDBCUserGroupServiceConfig config = new JDBCUserGroupServiceConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setPasswordEncoderName(encoder);
        config.setPasswordPolicyName(policyName);
        config.setCreatingTables(false);
        return config;
    }

    protected SecurityRoleServiceConfig createRoleConfig(String name, Class<?> aClass, String adminRole) {
        JDBCRoleServiceConfig config = new JDBCRoleServiceConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setAdminRoleName(adminRole);
        config.setCreatingTables(false);
        return config;
    }

    protected SecurityAuthProviderConfig createAuthConfig(String name, Class<?> aClass, String userGroupServiceName) {
        JDBCConnectAuthProviderConfig config = new JDBCConnectAuthProviderConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setUserGroupServiceName(userGroupServiceName);
        return config;
    }

    @Test
    public void testRoleConfig() throws IOException {
        String invalidPath;
        super.testRoleConfig();
        JDBCRoleServiceConfig config = (JDBCRoleServiceConfig)this.createRoleConfig("jdbc", JDBCRoleService.class, AbstractRoleService.DEFAULT_LOCAL_ADMIN_ROLE);
        config.setDriverClassName("a.b.c");
        config.setUserName("user");
        config.setConnectURL("jdbc:connect");
        config.setPropertyFileNameDDL("rolesddl.xml");
        config.setPropertyFileNameDML("rolesdml.xml");
        JDBCRoleServiceConfig configJNDI = (JDBCRoleServiceConfig)this.createRoleConfig("jndi", JDBCRoleService.class, AbstractRoleService.DEFAULT_LOCAL_ADMIN_ROLE);
        configJNDI.setJndi(true);
        configJNDI.setJndiName("jndi:connect");
        configJNDI.setPropertyFileNameDDL("rolesddl.xml");
        configJNDI.setPropertyFileNameDML("rolesdml.xml");
        JdbcSecurityConfigValidator validator = new JdbcSecurityConfigValidator(this.getSecurityManager());
        try {
            configJNDI.setJndiName("");
            validator.validateAddRoleService((SecurityRoleServiceConfig)configJNDI);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"JNDINAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            config.setDriverClassName("");
            validator.validateAddRoleService((SecurityRoleServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DRIVER_CLASSNAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setDriverClassName("a.b.c");
        try {
            config.setUserName("");
            validator.validateAddRoleService((SecurityRoleServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"USERNAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setUserName("user");
        try {
            config.setConnectURL(null);
            validator.validateAddRoleService((SecurityRoleServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"JDBCURL_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setConnectURL("jdbc:connect");
        try {
            validator.validateAddRoleService((SecurityRoleServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DRIVER_CLASS_NOTFOUND", (Object)ex.getId());
            Assert.assertEquals((Object)"a.b.c", (Object)ex.getArgs()[0]);
        }
        config.setDriverClassName("java.lang.String");
        config.setPropertyFileNameDDL(null);
        try {
            validator.validateAddRoleService((SecurityRoleServiceConfig)config);
        }
        catch (SecurityConfigException ex) {
            throw new IOException(ex);
        }
        GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
        EasyMock.expect((Object)secMgr.listRoleServices()).andReturn(new TreeSet<String>(Arrays.asList("default", "jdbc"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{secMgr});
        validator = new JdbcSecurityConfigValidator(secMgr);
        JDBCRoleServiceConfig oldConfig = new JDBCRoleServiceConfig(config);
        config.setPropertyFileNameDML(null);
        try {
            validator.validateModifiedRoleService((SecurityRoleServiceConfig)config, (SecurityRoleServiceConfig)oldConfig);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DML_FILE_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setPropertyFileNameDDL("rolesddl.xml");
        config.setPropertyFileNameDML("rolesdml.xml");
        if (new JdbcSecurityConfigValidator(this.getSecurityManager()).getTempDir() != null) {
            oldConfig = new JDBCRoleServiceConfig(config);
            invalidPath = "abc" + File.separator + "def.properties";
            config.setPropertyFileNameDDL(invalidPath);
            try {
                validator.validateModifiedRoleService((SecurityRoleServiceConfig)config, (SecurityRoleServiceConfig)oldConfig);
                Assert.fail();
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"DDL_FILE_INVALID", (Object)ex.getId());
                Assert.assertEquals((Object)invalidPath, (Object)ex.getArgs()[0]);
            }
        }
        config.setPropertyFileNameDDL("rolesddl.xml");
        config.setPropertyFileNameDML("rolesdml.xml");
        if (new JdbcSecurityConfigValidator(this.getSecurityManager()).getTempDir() != null) {
            oldConfig = new JDBCRoleServiceConfig(config);
            invalidPath = "abc" + File.separator + "def.properties";
            config.setPropertyFileNameDML(invalidPath);
            try {
                validator.validateModifiedRoleService((SecurityRoleServiceConfig)config, (SecurityRoleServiceConfig)oldConfig);
                Assert.fail();
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"DML_FILE_INVALID", (Object)ex.getId());
                Assert.assertEquals((Object)invalidPath, (Object)ex.getArgs()[0]);
            }
        }
        oldConfig = new JDBCRoleServiceConfig(config);
        config.setPropertyFileNameDDL(null);
        config.setCreatingTables(true);
        config.setPropertyFileNameDML("rolesdml.xml");
        try {
            validator.validateModifiedRoleService((SecurityRoleServiceConfig)config, (SecurityRoleServiceConfig)oldConfig);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DDL_FILE_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
    }

    @Test
    public void testUserGroupConfig() throws IOException {
        String invalidPath;
        super.testUserGroupConfig();
        JDBCUserGroupServiceConfig config = (JDBCUserGroupServiceConfig)this.createUGConfig("jdbc", JDBCUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default");
        config.setDriverClassName("a.b.c");
        config.setUserName("user");
        config.setConnectURL("jdbc:connect");
        config.setPropertyFileNameDDL("usersddl.xml");
        config.setPropertyFileNameDML("usersdml.xml");
        JDBCUserGroupServiceConfig configJNDI = (JDBCUserGroupServiceConfig)this.createUGConfig("jdbc", JDBCUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default");
        configJNDI.setJndi(true);
        configJNDI.setJndiName("jndi:connect");
        configJNDI.setPropertyFileNameDDL("usersddl.xml");
        configJNDI.setPropertyFileNameDML("usersdml.xml");
        JdbcSecurityConfigValidator validator = new JdbcSecurityConfigValidator(this.getSecurityManager());
        try {
            configJNDI.setJndiName("");
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)configJNDI);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"JNDINAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            config.setDriverClassName("");
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DRIVER_CLASSNAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setDriverClassName("a.b.c");
        try {
            config.setUserName("");
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"USERNAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setUserName("user");
        try {
            config.setConnectURL(null);
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"JDBCURL_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setConnectURL("jdbc:connect");
        try {
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DRIVER_CLASS_NOTFOUND", (Object)ex.getId());
            Assert.assertEquals((Object)"a.b.c", (Object)ex.getArgs()[0]);
        }
        config.setDriverClassName("java.lang.String");
        config.setPropertyFileNameDDL(null);
        try {
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)config);
        }
        catch (SecurityConfigException ex) {
            throw new IOException(ex);
        }
        GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
        EasyMock.expect((Object)secMgr.listUserGroupServices()).andReturn(new TreeSet<String>(Arrays.asList("default", "jdbc"))).anyTimes();
        GeoServerPlainTextPasswordEncoder pwEncoder = this.getPlainTextPasswordEncoder();
        EasyMock.expect((Object)secMgr.loadPasswordEncoder(pwEncoder.getName())).andReturn((Object)pwEncoder).anyTimes();
        EasyMock.expect((Object)secMgr.listPasswordValidators()).andReturn(new TreeSet<String>(Arrays.asList("default"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{secMgr});
        validator = new JdbcSecurityConfigValidator(secMgr);
        JDBCUserGroupServiceConfig oldConfig = new JDBCUserGroupServiceConfig(config);
        config.setPropertyFileNameDML(null);
        try {
            validator.validateModifiedUserGroupService((SecurityUserGroupServiceConfig)config, (SecurityUserGroupServiceConfig)oldConfig);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DML_FILE_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setPropertyFileNameDDL("usersddl.xml");
        config.setPropertyFileNameDML("usersdml.xml");
        if (new JdbcSecurityConfigValidator(this.getSecurityManager()).getTempDir() != null) {
            oldConfig = new JDBCUserGroupServiceConfig(config);
            invalidPath = "abc" + File.separator + "def.properties";
            config.setPropertyFileNameDDL(invalidPath);
            try {
                validator.validateModifiedUserGroupService((SecurityUserGroupServiceConfig)config, (SecurityUserGroupServiceConfig)oldConfig);
                Assert.fail();
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"DDL_FILE_INVALID", (Object)ex.getId());
                Assert.assertEquals((Object)invalidPath, (Object)ex.getArgs()[0]);
            }
        }
        config.setPropertyFileNameDDL("usersddl.xml");
        config.setPropertyFileNameDML("usersdml.xml");
        if (new JdbcSecurityConfigValidator(this.getSecurityManager()).getTempDir() != null) {
            oldConfig = new JDBCUserGroupServiceConfig(config);
            invalidPath = "abc" + File.separator + "def.properties";
            config.setPropertyFileNameDML(invalidPath);
            try {
                validator.validateModifiedUserGroupService((SecurityUserGroupServiceConfig)config, (SecurityUserGroupServiceConfig)oldConfig);
                Assert.fail();
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"DML_FILE_INVALID", (Object)ex.getId());
                Assert.assertEquals((Object)invalidPath, (Object)ex.getArgs()[0]);
            }
        }
        config.setPropertyFileNameDDL(null);
        config.setCreatingTables(true);
        config.setPropertyFileNameDML("usersdml.xml");
        try {
            validator.validateModifiedUserGroupService((SecurityUserGroupServiceConfig)config, (SecurityUserGroupServiceConfig)oldConfig);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DDL_FILE_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
    }

    @Test
    public void testAuthenticationProvider() throws IOException {
        super.testAuthenticationProvider();
        JDBCConnectAuthProviderConfig config = (JDBCConnectAuthProviderConfig)this.createAuthConfig("jdbcprov", JDBCConnectAuthProvider.class, "default");
        config.setConnectURL("jdbc:connect");
        JdbcSecurityConfigValidator validator = new JdbcSecurityConfigValidator(this.getSecurityManager());
        try {
            config.setDriverClassName("");
            validator.validateAddAuthProvider((SecurityAuthProviderConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DRIVER_CLASSNAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setDriverClassName("a.b.c");
        try {
            validator.validateAddAuthProvider((SecurityAuthProviderConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"DRIVER_CLASS_NOTFOUND", (Object)ex.getId());
            Assert.assertEquals((Object)"a.b.c", (Object)ex.getArgs()[0]);
        }
        try {
            config.setConnectURL(null);
            validator.validateAddAuthProvider((SecurityAuthProviderConfig)config);
            Assert.fail();
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"JDBCURL_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
    }
}

