/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.util.Collections;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.MemoryRoleService;
import org.geoserver.security.impl.MemoryRoleStore;
import org.geoserver.security.ldap.LDAPAuthenticationProvider;
import org.geoserver.security.ldap.LDAPBaseTest;
import org.geoserver.security.ldap.LDAPSecurityServiceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class LDAPAuthenticationProviderTest
extends LDAPBaseTest {
    protected LDAPAuthenticationProvider authProvider;

    @Override
    protected void createConfig() {
        this.config = new LDAPSecurityServiceConfig();
    }

    protected void createAuthenticationProvider() {
        this.authProvider = (LDAPAuthenticationProvider)this.securityProvider.createAuthenticationProvider((SecurityNamedServiceConfig)this.config);
    }

    @RunWith(value=FrameworkRunner.class)
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
    @CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
    @ApplyLdifFiles(value={"data3.ldif"})
    public static class LDAPAuthenticationProviderData3Test
    extends LDAPAuthenticationProviderTest {
        @Test
        public void testColonPassword() throws Exception {
            LDAPAuthenticationProviderData3Test.getService().setAllowAnonymousAccess(true);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.createAuthenticationProvider();
            this.authentication = new UsernamePasswordAuthenticationToken((Object)"colon", (Object)"da:da");
            Authentication result = this.authProvider.authenticate(this.authentication);
            Assert.assertEquals((long)2L, (long)result.getAuthorities().size());
        }
    }

    @RunWith(value=FrameworkRunner.class)
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
    @CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
    @ApplyLdifFiles(value={"data.ldif"})
    public static class LDAPAuthenticationProviderDataTest
    extends LDAPAuthenticationProviderTest {
        @Test
        public void testBindBeforeGroupSearch() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(false);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.config.setBindBeforeGroupSearch(Boolean.valueOf(true));
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authentication);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"admin", (Object)result.getName());
            Assert.assertEquals((long)3L, (long)result.getAuthorities().size());
        }

        @Test
        public void testBindBeforeGroupSearchRequiredIfAnonymousDisabled() throws Exception {
            try {
                LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(false);
                ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
                this.config.setBindBeforeGroupSearch(Boolean.valueOf(false));
                this.createAuthenticationProvider();
                boolean error = false;
                try {
                    this.authProvider.authenticate(this.authentication);
                }
                catch (Exception e) {
                    error = true;
                }
                Assert.assertTrue((boolean)error);
            }
            finally {
                LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(true);
            }
        }

        @Test
        public void testUserFilterAndFormat() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(true);
            this.config.setUserFilter("(telephonenumber=1)");
            ((LDAPSecurityServiceConfig)this.config).setUserFormat("uid={0},ou=People,dc=example,dc=com");
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authentication);
            Assert.assertEquals((long)3L, (long)result.getAuthorities().size());
        }

        @Test
        public void testUserFilterPlacemarks() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(true);
            this.config.setUserFilter("(givenName={1})");
            ((LDAPSecurityServiceConfig)this.config).setUserFormat("uid={0},ou=People,dc=example,dc=com");
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authentication);
            Assert.assertEquals((long)3L, (long)result.getAuthorities().size());
            this.config.setUserFilter("(cn={0})");
            ((LDAPSecurityServiceConfig)this.config).setUserFormat("uid={0},ou=People,dc=example,dc=com");
            this.createAuthenticationProvider();
            result = this.authProvider.authenticate(this.authentication);
            Assert.assertEquals((long)3L, (long)result.getAuthorities().size());
        }

        @Test
        public void testAdminGroup() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(true);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.config.setAdminGroup("other");
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authenticationOther);
            boolean foundAdmin = false;
            for (GrantedAuthority authority : result.getAuthorities()) {
                if (!authority.getAuthority().equalsIgnoreCase("ROLE_ADMINISTRATOR")) continue;
                foundAdmin = true;
            }
            Assert.assertTrue((boolean)foundAdmin);
        }

        @Test
        public void testGroupAdminGroup() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(true);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.config.setGroupAdminGroup("other");
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authenticationOther);
            boolean foundAdmin = false;
            for (GrantedAuthority authority : result.getAuthorities()) {
                if (!authority.getAuthority().equalsIgnoreCase("ROLE_GROUP_ADMIN")) continue;
                foundAdmin = true;
            }
            Assert.assertTrue((boolean)foundAdmin);
        }

        @Test
        public void testRoleService() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(true);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.createAuthenticationProvider();
            this.authProvider.setSecurityManager(this.securityManager);
            this.securityManager.setProviders(Collections.singletonList(this.authProvider));
            MemoryRoleStore roleService = new MemoryRoleStore();
            roleService.initializeFromService((GeoServerRoleService)new MemoryRoleService());
            roleService.setSecurityManager(this.securityManager);
            GeoServerRole role = roleService.createRoleObject("MyRole");
            roleService.addRole(role);
            roleService.associateRoleToUser(role, "other");
            this.securityManager.setActiveRoleService((GeoServerRoleService)roleService);
            Authentication result = this.authProvider.authenticate(this.authenticationOther);
            Assert.assertTrue((boolean)result.getAuthorities().contains(role));
            Assert.assertEquals((long)3L, (long)result.getAuthorities().size());
        }

        @Test
        public void testHierarchicalGroupSearch() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(true);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.config.setBindBeforeGroupSearch(Boolean.valueOf(false));
            this.config.setUseNestedParentGroups(true);
            this.config.setNestedGroupSearchFilter("member=cn={1}");
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authenticationNested);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"nestedUser", (Object)result.getName());
            Assert.assertEquals((long)3L, (long)result.getAuthorities().size());
            Assert.assertTrue((boolean)result.getAuthorities().stream().anyMatch(x -> "ROLE_NESTED".equals(x.getAuthority())));
            Assert.assertTrue((boolean)result.getAuthorities().stream().anyMatch(x -> "ROLE_EXTRA".equals(x.getAuthority())));
        }

        @Test
        public void testBindBeforeHierarchicalGroupSearch() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(false);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.config.setBindBeforeGroupSearch(Boolean.valueOf(true));
            this.config.setUseNestedParentGroups(true);
            this.config.setNestedGroupSearchFilter("member=cn={1}");
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authenticationNested);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"nestedUser", (Object)result.getName());
            Assert.assertEquals((long)3L, (long)result.getAuthorities().size());
            Assert.assertTrue((boolean)result.getAuthorities().stream().anyMatch(x -> "ROLE_NESTED".equals(x.getAuthority())));
            Assert.assertTrue((boolean)result.getAuthorities().stream().anyMatch(x -> "ROLE_EXTRA".equals(x.getAuthority())));
        }

        @Test
        public void testBindBeforeHierarchicalDisabledGroupSearch() throws Exception {
            LDAPAuthenticationProviderDataTest.getService().setAllowAnonymousAccess(false);
            ((LDAPSecurityServiceConfig)this.config).setUserDnPattern("uid={0},ou=People");
            this.config.setBindBeforeGroupSearch(Boolean.valueOf(true));
            this.config.setUseNestedParentGroups(false);
            this.createAuthenticationProvider();
            Authentication result = this.authProvider.authenticate(this.authenticationNested);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"nestedUser", (Object)result.getName());
            Assert.assertEquals((long)2L, (long)result.getAuthorities().size());
            Assert.assertTrue((boolean)result.getAuthorities().stream().anyMatch(x -> "ROLE_NESTED".equals(x.getAuthority())));
            Assert.assertTrue((boolean)result.getAuthorities().stream().noneMatch(x -> "ROLE_EXTRA".equals(x.getAuthority())));
        }
    }
}

