/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.File;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.ldap.LDAPBaseSecurityServiceConfig;
import org.geoserver.security.ldap.LDAPSecurityProvider;
import org.junit.After;
import org.junit.Before;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class LDAPBaseTest
extends AbstractLdapTestUnit {
    protected GeoServerSecurityManager securityManager;
    protected LDAPSecurityProvider securityProvider;
    protected Authentication authentication;
    protected Authentication authenticationOther;
    protected Authentication authenticationNested;
    protected LDAPBaseSecurityServiceConfig config;
    private File tempFolder;
    public static final String ldapServerUrl = "ldap://127.0.0.1";
    public static final String basePath = "dc=example,dc=com";

    @Before
    public void setUp() throws Exception {
        this.tempFolder = File.createTempFile("ldap", "test");
        this.tempFolder.delete();
        this.tempFolder.mkdirs();
        GeoServerResourceLoader resourceLoader = new GeoServerResourceLoader(this.tempFolder);
        this.securityManager = new GeoServerSecurityManager(new GeoServerDataDirectory(resourceLoader));
        this.securityProvider = new LDAPSecurityProvider(this.securityManager);
        this.createConfig();
        this.config.setServerURL("ldap://127.0.0.1:" + LDAPBaseTest.getLdapServer().getPort() + "/dc=example,dc=com");
        this.config.setGroupSearchBase("ou=Groups");
        this.config.setGroupSearchFilter("member=cn={1}");
        this.config.setUseTLS(Boolean.valueOf(false));
        this.authentication = new UsernamePasswordAuthenticationToken((Object)"admin", (Object)"admin");
        this.authenticationOther = new UsernamePasswordAuthenticationToken((Object)"other", (Object)"other");
        this.authenticationNested = new UsernamePasswordAuthenticationToken((Object)"nestedUser", (Object)"other");
    }

    protected abstract void createConfig();

    @After
    public void tearDown() throws Exception {
        this.tempFolder.delete();
        if (SecurityContextHolder.getContext() != null) {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }
}

