/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.io.IOUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.geoserver.security.ldap.EmbeddedLdapServer;
import org.geotools.util.logging.Logging;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.ldif.parser.LdifParser;
import org.springframework.ldap.support.LdapUtils;

public class LDAPTestUtils {
    public static final int LDAP_SERVER_PORT = 10389;
    public static final String LDAP_SERVER_URL = "ldap://127.0.0.1";
    public static final String LDAP_BASE_PATH = "dc=example,dc=com";
    public static final String DEFAULT_PRINCIPAL = "uid=admin,ou=system";
    public static final String DEFAULT_PASSWORD = "secret";
    static final Logger LOGGER = Logging.getLogger(LDAPTestUtils.class);
    private static EmbeddedLdapServer embeddedServer;

    public static void startEmbeddedServer(int port, String defaultPartitionSuffix, String defaultPartitionName, boolean allowAnonymousAccess) {
        if (embeddedServer != null) {
            throw new IllegalStateException("An embedded server is already started");
        }
        try {
            embeddedServer = EmbeddedLdapServer.newEmbeddedServer(defaultPartitionName, defaultPartitionSuffix, port, allowAnonymousAccess);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start embedded server", e);
        }
    }

    public static void shutdownEmbeddedServer() throws Exception {
        if (embeddedServer != null) {
            embeddedServer.shutdown();
            embeddedServer = null;
        }
    }

    public static boolean initLdapServer(boolean allowAnonymous, String ldapServerUrl, String basePath) throws Exception {
        return LDAPTestUtils.initLdapServer(allowAnonymous, ldapServerUrl, basePath, "data.ldif");
    }

    public static boolean initLdapServer(boolean allowAnonymous, String ldapServerUrl, String basePath, String ldifPath) throws Exception {
        try {
            if (!LDAPTestUtils.portIsBusy("127.0.0.1", 10389)) {
                LDAPTestUtils.startEmbeddedServer(10389, basePath, "test", allowAnonymous);
                LdapContextSource contextSource = new LdapContextSource();
                contextSource.setUrl(ldapServerUrl);
                contextSource.setUserDn(DEFAULT_PRINCIPAL);
                contextSource.setPassword(DEFAULT_PASSWORD);
                contextSource.setPooled(false);
                contextSource.afterPropertiesSet();
                LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
                LDAPTestUtils.cleanAndSetup(template.getContextSource(), new LdapName(LDAP_BASE_PATH), (Resource)new ClassPathResource(ldifPath));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean portIsBusy(String host, int port) {
        try (ServerSocket ss = new ServerSocket(port);){
            DatagramSocket ds = new DatagramSocket(port);
            try {
                ss.setReuseAddress(true);
                ds.setReuseAddress(true);
                boolean bl = false;
                ds.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    ds.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(ContextSource contextSource, Name name) throws NamingException {
        DirContext ctx = null;
        try {
            ctx = contextSource.getReadWriteContext();
            LDAPTestUtils.clearSubContexts(ctx, name);
        }
        finally {
            try {
                ctx.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(DirContext ctx, Name name) throws NamingException {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = ctx.listBindings(name);
            while (enumeration.hasMore()) {
                Binding element = enumeration.next();
                ArrayList<Rdn> list = new ArrayList<Rdn>(((LdapName)name).getRdns());
                list.addAll(LdapUtils.newLdapName((String)element.getName()).getRdns());
                LdapName childName = new LdapName(list);
                try {
                    ctx.destroySubcontext(childName);
                }
                catch (ContextNotEmptyException e) {
                    LDAPTestUtils.clearSubContexts(ctx, (Name)childName);
                    ctx.destroySubcontext(childName);
                }
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "", e);
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLdif(ContextSource contextSource, Resource ldifFile) throws IOException {
        DirContext context = contextSource.getReadWriteContext();
        try {
            LDAPTestUtils.loadLdif(context, ldifFile);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void cleanAndSetup(ContextSource contextSource, LdapName rootNode, Resource ldifFile) throws NamingException, IOException {
        LDAPTestUtils.clearSubContexts(contextSource, (Name)rootNode);
        LDAPTestUtils.loadLdif(contextSource, ldifFile);
    }

    private static void loadLdif(DirContext context, Resource ldifFile) throws IOException {
        try {
            LdapName baseDn = (LdapName)context.getEnvironment().get("org.springframework.ldap.base.path");
            LdifParser parser = new LdifParser(ldifFile);
            parser.open();
            while (parser.hasMoreRecords()) {
                LdapAttributes record = parser.getRecord();
                DistinguishedName dn = record.getDN();
                if (baseDn != null) {
                    dn.removeFirst((Name)baseDn);
                }
                context.bind((Name)dn, null, (Attributes)record);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to populate LDIF", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLdif(DefaultDirectoryService directoryService, Resource ldifFile) throws IOException {
        File tempFile = File.createTempFile("spring_ldap_test", ".ldif");
        try (InputStream inputStream = ldifFile.getInputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(tempFile));
            LdifFileLoader fileLoader = new LdifFileLoader(directoryService.getSession(), tempFile.getAbsolutePath());
            fileLoader.execute();
        }
        finally {
            try {
                tempFile.delete();
            }
            catch (Exception exception) {}
        }
    }
}

