/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextCallback;
import org.springframework.ldap.core.AuthenticationErrorCallback;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

public class BindingLdapTemplate
extends SpringSecurityLdapTemplate {
    public BindingLdapTemplate(ContextSource contextSource) {
        super(contextSource);
    }

    public boolean authenticate(Name base, String username, String password, AuthenticatedLdapEntryContextCallback callback, AuthenticationErrorCallback errorCallback) {
        try {
            DirContext ctx = this.getContextSource().getContext(username, password);
            ContextExecutor ce = ctx1 -> {
                callback.executeWithContext(ctx1, null);
                return null;
            };
            try {
                ce.executeWithContext(ctx);
            }
            catch (NamingException e) {
                throw LdapUtils.convertLdapException((NamingException)e);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return true;
        }
        catch (Exception e) {
            errorCallback.execute(e);
            return false;
        }
    }
}

