/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.LocalWorkspaceCatalogFilter;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.CatalogFilterAccessManager;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.geoserver.util.PropertyRule;
import org.geotools.api.filter.Filter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.security.core.Authentication;

public class LocalWorkspaceSecureCatalogTest
extends AbstractAuthorizationTest {
    @Rule
    public PropertyRule inheritance = PropertyRule.system((String)"GEOSERVER_GLOBAL_LAYER_GROUP_INHERIT");

    @Override
    @Before
    public void setUp() throws Exception {
        LocalWorkspaceCatalogFilter.groupInherit = null;
        super.setUp();
        this.populateCatalog();
    }

    CatalogFilterAccessManager setupAccessManager() throws Exception {
        DefaultResourceAccessManager defAsResourceManager = this.buildAccessManager("wideOpen.properties");
        CatalogFilterAccessManager mgr = new CatalogFilterAccessManager();
        mgr.setCatalogFilters(Collections.singletonList(new LocalWorkspaceCatalogFilter(this.catalog)));
        mgr.setDelegate((ResourceAccessManager)defAsResourceManager);
        return mgr;
    }

    @Test
    public void testAccessToLayer() throws Exception {
        CatalogFilterAccessManager mgr = this.setupAccessManager();
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)mgr){};
        Assert.assertNotNull((Object)sc.getLayerByName("topp:states"));
        WorkspaceInfo ws = sc.getWorkspaceByName("nurc");
        LocalWorkspace.set((WorkspaceInfo)ws);
        Assert.assertNull((Object)sc.getWorkspaceByName("topp"));
        Assert.assertNull((Object)sc.getResourceByName("topp:states", ResourceInfo.class));
        Assert.assertNull((Object)sc.getLayerByName("topp:states"));
    }

    @Test
    public void testAccessToStyle() throws Exception {
        CatalogFilterAccessManager mgr = this.setupAccessManager();
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)mgr){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        Assert.assertEquals((long)2L, (long)sc.getStyles().size());
        WorkspaceInfo ws = sc.getWorkspaceByName("topp");
        LocalWorkspace.set((WorkspaceInfo)ws);
        Assert.assertEquals((long)2L, (long)sc.getStyles().size());
        LocalWorkspace.remove();
        ws = sc.getWorkspaceByName("nurc");
        LocalWorkspace.set((WorkspaceInfo)ws);
        Assert.assertEquals((long)1L, (long)sc.getStyles().size());
    }

    @Test
    public void testAccessToLayerGroup() throws Exception {
        CatalogFilterAccessManager mgr = this.setupAccessManager();
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)mgr){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        Assert.assertEquals((long)this.catalog.getLayerGroups().size(), (long)sc.getLayerGroups().size());
        WorkspaceInfo ws = sc.getWorkspaceByName("topp");
        LocalWorkspace.set((WorkspaceInfo)ws);
        Assert.assertEquals((long)this.getWorkspaceAccessibleGroupSize("topp"), (long)sc.getLayerGroups().size());
        LocalWorkspace.remove();
        ws = sc.getWorkspaceByName("nurc");
        LocalWorkspace.set((WorkspaceInfo)ws);
        Assert.assertEquals((long)this.getWorkspaceAccessibleGroupSize("nurc"), (long)sc.getLayerGroups().size());
        Assert.assertEquals((Object)"layerGroup", (Object)((LayerGroupInfo)sc.getLayerGroups().get(0)).getName());
        LocalWorkspace.remove();
    }

    private long getWorkspaceAccessibleGroupSize(String workspaceName) {
        return this.catalog.getLayerGroups().stream().filter(lg -> lg.getWorkspace() == null || workspaceName.equals(lg.getWorkspace().getName())).count();
    }

    @Test
    public void testAccessToLayerGroupNoInheritance() throws Exception {
        CatalogFilterAccessManager mgr = this.setupAccessManager();
        this.inheritance.setValue("false");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)mgr){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        MatcherAssert.assertThat((Object)sc.getLayerGroups(), (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.layerGroupGlobal)));
        MatcherAssert.assertThat((Object)sc.getLayerGroups(), (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.layerGroupTopp)));
        WorkspaceInfo ws = sc.getWorkspaceByName("topp");
        LocalWorkspace.set((WorkspaceInfo)ws);
        MatcherAssert.assertThat((Object)sc.getLayerGroups(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.layerGroupGlobal))));
        MatcherAssert.assertThat((Object)sc.getLayerGroups(), (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.layerGroupTopp)));
        LocalWorkspace.remove();
        ws = sc.getWorkspaceByName("nurc");
        LocalWorkspace.set((WorkspaceInfo)ws);
        MatcherAssert.assertThat((Object)sc.getLayerGroups(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.layerGroupGlobal))));
        MatcherAssert.assertThat((Object)sc.getLayerGroups(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.layerGroupTopp))));
        LocalWorkspace.remove();
    }

    @Test
    public void testAccessToStyleAsIterator() throws Exception {
        int size;
        CatalogFilterAccessManager mgr = this.setupAccessManager();
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)mgr){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)sc, (Class[])new Class[]{SecureCatalogImpl.class});
        try (CloseableIterator styles = sc.list(StyleInfo.class, (Filter)Filter.INCLUDE);){
            int size2 = Iterators.size((Iterator)styles);
            Assert.assertEquals((long)2L, (long)size2);
        }
        WorkspaceInfo ws = sc.getWorkspaceByName("topp");
        LocalWorkspace.set((WorkspaceInfo)ws);
        try (CloseableIterator styles = sc.list(StyleInfo.class, (Filter)Filter.INCLUDE);){
            size = Iterators.size((Iterator)styles);
            Assert.assertEquals((long)2L, (long)size);
        }
        LocalWorkspace.remove();
        ws = sc.getWorkspaceByName("nurc");
        LocalWorkspace.set((WorkspaceInfo)ws);
        styles = sc.list(StyleInfo.class, (Filter)Filter.INCLUDE);
        try {
            size = Iterators.size((Iterator)styles);
            Assert.assertEquals((long)1L, (long)size);
        }
        finally {
            if (styles != null) {
                styles.close();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        LocalWorkspace.remove();
    }
}

