/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AbstractSecurityServiceTest;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.GroupAdminRoleService;
import org.geoserver.security.GroupAdminUserGroupService;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.GroupAdminProperty;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLRoleServiceConfig;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.security.xml.XMLUserGroupServiceConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class GroupAdminServiceTest
extends AbstractSecurityServiceTest {
    protected GeoServerUserGroupStore ugStore;
    protected GeoServerRoleStore roleStore;
    GeoServerUser bob;
    GeoServerUser alice;
    GeoServerUserGroup users;
    GeoServerUserGroup admins;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerUserGroupService ugService = this.createUserGroupService("gaugs");
        GeoServerRoleService roleService = this.createRoleService("gars");
        this.getSecurityManager().setActiveRoleService(roleService);
        GeoServerUserGroupStore ugStore = this.createStore(ugService);
        GeoServerUser bob = ugStore.createUserObject("bob", "foobar", true);
        GroupAdminProperty.set((Properties)bob.getProperties(), (String[])new String[]{"users"});
        ugStore.addUser(bob);
        GeoServerUser alice = ugStore.createUserObject("alice", "foobar", true);
        ugStore.addUser(alice);
        GeoServerUserGroup users = ugStore.createGroupObject("users", true);
        ugStore.addGroup(users);
        GeoServerUserGroup admins = ugStore.createGroupObject("admins", true);
        ugStore.addGroup(admins);
        ugStore.store();
        GeoServerRole groupAdminRole = null;
        GeoServerRoleStore roleStore = this.createStore(roleService);
        roleStore.addRole(roleStore.createRoleObject("adminRole"));
        groupAdminRole = roleStore.createRoleObject("groupAdminRole");
        roleStore.addRole(groupAdminRole);
        roleStore.associateRoleToUser(groupAdminRole, bob.getUsername());
        roleStore.store();
    }

    @Before
    public void init() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        this.ugStore = secMgr.loadUserGroupService("gaugs").createStore();
        this.roleStore = secMgr.loadRoleService("gars").createStore();
        this.bob = this.ugStore.getUserByUsername("bob");
        this.alice = this.ugStore.getUserByUsername("alice");
        this.users = this.ugStore.getGroupByGroupname("users");
        this.admins = this.ugStore.getGroupByGroupname("admins");
    }

    @Before
    public void removeBill() throws Exception {
        GeoServerUserGroupStore ugStore = this.getSecurityManager().loadUserGroupService("gaugs").createStore();
        GeoServerUser bill = ugStore.getUserByUsername("bill");
        if (bill != null) {
            ugStore.removeUser(bill);
            ugStore.store();
        } else {
            ugStore.load();
        }
    }

    @After
    public void clearAuth() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public GeoServerRoleService createRoleService(String name) throws Exception {
        XMLRoleServiceConfig config = new XMLRoleServiceConfig();
        config.setName(name);
        config.setAdminRoleName("adminRole");
        config.setGroupAdminRoleName("groupAdminRole");
        config.setClassName(XMLRoleService.class.getName());
        config.setCheckInterval(1000L);
        config.setFileName("roles.xml");
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)config);
        return this.getSecurityManager().loadRoleService(config.getName());
    }

    public GeoServerUserGroupService createUserGroupService(String name) throws Exception {
        XMLUserGroupServiceConfig config = new XMLUserGroupServiceConfig();
        config.setName(name);
        config.setClassName(XMLUserGroupService.class.getName());
        config.setFileName("users.xml");
        config.setCheckInterval(1000L);
        config.setPasswordEncoderName(this.getDigestPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)config);
        return this.getSecurityManager().loadUserGroupService(name);
    }

    void setAuth() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)this.bob, (Object)this.bob.getPassword(), Collections.singletonList(GeoServerRole.GROUP_ADMIN_ROLE));
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
    }

    @Test
    public void testWrapRoleService() throws Exception {
        GeoServerRoleService roleService = this.getSecurityManager().getActiveRoleService();
        Assert.assertFalse((boolean)(roleService instanceof GroupAdminRoleService));
        this.setAuth();
        roleService = this.getSecurityManager().getActiveRoleService();
        Assert.assertTrue((boolean)(roleService instanceof GroupAdminRoleService));
    }

    @Test
    public void testWrapUserGroupService() throws Exception {
        GeoServerUserGroupService ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        Assert.assertFalse((boolean)(ugService instanceof GroupAdminUserGroupService));
        this.setAuth();
        ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        Assert.assertTrue((boolean)(ugService instanceof GroupAdminUserGroupService));
    }

    @Test
    public void testHideAdminRole() throws Exception {
        GeoServerRoleService roleService = this.getSecurityManager().getActiveRoleService();
        GeoServerRole adminRole = roleService.createRoleObject("adminRole");
        Assert.assertTrue((boolean)roleService.getRoles().contains(adminRole));
        Assert.assertNotNull((Object)roleService.getAdminRole());
        Assert.assertNotNull((Object)roleService.getRoleByName("adminRole"));
        this.setAuth();
        roleService = this.getSecurityManager().getActiveRoleService();
        Assert.assertFalse((boolean)roleService.getRoles().contains(adminRole));
        Assert.assertNull((Object)roleService.getAdminRole());
        Assert.assertNull((Object)roleService.getRoleByName("adminRole"));
    }

    @Test
    public void testHideGroups() throws Exception {
        Assume.assumeFalse((System.getProperty("macos-github-build") != null ? 1 : 0) != 0);
        GeoServerUserGroupService ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        Assert.assertTrue((boolean)ugService.getUserGroups().contains(this.users));
        Assert.assertNotNull((Object)ugService.getGroupByGroupname("users"));
        Assert.assertTrue((boolean)ugService.getUserGroups().contains(this.admins));
        Assert.assertNotNull((Object)ugService.getGroupByGroupname("admins"));
        this.setAuth();
        ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        Assert.assertTrue((boolean)ugService.getUserGroups().contains(this.users));
        Assert.assertNotNull((Object)ugService.getGroupByGroupname("users"));
        Assert.assertFalse((boolean)ugService.getUserGroups().contains(this.admins));
        Assert.assertNull((Object)ugService.getGroupByGroupname("admins"));
    }

    @Test
    public void testRoleServiceReadOnly() throws Exception {
        this.setAuth();
        GeoServerRoleService roleService = this.getSecurityManager().getActiveRoleService();
        Assert.assertFalse((boolean)roleService.canCreateStore());
        Assert.assertNull((Object)roleService.createStore());
    }

    @Test
    public void testCreateNewUser() throws Exception {
        this.setAuth();
        GeoServerUserGroupService ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        GeoServerUserGroupStore ugStore = ugService.createStore();
        GeoServerUser bill = ugStore.createUserObject("bill", "foobar", true);
        ugStore.addUser(bill);
        ugStore.store();
        Assert.assertNotNull((Object)ugService.getUserByUsername("bill"));
    }

    @Test
    public void testAssignUserToGroup() throws Exception {
        this.testCreateNewUser();
        GeoServerUserGroupService ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        GeoServerUserGroupStore ugStore = ugService.createStore();
        GeoServerUser bill = ugStore.getUserByUsername("bill");
        ugStore.associateUserToGroup(bill, this.users);
        ugStore.store();
        Assert.assertEquals((long)1L, (long)ugStore.getGroupsForUser(bill).size());
        Assert.assertTrue((boolean)ugStore.getGroupsForUser(bill).contains(this.users));
        ugStore.associateUserToGroup(bill, this.admins);
        ugStore.store();
        Assert.assertEquals((long)1L, (long)ugStore.getGroupsForUser(bill).size());
        Assert.assertTrue((boolean)ugStore.getGroupsForUser(bill).contains(this.users));
        Assert.assertFalse((boolean)ugStore.getGroupsForUser(bill).contains(this.admins));
    }

    @Test
    public void testRemoveUserInGroup() throws Exception {
        this.testAssignUserToGroup();
        GeoServerUserGroupService ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        GeoServerUserGroupStore ugStore = ugService.createStore();
        GeoServerUser bill = ugStore.getUserByUsername("bill");
        ugStore.removeUser(bill);
        ugStore.store();
        Assert.assertNull((Object)ugStore.getUserByUsername("bill"));
    }

    @Test
    public void testRemoveUserNotInGroup() throws Exception {
        Assume.assumeFalse((System.getProperty("macos-github-build") != null ? 1 : 0) != 0);
        GeoServerUserGroupService ugService = this.getSecurityManager().loadUserGroupService(this.ugStore.getName());
        GeoServerUserGroupStore ugStore = ugService.createStore();
        GeoServerUser sally = ugStore.createUserObject("sally", "foobar", true);
        ugStore.addUser(sally);
        ugStore.associateUserToGroup(sally, this.admins);
        ugStore.store();
        this.setAuth();
        ugService = this.getSecurityManager().loadUserGroupService(ugStore.getName());
        ugStore = ugService.createStore();
        try {
            ugStore.removeUser(sally);
            Assert.fail();
        }
        catch (IOException e) {
            ugStore.load();
        }
    }
}

