/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import org.geoserver.data.test.Security_2_2_TestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.VariableFilterChain;
import org.geoserver.security.config.RoleFilterConfig;
import org.geoserver.security.config.SSLFilterConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.StringUtils;

public class MigrateFrom_2_2_Test
extends GeoServerSystemTestSupport {
    protected SystemTestData createTestData() throws Exception {
        return new Security_2_2_TestData();
    }

    @Test
    public void testMigration() throws Exception {
        File logoutFilterDir = new File(this.getSecurityManager().get("security/filter").dir(), "formLogout");
        File oldLogoutFilterConfig = new File(logoutFilterDir, "config.xml.2.2.x");
        Assert.assertTrue((boolean)oldLogoutFilterConfig.exists());
        File oldSecManagerConfig = new File(this.getSecurityManager().get("security").dir(), "config.xml.2.2.x");
        Assert.assertTrue((boolean)oldSecManagerConfig.exists());
        RoleFilterConfig rfConfig = (RoleFilterConfig)this.getSecurityManager().loadFilterConfig("roleFilter", true);
        Assert.assertNotNull((Object)rfConfig);
        SSLFilterConfig sslConfig = (SSLFilterConfig)this.getSecurityManager().loadFilterConfig("sslFilter", true);
        Assert.assertNotNull((Object)sslConfig);
        Assert.assertNull((Object)this.getSecurityManager().loadFilterConfig("guiException", true));
        SecurityManagerConfig config = this.getSecurityManager().loadSecurityConfig();
        for (RequestFilterChain chain : config.getFilterChain().getRequestChains()) {
            Assert.assertFalse((boolean)chain.getFilterNames().contains("exception"));
            Assert.assertFalse((boolean)chain.getFilterNames().remove("interceptor"));
            Assert.assertFalse((boolean)chain.getFilterNames().remove("restInterceptor"));
            Assert.assertFalse((boolean)chain.getFilterNames().remove("contextAsc"));
            Assert.assertFalse((boolean)chain.getFilterNames().remove("contextNoAsc"));
            Assert.assertFalse((boolean)chain.isDisabled());
            Assert.assertFalse((boolean)chain.isRequireSSL());
            Assert.assertFalse((boolean)StringUtils.hasLength((String)chain.getRoleFilterName()));
            if ("web".equals(chain.getName()) || "webLogin".equals(chain.getName()) || "webLogout".equals(chain.getName())) {
                Assert.assertTrue((boolean)chain.isAllowSessionCreation());
            } else {
                Assert.assertFalse((boolean)chain.isAllowSessionCreation());
            }
            if (!(chain instanceof VariableFilterChain)) continue;
            VariableFilterChain vchain = (VariableFilterChain)chain;
            Assert.assertEquals((Object)"exception", (Object)vchain.getExceptionTranslationName());
            if ("rest".equals(vchain.getName()) || "gwc".equals(vchain.getName())) {
                Assert.assertEquals((Object)"restInterceptor", (Object)vchain.getInterceptorName());
                continue;
            }
            Assert.assertEquals((Object)"interceptor", (Object)vchain.getInterceptorName());
        }
    }

    @Test
    public void testWebLoginChainSessionCreation() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        SecurityManagerConfig config = secMgr.loadSecurityConfig();
        RequestFilterChain chain = config.getFilterChain().getRequestChainByName("webLogin");
        Assert.assertTrue((boolean)chain.isAllowSessionCreation());
    }
}

