/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.file;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.awaitility.Awaitility;
import org.geoserver.platform.resource.Files;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.file.RoleFileWatcher;
import org.geoserver.security.file.UserGroupFileWatcher;
import org.geoserver.security.impl.AbstractRoleService;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;

public class FileTest {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    int gaCounter = 0;
    int ugCounter = 0;
    GeoServerRoleService gaService = new AbstractRoleService(){

        public String getName() {
            return "TestGAService";
        }

        protected void deserialize() throws IOException {
            ++FileTest.this.gaCounter;
        }

        public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
            super.initializeFromConfig(config);
        }
    };
    GeoServerUserGroupService ugService = new AbstractUserGroupService(){

        public String getName() {
            return "TestUGService";
        }

        protected void deserialize() throws IOException {
            ++FileTest.this.ugCounter;
        }

        public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileWatcher() throws Exception {
        Files.schedule((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            File ugFile = File.createTempFile("users", ".xml");
            ugFile.deleteOnExit();
            File gaFile = File.createTempFile("roles", ".xml");
            gaFile.deleteOnExit();
            RoleFileWatcher gaWatcher = new RoleFileWatcher(Files.asResource((File)gaFile), this.gaService);
            Assert.assertEquals((long)1L, (long)this.gaCounter);
            gaWatcher.start();
            UserGroupFileWatcher ugWatcher = new UserGroupFileWatcher(Files.asResource((File)ugFile), this.ugService);
            Assert.assertEquals((long)1L, (long)this.ugCounter);
            ugWatcher.start();
            LOGGER.info(gaWatcher.toString());
            LOGGER.info(ugWatcher.toString());
            ugFile.setLastModified(ugFile.lastModified() + 1000L);
            gaFile.setLastModified(gaFile.lastModified() + 1000L);
            Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> this.ugCounter == 2 && this.gaCounter == 2);
            ugWatcher.setTerminate(true);
            gaWatcher.setTerminate(true);
            ugFile.delete();
            gaFile.delete();
        }
        finally {
            Files.schedule((long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

