/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.AbstractAccesRuleDAOConcurrencyTest;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.MemoryDataAccessRuleDAO;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class DataAccesRuleDAOConcurrencyTest
extends AbstractAccesRuleDAOConcurrencyTest<DataAccessRuleDAO> {
    @Override
    protected DataAccessRuleDAO buildDAO() throws Exception {
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)catalog.getWorkspaceByName((String)EasyMock.anyObject())).andReturn((Object)new WorkspaceInfoImpl()).anyTimes();
        EasyMock.expect((Object)catalog.getLayerByName((String)EasyMock.anyObject())).andReturn((Object)new LayerInfoImpl()).anyTimes();
        EasyMock.replay((Object[])new Object[]{catalog});
        Properties props = new Properties();
        props.put("mode", "CHALLENGE");
        props.put("*.*.r", "*");
        return new MemoryDataAccessRuleDAO(catalog, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void manipulate(int c) throws IOException {
        String customRole = "R_TEST_" + c;
        String ws = "w" + c;
        String layer = "l" + c;
        ((DataAccessRuleDAO)this.dao).getRules();
        DataAccessRule rule = new DataAccessRule(ws, layer, AccessMode.READ, new String[]{"R_READ", "R_WRITE", customRole});
        DataAccessRuleDAO dataAccessRuleDAO = (DataAccessRuleDAO)this.dao;
        synchronized (dataAccessRuleDAO) {
            ((DataAccessRuleDAO)this.dao).addRule((Comparable)rule);
            ((DataAccessRuleDAO)this.dao).storeRules();
        }
        Assert.assertEquals(Collections.singleton(rule), (Object)((DataAccessRuleDAO)this.dao).getRulesAssociatedWithRole(customRole));
        ((DataAccessRuleDAO)this.dao).getRules();
        dataAccessRuleDAO = (DataAccessRuleDAO)this.dao;
        synchronized (dataAccessRuleDAO) {
            ((DataAccessRuleDAO)this.dao).removeRule((Comparable)rule);
            ((DataAccessRuleDAO)this.dao).storeRules();
        }
        MatcherAssert.assertThat((Object)((DataAccessRuleDAO)this.dao).getRules(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)rule)));
        Assert.assertEquals((Object)CatalogMode.CHALLENGE, (Object)((DataAccessRuleDAO)this.dao).getMode());
        return null;
    }
}

