/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.security.impl.DataAccesRuleDAOConcurrencyTest;
import org.geoserver.security.impl.DataAccessRuleDAO;

public class DataAccesRuleDAOFileConcurrencyTest
extends DataAccesRuleDAOConcurrencyTest {
    @Override
    protected DataAccessRuleDAO buildDAO() throws Exception {
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)catalog.getWorkspaceByName((String)EasyMock.anyObject())).andReturn((Object)new WorkspaceInfoImpl()).anyTimes();
        EasyMock.expect((Object)catalog.getLayerByName((String)EasyMock.anyObject())).andReturn((Object)new LayerInfoImpl()).anyTimes();
        EasyMock.replay((Object[])new Object[]{catalog});
        Properties props = new Properties();
        props.put("mode", "CHALLENGE");
        props.put("*.*.r", "*");
        File dir = new File("target/layers-concurrency");
        FileUtils.deleteQuietly((File)dir);
        dir.mkdir();
        try (FileOutputStream fos = new FileOutputStream(new File(dir, "layers.properties"));){
            props.store(fos, null);
        }
        FileSystemResourceStore store = new FileSystemResourceStore(dir);
        return new DataAccessRuleDAO(catalog, store.get(""));
    }

    @Override
    protected int getLoops() {
        return 50000;
    }
}

