/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AbstractSecurityServiceTest;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.config.J2eeRoleServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.impl.GeoServerJ2eeRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.util.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class GeoServerJ2eeRoleServiceTest
extends AbstractSecurityServiceTest {
    public GeoServerRoleService createRoleService(String name) throws Exception {
        J2eeRoleServiceConfig config = new J2eeRoleServiceConfig();
        config.setName(name);
        config.setClassName(GeoServerJ2eeRoleService.class.getName());
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)config);
        return null;
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.createRoleService("test1");
        this.createRoleService("test2");
    }

    @Test
    public void testNoRoles() throws Exception {
        this.assertIsValid("web1.xml");
        this.copyWebXML("web1.xml");
        GeoServerRoleService service = this.getSecurityManager().loadRoleService("test1");
        this.checkEmpty(service);
    }

    @Test
    public void testRoles() throws Exception {
        this.assertIsValid("web2.xml");
        this.copyWebXML("web2.xml");
        GeoServerRoleService service = this.getSecurityManager().loadRoleService("test2");
        Assert.assertEquals((long)4L, (long)service.getRoleCount());
        Assert.assertTrue((boolean)service.getRoles().contains(new GeoServerRole("role1")));
        Assert.assertTrue((boolean)service.getRoles().contains(new GeoServerRole("role2")));
        Assert.assertTrue((boolean)service.getRoles().contains(new GeoServerRole("employee")));
        Assert.assertTrue((boolean)service.getRoles().contains(new GeoServerRole("MGR")));
    }

    protected void copyWebXML(String name) throws IOException {
        File dataDir = this.getDataDirectory().root();
        File to = new File(dataDir, "WEB-INF");
        to = new File(to, "web.xml");
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(name), (File)to);
    }

    protected void assertIsValid(String name) throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new Source[]{new StreamSource(new File("src/test/resources/org/geoserver/security/xsd/xml.xsd")), new StreamSource(new File("src/test/resources/org/geoserver/security/xsd/web-app_3_1.xsd")), new StreamSource(new File("src/test/resources/org/geoserver/security/xsd/web-common_3_1.xsd")), new StreamSource(new File("src/test/resources/org/geoserver/security/xsd/javaee_7.xsd")), new StreamSource(new File("src/test/resources/org/geoserver/security/xsd/javaee_web_services_client_1_4.xsd")), new StreamSource(new File("src/test/resources/org/geoserver/security/xsd/jsp_2_3.xsd"))});
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(new File("src/test/resources/org/geoserver/security/impl/" + name)));
    }
}

