/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Properties;
import org.easymock.EasyMock;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.security.impl.AbstractAccesRuleDAOConcurrencyTest;
import org.geoserver.security.impl.RESTAccessRuleDAO;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class RESTAccessRuleDAOTest
extends AbstractAccesRuleDAOConcurrencyTest<RESTAccessRuleDAO> {
    @Override
    protected RESTAccessRuleDAO buildDAO() throws Exception {
        Properties props = new Properties();
        props.put("/rest/**;GET,POST,PUT,DELETE=", "ROLE_ADMINISTRATOR");
        GeoServerDataDirectory dd = (GeoServerDataDirectory)EasyMock.mock(GeoServerDataDirectory.class);
        return new MemoryRESTAccessRuleDAO(dd, props);
    }

    @Override
    protected Void manipulate(int c) {
        String customRole = "R_TEST" + c;
        String rule = "/rest/resource" + c + ";GET,POST,PUT,DELETE=" + customRole;
        ((RESTAccessRuleDAO)this.dao).getRules();
        ((RESTAccessRuleDAO)this.dao).addRule((Comparable)((Object)rule));
        MatcherAssert.assertThat((Object)((RESTAccessRuleDAO)this.dao).getRules(), (Matcher)CoreMatchers.hasItem((Object)rule));
        ((RESTAccessRuleDAO)this.dao).removeRule((Comparable)((Object)rule));
        return null;
    }

    static class MemoryRESTAccessRuleDAO
    extends RESTAccessRuleDAO {
        public MemoryRESTAccessRuleDAO(GeoServerDataDirectory dd, Properties props) throws IOException {
            super(dd);
            this.loadRules(props);
        }

        protected void checkPropertyFile(boolean force) {
            this.lastModified = Long.MAX_VALUE;
        }
    }
}

