/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.SecuredLayerGroupInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class SecuredLayerGroupTest
extends GeoServerSystemTestSupport {
    @Test
    public void testCreateNewLayerGroup() throws Exception {
        LayerGroupInfo lg = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        CatalogFactory factory = (CatalogFactory)EasyMock.createNiceMock(CatalogFactory.class);
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)catalog.getFactory()).andReturn((Object)factory);
        EasyMock.replay((Object[])new Object[]{catalog});
        EasyMock.expect((Object)factory.createLayerGroup()).andReturn((Object)lg);
        EasyMock.replay((Object[])new Object[]{factory});
        SecureCatalogImpl secureCatalog = new SecureCatalogImpl(catalog);
        LayerGroupInfo layerGroup = secureCatalog.getFactory().createLayerGroup();
        Assert.assertTrue((boolean)(layerGroup instanceof SecuredLayerGroupInfo));
        Assert.assertSame((Object)((SecuredLayerGroupInfo)layerGroup).unwrap(LayerGroupInfo.class), (Object)lg);
    }

    @Test
    public void testGetLayerGroup() throws Exception {
        LayerGroupInfo lg = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        EasyMock.expect((Object)lg.getWorkspace()).andReturn(null);
        ArrayList layers = new ArrayList();
        EasyMock.expect((Object)lg.getLayers()).andReturn(layers);
        EasyMock.replay((Object[])new Object[]{lg});
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)catalog.getLayerGroup("lg")).andReturn((Object)lg);
        EasyMock.replay((Object[])new Object[]{catalog});
        SecureCatalogImpl secureCatalog = new SecureCatalogImpl(catalog);
        LayerGroupInfo layerGroup = secureCatalog.getLayerGroup("lg");
        Assert.assertTrue((boolean)(layerGroup instanceof SecuredLayerGroupInfo));
        Assert.assertSame((Object)((SecuredLayerGroupInfo)layerGroup).unwrap(LayerGroupInfo.class), (Object)lg);
    }

    @Test
    public void testLayerGroupSynchronised() throws Exception {
        LayerInfo layer1 = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        LayerInfo layer2 = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        LayerGroupInfo lg = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        ArrayList layers = new ArrayList();
        EasyMock.expect((Object)lg.getLayers()).andReturn(layers).anyTimes();
        lg.setRootLayer(layer1);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{lg});
        ArrayList securedLayers = new ArrayList();
        SecuredLayerGroupInfo securedLg = new SecuredLayerGroupInfo(lg, null, securedLayers, new ArrayList());
        securedLg.getLayers().add(new SecuredLayerInfo(layer1, null));
        securedLg.getLayers().add(new SecuredLayerInfo(layer2, null));
        Assert.assertEquals((long)2L, (long)securedLg.getLayers().size());
        Assert.assertEquals((long)2L, (long)layers.size());
        Assert.assertSame(layers.get(0), (Object)layer1);
        Assert.assertSame(layers.get(1), (Object)layer2);
        securedLg.getLayers().remove(1);
        Assert.assertEquals((long)1L, (long)securedLg.getLayers().size());
        Assert.assertEquals((long)1L, (long)layers.size());
        securedLg.setRootLayer((LayerInfo)new SecuredLayerInfo(layer2, null));
    }

    @Test
    public void testStyleGroup() throws Exception {
        LayerGroupInfo lg = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        EasyMock.expect((Object)lg.getWorkspace()).andReturn(null);
        ArrayList<Object> layers = new ArrayList<Object>();
        layers.add(null);
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        StyleInfo s = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        EasyMock.expect((Object)s.getName()).andReturn((Object)"styleGroup");
        styles.add(s);
        EasyMock.replay((Object[])new Object[]{s});
        EasyMock.expect((Object)lg.getLayers()).andReturn(layers);
        EasyMock.expect((Object)lg.getStyles()).andReturn(styles);
        EasyMock.replay((Object[])new Object[]{lg});
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)catalog.getLayerGroup("lg")).andReturn((Object)lg);
        EasyMock.replay((Object[])new Object[]{catalog});
        SecureCatalogImpl secureCatalog = new SecureCatalogImpl(catalog);
        LayerGroupInfo layerGroup = secureCatalog.getLayerGroup("lg");
        Assert.assertTrue((boolean)(layerGroup instanceof SecuredLayerGroupInfo));
        Assert.assertSame((Object)((SecuredLayerGroupInfo)layerGroup).unwrap(LayerGroupInfo.class), (Object)lg);
        Assert.assertEquals((long)1L, (long)layerGroup.getLayers().size());
        Assert.assertEquals((long)1L, (long)layerGroup.getStyles().size());
    }
}

