/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.DigestAuthenticationFilterConfig;
import org.geoserver.security.config.ExceptionTranslationFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationBaseFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationFilterConfig;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RequestHeaderAuthenticationFilterConfig;
import org.geoserver.security.config.RoleFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SecurityInterceptorFilterConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationFilterConfig;
import org.geoserver.security.config.X509CertificateAuthenticationFilterConfig;
import org.geoserver.security.filter.GeoServerDigestAuthenticationFilter;
import org.geoserver.security.filter.GeoServerExceptionTranslationFilter;
import org.geoserver.security.filter.GeoServerJ2eeAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRequestHeaderAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRoleFilter;
import org.geoserver.security.filter.GeoServerSecurityInterceptorFilter;
import org.geoserver.security.filter.GeoServerUserNamePasswordAuthenticationFilter;
import org.geoserver.security.filter.GeoServerX509CertificateAuthenticationFilter;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.security.validation.FilterConfigValidator;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.test.GeoServerMockTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class FilterConfigValidatorTest
extends GeoServerMockTestSupport {
    @Test
    public void testDigestConfigValidation() throws Exception {
        DigestAuthenticationFilterConfig config = new DigestAuthenticationFilterConfig();
        config.setClassName(GeoServerDigestAuthenticationFilter.class.getName());
        config.setName("testDigest");
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        FilterConfigValidator validator = new FilterConfigValidator(secMgr);
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no user group service should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"USER_GROUP_SERVICE_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setUserGroupServiceName("blabla");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"unknown user group service should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_USER_GROUP_SERVICE", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"blabla", (Object)ex.getArgs()[0]);
        }
        config.setUserGroupServiceName(XMLUserGroupService.DEFAULT_NAME);
        config.setNonceValiditySeconds(-1);
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"invalid nonce should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"INVALID_SECONDS", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setNonceValiditySeconds(100);
        validator.validateFilterConfig(config);
    }

    @Test
    public void testRoleFilterConfigValidation() throws Exception {
        RoleFilterConfig config = new RoleFilterConfig();
        config.setClassName(GeoServerRoleFilter.class.getName());
        config.setName("testRoleFilter");
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        FilterConfigValidator validator = new FilterConfigValidator(secMgr);
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no header attribute should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"HEADER_ATTRIBUTE_NAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setHttpResponseHeaderAttrForIncludedRoles("roles");
        config.setRoleConverterName("unknown");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"unkonwn role converter should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_ROLE_CONVERTER", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"unknown", (Object)ex.getArgs()[0]);
        }
        config.setRoleConverterName(null);
        validator.validateFilterConfig(config);
    }

    @Test
    public void testSecurityInterceptorFilterConfigValidation() throws Exception {
        SecurityInterceptorFilterConfig config = new SecurityInterceptorFilterConfig();
        config.setClassName(GeoServerSecurityInterceptorFilter.class.getName());
        config.setName("testInterceptFilter");
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        FilterConfigValidator validator = new FilterConfigValidator(secMgr);
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no metadata source should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"SECURITY_METADATA_SOURCE_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setSecurityMetadataSource("unknown");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"unknown metadata source should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_SECURITY_METADATA_SOURCE", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"unknown", (Object)ex.getArgs()[0]);
        }
    }

    @Test
    public void testX509FilterConfigValidation() throws Exception {
        X509CertificateAuthenticationFilterConfig config = new X509CertificateAuthenticationFilterConfig();
        config.setClassName(GeoServerX509CertificateAuthenticationFilter.class.getName());
        config.setName("testX509");
        this.check((J2eeAuthenticationBaseFilterConfig)config);
    }

    @Test
    public void testUsernamePasswordFilterConfigValidation() throws Exception {
        UsernamePasswordAuthenticationFilterConfig config = new UsernamePasswordAuthenticationFilterConfig();
        config.setClassName(GeoServerUserNamePasswordAuthenticationFilter.class.getName());
        config.setName("testUsernamePassword");
        FilterConfigValidator validator = new FilterConfigValidator(this.getSecurityManager());
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no user should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"USER_PARAMETER_NAME_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setUsernameParameterName("user");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no password should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"PASSWORD_PARAMETER_NAME_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setPasswordParameterName("password");
        validator.validateFilterConfig(config);
    }

    @Test
    public void testJ2eeFilterConfigValidation() throws Exception {
        J2eeAuthenticationFilterConfig config = new J2eeAuthenticationFilterConfig();
        config.setClassName(GeoServerJ2eeAuthenticationFilter.class.getName());
        config.setName("testJ2ee");
        this.check((J2eeAuthenticationBaseFilterConfig)config);
    }

    @Test
    public void testExceptionTranslationFilterConfigValidation() throws Exception {
        ExceptionTranslationFilterConfig config = new ExceptionTranslationFilterConfig();
        config.setClassName(GeoServerExceptionTranslationFilter.class.getName());
        config.setName("testEx");
        FilterConfigValidator validator = new FilterConfigValidator(this.getSecurityManager());
        config.setAuthenticationFilterName("unknown");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"invalid entry point should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"INVALID_ENTRY_POINT", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"unknown", (Object)ex.getArgs()[0]);
        }
        config.setAuthenticationFilterName("interceptor");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no auth entry point should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"NO_AUTH_ENTRY_POINT", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"interceptor", (Object)ex.getArgs()[0]);
        }
        config.setAuthenticationFilterName(null);
        validator.validateFilterConfig(config);
    }

    public void check(PreAuthenticatedUserNameFilterConfig config) throws Exception {
        FilterConfigValidator validator = new FilterConfigValidator(this.getSecurityManager());
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no role source should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"ROLE_SOURCE_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no user group service should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"USER_GROUP_SERVICE_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setUserGroupServiceName("blabla");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"unknown group service should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_USER_GROUP_SERVICE", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"blabla", (Object)ex.getArgs()[0]);
        }
        config.setUserGroupServiceName(XMLUserGroupService.DEFAULT_NAME);
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService);
        config.setRoleServiceName("blabla");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"unknown role service should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_ROLE_SERVICE", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"blabla", (Object)ex.getArgs()[0]);
        }
        config.setRoleServiceName(XMLRoleService.DEFAULT_NAME);
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header);
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no roles header attribute should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"ROLES_HEADER_ATTRIBUTE_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setRolesHeaderAttribute("roles");
        config.setRoleConverterName("unknown");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"unknown role converter should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_ROLE_CONVERTER", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"unknown", (Object)ex.getArgs()[0]);
        }
        config.setRoleConverterName(null);
        validator.validateFilterConfig(config);
    }

    public void check(J2eeAuthenticationBaseFilterConfig config) throws Exception {
        this.check((PreAuthenticatedUserNameFilterConfig)config);
        FilterConfigValidator validator = new FilterConfigValidator(this.getSecurityManager());
        config.setRoleSource((RoleSource)J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE);
        config.setRoleServiceName("blabla");
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"unknown role service should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_ROLE_SERVICE", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"blabla", (Object)ex.getArgs()[0]);
        }
        config.setRoleServiceName(XMLRoleService.DEFAULT_NAME);
    }

    @Test
    public void testRequestHeaderFilterConfigValidation() throws Exception {
        RequestHeaderAuthenticationFilterConfig config = new RequestHeaderAuthenticationFilterConfig();
        config.setClassName(GeoServerRequestHeaderAuthenticationFilter.class.getName());
        config.setName("testRequestHeader");
        FilterConfigValidator validator = new FilterConfigValidator(this.getSecurityManager());
        try {
            validator.validateFilterConfig(config);
            Assert.fail((String)"no principal header attribute should fail");
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"PRINCIPAL_HEADER_ATTRIBUTE_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setPrincipalHeaderAttribute("user");
        this.check((PreAuthenticatedUserNameFilterConfig)config);
    }
}

