/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.net.URL;
import org.geoserver.security.password.MasterPasswordChangeRequest;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.password.MasterPasswordProviderException;
import org.geoserver.security.password.URLMasterPasswordProvider;
import org.geoserver.security.password.URLMasterPasswordProviderConfig;
import org.geoserver.security.password.URLMasterPasswordProviderException;
import org.geoserver.security.validation.MasterPasswordChangeException;
import org.geoserver.security.validation.MasterPasswordChangeValidator;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.test.GeoServerMockTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MasterPasswordChangeValidatorTest
extends GeoServerMockTestSupport {
    MasterPasswordChangeValidator validator;

    @Before
    public void setValidator() {
        this.validator = new MasterPasswordChangeValidator(this.getSecurityManager());
    }

    protected void checkCurrentPassword(MasterPasswordChangeRequest r) throws Exception {
        try {
            this.validator.validateChangeRequest(r);
            Assert.fail();
        }
        catch (MasterPasswordChangeException ex) {
            this.assertSecurityException(ex, "CURRENT_PASSWORD_REQUIRED", new Object[0]);
        }
        r.setCurrentPassword("blabalb".toCharArray());
        try {
            this.validator.validateChangeRequest(r);
            Assert.fail();
        }
        catch (MasterPasswordChangeException ex) {
            this.assertSecurityException(ex, "CURRENT_PASSWORD_ERROR", new Object[0]);
        }
    }

    protected void checkConfirmationPassword(MasterPasswordChangeRequest r) throws Exception {
        try {
            this.validator.validateChangeRequest(r);
            Assert.fail();
        }
        catch (MasterPasswordChangeException ex) {
            this.assertSecurityException(ex, "CONFIRMATION_PASSWORD_REQUIRED", new Object[0]);
        }
    }

    protected void checkNewPassword(MasterPasswordChangeRequest r) throws Exception {
        boolean fail = false;
        try {
            this.validator.validateChangeRequest(r);
        }
        catch (MasterPasswordChangeException ex) {
            fail = true;
            this.assertSecurityException(ex, "NEW_PASSWORD_REQUIRED", new Object[0]);
        }
        Assert.assertTrue((boolean)fail);
    }

    protected void checkConfirmationEqualsNewPassword(MasterPasswordChangeRequest r) throws Exception {
        boolean fail = false;
        try {
            this.validator.validateChangeRequest(r);
        }
        catch (MasterPasswordChangeException ex) {
            fail = true;
            this.assertSecurityException(ex, "PASSWORD_AND_CONFIRMATION_NOT_EQUAL", new Object[0]);
        }
        Assert.assertTrue((boolean)fail);
    }

    protected void checkCurrentEqualsNewPassword(MasterPasswordChangeRequest r) throws Exception {
        try {
            this.validator.validateChangeRequest(r);
            Assert.fail();
        }
        catch (MasterPasswordChangeException ex) {
            this.assertSecurityException(ex, "NEW_EQUALS_CURRENT", new Object[0]);
        }
    }

    protected void validateAgainstPolicy(MasterPasswordChangeRequest r) throws Exception {
        try {
            this.validator.validateChangeRequest(r);
            Assert.fail();
        }
        catch (PasswordPolicyException passwordPolicyException) {
            // empty catch block
        }
    }

    @Test
    public void testUrlConfig() throws Exception {
        URLMasterPasswordProvider.URLMasterPasswordProviderValidator validator = new URLMasterPasswordProvider.URLMasterPasswordProviderValidator(this.getSecurityManager());
        URLMasterPasswordProviderConfig config = new URLMasterPasswordProviderConfig();
        config.setName("foo");
        config.setClassName(URLMasterPasswordProvider.class.getCanonicalName());
        try {
            validator.validateAddMasterPasswordProvider((MasterPasswordProviderConfig)config);
            Assert.fail();
        }
        catch (URLMasterPasswordProviderException e) {
            this.assertSecurityException((MasterPasswordProviderException)e, "URL_REQUIRED", new Object[0]);
        }
        config.setURL(new URL("file:ABC"));
        config.setReadOnly(true);
        try {
            validator.validateAddMasterPasswordProvider((MasterPasswordProviderConfig)config);
            Assert.fail();
        }
        catch (URLMasterPasswordProviderException e) {
            this.assertSecurityException((MasterPasswordProviderException)e, "URL_LOCATION_NOT_READABLE", new URL("file:ABC"));
        }
    }

    @Test
    public void testValidator() throws Exception {
        MasterPasswordChangeRequest r = new MasterPasswordChangeRequest();
        this.checkCurrentPassword(r);
        r.setCurrentPassword("geoserver".toCharArray());
        this.checkConfirmationPassword(r);
        r.setConfirmPassword("abc".toCharArray());
        this.checkNewPassword(r);
        r.setNewPassword("def".toCharArray());
        this.checkConfirmationEqualsNewPassword(r);
        r.setNewPassword("abc".toCharArray());
        this.validateAgainstPolicy(r);
        r.setConfirmPassword(r.getCurrentPassword());
        r.setNewPassword(r.getCurrentPassword());
        this.checkCurrentEqualsNewPassword(r);
        r.setConfirmPassword((String.valueOf(r.getCurrentPassword()) + "1").toCharArray());
        r.setNewPassword((String.valueOf(r.getCurrentPassword()) + "1").toCharArray());
        this.validator.validateChangeRequest(r);
    }

    protected void assertSecurityException(MasterPasswordChangeException ex, String id, Object ... params) {
        Assert.assertEquals((Object)id, (Object)ex.getId());
        Assert.assertEquals((long)params.length, (long)ex.getArgs().length);
        for (int i = 0; i < params.length; ++i) {
            Assert.assertEquals((Object)params[i], (Object)ex.getArgs()[i]);
        }
    }

    protected void assertSecurityException(MasterPasswordProviderException ex, String id, Object ... params) {
        Assert.assertEquals((Object)id, (Object)ex.getId());
        Assert.assertEquals((long)params.length, (long)ex.getArgs().length);
        for (int i = 0; i < params.length; ++i) {
            Assert.assertEquals((Object)params[i], (Object)ex.getArgs()[i]);
        }
    }
}

