/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.Component;
import org.apache.wicket.core.util.string.ComponentRenderer;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.util.tester.TagTester;
import org.geoserver.web.DefaultGeoServerNodeInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class GeoServerBasePageTest
extends GeoServerWicketTestSupport {
    @Test
    public void testLoginFormShowsWhenLoggedOut() throws Exception {
        this.logout();
        tester.startPage(GeoServerHomePage.class);
        tester.assertVisible("loginforms");
        tester.assertVisible("loginforms:0:loginform");
        tester.assertInvisible("logoutform");
        ListView loginForms = (ListView)tester.getLastRenderedPage().get("loginforms");
        String responseTxt = ComponentRenderer.renderComponent((Component)loginForms).toString();
        TagTester tagTester = TagTester.createTagByName((String)responseTxt, (String)"form");
        Assert.assertEquals((Object)"http://localhost/context/j_spring_security_check", (Object)tagTester.getAttribute("action"));
    }

    @Test
    public void testLogoutFormShowsWhenLoggedIn() throws Exception {
        this.login();
        tester.startPage(GeoServerHomePage.class);
        tester.assertVisible("loginforms");
        tester.assertInvisible("loginforms:0:loginform");
        tester.assertVisible("logoutform");
        ListView loginForms = (ListView)tester.getLastRenderedPage().get("loginforms");
        Assert.assertEquals((long)1L, (long)loginForms.getList().size());
        Component logoutforms = tester.getLastRenderedPage().get("logoutform");
        String responseTxt = ComponentRenderer.renderComponent((Component)logoutforms).toString();
        TagTester tagTester = TagTester.createTagByName((String)responseTxt, (String)"form");
        Assert.assertEquals((Object)"http://localhost/context/j_spring_security_logout", (Object)tagTester.getAttribute("action"));
    }

    @Test
    public void testDefaultNodeInfoLoggedOut() throws Exception {
        this.logout();
        System.setProperty("GEOSERVER_NODE_OPTS", "id=test");
        DefaultGeoServerNodeInfo.initializeFromEnviroment();
        tester.startPage(GeoServerHomePage.class);
        tester.assertInvisible("nodeIdContainer");
    }

    @Test
    public void testDefaultNodeInfoLoggedIn() throws Exception {
        this.login();
        System.setProperty("GEOSERVER_NODE_OPTS", "id:test;background:red;color:black");
        DefaultGeoServerNodeInfo.initializeFromEnviroment();
        tester.startPage(GeoServerHomePage.class);
        tester.assertVisible("nodeIdContainer");
        tester.assertModelValue("nodeIdContainer:nodeId", (Object)"test");
    }
}

