/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.web.GeoServerWicketOnlineTestSupport;
import org.geotools.util.Base64;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class GeoServerWicketOnlineTest
extends GeoServerWicketOnlineTestSupport {
    @Test
    public void testLogin() throws IOException {
        Assume.assumeTrue((boolean)this.isOnline());
        String jsessionid = this.login("admin", "geoserver");
        this.get("web/", jsessionid);
        this.logout(jsessionid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotAddAccessRuleIterative() throws IOException {
        Assume.assumeTrue((boolean)this.isOnline());
        List<ServiceAccessRule> initialRules = this.getServiceAccessRules();
        String jsessionid = this.login("admin", "geoserver");
        try {
            for (int j = 0; j < 20; ++j) {
                int i = 13;
                this.getNewServiceAccessRulePageWicket(jsessionid);
                this.addServiceAccessRuleWicket(jsessionid, i, false);
                this.assertServiceAccessRuleNotAdded(initialRules, "Added access rule using only an exising session id");
            }
        }
        finally {
            this.logout(jsessionid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotAddAccessRuleProgramatic() throws IOException {
        Assume.assumeTrue((boolean)this.isOnline());
        List<ServiceAccessRule> initialRules = this.getServiceAccessRules();
        String jsessionid = this.login("admin", "geoserver");
        try {
            int i = this.getNewServiceAccessRulePageWicket(jsessionid);
            this.addServiceAccessRuleWicket(jsessionid, i, false);
            this.assertServiceAccessRuleNotAdded(initialRules, "Added access rule using only an exising session id and response from page requests");
        }
        finally {
            this.logout(jsessionid);
        }
    }

    private int getNewServiceAccessRulePageWicket(String jsessionid) throws IOException {
        HttpURLConnection connection = this.get("web/wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage", jsessionid, null);
        IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
        int i = Integer.parseInt(connection.getURL().getQuery());
        connection.disconnect();
        return i;
    }

    private void addServiceAccessRuleWicket(String jsessionid, int i, boolean setReferer) throws IOException {
        String body = "service=4";
        HttpURLConnection connection = this.preparePost("web/wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i + "-1.IBehaviorListener.0-form-service", body.length(), "application/x-www-form-urlencoded", jsessionid);
        connection.setRequestProperty("Wicket-Ajax", "true");
        connection.setRequestProperty("Wicket-Ajax-BaseURL", "wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i);
        connection.setRequestProperty("Wicket-FocusedElementId", "service");
        if (setReferer) {
            connection.setRequestProperty("Referer", "http://localhost:9090/geoserver/web/wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i);
        }
        if ((connection = this.doPost(connection, body)).getResponseCode() < 400) {
            IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        connection.disconnect();
        body = "roles:anyRole=on";
        connection = this.preparePost("web/wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i + "-1.IBehaviorListener.0-form-roles-anyRole", body.length(), "application/x-www-form-urlencoded", jsessionid);
        connection.setRequestProperty("Wicket-Ajax", "true");
        if (setReferer) {
            connection.setRequestProperty("Referer", "http://localhost:9090/geoserver/web/wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i);
        }
        connection.setRequestProperty("Wicket-Ajax-BaseURL", "wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i);
        connection.setRequestProperty("Wicket-FocusedElementId", "id3c");
        connection = this.doPost(connection, body);
        if (connection.getResponseCode() < 400) {
            IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        connection.disconnect();
        body = "save=x&service=4&p::method=12&roles:anyRole=on";
        connection = this.preparePost("web/wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i + "-1.IFormSubmitListener-form", body.length(), "application/x-www-form-urlencoded", jsessionid);
        connection.setInstanceFollowRedirects(false);
        if (setReferer) {
            connection.setRequestProperty("Referer", "http://localhost:9090/geoserver/web/wicket/bookmarkable/org.geoserver.security.web.service.NewServiceAccessRulePage?" + i);
        }
        if ((connection = this.doPost(connection, body)).getResponseCode() < 400) {
            IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        connection.disconnect();
    }

    private void assertServiceAccessRuleNotAdded(List<ServiceAccessRule> initialRules, String message) throws IOException {
        List<ServiceAccessRule> updatedRules = this.getServiceAccessRules();
        if (updatedRules.size() > initialRules.size()) {
            ServiceAccessRule addedRule = updatedRules.get(updatedRules.size() - 1);
            this.deleteServiceAccessRule(addedRule.getKey());
            Assert.fail((String)message);
        }
    }

    protected List<ServiceAccessRule> getServiceAccessRules() throws IOException {
        HttpURLConnection connection = this.prepareGet("rest/security/acl/services", null, "application/json");
        connection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])"admin:geoserver".getBytes()));
        connection = this.doGet(connection);
        String response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
        connection.disconnect();
        JSONObject jsonObject = JSONObject.fromObject((Object)response);
        ArrayList<ServiceAccessRule> serviceAccessRules = new ArrayList<ServiceAccessRule>();
        for (Object key : jsonObject.keySet()) {
            String[] serviceMethod = ((String)key).split("\\.");
            String[] roles = ((String)jsonObject.get(key)).split(",");
            serviceAccessRules.add(new ServiceAccessRule(serviceMethod[0], serviceMethod[1], roles));
        }
        return serviceAccessRules;
    }

    protected boolean deleteServiceAccessRule(String ruleName) throws IOException {
        HttpURLConnection connection = this.prepareDelete("rest/security/acl/services/" + ruleName, null);
        connection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])"admin:geoserver".getBytes()));
        connection = this.doGet(connection);
        int responseCode = connection.getResponseCode();
        connection.disconnect();
        return responseCode == 200;
    }
}

