/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.LoginFormHTMLInclude;
import org.geoserver.web.LoginFormInfo;
import org.junit.Assert;
import org.junit.Test;

public class LoginFormHTMLIncludeTest
extends GeoServerWicketTestSupport {
    @Test
    public void testImportAsStringDefault() throws Exception {
        LoginFormHTMLInclude defaultInclude = new LoginFormHTMLInclude("login.form", new PackageResourceReference(LoginFormInfo.class, "include_login_form.html"));
        String defaultString = defaultInclude.importAsString();
        Assert.assertTrue((String)"Default include should contains autocomplete=\"on\"", (boolean)defaultString.contains("autocomplete=\"on\""));
    }

    @Test
    public void testImportAsStringAutocompleteOff() throws Exception {
        String existingAutocompleteSetting = System.getProperty("geoserver.login.autocomplete");
        System.setProperty("geoserver.login.autocomplete", "off");
        LoginFormHTMLInclude defaultInclude = new LoginFormHTMLInclude("login.form", new PackageResourceReference(LoginFormInfo.class, "include_login_form.html"));
        String defaultString = defaultInclude.importAsString();
        Assert.assertTrue((String)"Default include should contains autocomplete=\"off\"", (boolean)defaultString.contains("autocomplete=\"off\""));
        if (existingAutocompleteSetting != null) {
            System.setProperty("geoserver.login.autocomplete", existingAutocompleteSetting);
        }
    }
}

