/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.WorkspaceAdminComponentAuthorizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WorkspaceAdminComponentAuthorizerTest
extends GeoServerWicketTestSupport {
    private WorkspaceAdminComponentAuthorizer authorizer;
    private ResourceAccessManager accessManager;

    @Before
    public void setUp() {
        this.accessManager = new WorkspaceAdminComponentAuthorizer().getAccessManager();
        this.authorizer = new WorkspaceAdminComponentAuthorizer(){

            ResourceAccessManager getAccessManager() {
                return WorkspaceAdminComponentAuthorizerTest.this.accessManager;
            }
        };
    }

    @After
    public void after() {
        RequestContextHolder.setRequestAttributes(null);
    }

    private boolean isAccessAllowed(Authentication user) {
        Class<GeoServerBasePage> unused = GeoServerBasePage.class;
        return this.authorizer.isAccessAllowed(unused, user);
    }

    @Test
    public void testGetAccessManager() {
        this.authorizer = new WorkspaceAdminComponentAuthorizer();
        Assert.assertNotNull((Object)this.authorizer.getAccessManager());
    }

    @Test
    public void testAdmin() {
        Assert.assertTrue((boolean)this.isAccessAllowed(this.admin()));
    }

    @Test
    public void testNull() {
        Assert.assertFalse((boolean)this.isAccessAllowed(null));
    }

    @Test
    public void testNoAccessManager() {
        this.accessManager = null;
        Assert.assertNull((Object)this.authorizer.getAccessManager());
        Authentication user = this.user("test", "ROLE_1");
        Assert.assertFalse((boolean)this.isAccessAllowed(user));
    }

    @Test
    public void testNotAuthenticated() {
        Authentication user = this.user("test", new String[0]);
        user.setAuthenticated(false);
        Assert.assertFalse((boolean)this.isAccessAllowed(user));
    }

    @Test
    public void testNotWorkspaceAdmin() {
        Authentication user = this.user("test", "ROLE_USER");
        Assert.assertFalse((boolean)this.isAccessAllowed(user));
    }

    @Test
    public void testIsWorkspaceAdmin() {
        Authentication user = this.user("test", "ROLE_USER");
        this.accessManager = (ResourceAccessManager)Mockito.mock(ResourceAccessManager.class);
        Mockito.when((Object)this.accessManager.isWorkspaceAdmin(user, this.getCatalog())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.isAccessAllowed(user));
    }

    @Test
    public void testRequestCache() {
        Authentication user = this.user("test", "ROLE_USER");
        this.accessManager = (ResourceAccessManager)Mockito.mock(ResourceAccessManager.class);
        Mockito.when((Object)this.accessManager.isWorkspaceAdmin(user, this.getCatalog())).thenReturn((Object)true);
        ServletRequestAttributes atts = new ServletRequestAttributes((HttpServletRequest)new MockHttpServletRequest());
        RequestContextHolder.setRequestAttributes((RequestAttributes)atts);
        this.authorizer = (WorkspaceAdminComponentAuthorizer)Mockito.spy((Object)this.authorizer);
        Assert.assertTrue((boolean)this.isAccessAllowed(user));
        Assert.assertTrue((boolean)this.isAccessAllowed(user));
        Assert.assertTrue((boolean)this.isAccessAllowed(user));
        ((WorkspaceAdminComponentAuthorizer)Mockito.verify((Object)this.authorizer, (VerificationMode)Mockito.times((int)1))).setCachedValue(true);
        ((WorkspaceAdminComponentAuthorizer)Mockito.verify((Object)this.authorizer, (VerificationMode)Mockito.times((int)1))).isWorkspaceAdmin(user);
        Object cached = atts.getAttribute("WORKSPACEADMIN_COMPONENT_AUTHORIZER_VALUE", 0);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cached);
    }

    private Authentication admin() {
        this.login();
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private Authentication user(String name, String ... roles) {
        this.login(name, "pwd", roles);
        return SecurityContextHolder.getContext().getAuthentication();
    }
}

