/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.ContactPage;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContactPageTest
extends GeoServerWicketTestSupport {
    private GeoServer geoServer;

    @Before
    public void reset() {
        this.geoServer = this.getGeoServerApplication().getGeoServer();
        GeoServerInfo info = this.geoServer.getGlobal();
        ContactInfoImpl contact = new ContactInfoImpl();
        contact.setAddress("My address");
        info.getSettings().setContact((ContactInfo)contact);
        this.geoServer.save(info);
    }

    @Test
    public void testValues() {
        ContactInfo info = this.geoServer.getGlobal().getSettings().getContact();
        this.login();
        tester.startPage(ContactPage.class);
        tester.assertComponent("form:contact:address:stringField", TextField.class);
        tester.assertModelValue("form:contact:address:stringField", (Object)info.getAddress());
    }

    @Test
    public void testSave() {
        this.login();
        tester.startPage(ContactPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("contact:address:stringField", "newAddress1");
        ft = tester.newFormTester("form");
        ft.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
        ContactInfo info = this.getGeoServerApplication().getGeoServer().getGlobal().getSettings().getContact();
        Assert.assertEquals((Object)"newAddress1", (Object)info.getAddress());
    }

    @Test
    public void testApply() {
        this.login();
        tester.startPage(ContactPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("contact:address:stringField", "newAddress2");
        ft.submit("apply");
        tester.assertRenderedPage(ContactPage.class);
        ContactInfo info = this.getGeoServerApplication().getGeoServer().getGlobal().getSettings().getContact();
        Assert.assertEquals((Object)"newAddress2", (Object)info.getAddress());
    }

    @Test
    public void testInternationalContent() {
        this.login();
        tester.startPage(ContactPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("contact:contactPerson:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:contactPerson:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:contactPerson:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:contactPerson:internationalField:container:addNew", "click");
        ft.select("contact:contactPerson:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:contactPerson:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:contactOrganization:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:contactOrganization:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:contactOrganization:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:contactOrganization:internationalField:container:addNew", "click");
        ft.select("contact:contactOrganization:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:contactOrganization:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:contactEmail:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:contactEmail:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:contactEmail:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:contactEmail:internationalField:container:addNew", "click");
        ft.select("contact:contactEmail:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:contactEmail:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:contactFacsimile:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:contactFacsimile:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:contactFacsimile:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:contactFacsimile:internationalField:container:addNew", "click");
        ft.select("contact:contactFacsimile:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:contactFacsimile:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:contactVoice:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:contactVoice:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:contactVoice:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:contactVoice:internationalField:container:addNew", "click");
        ft.select("contact:contactVoice:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:contactVoice:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:addressType:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:addressType:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:addressType:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:addressType:internationalField:container:addNew", "click");
        ft.select("contact:addressType:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:addressType:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:address:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:address:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:address:internationalField:container:addNew", "click");
        ft.select("contact:address:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:address:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:addressCity:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:addressCity:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:addressCity:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:addressCity:internationalField:container:addNew", "click");
        ft.select("contact:addressCity:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:addressCity:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:addressCountry:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:addressCountry:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:addressCountry:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:addressCountry:internationalField:container:addNew", "click");
        ft.select("contact:addressCountry:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:addressCountry:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft.setValue("contact:addressDeliveryPoint:labelContainer:labelContainer_i18nCheckbox", true);
        tester.executeAjaxEvent("form:contact:addressDeliveryPoint:labelContainer:labelContainer_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:contact:addressDeliveryPoint:internationalField:container:addNew", "click");
        tester.executeAjaxEvent("form:contact:addressDeliveryPoint:internationalField:container:addNew", "click");
        ft.select("contact:addressDeliveryPoint:internationalField:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 20);
        ft.select("contact:addressDeliveryPoint:internationalField:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 22);
        ft = tester.newFormTester("form");
        ft.setValue("contact:contactPerson:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "A i18n contact person");
        ft.setValue("contact:contactPerson:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "Another i18n contact person");
        ft.setValue("contact:contactOrganization:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "A i18n contact organization");
        ft.setValue("contact:contactOrganization:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "Another i18n contact organization");
        ft.setValue("contact:contactEmail:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "first@i18n.org");
        ft.setValue("contact:contactEmail:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "second@i18n.org");
        ft.setValue("contact:contactVoice:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "0000010001");
        ft.setValue("contact:contactVoice:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "111000111000");
        ft.setValue("contact:contactFacsimile:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "0000022220001");
        ft.setValue("contact:contactFacsimile:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "333444443333");
        ft.setValue("contact:addressType:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "work");
        ft.setValue("contact:addressType:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "work");
        ft.setValue("contact:address:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "Avenida Atlantica 101");
        ft.setValue("contact:address:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "via di Sotterra 12");
        ft.setValue("contact:addressCity:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "Eudossia");
        ft.setValue("contact:addressCity:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "Pentesilea");
        ft.setValue("contact:addressCountry:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "Country of Eudossia");
        ft.setValue("contact:addressCountry:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "Country of Pentesilea");
        ft.setValue("contact:addressDeliveryPoint:internationalField:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "Delivery Point of Eudossia");
        ft.setValue("contact:addressDeliveryPoint:internationalField:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "Delivery Point of Pentesilea");
        tester.debugComponentTrees();
        ft.submit("submit");
        ContactInfo contactInfo = this.getGeoServer().getSettings().getContact();
        this.assertI18NContent(contactInfo.getInternationalContactPerson());
        this.assertI18NContent(contactInfo.getInternationalContactOrganization());
        this.assertI18NContent(contactInfo.getInternationalContactEmail());
        this.assertI18NContent(contactInfo.getInternationalContactVoice());
        this.assertI18NContent(contactInfo.getInternationalContactFacsimile());
        this.assertI18NContent(contactInfo.getInternationalAddress());
        this.assertI18NContent(contactInfo.getInternationalAddressType());
        this.assertI18NContent(contactInfo.getInternationalAddressCity());
        this.assertI18NContent(contactInfo.getInternationalAddressCountry());
        this.assertI18NContent(contactInfo.getInternationalAddressDeliveryPoint());
    }

    private void assertI18NContent(InternationalString internationalString) {
        GrowableInternationalString growable = (GrowableInternationalString)internationalString;
        growable.getLocales().forEach(l -> Assert.assertFalse((boolean)internationalString.toString(l).isEmpty()));
    }
}

