/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.GlobalSettingsPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GlobalSettingsPageTest
extends GeoServerWicketTestSupport {
    private GeoServer gs;

    @Before
    public void reset() {
        this.gs = this.getGeoServerApplication().getGeoServer();
        GeoServerInfo info = this.gs.getGlobal();
        info.getSettings().setVerbose(false);
        this.gs.save(info);
    }

    @Test
    public void testValues() {
        GeoServerInfo info = this.gs.getGlobal();
        this.login();
        tester.startPage(GlobalSettingsPage.class);
        tester.assertComponent("form:verbose", CheckBox.class);
        tester.assertModelValue("form:verbose", (Object)info.getSettings().isVerbose());
        tester.assertComponent("form:showCreatedTimeCols", CheckBox.class);
        tester.assertModelValue("form:showCreatedTimeCols", (Object)info.getSettings().isShowCreatedTimeColumnsInAdminList());
        tester.assertComponent("form:showModifiedTimeCols", CheckBox.class);
        tester.assertModelValue("form:showModifiedTimeCols", (Object)info.getSettings().isShowModifiedTimeColumnsInAdminList());
        tester.assertComponent("form:trailingSlashMatch", CheckBox.class);
        tester.assertModelValue("form:trailingSlashMatch", (Object)info.isTrailingSlashMatch());
    }

    @Test
    public void testSave() {
        this.login();
        tester.startPage(GlobalSettingsPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("verbose", true);
        ft.setValue("trailingSlashMatch", false);
        ft.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
        Assert.assertTrue((boolean)this.gs.getSettings().isVerbose());
        Assert.assertFalse((boolean)this.gs.getGlobal().isTrailingSlashMatch());
    }

    @Test
    public void testApply() {
        this.login();
        tester.startPage(GlobalSettingsPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("verbose", true);
        ft.setValue("trailingSlashMatch", false);
        ft.submit("apply");
        tester.assertRenderedPage(GlobalSettingsPage.class);
        Assert.assertTrue((boolean)this.gs.getSettings().isVerbose());
        Assert.assertFalse((boolean)this.gs.getGlobal().isTrailingSlashMatch());
    }

    @Test
    public void testDefaultLocale() {
        this.login();
        tester.startPage(GlobalSettingsPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.select("defaultLocale", 10);
        ft.submit("submit");
        Assert.assertNotNull((Object)this.gs.getSettings().getDefaultLocale());
    }
}

